/******************************************************************
 * @file   t_array.cpp
 * @author Richard Luo
 * @date   2009-05-31
 * 
 * @brief  
 * 
 ****************************************************************** 
 */

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <iostream>
#include "libconfig.h++"

#include "logic_error.h"

using namespace libconfig;
using namespace std;

template <typename T>
static void dump_cfg_array (const Setting& elem)
{
    std::cout << "path is: " << elem.getPath() << std::endl;
    std::cout << "len  is: " << elem.getLength() << std::endl;
    for (int i=0; i < elem.getLength(); ++i) {
        T s = elem[i];
        cout << "elem[" << i << "] is: " << s << endl;
    }
}

static void dump_cfg_list (const Setting& elem)
{
    std::cout << "path is: " << elem.getPath() << std::endl;
    std::cout << "len  is: " << elem.getLength() << std::endl;
    for (int i=0; i < elem.getLength(); ++i) {

        ERR_INFO_THROW( (false == elem[i].isGroup()), "is group?");

        ERR_INFO_THROW( (true == elem[i].isGroup()), "is group?");

        int id = 0;
        ERR_INFO_THROW(false == elem[i].lookupValue("id", id), "error with id" );
        printf("id:%20d \n", id);

        std::string version;
        ERR_INFO_THROW(false == elem[i].lookupValue("version", version), "error with version");
        printf("version:%20s \n", version.c_str() );

        int size;
        ERR_INFO_THROW(false == elem[i].lookupValue("size", size), "error with size");
        printf("size:%20d \n", size);
    }
}

class ConfigTest: public testing::Test {
protected:

    virtual void SetUp() {}

    virtual void TearDown() {}

    Config cfg_;
};

TEST_F(ConfigTest, test_lib_confg)
{
    try
    {
        const char *ifile = "array.cfg";
        /* Load the configuration.. */
        cout << "loading [" << ifile << "]...";
        cfg_.readFile(ifile);
        cout << "ok" << endl;

        /** Look up an array element */
        cout << "looking up array element...";
        dump_cfg_array<std::string>(cfg_.lookup("test.files"));
        dump_cfg_array<int>(cfg_.lookup("test.nums"));
        ASSERT_TRUE(cfg_.lookup("test.groups").isList());
        dump_cfg_list(cfg_.lookup("test.groups"));
        cout << "Done!" << endl;
    }
    catch (const ParseException& pe) {
        cout << pe.what() << endl;
        ASSERT_TRUE(0);
    }
    catch (...)
    {
        ASSERT_TRUE(0);
    }
}




int main(int argc, char* argv[])
{
    testing::InitGoogleTest(&argc, argv);
    return RUN_ALL_TESTS();
}




