/******************************************************************
 * @file   psoc_data.h
 * @author Richard Luo
 * @date   2008-09-20
 * 
 * @brief  
 * 
 ****************************************************************** 
 */

#ifndef _PSOC_DATA_H
#define _PSOC_DATA_H 1


#ifdef CONV_VECTOR

static char data1[] =
    "11001011"
    "10000000"
    "00000000"
    "00000000"
    "00000000"
    "00000000";

static char data2[] = "11111111111";
static char data3[] = "00000";

const char *init_v1_info =
    "11001010""00000000""00000000""00000000""00000000""00000000""00000000""00000000"
    "00000000""00000000""00000000""00000000""00000000""00000000""00000000""00000000"
    "00001101""11101110""00000001""11110111""10110000""00000111""10011111""00000111"
    "01011110""01111100""10000001""11111101""11101010""00000001""11110111""10100000"
    "00011111""10011111""01110000""00011111""01111100""10011000""01111101""11110100"
    "10000001""11110111""10000000""01001111""11011111""00000000""00011111""01111111"
    "10001001""0111";

const char *init_v2_info =
    "11011110""11100000""00011111""01111011""00000000""01111001""11110000""01110101"
    "11100111""11001000""00011111""11011110""10100000""00011111""01111010""00000001"
    "11111001""11110111""00000001""11110111""11001001""10000111""11011111""01001000"
    "00011110""01111101""00000000""11111101""11100000""00001101""11110111""11000000"
    "00000111""11011111""11100010""010111";

const char *init_v3_info =
    "11011110""11100000""00011111""01111010""00000001""11111101""11101010""00000001"
    "11110111""10110000""01000111""11011111""00001010""00111111""01111100""11111110"
    "01111101""11110100""01100001""11110111""11111000""10010111""00000000""00000000"
    "00000011""01111011""10000000""01111101""11101000""00000111""11110111""10101000"
    "00000111""11011110""11000001""00011111""01111100""00110000""01111101""11110011"
    "11010101""11110111""11010001""10000111""11011110""11100010""00011111""01111111"
    "10001001""01110000""00000000""00000000""00110111""10111000""00000111""11011110"
    "10000000""01111111""01111010""10000000""01111101""11101100""00010001""11110111"
    "11000010""10001111""11011111""00111111""10111111""01111101""00011000""01111101"
    "11111110""00100101""11000000""00000000""00000000""11011110""11100000""00011111"
    "01111010""00000001""11111101""11101010""00000001""11110111""10110000""01000111"
    "11011111""00001100""00011111""01111100""11110100""01111101""11110100""01100001"
    "11110111""10111000""10000111""11011111""11100010""01011100""00000000""00000000"
    "0000";

const char *id_setup_vector_info =
    "11011110""11100010""00011111""01110000""00000001""01111101""11101110""00000001"
    "11110111""10110000""00000111""10011111""00000111""01011110""01111100""10000001"
    "11111101""11101010""00000001""11110111""10100000""00011111""10011111""01110000"
    "00011111""01111100""10011000""01111101""11110100""10000001""11100111""11010000"
    "00000111""11011110""00000000""11011111""01111100""00000000""01111101""11111110"
    "00100101"
    "11";


const char *read_id_v1 = "10111111""000";
const char *read_id_v2 = "11011111""1001";

// const char *erase_all_v =
//     "10011111""10000010""10111110""01111111""00101011""01111101""11101110""00000001"
//     "11110111""10110000""00000111""10011111""00000111""01011110""01111100""10000001"
//     "11111101""11101010""00000001""11110111""10100000""00011111""10011111""01110000"
//     "00011111""01111100""10011000""01111101""11110100""10000001""11110111""10000000"
//     "00101111""11011111""00000000""00011111""01111111""10001001""01110000";

const char *erase_all_v =
    "10011111""10000010""10111110""01111111""00101011""01111101""11101110""00000001"
    "11110111""10110000""00000111""10011111""00000111""01011110""01111100""10000001"
    "11111101""11101010""00000001""11110111""10100000""00011111""10011111""01110000"
    "00011111""01111100""10011000""01111101""11110100""10000001""11110111""10000000"
    "00101111""11011111""00000000""00011111""01111111""10001001""01110000";


const char *program_block_v_info =
    "10011111""10000010""10111110""01111111""00101011""01111101""11101110""00000001"
    "11110111""10110000""00000111""10011111""00000111""01011110""01111100""10000001"
    "11111101""11101010""00000001""11110111""10100000""00011111""10011111""01110000"
    "00011111""01111100""10011000""01111101""11110100""10000001""11110111""10000000"
    "00010111""11011111""00000000""00011111""01111111""10001001""01110000";

const char *very_setup_v_info =
    "11011110""11100000""00011111""01111011""00000000""01111001""11110000""01110101"
    "11100111""11001000""00011111""11011110""10100000""00011111""01111010""00000001"
    "11111001""11110111""00000001""11110111""11001001""10000111""11011111""01001000"
    "00011111""01111000""00000000""11111101""11110000""00000001""11110111""11111000"
    "10010111";

const char *secure_vector_info =
    "10011111""10001010""10011110""01111111""00101011""01111101""11101110""00000001"
    "11110111""10110000""00000111""10011111""00000111""01011110""01111100""10000001"
    "11111101""11101010""00000001""11110111""10100000""00011111""10011111""01110000"
    "00011111""01111100""10011000""01111101""11110100""10000001""11110111""10000000"
    "00100111""11011111""00000000""00011111""01111111""10001001""01110000";


const char *checksum_vector_info =
    "11011110""11100000""00011111""01111011""00000000""01111001""11110000""01110101"
    "11100111""11001000""00011111""11011110""10100000""00011111""01111010""00000001"
    "11111001""11110111""00000001""11110111""11001001""10000111""11011111""01001000"
    "00011110""01111101""00000000""01111101""11100000""00001111""11110111""11000000"
    "00000111""11011111""11100010""01011100";

//          0b11011110,0b11100000,0b00011111,0b01111011,0b00000000,0b01111001,0b11110000,0b01110101,
//          0b11100111,0b11001000,0b00011111,0b11011110,0b10100000,0b00011111,0b01111010,0b00000001,
//          0b11111001,0b11110111,0b00000001,0b11110111,0b11001001,0b10000111,0b11011111,0b01001000,
//          0b00011110,0b01111101,0b00000000,0b01111101,0b11100000,0b00001111,0b11110111,0b11000000,
//          0b00000111,0b11011111,0b11100010,0b01011100


static int vector_convert (const char *s, void *buf)
{
    int i = 0;
    int len = strlen(s);

    for (; i < len; ++i)
        if (s[i] == '1')
            set_bit(i, buf);
        else
            clear_bit(i, buf);

    return i;
}

static void vector_show (const char *name, const char *data)
{
    u32 buf[32] = {0};

    int i, m, n = vector_convert(data, buf);
    
    printk("static psoc_vector_t %s = { \n", name);
    printk("\t.data_ = {\n");

    m = (n + 31)/32;

    for (i=0; i < m; ++i)
        if (0 == i%2)
            printk("\t\t0x%08x, ", buf[i]);
        else
            printk("0x%08x,\n", buf[i]);

    if (i%2) printk("\n");

    printk("\t},\n");
    printk("\t.n_ = %d\n", n);
    printk("};\n");
}

static inline void issp_verctor_convert (void)
{
    /* vector_show("vector1", data1);     */
    /* vector_show("vector2", data2);     */
    /* vector_show("vector3", data3);     */
    /* vector_show("init_v1", init_v1_info); */
    /* vector_show("init_v2", init_v2_info); */
    /* vector_show("init_v3", init_v3_info); */
    /* vector_show("id_setup_vector", id_setup_vector_info); */
    /* vector_show("id_setup_vector", id_setup_vector_info); */
    /* vector_show("read_id_v1", read_id_v1); */
    /* vector_show("read_id_v2", read_id_v2);  */
    /* vector_show("erase_all_vec", erase_all_vec); */

    // vector_show("program_block_v", program_block_v_info);

 
    /* vector_show("verify_setup_vec", very_setup_v_info); */

    /* vector_show("secure_vector", secure_vector_info); */

    vector_show("checksum_vector", checksum_vector_info);

}

#endif

// static uint8_t tdata [] = {
//     '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f',
//     '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f',
//     '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f',
//     '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f',
//     '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f',
//     '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f',
//     '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f',
//     '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f',
//     '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f',
//     '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f',
//     '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f',
//     '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f',
//     '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f',
//     '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f',
//     '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f',
//     '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f',
// };

#endif /* _PSOC_DATA_H */



