/******************************************************************
 * @file   dmp_mem.c
 * @author Richard Luo
 * @date   2008-05-12
 * 
 * @brief  
 * 
 ****************************************************************** 
 */

static inline char *my_itoa_16(int value, char *string)
{
    char tmp[33];
    char *tp = tmp;
    unsigned i;
    unsigned val;
    char *sp;

    val = (unsigned)value;
    while (val || tp == tmp)
    {
        i = (val & ~0xfffffff0);
        val = val >> 4;
        if (i < 10)
            *tp++ = i+'0';
        else
            *tp++ = i + 'a' - 10;
    }

    sp = string;

    while (tp > tmp)
        *sp++ = *--tp;
    *sp = 0;
    return string;
}

static inline void dump_mem_short (void *addr, unsigned sz)
{
    char buf[10] = { 0 };
    volatile unsigned short *pdata = (unsigned short*) addr;

    unsigned i;
    for (i = 0; i < sz; i += sizeof(*pdata), pdata++ ) {
        debug( my_itoa_16(*pdata, buf) );
        if (i && 0 == (i+sizeof(*pdata))%(16*(sizeof(*pdata))) )
            debug("\n");
        else
            debug("-");
    }
    debug("\n");
}

static inline void dump_mem_byte (void *addr, unsigned sz)
{

    char buf[10];
    volatile unsigned char *pdata = (unsigned char*) addr;

    unsigned i;
    for (i = 0; i < sz; i += sizeof(*pdata), pdata++ ) {
        debug( my_itoa_16(*pdata, buf) );
        if (i && 0 == (i+sizeof(*pdata))%(16*(sizeof(*pdata))) )
            debug("\n");
        else
            debug("=");
    }
}

struct dmps {
    const char *name_;
    unsigned* addr_;
};

static inline void dmps_show (const struct dmps *d)
{
    debug(d->name_);
    debug(":\n");
    dump_mem_short(d->addr_, 4);
    debug("================\n");
}



static inline void dump_addr(const char *prefix, void *addr, unsigned size)
{
	debug (prefix);
    dump_mem_short(addr, size);
}

static inline void dump_all(void)
{
    unsigned short *flash_addr = (unsigned short *) (0x10000000);
    unsigned short *uboot_addr = (unsigned short *) (0x10008000);
    unsigned short *sram_addr = (unsigned short *) (0x200000);

    debug("================================================================\n");
    dump_addr("flash_addr:\n", flash_addr, 0x100);
    dump_addr("uboot_addr:\n", uboot_addr, 0x100);
    dump_addr("sram_addr:\n", sram_addr, 0x100);
    debug("****************************************************************\n");

}

#include "AT91SAM9260_inc.h"

static inline void dump_addrs()
{
    struct dmps a[] = { 

        // { "AT91C_SMC_SETUP0", (unsigned*)(AT91C_SMC_SETUP0) }, //DMPS_INITIALIZE(AT91C_SMC_SETUP0),
        // { "AT91C_SMC_PULSE0", (unsigned*)(AT91C_SMC_PULSE0) }, //DMPS_INITIALIZE(AT91C_SMC_PULSE0),
        // { "AT91C_SMC_CYCLE0", (unsigned*)(AT91C_SMC_CYCLE0) },  //DMPS_INITIALIZE(AT91C_SMC_CYCLE0),
        // { "AT91C_SMC_CTRL0", (unsigned*)(AT91C_SMC_CTRL0) },
        // { "AT91C_WDTC_WDMR", (unsigned*)(AT91C_WDTC_WDMR) },
        // { "AT91C_BASE_CKGR", (unsigned*)(AT91C_BASE_CKGR) },
        // { "AT91C_PMC_MCKR", (unsigned*)(AT91C_PMC_MCKR) },

        { "AT91C_DBGU_CSR", (unsigned*)(AT91C_DBGU_CSR) },
        { "AT91C_DBGU_RHR", (unsigned*)(AT91C_DBGU_RHR) },
        { "AT91C_US0_BRGR", (unsigned*)(AT91C_US0_BRGR) },
        { "AT91C_DBGU_CIDR", (unsigned*)(AT91C_DBGU_CIDR) },
        { "AT91C_DBGU_EXID", (unsigned*)(AT91C_DBGU_EXID) },
        { "AT91C_DBGU_FNTR", (unsigned*)(AT91C_DBGU_FNTR) },
        { "AT91C_DBGU_FNTR", (unsigned*)(AT91C_DBGU_FNTR) },
    };

    int i = 0;
    for (; i < sizeof(a)/sizeof(a[0]); ++i)
        dmps_show(&a[i]);
}


//#define RICHARD_DEBUG_DBGU
#if defined RICHARD_DEBUG_DBGU

#define DEBUG_DEBUG_UNIT() do {                     \
        int t_count = 0;                            \
        while (++t_count) {                         \
            if (1 == t_count) {                     \
                debug("start a new test here: ");   \
                HERE();                             \
            }                                       \
            int v = serial_getc();                  \
            if (v == 'q')                           \
                break;                              \
            debug("v: %8.8x \n", v);                \
        }                                           \
    } while(0)

#else
#define DEBUG_DEBUG_UNIT() do {} while(0)
#endif

