#!/bin/sh
################################################################
# install_panel_ID.sh
# Richard Luo
# 2008-08-25
################################################################


device_name=/dev/ak_DIP
driver_name=ak_DIP.ko

minor=0
kmodule=ak_DIP

if [ ! -f $driver_name ] ; then
    echo "the file $driver_name not exist in the current dir, exit"
    exit
fi

if [ -e $device_name ] ; then
    echo "$device_name exist, delete"
    rm -f $device_name
fi

################################################################
#### remove previous installed driver.
major=$(awk "\$2==\"$kmodule\" {print \$1}" /proc/devices)
if [ $major ] ; then
    echo "before rmmod $driver_name"
    rmmod $driver_name || exit
    echo ";-) $driver_name removed ok!"
fi
################################################################ 

sleep 1
################################################################
#### install new one
echo "before insmod $driver_name"

insmod $driver_name  || exit

sleep 1
major=$(awk "\$2==\"$kmodule\" {print \$1}" /proc/devices)
if [ $major ] ; then
    echo ";-) new $driver_name installed ok, \$major is $major"
else
    echo "!!!!!!!!!!!!!!!cannot find DIP major number!!!!!!!!!!!!!!!!!!!!!!!!!"
    exit 0
fi
################################################################

echo ";-) \$major=$major, \$minor=$minor"

mknod $device_name c $major $minor || exit

echo "================================================================"
echo "****************     DIP Module Install OK   *******************"
echo "================================================================"

