/******************************************************************
 * @file   ak2_partition_params.h
 * @author Richard Luo
 * @date   2009-02-16
 * 
 * @brief  
 * 
 ****************************************************************** 
 */

#ifndef _AK2_PARTITION_PARAMS_H
#define _AK2_PARTITION_PARAMS_H


#define NORFLASH1_START_ADDR            0x10000000

#define PARTITION_BSP1_OFFSET           0
#define PARTITION_BSP2_OFFSET           0x00001000
#define PARTITION_UBOOT_ENV_OFFSET      0x00002000
#define PARTITION_UBOOT_OFFSET          0x00003000
#define PARTITION_DATAFS_OFFSET         0x00020000
#define PARTITION_IMAGEFS_OFFSET        0x00700000
#define PARTITION_FLASH_END_OFFSET      0x01000000

#define PARTITION_BSP1_SIZE             (PARTITION_BSP2_OFFSET - PARTITION_BSP1_OFFSET)
#define PARTITION_BSP2_SIZE             (PARTITION_UBOOT_ENV_OFFSET - PARTITION_BSP2_OFFSET)
#define PARTITION_UBOOT_ENV_SIZE        (PARTITION_UBOOT_OFFSET - PARTITION_UBOOT_ENV_OFFSET)
#define PARTITION_UBOOT_SIZE            (PARTITION_DATAFS_OFFSET - PARTITION_UBOOT_OFFSET)
#define PARTITION_DATAFS_SIZE           (PARTITION_IMAGEFS_OFFSET - PARTITION_DATAFS_OFFSET)
#define PARTITION_IMAGEFS_SIZE          (PARTITION_FLASH_END_OFFSET - PARTITION_IMAGEFS_OFFSET)

#define PARTITION_BSP1_START            (NORFLASH1_START_ADDR + PARTITION_BSP1_OFFSET)
#define PARTITION_BSP2_START            (NORFLASH1_START_ADDR + PARTITION_BSP2_OFFSET)
#define PARTITION_UBOOT_ENV_START       (NORFLASH1_START_ADDR + PARTITION_UBOOT_OFFSET)
#define PARTITION_UBOOT_START           (NORFLASH1_START_ADDR + PARTITION_UBOOT_OFFSET)
#define PARTITION_DATAFS_START          (NORFLASH1_START_ADDR + PARTITION_DATAFS_OFFSET)
#define PARTITION_IMAGEFS_START         (NORFLASH1_START_ADDR + PARTITION_IMAGEFS_OFFSET)

#endif /* _AK2_PARTITION_PARAMS_H */



