
#include <linux/types.h>

#define crc8_init   0xff
#define crc16_init  0xffff
#define crc32_init  0xffffffff

const unsigned char CRC8_TABLE[] = {
	 0x000,0x069,0x0d2,0x0bb,0x0cd,0x0a4,0x01f,0x076,
	 0x0f3,0x09a,0x021,0x048,0x03e,0x057,0x0ec,0x085,
	 0x0e6,0x08f,0x034,0x05d,0x02b,0x042,0x0f9,0x090,
	 0x015,0x07c,0x0c7,0x0ae,0x0d8,0x0b1,0x00a,0x063,
	 0x0a5,0x0cc,0x077,0x01e,0x068,0x001,0x0ba,0x0d3,
	 0x056,0x03f,0x084,0x0ed,0x09b,0x0f2,0x049,0x020,
	 0x043,0x02a,0x091,0x0f8,0x08e,0x0e7,0x05c,0x035,
	 0x0b0,0x0d9,0x062,0x00b,0x07d,0x014,0x0af,0x0c6,
	 0x04a,0x023,0x098,0x0f1,0x087,0x0ee,0x055,0x03c,
	 0x0b9,0x0d0,0x06b,0x002,0x074,0x01d,0x0a6,0x0cf,
	 0x0ac,0x0c5,0x07e,0x017,0x061,0x008,0x0b3,0x0da,
	 0x05f,0x036,0x08d,0x0e4,0x092,0x0fb,0x040,0x029,
	 0x0ef,0x086,0x03d,0x054,0x022,0x04b,0x0f0,0x099,
	 0x01c,0x075,0x0ce,0x0a7,0x0d1,0x0b8,0x003,0x06a,
	 0x009,0x060,0x0db,0x0b2,0x0c4,0x0ad,0x016,0x07f,
	 0x0fa,0x093,0x028,0x041,0x037,0x05e,0x0e5,0x08c,
	 0x094,0x0fd,0x046,0x02f,0x059,0x030,0x08b,0x0e2,
	 0x067,0x00e,0x0b5,0x0dc,0x0aa,0x0c3,0x078,0x011,
	 0x072,0x01b,0x0a0,0x0c9,0x0bf,0x0d6,0x06d,0x004,
	 0x081,0x0e8,0x053,0x03a,0x04c,0x025,0x09e,0x0f7,
	 0x031,0x058,0x0e3,0x08a,0x0fc,0x095,0x02e,0x047,
	 0x0c2,0x0ab,0x010,0x079,0x00f,0x066,0x0dd,0x0b4,
	 0x0d7,0x0be,0x005,0x06c,0x01a,0x073,0x0c8,0x0a1,
	 0x024,0x04d,0x0f6,0x09f,0x0e9,0x080,0x03b,0x052,
	 0x0de,0x0b7,0x00c,0x065,0x013,0x07a,0x0c1,0x0a8,
	 0x02d,0x044,0x0ff,0x096,0x0e0,0x089,0x032,0x05b,
	 0x038,0x051,0x0ea,0x083,0x0f5,0x09c,0x027,0x04e,
	 0x0cb,0x0a2,0x019,0x070,0x006,0x06f,0x0d4,0x0bd,
	 0x07b,0x012,0x0a9,0x0c0,0x0b6,0x0df,0x064,0x00d,
	 0x088,0x0e1,0x05a,0x033,0x045,0x02c,0x097,0x0fe,
	 0x09d,0x0f4,0x04f,0x026,0x050,0x039,0x082,0x0eb,
	 0x06e,0x007,0x0bc,0x0d5,0x0a3,0x0ca,0x071,0x018 };

const unsigned short CRC16_TABLE[256] = {
	0x0000,0x1189,0x2312,0x329b,0x4624,0x57ad,0x6536,0x74bf,
	0x8c48,0x9dc1,0xaf5a,0xbed3,0xca6c,0xdbe5,0xe97e,0xf8f7,
	0x1891,0x0918,0x3b83,0x2a0a,0x5eb5,0x4f3c,0x7da7,0x6c2e,
	0x94d9,0x8550,0xb7cb,0xa642,0xd2fd,0xc374,0xf1ef,0xe066,
	0x3122,0x20ab,0x1230,0x03b9,0x7706,0x668f,0x5414,0x459d,
	0xbd6a,0xace3,0x9e78,0x8ff1,0xfb4e,0xeac7,0xd85c,0xc9d5,
	0x29b3,0x383a,0x0aa1,0x1b28,0x6f97,0x7e1e,0x4c85,0x5d0c,
	0xa5fb,0xb472,0x86e9,0x9760,0xe3df,0xf256,0xc0cd,0xd144,
	0x6244,0x73cd,0x4156,0x50df,0x2460,0x35e9,0x0772,0x16fb,
	0xee0c,0xff85,0xcd1e,0xdc97,0xa828,0xb9a1,0x8b3a,0x9ab3,
	0x7ad5,0x6b5c,0x59c7,0x484e,0x3cf1,0x2d78,0x1fe3,0x0e6a,
	0xf69d,0xe714,0xd58f,0xc406,0xb0b9,0xa130,0x93ab,0x8222,
	0x5366,0x42ef,0x7074,0x61fd,0x1542,0x04cb,0x3650,0x27d9,
	0xdf2e,0xcea7,0xfc3c,0xedb5,0x990a,0x8883,0xba18,0xab91,
	0x4bf7,0x5a7e,0x68e5,0x796c,0x0dd3,0x1c5a,0x2ec1,0x3f48,
	0xc7bf,0xd636,0xe4ad,0xf524,0x819b,0x9012,0xa289,0xb300,
	0xc488,0xd501,0xe79a,0xf613,0x82ac,0x9325,0xa1be,0xb037,
	0x48c0,0x5949,0x6bd2,0x7a5b,0x0ee4,0x1f6d,0x2df6,0x3c7f,
	0xdc19,0xcd90,0xff0b,0xee82,0x9a3d,0x8bb4,0xb92f,0xa8a6,
	0x5051,0x41d8,0x7343,0x62ca,0x1675,0x07fc,0x3567,0x24ee,
	0xf5aa,0xe423,0xd6b8,0xc731,0xb38e,0xa207,0x909c,0x8115,
	0x79e2,0x686b,0x5af0,0x4b79,0x3fc6,0x2e4f,0x1cd4,0x0d5d,
	0xed3b,0xfcb2,0xce29,0xdfa0,0xab1f,0xba96,0x880d,0x9984,
	0x6173,0x70fa,0x4261,0x53e8,0x2757,0x36de,0x0445,0x15cc,
	0xa6cc,0xb745,0x85de,0x9457,0xe0e8,0xf161,0xc3fa,0xd273,
	0x2a84,0x3b0d,0x0996,0x181f,0x6ca0,0x7d29,0x4fb2,0x5e3b,
	0xbe5d,0xafd4,0x9d4f,0x8cc6,0xf879,0xe9f0,0xdb6b,0xcae2,
	0x3215,0x239c,0x1107,0x008e,0x7431,0x65b8,0x5723,0x46aa,
	0x97ee,0x8667,0xb4fc,0xa575,0xd1ca,0xc043,0xf2d8,0xe351,
	0x1ba6,0x0a2f,0x38b4,0x293d,0x5d82,0x4c0b,0x7e90,0x6f19,
	0x8f7f,0x9ef6,0xac6d,0xbde4,0xc95b,0xd8d2,0xea49,0xfbc0,
	0x0337,0x12be,0x2025,0x31ac,0x4513,0x549a,0x6601,0x7788
	};


const unsigned long int CRC32_TABLE[] = {
		  0x00000000,0x77073096,0xee0e612c,0x990951ba,
		  0x076dc419,0x706af48f,0xe963a535,0x9e6495a3,
		  0x0edb8832,0x79dcb8a4,0xe0d5e91e,0x97d2d988,
		  0x09b64c2b,0x7eb17cbd,0xe7b82d07,0x90bf1d91,
		  0x1db71064,0x6ab020f2,0xf3b97148,0x84be41de,
		  0x1adad47d,0x6ddde4eb,0xf4d4b551,0x83d385c7,
		  0x136c9856,0x646ba8c0,0xfd62f97a,0x8a65c9ec,
		  0x14015c4f,0x63066cd9,0xfa0f3d63,0x8d080df5,
		  0x3b6e20c8,0x4c69105e,0xd56041e4,0xa2677172,
		  0x3c03e4d1,0x4b04d447,0xd20d85fd,0xa50ab56b,
		  0x35b5a8fa,0x42b2986c,0xdbbbc9d6,0xacbcf940,
		  0x32d86ce3,0x45df5c75,0xdcd60dcf,0xabd13d59,
		  0x26d930ac,0x51de003a,0xc8d75180,0xbfd06116,
		  0x21b4f4b5,0x56b3c423,0xcfba9599,0xb8bda50f,
		  0x2802b89e,0x5f058808,0xc60cd9b2,0xb10be924,
		  0x2f6f7c87,0x58684c11,0xc1611dab,0xb6662d3d,
		  0x76dc4190,0x01db7106,0x98d220bc,0xefd5102a,
		  0x71b18589,0x06b6b51f,0x9fbfe4a5,0xe8b8d433,
		  0x7807c9a2,0x0f00f934,0x9609a88e,0xe10e9818,
		  0x7f6a0dbb,0x086d3d2d,0x91646c97,0xe6635c01,
		  0x6b6b51f4,0x1c6c6162,0x856530d8,0xf262004e,
		  0x6c0695ed,0x1b01a57b,0x8208f4c1,0xf50fc457,
		  0x65b0d9c6,0x12b7e950,0x8bbeb8ea,0xfcb9887c,
		  0x62dd1ddf,0x15da2d49,0x8cd37cf3,0xfbd44c65,
		  0x4db26158,0x3ab551ce,0xa3bc0074,0xd4bb30e2,
		  0x4adfa541,0x3dd895d7,0xa4d1c46d,0xd3d6f4fb,
		  0x4369e96a,0x346ed9fc,0xad678846,0xda60b8d0,
		  0x44042d73,0x33031de5,0xaa0a4c5f,0xdd0d7cc9,
		  0x5005713c,0x270241aa,0xbe0b1010,0xc90c2086,
		  0x5768b525,0x206f85b3,0xb966d409,0xce61e49f,
		  0x5edef90e,0x29d9c998,0xb0d09822,0xc7d7a8b4,
		  0x59b33d17,0x2eb40d81,0xb7bd5c3b,0xc0ba6cad,
		  0xedb88320,0x9abfb3b6,0x03b6e20c,0x74b1d29a,
		  0xead54739,0x9dd277af,0x04db2615,0x73dc1683,
		  0xe3630b12,0x94643b84,0x0d6d6a3e,0x7a6a5aa8,
		  0xe40ecf0b,0x9309ff9d,0x0a00ae27,0x7d079eb1,
		  0xf00f9344,0x8708a3d2,0x1e01f268,0x6906c2fe,
		  0xf762575d,0x806567cb,0x196c3671,0x6e6b06e7,
		  0xfed41b76,0x89d32be0,0x10da7a5a,0x67dd4acc,
		  0xf9b9df6f,0x8ebeeff9,0x17b7be43,0x60b08ed5,
		  0xd6d6a3e8,0xa1d1937e,0x38d8c2c4,0x4fdff252,
		  0xd1bb67f1,0xa6bc5767,0x3fb506dd,0x48b2364b,
		  0xd80d2bda,0xaf0a1b4c,0x36034af6,0x41047a60,
		  0xdf60efc3,0xa867df55,0x316e8eef,0x4669be79,
		  0xcb61b38c,0xbc66831a,0x256fd2a0,0x5268e236,
		  0xcc0c7795,0xbb0b4703,0x220216b9,0x5505262f,
		  0xc5ba3bbe,0xb2bd0b28,0x2bb45a92,0x5cb36a04,
		  0xc2d7ffa7,0xb5d0cf31,0x2cd99e8b,0x5bdeae1d,
		  0x9b64c2b0,0xec63f226,0x756aa39c,0x026d930a,
		  0x9c0906a9,0xeb0e363f,0x72076785,0x05005713,
		  0x95bf4a82,0xe2b87a14,0x7bb12bae,0x0cb61b38,
		  0x92d28e9b,0xe5d5be0d,0x7cdcefb7,0x0bdbdf21,
		  0x86d3d2d4,0xf1d4e242,0x68ddb3f8,0x1fda836e,
		  0x81be16cd,0xf6b9265b,0x6fb077e1,0x18b74777,
		  0x88085ae6,0xff0f6a70,0x66063bca,0x11010b5c,
		  0x8f659eff,0xf862ae69,0x616bffd3,0x166ccf45,
		  0xa00ae278,0xd70dd2ee,0x4e048354,0x3903b3c2,
		  0xa7672661,0xd06016f7,0x4969474d,0x3e6e77db,
		  0xaed16a4a,0xd9d65adc,0x40df0b66,0x37d83bf0,
		  0xa9bcae53,0xdebb9ec5,0x47b2cf7f,0x30b5ffe9,
		  0xbdbdf21c,0xcabac28a,0x53b39330,0x24b4a3a6,
		  0xbad03605,0xcdd70693,0x54de5729,0x23d967bf,
		  0xb3667a2e,0xc4614ab8,0x5d681b02,0x2a6f2b94,
		  0xb40bbe37,0xc30c8ea1,0x5a05df1b,0x2d02ef8d };



unsigned long int UpdCRC32(char BYTE,unsigned long int crc)
{
return(CRC32_TABLE[(crc ^ BYTE) & 0xFF] ^ ((crc >> 8) & 0x00FFFFFF));
}

// compute 16 bit CCITT crc using the table
// see: 1996_4/.../ccitt_crc.txt
//stolen from irda code: /user/src/linux/include/irda/crc.h
__u16 UpdCRC16(__u16 fcs, __u8 c)
{
return (((fcs) >> 8) ^ CRC16_TABLE[((fcs) ^ (c)) & 0xff]);
}

unsigned char UpdCRC8(unsigned char BYTE, unsigned char CRC)
{
return(CRC8_TABLE[BYTE] ^ CRC);
}

