/******************************************************************
 * @file   dbgpk.h
 * @author Richard Luo
 * @date   2008-07-09
 * 
 * @brief  
 * 
 ****************************************************************** 
 */

#ifndef _DEBUGK_H
#define _DEBUGK_H 1

#include <linux/kernel.h>

#ifdef _DBGPK_

#define dbgpk(format,args...) do {                      \
        char tbuf[64];                                  \
        char *p = tbuf;                                 \
        struct timeval tm;                              \
        do_gettimeofday(&tm);                           \
        p += snprintf(tbuf,                             \
                      sizeof(tbuf)-1, "[%5lu.%06lu]",   \
                      (unsigned long)tm.tv_sec,         \
                      (unsigned long)tm.tv_usec);       \
        *p = 0;                                         \
        printk(KERN_DEBUG "<%s> %d ", tbuf, __LINE__);  \
        printk(KERN_DEBUG format, ## args);             \
    }while(0)

#if 0
#define dbgpk_buf(format,args...) do {                                  \
        char b[1024];                                                   \
        char *p = b;                                                    \
        int sz;                                                         \
        p += snprintf(p, sizeof(b)-1, "[%s:%d]>\n\t", __FILE__, __LINE__); \
        p += snprintf(p, sizeof(b)-(p-b+1), format, ## args);           \
        *p = 0;                                                         \
        sz = (p - b + 1);                                               \
        dbg_cycle_buf_append(b, sz);                                    \
    }while(0)
#endif


#define dbgpk_buf(format,args...) do {                                  \
        char b[1024];                                                   \
        char *p = b;                                                    \
        int sz;                                                         \
        p += snprintf(p, sizeof(b)-(p-b+1), format, ## args);           \
        *p = 0;                                                         \
        sz = (p - b + 1);                                               \
        dbg_cycle_buf_append(b, sz);                                    \
    }while(0)

#else

#define dbgpk(...) do { } while(0)
#define dbgpk_buf(...) do { } while(0)

#endif

#endif /* _DEBUGK_H */



