/******************************************************************
 * @file   reader_ioctls.h
 * @author Richard Luo
 * @date   2008-05-22
 * 
 * @brief  
 * 
 ****************************************************************** 
 */

#ifndef _READER_IOCTLS_H
#define _READER_IOCTLS_H 1

#include <linux/ioctl.h>

/*
 * Ioctl definitions
 */

enum {
    RELAY_ON = 1,
    RELAY_OFF,
    LED_ON,
    LED_OFF,
    BUZZ_ON,
    BUZZ_OFF,
    READER_IOC_MAXNR,
};


/* Use 'K' as magic number */
#define READER_IOC_MAGIC  'K'

#define READER_IOCRESET    _IO(READER_IOC_MAGIC, 0)


/*
 * S means "Set" through a ptr,
 * T means "Tell" directly
 * G means "Get" (to a pointed var)
 * Q means "Query", response is on the return value
 * X means "eXchange": G and S atomically
 * H means "sHift": T and Q atomically
 */
#define READER_IOCT_RELAY_ON    _IO(READER_IOC_MAGIC, RELAY_ON)
#define READER_IOCT_RELAY_OFF   _IO(READER_IOC_MAGIC, RELAY_OFF)
#define READER_IOCT_LED_ON      _IO(READER_IOC_MAGIC, LED_ON)
#define READER_IOCT_LED_OFF     _IO(READER_IOC_MAGIC, LED_OFF)
#define READER_IOCT_BUZZ_ON     _IO(READER_IOC_MAGIC, BUZZ_ON)
#define READER_IOCT_BUZZ_OFF    _IO(READER_IOC_MAGIC, BUZZ_OFF)

// #define READER_IOCSORDER   _IOW(READER_IOC_MAGIC,  1, int)
// #define READER_IOCTORDER   _IO(READER_IOC_MAGIC,   2)
// #define READER_IOCGORDER   _IOR(READER_IOC_MAGIC,  3, int)
// #define READER_IOCQORDER   _IO(READER_IOC_MAGIC,   4)
// #define READER_IOCXORDER   _IOWR(READER_IOC_MAGIC, 5, int)
// #define READER_IOCHORDER   _IO(READER_IOC_MAGIC,   6)

// #define READER_IOCTQSET    _IO(READER_IOC_MAGIC,   8)
// #define READER_IOCGQSET    _IOR(READER_IOC_MAGIC,  9, int)
// #define READER_IOCQQSET    _IO(READER_IOC_MAGIC,  10)
// #define READER_IOCXQSET    _IOWR(READER_IOC_MAGIC,11, int)
// #define READER_IOCHQSET    _IO(READER_IOC_MAGIC,  12)




#endif /* _READER_IOCTLS_H */



