#ifndef EV76C454_H
#define EV76C454_H
#include <linux/types.h>

// 8 bit registers
#define REG_f33_config                 0x00
#define     BIT_f33_signed_filtout             0x10
#define     BIT_f33_b_shift                    0x0f
#define REG_f33_coef_11                 0x01
#define REG_f33_coef_12                 0x02
#define REG_f33_coef_13                 0x03
#define REG_f33_coef_21                 0x04
#define REG_f33_coef_22                 0x05
#define REG_f33_coef_23                 0x06
#define REG_f33_coef_31                 0x07
#define REG_f33_coef_32                 0x08
#define REG_f33_coef_33                 0x09
#define REG_synchro                     0x0a
#define     BIT_div_clk                        0xc0
#define     BIT_dataclk_inv                    0x20
#define     BIT_sync_flash_inv                 0x10
#define     BIT_sync_fen_inv                   0x08
#define     BIT_sync_len_inv                   0x04
#define     BIT_BIT_idle_data                 0x02
#define     BIT_BIT_idle_len                  0x01
#define REG_frame_config                0x0b
#define     BIT_frame_cfg_flipv                0x10
#define     BIT_frame_cfg_fliph                0x08
#define     BIT_frame_cfg_subsfactor           0x07
#define REG_frame_lin_log 0x0c
#define     BIT_frame_vlr_ctrl                 0x0f
#define REG_frame_flash_config         0x0d
#define     BIT_flash_disa                     0x80
#define     BIT_frame_flash_del                0x7f
#define REG_pad_enable                 0x0e
#define     BIT_pad_stdby_ena                  0x08
#define     BIT_pad_stdby_inv                  0x04
#define     BIT_pad_trig_ena                   0x02
#define     BIT_pad_trig_inv                   0x01
#define REG_miscel_ctrl                0x0f
#define     BIT_output_hiz                     0x40
#define     BIT_bypass_gco                     0x20
#define     BIT_bypass_f33                     0x10
#define     BIT_twi_lock                       0x08
#define     BIT_overlap                        0x04
#define     BIT_trig                           0x02
#define     BIT_stdby_rqst                     0x01
#define REG_mlbx_data                   0x10
#define     BIT_mlbx_abort_data                0x03
#define REG_mlbx_flag_i                 0x11
#define     BIT_mlbx_fb_abort_clear            0x02
#define     BIT_mlbx_fb_abort_rqst             0x01
#define REG_fb_state                    0x12
#define     BIT_fb_overflow                    0x20
#define     BIT_fb_corrupted_frame             0x10
#define     BIT_fb_idle_ack                    0x08
#define     BIT_fb_stdby_dig_ack               0x04
#define     BIT_fb_stdby_itfr_ack              0x02
#define     BIT_fb_stdby_ana_ack               0x01
#define REG_pattern                     0x13
#define REG_fa_carac_frame              0x40 /* factory register, only for optimization */
#define REG_fa_carac_analog             0x41 /* factory register, only for optimization */
#define REG_fa_REG_ana                  0x42 /* factory register, only for optimization */
#define REG_fa_carac_chrono_and_clk     0x43 /* factory register, only for optimization */
#define REG_fa_low_pwr                  0x44 /* factory register, only for optimization */
#define REG_fa_test                     0x45 /* factory register, only for optimization */
#define REG_fa_carac_sdec_len           0x46 /* factory register, only for optimization */
#define REG_clamp_cfg                   0x47
#define     BIT_clamp_thld_lock                0x0f
#define     BIT_clamp_locker_ena               0x10
#define     BIT_clamp_defcor_disa              0x20
#define     BIT_clamp_manual                   0x40
#define REG_clamp_v0_gain 0x48
#define REG_clamp_offset_diff_1         0x49
#define REG_pcl_offset_diff_2           0x4a
#define REG_clamp_ana_offset            0x4b
#define REG_clamp_dig_offset            0x4c
#define REG_fb_clamp_ana_offset         0x4d
#define REG_fb_clamp_dig_offset         0x4e
#define REG_fa_fb_test_bist_result      0x4f /* factory register, only for optimization */
#define REG_fa_fb_pwr_twakeup_itfr    0x50 /* factory register, only for optimization */
#define REG_fa_fb_frame_flash_del       0x51 /* factory register, only for optimization */

// 16 bit registers
#define REG_frame_tint                  0x80
#define REG_frame_twait                 0x81
#define REG_frame_gain                  0x82
#define     BIT_frame_gain_analog              0x0380
#define     BIT_frame_gain_digital             0x007f
#define REG_frame_roi_0c                0x83
#define REG_frame_roi_0l                0x84
#define REG_frame_roi_w                 0x85
#define REG_frame_roi_h                 0x86
#define REG_gco_val                     0x87
#define REG_line_length_cfg             0x88
#define     BIT_use_ext_line_length            0x0800
#define     BIT_line_length_mask               0x07ff
#define REG_fb_carac_line_length_seq    0x89
#define REG_fb_frame_tint_seq           0x8a
#define REG_fb_frame_roi_1c_seq         0x8b
#define REG_fb_frame_roi_1l_seq         0x8c
#define REG_fb_frame_roi_2c_seq         0x8d
#define REG_fb_frame_roi_2l_seq         0x8e
#define REG_fa_pixtime_width            0xc0 /* factory register, only for optimization */
#define REG_fa_pixtime_tra_com          0xc1 /* factory register, only for optimization */
#define REG_fa_pixtime_sel              0xc2 /* factory register, only for optimization */
#define REG_fa_pixtime_res_com          0xc3 /* factory register, only for optimization */
#define REG_fa_pixtime_res_mem          0xc4 /* factory register, only for optimization */
#define REG_fa_pixtime_res              0xc5 /* factory register, only for optimization */
#define REG_fa_pixtime_shs              0xc6 /* factory register, only for optimization */
#define REG_fa_pixtime_shr1             0xc7 /* factory register, only for optimization */
#define REG_fa_pixtime_shr2             0xc8 /* factory register, only for optimization */
#define REG_fa_pixtime_enpix            0xc9 /* factory register, only for optimization */
#define REG_fa_pixtime_oc               0xca /* factory register, only for optimization */
#define REG_fa_pixtime_res_on_tra_com   0xcb /* factory register, only for optimization */
#define REG_fa_pixtime_res_on_readout   0xcc /* factory register, only for optimization */
#define REG_fa_shield_cfg               0xcd /* factory register, only for optimization */
#define REG_fa_carac_ana                0xce /* factory register, only for optimization */
#define REG_fa_twakeup                  0xcf /* factory register, only for optimization */
#define REG_fa_debbug_0                 0xd0 /* factory register, only for optimization */
#define REG_fa_debbug_1                 0xd1 /* factory register, only for optimization */
#define REG_fa_debbug_2                 0xd2 /* factory register, only for optimization */
#define REG_fa_debbug_3                 0xd3 /* factory register, only for optimization */
#define REG_fa_debbug_4                 0xd4 /* factory register, only for optimization */
#define REG_fa_debbug_5                 0xd5 /* factory register, only for optimization */
#define REG_fa_debbug_6                 0xd6 /* factory register, only for optimization */
#define REG_fa_debbug_7                 0xd7 /* factory register, only for optimization */
#define REG_fa_debbug_8                 0xd8 /* factory register, only for optimization */
#define REG_fa_debbug_9                 0xd9 /* factory register, only for optimization */
#define REG_fa_debbug_A                 0xda /* factory register, only for optimization */
#define REG_fa_debbug_B                 0xdb /* factory register, only for optimization */
#define REG_fa_carac_ana_force          0xdc /* factory register, only for optimization */
#define REG_fa_carac_ana_val            0xdd /* factory register, only for optimization */
#define REG_fa_carac_ana_gray_cnt       0xde /* factory register, only for optimization */
#define REG_fa_carac_ana_alin           0xdf /* factory register, only for optimization */
#define REG_fa_carac_ana_acol           0xe0 /* factory register, only for optimization */
#define REG_fa_fb_frame_lreadout_seq    0xe1 /* factory register, only for optimization */
#define REG_fa_fb_frame_treadout_seq    0xe2 /* factory register, only for optimization */
#define REG_fb_chip_id                  0xff

#define EV76C454_ID                      0x0701

// data sheet sections 9.10.2 and 9.10.3
#define DEFAULT_HORIZONTAL_WIDTH        864
#define DEFAULT_VERTICAL_HEIGHT         640

// data sheet table 1-1
#define DEFAULT_FPS                     60

static struct RegNames {
    __u8 reg;
    char *name;
} m_reg_names[] =
{
    {REG_f33_config, "REG_f33_config"},
    {REG_f33_coef_11, "REG_f33_coef_11"},
    {REG_f33_coef_12, "REG_f33_coef_12"},
    {REG_f33_coef_13, "REG_f33_coef_13"},
    {REG_f33_coef_21, "REG_f33_coef_21"},
    {REG_f33_coef_22, "REG_f33_coef_22"},
    {REG_f33_coef_23, "REG_f33_coef_23"},
    {REG_f33_coef_31, "REG_f33_coef_31"},
    {REG_f33_coef_32, "REG_f33_coef_32"},
    {REG_f33_coef_33, "REG_f33_coef_33"},
    {REG_synchro, "REG_synchro"},
    {REG_frame_config, "REG_frame_config"},
    {REG_frame_lin_log, "REG_frame_lin_log"},
    {REG_frame_flash_config, "REG_frame_flash_config"},
    {REG_pad_enable, "REG_pad_enable"},
    {REG_miscel_ctrl, "REG_miscel_ctrl"},
    {REG_mlbx_data, "REG_mlbx_data"},
    {REG_mlbx_flag_i, "REG_mlbx_flag_i"},
    {REG_fb_state, "REG_fb_state"},
    {REG_pattern, "REG_pattern"},
    {REG_fa_carac_frame, "REG_fa_carac_frame"},
    {REG_fa_carac_analog, "REG_fa_carac_analog"},
    {REG_fa_REG_ana, "REG_fa_REG_ana"},
    {REG_fa_carac_chrono_and_clk, "REG_fa_carac_chrono_and_clk"},
    {REG_fa_low_pwr, "REG_fa_low_pwr"},
    {REG_fa_test, "REG_fa_test"},
    {REG_fa_carac_sdec_len, "REG_fa_carac_sdec_len"},
    {REG_clamp_cfg, "REG_clamp_cfg"},
    {REG_clamp_v0_gain, "REG_clamp_v0_gain"},
    {REG_clamp_offset_diff_1, "REG_clamp_offset_diff_1"},
    {REG_pcl_offset_diff_2, "REG_pcl_offset_diff_2"},
    {REG_clamp_ana_offset, "REG_clamp_ana_offset"},
    {REG_clamp_dig_offset, "REG_clamp_dig_offset"},
    {REG_fb_clamp_ana_offset, "REG_fb_clamp_ana_offset"},
    {REG_fb_clamp_dig_offset, "REG_fb_clamp_dig_offset"},
    {REG_fa_fb_test_bist_result, "REG_fa_fb_test_bist_result"},
    {REG_fa_fb_pwr_twakeup_itfr, "REG_fa_fb_pwr_twakeup_itfr"},
    {REG_fa_fb_frame_flash_del, "REG_fa_fb_frame_flash_del"},
    {REG_frame_tint, "REG_frame_tint"},
    {REG_frame_twait, "REG_frame_twait"},
    {REG_frame_gain, "REG_frame_gain"},
    {REG_frame_roi_0c, "REG_frame_roi_0c"},
    {REG_frame_roi_0l, "REG_frame_roi_0l"},
    {REG_frame_roi_w, "REG_frame_roi_w"},
    {REG_frame_roi_h, "REG_frame_roi_h"},
    {REG_gco_val, "REG_gco_val"},
    {REG_line_length_cfg, "REG_line_length_cfg"},
    {REG_fb_carac_line_length_seq, "REG_fb_carac_line_length_seq"},
    {REG_fb_frame_tint_seq, "REG_fb_frame_tint_seq"},
    {REG_fb_frame_roi_1c_seq, "REG_fb_frame_roi_1c_seq"},
    {REG_fb_frame_roi_1l_seq, "REG_fb_frame_roi_1l_seq"},
    {REG_fb_frame_roi_2c_seq, "REG_fb_frame_roi_2c_seq"},
    {REG_fb_frame_roi_2l_seq, "REG_fb_frame_roi_2l_seq"},
    {REG_fa_pixtime_width, "REG_fa_pixtime_width"},
    {REG_fa_pixtime_tra_com, "REG_fa_pixtime_tra_com"},
    {REG_fa_pixtime_sel, "REG_fa_pixtime_sel"},
    {REG_fa_pixtime_res_com, "REG_fa_pixtime_res_com"},
    {REG_fa_pixtime_res_mem, "REG_fa_pixtime_res_mem"},
    {REG_fa_pixtime_res, "REG_fa_pixtime_res"},
    {REG_fa_pixtime_shs, "REG_fa_pixtime_shs"},
    {REG_fa_pixtime_shr1, "REG_fa_pixtime_shr1"},
    {REG_fa_pixtime_shr2, "REG_fa_pixtime_shr2"},
    {REG_fa_pixtime_enpix, "REG_fa_pixtime_enpix"},
    {REG_fa_pixtime_oc, "REG_fa_pixtime_oc"},
    {REG_fa_pixtime_res_on_tra_com, "REG_fa_pixtime_res_on_tra_com"},
    {REG_fa_pixtime_res_on_readout, "REG_fa_pixtime_res_on_readout"},
    {REG_fa_shield_cfg, "REG_fa_shield_cfg"},
    {REG_fa_carac_ana, "REG_fa_carac_ana"},
    {REG_fa_twakeup, "REG_fa_twakeup"},
    {REG_fa_debbug_0, "REG_fa_debbug_0"},
    {REG_fa_debbug_1, "REG_fa_debbug_1"},
    {REG_fa_debbug_2, "REG_fa_debbug_2"},
    {REG_fa_debbug_3, "REG_fa_debbug_3"},
    {REG_fa_debbug_4, "REG_fa_debbug_4"},
    {REG_fa_debbug_5, "REG_fa_debbug_5"},
    {REG_fa_debbug_6, "REG_fa_debbug_6"},
    {REG_fa_debbug_7, "REG_fa_debbug_7"},
    {REG_fa_debbug_8, "REG_fa_debbug_8"},
    {REG_fa_debbug_9, "REG_fa_debbug_9"},
    {REG_fa_debbug_A, "REG_fa_debbug_A"},
    {REG_fa_debbug_B, "REG_fa_debbug_B"},
    {REG_fa_carac_ana_force, "REG_fa_carac_ana_force"},
    {REG_fa_carac_ana_val, "REG_fa_carac_ana_val"},
    {REG_fa_carac_ana_gray_cnt, "REG_fa_carac_ana_gray_cnt"},
    {REG_fa_carac_ana_alin, "REG_fa_carac_ana_alin"},
    {REG_fa_carac_ana_acol, "REG_fa_carac_ana_acol"},
    {REG_fa_fb_frame_lreadout_seq, "REG_fa_fb_frame_lreadout_seq"},
    {REG_fa_fb_frame_treadout_seq, "REG_fa_fb_frame_treadout_seq"},
    {REG_fb_chip_id, "REG_fb_chip_id"},
};

#endif
