/* SPDX-License-Identifier: GPL-2.0 or BSD-3-Clause */
/*
 * Copyright (C) STMicroelectronics 2017 - All Rights Reserved
 * Author: Gabriel Fernandez <gabriel.fernandez@st.com> for STMicroelectronics.
 */
/* OSCILLATOR clocks */
#define CK_HSE 0
#define CK_CSI 1
#define CK_LSI 2
#define CK_LSE 3
#define CK_HSI 4
#define CK_HSE_DIV2 5

/* Bus clocks */
#define TIM2 6
#define TIM3 7
#define TIM4 8
#define TIM5 9
#define TIM6 10
#define TIM7 11
#define TIM12 12
#define TIM13 13
#define TIM14 14
#define LPTIM1 15
#define SPI2 16
#define SPI3 17
#define USART2 18
#define USART3 19
#define UART4 20
#define UART5 21
#define UART7 22
#define UART8 23
#define I2C1 24
#define I2C2 25
#define I2C3 26
#define I2C5 27
#define SPDIF 28
#define CEC 29
#define DAC12 30
#define MDIO 31
#define TIM1 32
#define TIM8 33
#define TIM15 34
#define TIM16 35
#define TIM17 36
#define SPI1 37
#define SPI4 38
#define SPI5 39
#define USART6 40
#define SAI1 41
#define SAI2 42
#define SAI3 43
#define DFSDM 44
#define FDCAN 45
#define LPTIM2 46
#define LPTIM3 47
#define LPTIM4 48
#define LPTIM5 49
#define SAI4 50
#define SYSCFG 51
#define VREF 52
#define TMPSENS 53
#define PMBCTRL 54
#define HDP 55
#define LTDC 56
#define DSI 57
#define IWDG2 58
#define USBPHY 59
#define STGENRO 60
#define SPI6 61
#define I2C4 62
#define I2C6 63
#define USART1 64
#define RTCAPB 65
#define TZC 66
#define TZPC 67
#define IWDG1 68
#define BSEC 69
#define STGEN 70
#define DMA1 71
#define DMA2 72
#define DMAMUX 73
#define ADC12 74
#define USBO 75
#define SDMMC3 76
#define DCMI 77
#define CRYP2 78
#define HASH2 79
#define RNG2 80
#define CRC2 81
#define HSEM 82
#define IPCC 83
#define GPIOA 84
#define GPIOB 85
#define GPIOC 86
#define GPIOD 87
#define GPIOE 88
#define GPIOF 89
#define GPIOG 90
#define GPIOH 91
#define GPIOI 92
#define GPIOJ 93
#define GPIOK 94
#define GPIOZ 95
#define CRYP1 96
#define HASH1 97
#define RNG1 98
#define BKPSRAM 99
#define MDMA 100
#define DMA2D 101
#define GPU 102
#define ETHCK 103
#define ETHTX 104
#define ETHRX 105
#define ETHMAC 106
#define FMC 107
#define QSPI 108
#define SDMMC1 109
#define SDMMC2 110
#define CRC1 111
#define USBH 112
#define ETHSTP 113

/* Kernel clocks */
#define SDMMC1_K 114
#define SDMMC2_K 115
#define SDMMC3_K 116
#define FMC_K 117
#define QSPI_K 118
#define ETHMAC_K 119
#define RNG1_K 120
#define RNG2_K 121
#define GPU_K 122
#define USBPHY_K 123
#define STGEN_K 124
#define SPDIF_K 125
#define SPI1_K 126
#define SPI2_K 127
#define SPI3_K 128
#define SPI4_K 129
#define SPI5_K 130
#define SPI6_K 131
#define CEC_K 132
#define I2C1_K 133
#define I2C2_K 134
#define I2C3_K 135
#define I2C4_K 136
#define I2C5_K 137
#define I2C6_K 138
#define LPTIM1_K 139
#define LPTIM2_K 140
#define LPTIM3_K 141
#define LPTIM4_K 142
#define LPTIM5_K 143
#define USART1_K 144
#define USART2_K 145
#define USART3_K 146
#define UART4_K 147
#define UART5_K 148
#define USART6_K 149
#define UART7_K 150
#define UART8_K 151
#define DFSDM_K 152
#define FDCAN_K 153
#define SAI1_K 154
#define SAI2_K 155
#define SAI3_K 156
#define SAI4_K 157
#define ADC12_K 158
#define DSI_K 159
#define ADFSDM_K 160
#define USBO_K 161
#define LTDC_K 162

/* PLL */
#define PLL1 163
#define PLL2 164
#define PLL3 165
#define PLL4 166

/* ODF */
#define PLL1_P 167
#define PLL1_Q 168
#define PLL1_R 169
#define PLL2_P 170
#define PLL2_Q 171
#define PLL2_R 172
#define PLL3_P 173
#define PLL3_Q 174
#define PLL3_R 175
#define PLL4_P 176
#define PLL4_Q 177
#define PLL4_R 178

/* AUX */
#define RTC 179

/* MCLK */
#define CK_PER 180
#define CK_MPU 181
#define CK_AXI 182
#define CK_MCU 183

/* Time base */
#define TIM2_K 184
#define TIM3_K 185
#define TIM4_K 186
#define TIM5_K 187
#define TIM6_K 188
#define TIM7_K 189
#define TIM12_K 190
#define TIM13_K 191
#define TIM14_K 192
#define TIM1_K 193
#define TIM8_K 194
#define TIM15_K 195
#define TIM16_K 196
#define TIM17_K 197

/* MCO clocks */
#define CK_MCO1 198
#define CK_MCO2 199

/* TRACE & DEBUG clocks */
#define DBG 200
#define CK_DBG 201
#define CK_TRACE 202

/* DDR */
#define DDRC1 203
#define DDRC1LP 204
#define DDRC2 205
#define DDRC2LP 206
#define DDRPHYC 207
#define DDRPHYCLP 208
#define DDRCAPB 209
#define DDRCAPBLP 210
#define AXIDCG 211
#define DDRPHYCAPB 212
#define DDRPHYCAPBLP 213
#define DDRPERFM 214

#define STM32MP1_LAST_CLK 215
