#ifndef CYGONCE_LIBM_LDEXP_H
#define CYGONCE_LIBM_LDEXP_H
//===========================================================================
//
//      ldexp.h
//
//      Test vectors for testing of ldexp() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   jlarmour
// Contributors:  jlarmour
// Date:        1998-02-13
// Purpose:     
// Description: 
// Usage:       #include "vectors/ldexp.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support.h"// extra support for math tests

#define LDEXP_TOLERANCE 1.0E-04

static const Cyg_libm_test_double_vec_t ldexp_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{ 1, 1077999148u, 2506787616u, 0u, 54u, 1134622252u, 2506787616u, 0, LDEXP_TOLERANCE, 0},
{ 2, 3214772338u, 2077734866u, 0u, 34u, 3250423922u, 2077734866u, 0, LDEXP_TOLERANCE, 0},
{ 3, 1080413105u, 548846937u, 0u, 225u, 1316342705u, 548846937u, 0, LDEXP_TOLERANCE, 0},
{ 4, 3218221902u, 486455730u, 0u, 318u, 3551669070u, 486455730u, 0, LDEXP_TOLERANCE, 0},
{ 5, 3224095940u, 4065937691u, 0u, 436u, 3681275076u, 4065937691u, 0, LDEXP_TOLERANCE, 0},
{ 6, 1071992326u, 2845631987u, 0u, 28u, 1101352454u, 2845631987u, 0, LDEXP_TOLERANCE, 0},
{ 7, 1046025801u, 4006030831u, 0u, 281u, 1340675657u, 4006030831u, 0, LDEXP_TOLERANCE, 0},
{ 8, 3220544804u, 1507340799u, 0u, 346u, 3583352100u, 1507340799u, 0, LDEXP_TOLERANCE, 0},
{ 9, 3194723612u, 479621759u, 0u, 449u, 3665534236u, 479621759u, 0, LDEXP_TOLERANCE, 0},
{ 10, 1089363191u, 1746012320u, 0u, 291u, 1394498807u, 1746012320u, 0, LDEXP_TOLERANCE, 0},
{ 11, 1076292113u, 2043066528u, 0u, 292u, 1382476305u, 2043066528u, 0, LDEXP_TOLERANCE, 0},
{ 12, 3235652646u, 2131233512u, 0u, 104u, 3344704550u, 2131233512u, 0, LDEXP_TOLERANCE, 0},
{ 13, 1058485694u, 2336118392u, 0u, 314u, 1387738558u, 2336118392u, 0, LDEXP_TOLERANCE, 0},
{ 14, 1082419809u, 2572806098u, 0u, 29u, 1112828513u, 2572806098u, 0, LDEXP_TOLERANCE, 0},
{ 15, 1095385097u, 370772494u, 0u, 470u, 1588215817u, 370772494u, 0, LDEXP_TOLERANCE, 0},
{ 16, 3205432790u, 2588298075u, 0u, 44u, 3251570134u, 2588298075u, 0, LDEXP_TOLERANCE, 0},
{ 17, 1095917486u, 3103659359u, 0u, 383u, 1497522094u, 3103659359u, 0, LDEXP_TOLERANCE, 0},
{ 18, 1073371132u, 1515119937u, 0u, 213u, 1296717820u, 1515119937u, 0, LDEXP_TOLERANCE, 0},
{ 19, 1060343410u, 1857607719u, 0u, 356u, 1433636466u, 1857607719u, 0, LDEXP_TOLERANCE, 0},
{ 20, 3233184100u, 1472965721u, 0u, 277u, 3523639652u, 1472965721u, 0, LDEXP_TOLERANCE, 0},
{ 21, 3230691143u, 2574511435u, 0u, 215u, 3456134983u, 2574511435u, 0, LDEXP_TOLERANCE, 0},
{ 22, 3254171964u, 122146127u, 0u, 445u, 3720788284u, 122146127u, 0, LDEXP_TOLERANCE, 0},
{ 23, 1072428204u, 831542630u, 0u, 171u, 1251734700u, 831542630u, 0, LDEXP_TOLERANCE, 0},
{ 24, 1068797024u, 1682228977u, 0u, 239u, 1319406688u, 1682228977u, 0, LDEXP_TOLERANCE, 0},
{ 25, 1053852869u, 105430463u, 0u, 369u, 1440777413u, 105430463u, 0, LDEXP_TOLERANCE, 0},
{ 26, 1048952779u, 3490880064u, 0u, 127u, 1182121931u, 3490880064u, 0, LDEXP_TOLERANCE, 0},
{ 27, 1088448632u, 336073679u, 0u, 29u, 1118857336u, 336073679u, 0, LDEXP_TOLERANCE, 0},
{ 28, 1102287487u, 265058758u, 0u, 389u, 1510183551u, 265058758u, 0, LDEXP_TOLERANCE, 0},
{ 29, 3231657216u, 258027773u, 0u, 472u, 3726585088u, 258027773u, 0, LDEXP_TOLERANCE, 0},
{ 30, 1093107080u, 252015623u, 0u, 96u, 1193770376u, 252015623u, 0, LDEXP_TOLERANCE, 0},
{ 31, 1067920032u, 78287159u, 0u, 263u, 1343695520u, 78287159u, 0, LDEXP_TOLERANCE, 0},
{ 32, 1073395576u, 1555523835u, 0u, 92u, 1169864568u, 1555523835u, 0, LDEXP_TOLERANCE, 0},
{ 33, 1063005332u, 1067681081u, 0u, 264u, 1339829396u, 1067681081u, 0, LDEXP_TOLERANCE, 0},
{ 34, 1102231954u, 3893923133u, 0u, 244u, 1358084498u, 3893923133u, 0, LDEXP_TOLERANCE, 0},
{ 35, 3230686533u, 1759897777u, 0u, 309u, 3554696517u, 1759897777u, 0, LDEXP_TOLERANCE, 0},
{ 36, 3239098397u, 2737037055u, 0u, 73u, 3315644445u, 2737037055u, 0, LDEXP_TOLERANCE, 0},
{ 37, 3216262634u, 2075329122u, 0u, 66u, 3285468650u, 2075329122u, 0, LDEXP_TOLERANCE, 0},
{ 38, 3196997769u, 1611276410u, 0u, 194u, 3400421513u, 1611276410u, 0, LDEXP_TOLERANCE, 0},
{ 39, 3202638019u, 1799495751u, 0u, 455u, 3679740099u, 1799495751u, 0, LDEXP_TOLERANCE, 0},
{ 40, 1094899225u, 1827380665u, 0u, 66u, 1164105241u, 1827380665u, 0, LDEXP_TOLERANCE, 0},
{ 41, 1071303853u, 2051165551u, 0u, 459u, 1552600237u, 2051165551u, 0, LDEXP_TOLERANCE, 0},
{ 42, 1065537321u, 302759375u, 0u, 340u, 1422053161u, 302759375u, 0, LDEXP_TOLERANCE, 0},
{ 43, 1086875018u, 575413558u, 0u, 398u, 1504208266u, 575413558u, 0, LDEXP_TOLERANCE, 0},
{ 44, 1053673372u, 2702778974u, 0u, 443u, 1518192540u, 2702778974u, 0, LDEXP_TOLERANCE, 0},
{ 45, 3193817621u, 1570767698u, 0u, 282u, 3489516053u, 1570767698u, 0, LDEXP_TOLERANCE, 0},
{ 46, 1071069297u, 2192461366u, 0u, 302u, 1387739249u, 2192461366u, 0, LDEXP_TOLERANCE, 0},
{ 47, 3238418804u, 1337840437u, 0u, 144u, 3389413748u, 1337840437u, 0, LDEXP_TOLERANCE, 0},
{ 48, 3248513649u, 1699484613u, 0u, 140u, 3395314289u, 1699484613u, 0, LDEXP_TOLERANCE, 0},
{ 49, 3217360803u, 3717603375u, 0u, 269u, 3499427747u, 3717603375u, 0, LDEXP_TOLERANCE, 0},
{ 50, 1088279286u, 3814565670u, 0u, 496u, 1608372982u, 3814565670u, 0, LDEXP_TOLERANCE, 0},
{ 51, 1049002975u, 2752608599u, 0u, 470u, 1541833695u, 2752608599u, 0, LDEXP_TOLERANCE, 0},
{ 52, 1057404205u, 3994112087u, 0u, 203u, 1270265133u, 3994112087u, 0, LDEXP_TOLERANCE, 0},
{ 53, 3192718923u, 705652685u, 0u, 346u, 3555526219u, 705652685u, 0, LDEXP_TOLERANCE, 0},
{ 54, 1047202319u, 2552982406u, 0u, 120u, 1173031439u, 2552982406u, 0, LDEXP_TOLERANCE, 0},
{ 55, 1107213408u, 428765703u, 0u, 30u, 1138670688u, 428765703u, 0, LDEXP_TOLERANCE, 0},
{ 56, 3206857463u, 3463957950u, 0u, 454u, 3682910967u, 3463957950u, 0, LDEXP_TOLERANCE, 0},
{ 57, 3219940202u, 3511931302u, 0u, 482u, 3725353834u, 3511931302u, 0, LDEXP_TOLERANCE, 0},
{ 58, 1049545113u, 1382645956u, 0u, 27u, 1077856665u, 1382645956u, 0, LDEXP_TOLERANCE, 0},
{ 59, 3240285101u, 4024164216u, 0u, 494u, 3758281645u, 4024164216u, 0, LDEXP_TOLERANCE, 0},
{ 60, 1090664768u, 3201265259u, 0u, 304u, 1409431872u, 3201265259u, 0, LDEXP_TOLERANCE, 0},
{ 61, 3195451094u, 2082243603u, 0u, 200u, 3405166294u, 2082243603u, 0, LDEXP_TOLERANCE, 0},
{ 62, 1070789511u, 3477510131u, 0u, 209u, 1289941895u, 3477510131u, 0, LDEXP_TOLERANCE, 0},
{ 63, 3202292384u, 98230582u, 0u, 499u, 3725531808u, 98230582u, 0, LDEXP_TOLERANCE, 0},
{ 64, 1057053639u, 2055490142u, 0u, 155u, 1219582919u, 2055490142u, 0, LDEXP_TOLERANCE, 0},
{ 65, 3231608324u, 3135714676u, 0u, 72u, 3307105796u, 3135714676u, 0, LDEXP_TOLERANCE, 0},
{ 66, 1067886563u, 3959938578u, 0u, 121u, 1194764259u, 3959938578u, 0, LDEXP_TOLERANCE, 0},
{ 67, 1064521796u, 2810759459u, 0u, 133u, 1203982404u, 2810759459u, 0, LDEXP_TOLERANCE, 0},
{ 68, 1050312077u, 2893664965u, 0u, 378u, 1446673805u, 2893664965u, 0, LDEXP_TOLERANCE, 0},
{ 69, 1083212579u, 1755264865u, 0u, 240u, 1334870819u, 1755264865u, 0, LDEXP_TOLERANCE, 0},
{ 70, 1106413681u, 4047817320u, 0u, 313u, 1434617969u, 4047817320u, 0, LDEXP_TOLERANCE, 0},
{ 71, 3203399791u, 846447545u, 0u, 417u, 3640655983u, 846447545u, 0, LDEXP_TOLERANCE, 0},
{ 72, 1064185862u, 3943538251u, 0u, 42u, 1108226054u, 3943538251u, 0, LDEXP_TOLERANCE, 0},
{ 73, 3240055222u, 3604989074u, 0u, 181u, 3429847478u, 3604989074u, 0, LDEXP_TOLERANCE, 0},
{ 74, 1047367602u, 203456665u, 0u, 144u, 1198362546u, 203456665u, 0, LDEXP_TOLERANCE, 0},
{ 75, 3189239631u, 1189635129u, 0u, 412u, 3621252943u, 1189635129u, 0, LDEXP_TOLERANCE, 0},
{ 76, 3205779054u, 3013056723u, 0u, 397u, 3622063726u, 3013056723u, 0, LDEXP_TOLERANCE, 0},
{ 77, 3213557485u, 1246486570u, 0u, 474u, 3710582509u, 1246486570u, 0, LDEXP_TOLERANCE, 0},
{ 78, 1067165665u, 743938884u, 0u, 66u, 1136371681u, 743938884u, 0, LDEXP_TOLERANCE, 0},
{ 79, 3251710188u, 3283695916u, 0u, 173u, 3433113836u, 3283695916u, 0, LDEXP_TOLERANCE, 0},
{ 80, 1049044587u, 137961661u, 0u, 205u, 1264002667u, 137961661u, 0, LDEXP_TOLERANCE, 0},
{ 81, 3203917457u, 2416207160u, 0u, 306u, 3524781713u, 2416207160u, 0, LDEXP_TOLERANCE, 0},
{ 82, 1087554095u, 2312530895u, 0u, 328u, 1431487023u, 2312530895u, 0, LDEXP_TOLERANCE, 0},
{ 83, 3219731834u, 3553194394u, 0u, 51u, 3273209210u, 3553194394u, 0, LDEXP_TOLERANCE, 0},
{ 84, 1089802564u, 4018123754u, 0u, 40u, 1131745604u, 4018123754u, 0, LDEXP_TOLERANCE, 0},
{ 85, 3250695960u, 4001402392u, 0u, 197u, 3457265432u, 4001402392u, 0, LDEXP_TOLERANCE, 0},
{ 86, 1094799453u, 1020693107u, 0u, 461u, 1578192989u, 1020693107u, 0, LDEXP_TOLERANCE, 0},
{ 87, 3211977643u, 4053777521u, 0u, 379u, 3609387947u, 4053777521u, 0, LDEXP_TOLERANCE, 0},
{ 88, 1054173542u, 374437781u, 0u, 354u, 1425369446u, 374437781u, 0, LDEXP_TOLERANCE, 0},
{ 89, 1104453092u, 1396680572u, 0u, 231u, 1346674148u, 1396680572u, 0, LDEXP_TOLERANCE, 0},
{ 90, 1065738071u, 3778242113u, 0u, 72u, 1141235543u, 3778242113u, 0, LDEXP_TOLERANCE, 0},
{ 91, 3194422028u, 1839068700u, 0u, 22u, 3217490700u, 1839068700u, 0, LDEXP_TOLERANCE, 0},
{ 92, 3249772522u, 3333658503u, 0u, 172u, 3430127594u, 3333658503u, 0, LDEXP_TOLERANCE, 0},
{ 93, 3217561104u, 968764933u, 0u, 236u, 3465025040u, 968764933u, 0, LDEXP_TOLERANCE, 0},
{ 94, 3208346874u, 2557447419u, 0u, 356u, 3581639930u, 2557447419u, 0, LDEXP_TOLERANCE, 0},
{ 95, 1092040860u, 2421020125u, 0u, 39u, 1132935324u, 2421020125u, 0, LDEXP_TOLERANCE, 0},
{ 96, 1051546374u, 390319448u, 0u, 307u, 1373459206u, 390319448u, 0, LDEXP_TOLERANCE, 0},
{ 97, 1104422077u, 120202647u, 0u, 410u, 1534338237u, 120202647u, 0, LDEXP_TOLERANCE, 0},
{ 98, 3205907556u, 1571279631u, 0u, 183u, 3397796964u, 1571279631u, 0, LDEXP_TOLERANCE, 0},
{ 99, 3209048500u, 3811286432u, 0u, 188u, 3406180788u, 3811286432u, 0, LDEXP_TOLERANCE, 0},
{ 100, 1082016752u, 2844125311u, 0u, 384u, 1484669936u, 2844125311u, 0, LDEXP_TOLERANCE, 0},
{ 101, 3223518474u, 4002983238u, 0u, 232u, 3466788106u, 4002983238u, 0, LDEXP_TOLERANCE, 0},
{ 102, 1084999692u, 705964542u, 0u, 337u, 1438369804u, 705964542u, 0, LDEXP_TOLERANCE, 0},
{ 103, 3253568979u, 697641380u, 0u, 20u, 3274540499u, 697641380u, 0, LDEXP_TOLERANCE, 0},
{ 104, 1066189359u, 4290199654u, 0u, 261u, 1339867695u, 4290199654u, 0, LDEXP_TOLERANCE, 0},
{ 105, 3254107020u, 3987628760u, 0u, 187u, 3450190732u, 3987628760u, 0, LDEXP_TOLERANCE, 0},
{ 106, 1107254732u, 713663124u, 0u, 331u, 1454333388u, 713663124u, 0, LDEXP_TOLERANCE, 0},
{ 107, 1072634213u, 4243219780u, 0u, 67u, 1142888805u, 4243219780u, 0, LDEXP_TOLERANCE, 0},
{ 108, 3252818240u, 2525320167u, 0u, 158u, 3418493248u, 2525320167u, 0, LDEXP_TOLERANCE, 0},
{ 109, 1106165945u, 3774123863u, 0u, 119u, 1230946489u, 3774123863u, 0, LDEXP_TOLERANCE, 0},
{ 110, 3215263804u, 4238491666u, 0u, 282u, 3510962236u, 4238491666u, 0, LDEXP_TOLERANCE, 0},
{ 111, 1047864809u, 2749649438u, 0u, 342u, 1406477801u, 2749649438u, 0, LDEXP_TOLERANCE, 0},
{ 112, 3213031252u, 2168353677u, 0u, 119u, 3337811796u, 2168353677u, 0, LDEXP_TOLERANCE, 0},
{ 113, 3235560047u, 1920824271u, 0u, 448u, 3705322095u, 1920824271u, 0, LDEXP_TOLERANCE, 0},
{ 114, 1064313208u, 4197962774u, 0u, 119u, 1189093752u, 4197962774u, 0, LDEXP_TOLERANCE, 0},
{ 115, 3226731627u, 481356510u, 0u, 228u, 3465806955u, 481356510u, 0, LDEXP_TOLERANCE, 0},
{ 116, 1098012633u, 1760061418u, 0u, 422u, 1540511705u, 1760061418u, 0, LDEXP_TOLERANCE, 0},
{ 117, 1062348526u, 1907225401u, 0u, 468u, 1553082094u, 1907225401u, 0, LDEXP_TOLERANCE, 0},
{ 118, 1103185231u, 4242092620u, 0u, 299u, 1416709455u, 4242092620u, 0, LDEXP_TOLERANCE, 0},
{ 119, 1052367173u, 3238059481u, 0u, 481u, 1556732229u, 3238059481u, 0, LDEXP_TOLERANCE, 0},
{ 120, 1100208345u, 3991562047u, 0u, 203u, 1313069273u, 3991562047u, 0, LDEXP_TOLERANCE, 0},
{ 121, 1060891184u, 899298139u, 0u, 214u, 1285286448u, 899298139u, 0, LDEXP_TOLERANCE, 0},
{ 122, 1104449768u, 3410634699u, 0u, 411u, 1535414504u, 3410634699u, 0, LDEXP_TOLERANCE, 0},
{ 123, 1073419044u, 3812243448u, 0u, 319u, 1407914788u, 3812243448u, 0, LDEXP_TOLERANCE, 0},
{ 124, 3202615057u, 987224991u, 0u, 224u, 3437496081u, 987224991u, 0, LDEXP_TOLERANCE, 0},
{ 125, 1075151824u, 1167721978u, 0u, 399u, 1493533648u, 1167721978u, 0, LDEXP_TOLERANCE, 0},
{ 126, 1064708193u, 2181267016u, 0u, 42u, 1108748385u, 2181267016u, 0, LDEXP_TOLERANCE, 0},
{ 127, 1077871417u, 2549219008u, 0u, 424u, 1522467641u, 2549219008u, 0, LDEXP_TOLERANCE, 0},
{ 128, 3198004943u, 1792969424u, 0u, 225u, 3433934543u, 1792969424u, 0, LDEXP_TOLERANCE, 0},
{ 129, 3216855791u, 1978756209u, 0u, 494u, 3734852335u, 1978756209u, 0, LDEXP_TOLERANCE, 0},
{ 130, 1077949895u, 2382114971u, 0u, 63u, 1144010183u, 2382114971u, 0, LDEXP_TOLERANCE, 0},
{ 131, 3195894477u, 514482752u, 0u, 472u, 3690822349u, 514482752u, 0, LDEXP_TOLERANCE, 0},
{ 132, 3242413319u, 543068462u, 0u, 443u, 3706932487u, 543068462u, 0, LDEXP_TOLERANCE, 0},
{ 133, 3204701180u, 2652073890u, 0u, 199u, 3413367804u, 2652073890u, 0, LDEXP_TOLERANCE, 0},
{ 134, 1061328546u, 1489535917u, 0u, 473u, 1557304994u, 1489535917u, 0, LDEXP_TOLERANCE, 0},
{ 135, 1052674720u, 3229843554u, 0u, 441u, 1515096736u, 3229843554u, 0, LDEXP_TOLERANCE, 0},
{ 136, 1097158000u, 173134582u, 0u, 79u, 1179995504u, 173134582u, 0, LDEXP_TOLERANCE, 0},
{ 137, 3237498591u, 1923844009u, 0u, 176u, 3422047967u, 1923844009u, 0, LDEXP_TOLERANCE, 0},
{ 138, 3224533985u, 668606628u, 0u, 441u, 3686956001u, 668606628u, 0, LDEXP_TOLERANCE, 0},
{ 139, 1068442768u, 582256337u, 0u, 144u, 1219437712u, 582256337u, 0, LDEXP_TOLERANCE, 0},
{ 140, 3213406340u, 1255215774u, 0u, 169u, 3390615684u, 1255215774u, 0, LDEXP_TOLERANCE, 0},
{ 141, 3206436910u, 3262514920u, 0u, 401u, 3626915886u, 3262514920u, 0, LDEXP_TOLERANCE, 0},
{ 142, 3211518779u, 2001934786u, 0u, 8u, 3219907387u, 2001934786u, 0, LDEXP_TOLERANCE, 0},
{ 143, 3198655042u, 3323394293u, 0u, 424u, 3643251266u, 3323394293u, 0, LDEXP_TOLERANCE, 0},
{ 144, 1102056915u, 2833190961u, 0u, 141u, 1249906131u, 2833190961u, 0, LDEXP_TOLERANCE, 0},
{ 145, 3206978856u, 845263327u, 0u, 219u, 3436617000u, 845263327u, 0, LDEXP_TOLERANCE, 0},
{ 146, 1075424006u, 3731374023u, 0u, 315u, 1405725446u, 3731374023u, 0, LDEXP_TOLERANCE, 0},
{ 147, 1079280993u, 917682262u, 0u, 98u, 1182041441u, 917682262u, 0, LDEXP_TOLERANCE, 0},
{ 148, 3241806761u, 233010859u, 0u, 477u, 3741977513u, 233010859u, 0, LDEXP_TOLERANCE, 0},
{ 149, 3235133813u, 2553517871u, 0u, 397u, 3651418485u, 2553517871u, 0, LDEXP_TOLERANCE, 0},
{ 150, 3207128644u, 1115950480u, 0u, 186u, 3402163780u, 1115950480u, 0, LDEXP_TOLERANCE, 0},
{ 151, 3204087297u, 2664821947u, 0u, 239u, 3454696961u, 2664821947u, 0, LDEXP_TOLERANCE, 0},
{ 152, 1071548167u, 3557912224u, 0u, 384u, 1474201351u, 3557912224u, 0, LDEXP_TOLERANCE, 0},
{ 153, 1081218889u, 2614232599u, 0u, 397u, 1497503561u, 2614232599u, 0, LDEXP_TOLERANCE, 0},
{ 154, 3216359929u, 1186945904u, 0u, 6u, 3222651385u, 1186945904u, 0, LDEXP_TOLERANCE, 0},
{ 155, 3239606498u, 829492767u, 0u, 92u, 3336075490u, 829492767u, 0, LDEXP_TOLERANCE, 0},
{ 156, 3226435447u, 2285296565u, 0u, 124u, 3356458871u, 2285296565u, 0, LDEXP_TOLERANCE, 0},
{ 157, 1055298632u, 2224685509u, 0u, 351u, 1423348808u, 2224685509u, 0, LDEXP_TOLERANCE, 0},
{ 158, 1079682185u, 2193774608u, 0u, 373u, 1470801033u, 2193774608u, 0, LDEXP_TOLERANCE, 0},
{ 159, 1043796692u, 2811972465u, 0u, 360u, 1421284052u, 2811972465u, 0, LDEXP_TOLERANCE, 0},
{ 160, 3190948438u, 1320866227u, 0u, 55u, 3248620118u, 1320866227u, 0, LDEXP_TOLERANCE, 0},
{ 161, 3204972194u, 309600080u, 0u, 150u, 3362258594u, 309600080u, 0, LDEXP_TOLERANCE, 0},
{ 162, 3247074394u, 4153979484u, 0u, 45u, 3294260314u, 4153979484u, 0, LDEXP_TOLERANCE, 0},
{ 163, 3245817826u, 4108948538u, 0u, 12u, 3258400738u, 4108948538u, 0, LDEXP_TOLERANCE, 0},
{ 164, 3214264384u, 1462119906u, 0u, 294u, 3522545728u, 1462119906u, 0, LDEXP_TOLERANCE, 0},
{ 165, 3197805498u, 3712598596u, 0u, 84u, 3285885882u, 3712598596u, 0, LDEXP_TOLERANCE, 0},
{ 166, 1067754068u, 3317653467u, 0u, 441u, 1530176084u, 3317653467u, 0, LDEXP_TOLERANCE, 0},
{ 167, 3205582754u, 2014267986u, 0u, 326u, 3547418530u, 2014267986u, 0, LDEXP_TOLERANCE, 0},
{ 168, 3249218409u, 3614018702u, 0u, 313u, 3577422697u, 3614018702u, 0, LDEXP_TOLERANCE, 0},
{ 169, 3229701513u, 2650850527u, 0u, 332u, 3577828745u, 2650850527u, 0, LDEXP_TOLERANCE, 0},
{ 170, 3225393003u, 2146825072u, 0u, 43u, 3270481771u, 2146825072u, 0, LDEXP_TOLERANCE, 0},
{ 171, 1090587893u, 3181518164u, 0u, 394u, 1503726837u, 3181518164u, 0, LDEXP_TOLERANCE, 0},
{ 172, 1083643710u, 311336721u, 0u, 16u, 1100420926u, 311336721u, 0, LDEXP_TOLERANCE, 0},
{ 173, 1045850005u, 536548906u, 0u, 136u, 1188456341u, 536548906u, 0, LDEXP_TOLERANCE, 0},
{ 174, 1093294119u, 493054331u, 0u, 458u, 1573541927u, 493054331u, 0, LDEXP_TOLERANCE, 0},
{ 175, 1059637485u, 1636490194u, 0u, 59u, 1121503469u, 1636490194u, 0, LDEXP_TOLERANCE, 0},
{ 176, 1051839122u, 1496609373u, 0u, 419u, 1491192466u, 1496609373u, 0, LDEXP_TOLERANCE, 0},
{ 177, 3217713352u, 4047547022u, 0u, 40u, 3259656392u, 4047547022u, 0, LDEXP_TOLERANCE, 0},
{ 178, 1052826789u, 1743733981u, 0u, 236u, 1300290725u, 1743733981u, 0, LDEXP_TOLERANCE, 0},
{ 179, 3239738856u, 1894485819u, 0u, 206u, 3455745512u, 1894485819u, 0, LDEXP_TOLERANCE, 0},
{ 180, 3241794374u, 3239269504u, 0u, 301u, 3557415750u, 3239269504u, 0, LDEXP_TOLERANCE, 0},
{ 181, 1082295059u, 2514398118u, 0u, 320u, 1417839379u, 2514398118u, 0, LDEXP_TOLERANCE, 0},
{ 182, 3239385933u, 2805194172u, 0u, 460u, 3721730893u, 2805194172u, 0, LDEXP_TOLERANCE, 0},
{ 183, 1046578695u, 88098545u, 0u, 342u, 1405191687u, 88098545u, 0, LDEXP_TOLERANCE, 0},
{ 184, 3234688596u, 2841362123u, 0u, 402u, 3656216148u, 2841362123u, 0, LDEXP_TOLERANCE, 0},
{ 185, 1074460694u, 2662035051u, 0u, 251u, 1337653270u, 2662035051u, 0, LDEXP_TOLERANCE, 0},
{ 186, 1107283576u, 1757901351u, 0u, 14u, 1121963640u, 1757901351u, 0, LDEXP_TOLERANCE, 0},
{ 187, 3246529140u, 1690749449u, 0u, 259u, 3518110324u, 1690749449u, 0, LDEXP_TOLERANCE, 0},
{ 188, 3205695979u, 452086895u, 0u, 290u, 3509783019u, 452086895u, 0, LDEXP_TOLERANCE, 0},
{ 189, 3245113300u, 3993463847u, 0u, 367u, 3629940692u, 3993463847u, 0, LDEXP_TOLERANCE, 0},
{ 190, 1081866822u, 2441536203u, 0u, 276u, 1371273798u, 2441536203u, 0, LDEXP_TOLERANCE, 0},
{ 191, 1069205029u, 2446986142u, 0u, 436u, 1526384165u, 2446986142u, 0, LDEXP_TOLERANCE, 0},
{ 192, 1100226690u, 3561788365u, 0u, 90u, 1194598530u, 3561788365u, 0, LDEXP_TOLERANCE, 0},
{ 193, 3217905473u, 2182131707u, 0u, 49u, 3269285697u, 2182131707u, 0, LDEXP_TOLERANCE, 0},
{ 194, 1074481825u, 1411649658u, 0u, 265u, 1352354465u, 1411649658u, 0, LDEXP_TOLERANCE, 0},
{ 195, 1098423846u, 1729843483u, 0u, 213u, 1321770534u, 1729843483u, 0, LDEXP_TOLERANCE, 0},
{ 196, 3206635099u, 3105740969u, 0u, 255u, 3474021979u, 3105740969u, 0, LDEXP_TOLERANCE, 0},
{ 197, 1069626394u, 395560434u, 0u, 447u, 1538339866u, 395560434u, 0, LDEXP_TOLERANCE, 0},
{ 198, 1096244467u, 3644230845u, 0u, 166u, 1270308083u, 3644230845u, 0, LDEXP_TOLERANCE, 0},
{ 199, 1065716026u, 120488169u, 0u, 345u, 1427474746u, 120488169u, 0, LDEXP_TOLERANCE, 0},
{ 200, 3239481707u, 1635144910u, 0u, 12u, 3252064619u, 1635144910u, 0, LDEXP_TOLERANCE, 0},
{ 201, 3188033119u, 3901916594u, 0u, 55u, 3245704799u, 3901916594u, 0, LDEXP_TOLERANCE, 0},
{ 202, 1048893172u, 1520233772u, 0u, 138u, 1193596660u, 1520233772u, 0, LDEXP_TOLERANCE, 0},
{ 203, 3243444050u, 2174480394u, 0u, 427u, 3691186002u, 2174480394u, 0, LDEXP_TOLERANCE, 0},
{ 204, 3227041648u, 2170587119u, 0u, 22u, 3250110320u, 2170587119u, 0, LDEXP_TOLERANCE, 0},
{ 205, 1058401310u, 1861796818u, 0u, 202u, 1270213662u, 1861796818u, 0, LDEXP_TOLERANCE, 0},
{ 206, 3226315730u, 3847770185u, 0u, 380u, 3624774610u, 3847770185u, 0, LDEXP_TOLERANCE, 0},
{ 207, 1069595396u, 541754047u, 0u, 233u, 1313913604u, 541754047u, 0, LDEXP_TOLERANCE, 0},
{ 208, 3212663474u, 272319256u, 0u, 131u, 3350026930u, 272319256u, 0, LDEXP_TOLERANCE, 0},
{ 209, 1059284620u, 3096749920u, 0u, 483u, 1565746828u, 3096749920u, 0, LDEXP_TOLERANCE, 0},
{ 210, 1076067883u, 2272922429u, 0u, 352u, 1445166635u, 2272922429u, 0, LDEXP_TOLERANCE, 0},
{ 211, 3230247604u, 3220743043u, 0u, 231u, 3472468660u, 3220743043u, 0, LDEXP_TOLERANCE, 0},
{ 212, 1050651323u, 2300380149u, 0u, 114u, 1170188987u, 2300380149u, 0, LDEXP_TOLERANCE, 0},
{ 213, 1072722410u, 2437243415u, 0u, 305u, 1392538090u, 2437243415u, 0, LDEXP_TOLERANCE, 0},
{ 214, 3231053247u, 3661627618u, 0u, 79u, 3313890751u, 3661627618u, 0, LDEXP_TOLERANCE, 0},
{ 215, 1041819430u, 1831574607u, 0u, 120u, 1167648550u, 1831574607u, 0, LDEXP_TOLERANCE, 0},
{ 216, 3236399793u, 2527076176u, 0u, 260u, 3509029553u, 2527076176u, 0, LDEXP_TOLERANCE, 0},
{ 217, 3195290997u, 2676398686u, 0u, 117u, 3317974389u, 2676398686u, 0, LDEXP_TOLERANCE, 0},
{ 218, 3193437916u, 1339584035u, 0u, 123u, 3322412764u, 1339584035u, 0, LDEXP_TOLERANCE, 0},
{ 219, 1095503867u, 3529401650u, 0u, 40u, 1137446907u, 3529401650u, 0, LDEXP_TOLERANCE, 0},
{ 220, 1048913359u, 263139465u, 0u, 226u, 1285891535u, 263139465u, 0, LDEXP_TOLERANCE, 0},
{ 221, 3234381459u, 2044871840u, 0u, 275u, 3522739859u, 2044871840u, 0, LDEXP_TOLERANCE, 0},
{ 222, 1103621815u, 1760748810u, 0u, 143u, 1253568183u, 1760748810u, 0, LDEXP_TOLERANCE, 0},
{ 223, 3233696138u, 3631905577u, 0u, 59u, 3295562122u, 3631905577u, 0, LDEXP_TOLERANCE, 0},
{ 224, 1090844360u, 895635283u, 0u, 327u, 1433728712u, 895635283u, 0, LDEXP_TOLERANCE, 0},
{ 225, 3211740211u, 3230452686u, 0u, 315u, 3542041651u, 3230452686u, 0, LDEXP_TOLERANCE, 0},
{ 226, 1075422810u, 1864139509u, 0u, 202u, 1287235162u, 1864139509u, 0, LDEXP_TOLERANCE, 0},
{ 227, 1091534863u, 3652704631u, 0u, 282u, 1387233295u, 3652704631u, 0, LDEXP_TOLERANCE, 0},
{ 228, 1055756112u, 945524907u, 0u, 417u, 1493012304u, 945524907u, 0, LDEXP_TOLERANCE, 0},
{ 229, 1042592415u, 3193385121u, 0u, 459u, 1523888799u, 3193385121u, 0, LDEXP_TOLERANCE, 0},
{ 230, 1097323612u, 2009367488u, 0u, 361u, 1475859548u, 2009367488u, 0, LDEXP_TOLERANCE, 0},
{ 231, 1080597180u, 424248253u, 0u, 445u, 1547213500u, 424248253u, 0, LDEXP_TOLERANCE, 0},
{ 232, 1042985978u, 1729313551u, 0u, 74u, 1120580602u, 1729313551u, 0, LDEXP_TOLERANCE, 0},
{ 233, 1052968515u, 262785866u, 0u, 366u, 1436747331u, 262785866u, 0, LDEXP_TOLERANCE, 0},
{ 234, 3201825802u, 1027600628u, 0u, 222u, 3434609674u, 1027600628u, 0, LDEXP_TOLERANCE, 0},
{ 235, 3189614508u, 2863482262u, 0u, 205u, 3404572588u, 2863482262u, 0, LDEXP_TOLERANCE, 0},
{ 236, 1087207520u, 2536788461u, 0u, 408u, 1515026528u, 2536788461u, 0, LDEXP_TOLERANCE, 0},
{ 237, 3220884452u, 1052878591u, 0u, 219u, 3450522596u, 1052878591u, 0, LDEXP_TOLERANCE, 0},
{ 238, 1050895039u, 3686077741u, 0u, 270u, 1334010559u, 3686077741u, 0, LDEXP_TOLERANCE, 0},
{ 239, 1072905134u, 3151697799u, 0u, 450u, 1544764334u, 3151697799u, 0, LDEXP_TOLERANCE, 0},
{ 240, 3199889853u, 3750592285u, 0u, 80u, 3283775933u, 3750592285u, 0, LDEXP_TOLERANCE, 0},
{ 241, 3195141686u, 524180329u, 0u, 335u, 3546414646u, 524180329u, 0, LDEXP_TOLERANCE, 0},
{ 242, 3237769823u, 549692228u, 0u, 429u, 3687608927u, 549692228u, 0, LDEXP_TOLERANCE, 0},
{ 243, 1044977851u, 123460729u, 0u, 325u, 1385765051u, 123460729u, 0, LDEXP_TOLERANCE, 0},
{ 244, 1103902874u, 3456203663u, 0u, 454u, 1579956378u, 3456203663u, 0, LDEXP_TOLERANCE, 0},
{ 245, 3221154648u, 2341156808u, 0u, 369u, 3608079192u, 2341156808u, 0, LDEXP_TOLERANCE, 0},
{ 246, 1089754623u, 3952801936u, 0u, 43u, 1134843391u, 3952801936u, 0, LDEXP_TOLERANCE, 0},
{ 247, 3207212058u, 563170079u, 0u, 150u, 3364498458u, 563170079u, 0, LDEXP_TOLERANCE, 0},
{ 248, 3225869468u, 1535381711u, 0u, 384u, 3628522652u, 1535381711u, 0, LDEXP_TOLERANCE, 0},
{ 249, 1054391309u, 4072415576u, 0u, 9u, 1063828493u, 4072415576u, 0, LDEXP_TOLERANCE, 0},
{ 250, 3209063031u, 3109049640u, 0u, 91u, 3304483447u, 3109049640u, 0, LDEXP_TOLERANCE, 0},
{ 251, 3218136187u, 2738823198u, 0u, 33u, 3252739195u, 2738823198u, 0, LDEXP_TOLERANCE, 0},
{ 252, 1061175490u, 1144180871u, 0u, 106u, 1172324546u, 1144180871u, 0, LDEXP_TOLERANCE, 0},
{ 253, 1096418100u, 1619819023u, 0u, 54u, 1153041204u, 1619819023u, 0, LDEXP_TOLERANCE, 0},
{ 254, 1071954071u, 2285696073u, 0u, 430u, 1522841751u, 2285696073u, 0, LDEXP_TOLERANCE, 0},
{ 255, 1072459589u, 1537999144u, 0u, 464u, 1558998853u, 1537999144u, 0, LDEXP_TOLERANCE, 0},
{ 256, 3235749098u, 157845884u, 0u, 443u, 3700268266u, 157845884u, 0, LDEXP_TOLERANCE, 0},
{ 257, 3222630024u, 232194256u, 0u, 125u, 3353702024u, 232194256u, 0, LDEXP_TOLERANCE, 0},
{ 258, 3241510667u, 1984016330u, 0u, 187u, 3437594379u, 1984016330u, 0, LDEXP_TOLERANCE, 0},
{ 259, 1076548691u, 4276701845u, 0u, 160u, 1244320851u, 4276701845u, 0, LDEXP_TOLERANCE, 0},
{ 260, 1093262183u, 458381635u, 0u, 32u, 1126816615u, 458381635u, 0, LDEXP_TOLERANCE, 0},
{ 261, 3217410826u, 2931856236u, 0u, 5u, 3222653706u, 2931856236u, 0, LDEXP_TOLERANCE, 0},
{ 262, 3188629767u, 978126928u, 0u, 295u, 3497959687u, 978126928u, 0, LDEXP_TOLERANCE, 0},
{ 263, 3222362209u, 1190217203u, 0u, 457u, 3701561441u, 1190217203u, 0, LDEXP_TOLERANCE, 0},
{ 264, 3219622048u, 3145593339u, 0u, 490u, 3733424288u, 3145593339u, 0, LDEXP_TOLERANCE, 0},
{ 265, 1085737474u, 637782232u, 0u, 393u, 1497827842u, 637782232u, 0, LDEXP_TOLERANCE, 0},
{ 266, 1063416038u, 2567938216u, 0u, 233u, 1307734246u, 2567938216u, 0, LDEXP_TOLERANCE, 0},
{ 267, 3245869330u, 1885951730u, 0u, 220u, 3476556050u, 1885951730u, 0, LDEXP_TOLERANCE, 0},
{ 268, 3207806174u, 2553919637u, 0u, 157u, 3372432606u, 2553919637u, 0, LDEXP_TOLERANCE, 0},
{ 269, 3247429520u, 2146563695u, 0u, 146u, 3400521616u, 2146563695u, 0, LDEXP_TOLERANCE, 0},
{ 270, 1061008451u, 1671615226u, 0u, 151u, 1219343427u, 1671615226u, 0, LDEXP_TOLERANCE, 0},
{ 271, 1076028796u, 3859211180u, 0u, 219u, 1305666940u, 3859211180u, 0, LDEXP_TOLERANCE, 0},
{ 272, 1072363386u, 1650981745u, 0u, 51u, 1125840762u, 1650981745u, 0, LDEXP_TOLERANCE, 0},
{ 273, 1068183512u, 1475114165u, 0u, 177u, 1253781464u, 1475114165u, 0, LDEXP_TOLERANCE, 0},
{ 274, 1097775870u, 2570983571u, 0u, 19u, 1117698814u, 2570983571u, 0, LDEXP_TOLERANCE, 0},
{ 275, 3249504174u, 4161096849u, 0u, 207u, 3466559406u, 4161096849u, 0, LDEXP_TOLERANCE, 0},
{ 276, 1107277558u, 4024344323u, 0u, 272u, 1392490230u, 4024344323u, 0, LDEXP_TOLERANCE, 0},
{ 277, 3238437161u, 2611187549u, 0u, 97u, 3340149033u, 2611187549u, 0, LDEXP_TOLERANCE, 0},
{ 278, 1045834828u, 3078509746u, 0u, 63u, 1111895116u, 3078509746u, 0, LDEXP_TOLERANCE, 0},
{ 279, 1089189384u, 2227116198u, 0u, 109u, 1203484168u, 2227116198u, 0, LDEXP_TOLERANCE, 0},
{ 280, 1080684976u, 1472665012u, 0u, 366u, 1464463792u, 1472665012u, 0, LDEXP_TOLERANCE, 0},
{ 281, 1080318978u, 3071232825u, 0u, 488u, 1592024066u, 3071232825u, 0, LDEXP_TOLERANCE, 0},
{ 282, 3205503940u, 437403482u, 0u, 267u, 3485473732u, 437403482u, 0, LDEXP_TOLERANCE, 0},
{ 283, 1062227791u, 4288608311u, 0u, 270u, 1345343311u, 4288608311u, 0, LDEXP_TOLERANCE, 0},
{ 284, 1044502599u, 349540356u, 0u, 19u, 1064425543u, 349540356u, 0, LDEXP_TOLERANCE, 0},
{ 285, 1043598726u, 944335909u, 0u, 297u, 1355025798u, 944335909u, 0, LDEXP_TOLERANCE, 0},
{ 286, 1051582533u, 2123384287u, 0u, 71u, 1126031429u, 2123384287u, 0, LDEXP_TOLERANCE, 0},
{ 287, 3198090050u, 2528390848u, 0u, 251u, 3461282626u, 2528390848u, 0, LDEXP_TOLERANCE, 0},
{ 288, 3240457093u, 132926909u, 0u, 67u, 3310711685u, 132926909u, 0, LDEXP_TOLERANCE, 0},
{ 289, 3246632231u, 40413554u, 0u, 24u, 3271798055u, 40413554u, 0, LDEXP_TOLERANCE, 0},
{ 290, 3200875834u, 3443172377u, 0u, 470u, 3693706554u, 3443172377u, 0, LDEXP_TOLERANCE, 0},
{ 291, 1081721846u, 373222953u, 0u, 163u, 1252639734u, 373222953u, 0, LDEXP_TOLERANCE, 0},
{ 292, 3194233874u, 2533101358u, 0u, 78u, 3276022802u, 2533101358u, 0, LDEXP_TOLERANCE, 0},
{ 293, 3234400000u, 1020015106u, 0u, 458u, 3714647808u, 1020015106u, 0, LDEXP_TOLERANCE, 0},
{ 294, 1097650417u, 4175026874u, 0u, 175u, 1281151217u, 4175026874u, 0, LDEXP_TOLERANCE, 0},
{ 295, 3217062816u, 3412658638u, 0u, 18u, 3235937184u, 3412658638u, 0, LDEXP_TOLERANCE, 0},
{ 296, 1041317040u, 3644551949u, 0u, 286u, 1341209776u, 3644551949u, 0, LDEXP_TOLERANCE, 0},
{ 297, 1097752504u, 778944340u, 0u, 426u, 1544445880u, 778944340u, 0, LDEXP_TOLERANCE, 0},
{ 298, 1067680885u, 937732557u, 0u, 71u, 1142129781u, 937732557u, 0, LDEXP_TOLERANCE, 0},
{ 299, 1086736464u, 2862118510u, 0u, 461u, 1570130000u, 2862118510u, 0, LDEXP_TOLERANCE, 0},
{ 300, 1096901686u, 850134980u, 0u, 211u, 1318151222u, 850134980u, 0, LDEXP_TOLERANCE, 0},
{ 301, 3251210973u, 4095059472u, 0u, 442u, 3714681565u, 4095059472u, 0, LDEXP_TOLERANCE, 0},
{ 302, 3245779466u, 1314480053u, 0u, 144u, 3396774410u, 1314480053u, 0, LDEXP_TOLERANCE, 0},
{ 303, 1090422995u, 2303828445u, 0u, 388u, 1497270483u, 2303828445u, 0, LDEXP_TOLERANCE, 0},
{ 304, 1096895426u, 3882733009u, 0u, 191u, 1297173442u, 3882733009u, 0, LDEXP_TOLERANCE, 0},
{ 305, 1089588191u, 2009174302u, 0u, 496u, 1609681887u, 2009174302u, 0, LDEXP_TOLERANCE, 0},
{ 306, 1097495331u, 312449728u, 0u, 173u, 1278898979u, 312449728u, 0, LDEXP_TOLERANCE, 0},
{ 307, 1049684114u, 1160162008u, 0u, 212u, 1271982226u, 1160162008u, 0, LDEXP_TOLERANCE, 0},
{ 308, 3209944762u, 670974566u, 0u, 343u, 3569606330u, 670974566u, 0, LDEXP_TOLERANCE, 0},
{ 309, 3221122343u, 2051675610u, 0u, 390u, 3630066983u, 2051675610u, 0, LDEXP_TOLERANCE, 0},
{ 310, 1042941085u, 1098012699u, 0u, 155u, 1205470365u, 1098012699u, 0, LDEXP_TOLERANCE, 0},
{ 311, 3198635158u, 2576510619u, 0u, 399u, 3617016982u, 2576510619u, 0, LDEXP_TOLERANCE, 0},
{ 312, 1093732734u, 2212627257u, 0u, 220u, 1324419454u, 2212627257u, 0, LDEXP_TOLERANCE, 0},
{ 313, 1079731753u, 2815026996u, 0u, 352u, 1448830505u, 2815026996u, 0, LDEXP_TOLERANCE, 0},
{ 314, 1057143242u, 908275876u, 0u, 334u, 1407367626u, 908275876u, 0, LDEXP_TOLERANCE, 0},
{ 315, 3228249088u, 4054744334u, 0u, 389u, 3636145152u, 4054744334u, 0, LDEXP_TOLERANCE, 0},
{ 316, 1051974004u, 749718883u, 0u, 80u, 1135860084u, 749718883u, 0, LDEXP_TOLERANCE, 0},
{ 317, 3214025736u, 4166701781u, 0u, 480u, 3717342216u, 4166701781u, 0, LDEXP_TOLERANCE, 0},
{ 318, 1066562662u, 3849549110u, 0u, 336u, 1418884198u, 3849549110u, 0, LDEXP_TOLERANCE, 0},
{ 319, 3191009014u, 3648637481u, 0u, 438u, 3650285302u, 3648637481u, 0, LDEXP_TOLERANCE, 0},
{ 320, 3205610460u, 229827507u, 0u, 298u, 3518086108u, 229827507u, 0, LDEXP_TOLERANCE, 0},
{ 321, 1096643939u, 4161699205u, 0u, 413u, 1529705827u, 4161699205u, 0, LDEXP_TOLERANCE, 0},
{ 322, 3195639002u, 2610757921u, 0u, 297u, 3507066074u, 2610757921u, 0, LDEXP_TOLERANCE, 0},
{ 323, 1101813983u, 545051245u, 0u, 68u, 1173117151u, 545051245u, 0, LDEXP_TOLERANCE, 0},
{ 324, 3220046694u, 3097521578u, 0u, 11u, 3231581030u, 3097521578u, 0, LDEXP_TOLERANCE, 0},
{ 325, 3216630070u, 1141349287u, 0u, 485u, 3725189430u, 1141349287u, 0, LDEXP_TOLERANCE, 0},
{ 326, 3236866557u, 3586841689u, 0u, 44u, 3283003901u, 3586841689u, 0, LDEXP_TOLERANCE, 0},
{ 327, 1089595934u, 2642699773u, 0u, 52u, 1144121886u, 2642699773u, 0, LDEXP_TOLERANCE, 0},
{ 328, 3233606825u, 1521902674u, 0u, 334u, 3583831209u, 1521902674u, 0, LDEXP_TOLERANCE, 0},
{ 329, 1066370780u, 1166542459u, 0u, 333u, 1415546588u, 1166542459u, 0, LDEXP_TOLERANCE, 0},
{ 330, 3220123386u, 2769313057u, 0u, 150u, 3377409786u, 2769313057u, 0, LDEXP_TOLERANCE, 0},
{ 331, 1098471976u, 1840369334u, 0u, 14u, 1113152040u, 1840369334u, 0, LDEXP_TOLERANCE, 0},
{ 332, 3252677278u, 2567854096u, 0u, 248u, 3512724126u, 2567854096u, 0, LDEXP_TOLERANCE, 0},
{ 333, 1070061501u, 1222383416u, 0u, 474u, 1567086525u, 1222383416u, 0, LDEXP_TOLERANCE, 0},
{ 334, 3207981719u, 1270950554u, 0u, 256u, 3476417175u, 1270950554u, 0, LDEXP_TOLERANCE, 0},
{ 335, 1041332729u, 131817720u, 0u, 452u, 1515289081u, 131817720u, 0, LDEXP_TOLERANCE, 0},
{ 336, 1043119240u, 1962885016u, 0u, 374u, 1435286664u, 1962885016u, 0, LDEXP_TOLERANCE, 0},
{ 337, 3218047470u, 3052053491u, 0u, 468u, 3708781038u, 3052053491u, 0, LDEXP_TOLERANCE, 0},
{ 338, 1066224243u, 4082134039u, 0u, 227u, 1304250995u, 4082134039u, 0, LDEXP_TOLERANCE, 0},
{ 339, 3203939696u, 1286929228u, 0u, 35u, 3240639856u, 1286929228u, 0, LDEXP_TOLERANCE, 0},
{ 340, 3202852071u, 1723150716u, 0u, 177u, 3388450023u, 1723150716u, 0, LDEXP_TOLERANCE, 0},
{ 341, 3228645956u, 3351728246u, 0u, 228u, 3467721284u, 3351728246u, 0, LDEXP_TOLERANCE, 0},
{ 342, 1081598008u, 3664833573u, 0u, 167u, 1256710200u, 3664833573u, 0, LDEXP_TOLERANCE, 0},
{ 343, 1104965247u, 143071571u, 0u, 448u, 1574727295u, 143071571u, 0, LDEXP_TOLERANCE, 0},
{ 344, 1050966579u, 2318822594u, 0u, 195u, 1255438899u, 2318822594u, 0, LDEXP_TOLERANCE, 0},
{ 345, 1093372204u, 709906874u, 0u, 330u, 1439402284u, 709906874u, 0, LDEXP_TOLERANCE, 0},
{ 346, 3231728166u, 566369690u, 0u, 261u, 3505406502u, 566369690u, 0, LDEXP_TOLERANCE, 0},
{ 347, 3216582391u, 4025642424u, 0u, 291u, 3521718007u, 4025642424u, 0, LDEXP_TOLERANCE, 0},
{ 348, 1062802257u, 1894196767u, 0u, 383u, 1464406865u, 1894196767u, 0, LDEXP_TOLERANCE, 0},
{ 349, 3245017107u, 3370316038u, 0u, 355u, 3617261587u, 3370316038u, 0, LDEXP_TOLERANCE, 0},
{ 350, 3243448963u, 472093737u, 0u, 342u, 3602061955u, 472093737u, 0, LDEXP_TOLERANCE, 0},
{ 351, 1075652455u, 1775629954u, 0u, 415u, 1510811495u, 1775629954u, 0, LDEXP_TOLERANCE, 0},
{ 352, 1072748883u, 130452005u, 0u, 460u, 1555093843u, 130452005u, 0, LDEXP_TOLERANCE, 0},
{ 353, 1103299779u, 947955476u, 0u, 82u, 1189283011u, 947955476u, 0, LDEXP_TOLERANCE, 0},
{ 354, 1101236445u, 2334159798u, 0u, 108u, 1214482653u, 2334159798u, 0, LDEXP_TOLERANCE, 0},
{ 355, 1070535958u, 4123069999u, 0u, 150u, 1227822358u, 4123069999u, 0, LDEXP_TOLERANCE, 0},
{ 356, 1089976512u, 2465499154u, 0u, 266u, 1368897728u, 2465499154u, 0, LDEXP_TOLERANCE, 0},
{ 357, 3201817089u, 1593603389u, 0u, 407u, 3628587521u, 1593603389u, 0, LDEXP_TOLERANCE, 0},
{ 358, 1047787098u, 2933875948u, 0u, 108u, 1161033306u, 2933875948u, 0, LDEXP_TOLERANCE, 0},
{ 359, 1079279810u, 1807691639u, 0u, 444u, 1544847554u, 1807691639u, 0, LDEXP_TOLERANCE, 0},
{ 360, 1043880753u, 3730428641u, 0u, 463u, 1529371441u, 3730428641u, 0, LDEXP_TOLERANCE, 0},
{ 361, 1096723626u, 3360816360u, 0u, 427u, 1544465578u, 3360816360u, 0, LDEXP_TOLERANCE, 0},
{ 362, 3197488312u, 1678396836u, 0u, 238u, 3447049400u, 1678396836u, 0, LDEXP_TOLERANCE, 0},
{ 363, 3226762726u, 424413376u, 0u, 258u, 3497295334u, 424413376u, 0, LDEXP_TOLERANCE, 0},
{ 364, 1080633926u, 3716185739u, 0u, 187u, 1276717638u, 3716185739u, 0, LDEXP_TOLERANCE, 0},
{ 365, 3204867490u, 3920379359u, 0u, 431u, 3656803746u, 3920379359u, 0, LDEXP_TOLERANCE, 0},
{ 366, 3215772443u, 1323631105u, 0u, 191u, 3416050459u, 1323631105u, 0, LDEXP_TOLERANCE, 0},
{ 367, 1050683091u, 2514548244u, 0u, 173u, 1232086739u, 2514548244u, 0, LDEXP_TOLERANCE, 0},
{ 368, 3239000308u, 1788218301u, 0u, 34u, 3274651892u, 1788218301u, 0, LDEXP_TOLERANCE, 0},
{ 369, 3237555984u, 1830011528u, 0u, 319u, 3572051728u, 1830011528u, 0, LDEXP_TOLERANCE, 0},
{ 370, 1092971882u, 513397822u, 0u, 220u, 1323658602u, 513397822u, 0, LDEXP_TOLERANCE, 0},
{ 371, 3195171314u, 444369027u, 0u, 36u, 3232920050u, 444369027u, 0, LDEXP_TOLERANCE, 0},
{ 372, 1090970899u, 3889472979u, 0u, 419u, 1530324243u, 3889472979u, 0, LDEXP_TOLERANCE, 0},
{ 373, 1057363231u, 2309685487u, 0u, 378u, 1453724959u, 2309685487u, 0, LDEXP_TOLERANCE, 0},
{ 374, 1106459870u, 1380631766u, 0u, 437u, 1564687582u, 1380631766u, 0, LDEXP_TOLERANCE, 0},
{ 375, 3248396473u, 428200516u, 0u, 376u, 3642661049u, 428200516u, 0, LDEXP_TOLERANCE, 0},
{ 376, 1058529374u, 1388434855u, 0u, 328u, 1402462302u, 1388434855u, 0, LDEXP_TOLERANCE, 0},
{ 377, 1073564525u, 1634474775u, 0u, 306u, 1394428781u, 1634474775u, 0, LDEXP_TOLERANCE, 0},
{ 378, 3253676249u, 2523906064u, 0u, 39u, 3294570713u, 2523906064u, 0, LDEXP_TOLERANCE, 0},
{ 379, 1081755890u, 1525260440u, 0u, 250u, 1343899890u, 1525260440u, 0, LDEXP_TOLERANCE, 0},
{ 380, 3203074326u, 1872475395u, 0u, 108u, 3316320534u, 1872475395u, 0, LDEXP_TOLERANCE, 0},
{ 381, 1084871394u, 3237497681u, 0u, 443u, 1549390562u, 3237497681u, 0, LDEXP_TOLERANCE, 0},
{ 382, 3242751645u, 260260645u, 0u, 481u, 3747116701u, 260260645u, 0, LDEXP_TOLERANCE, 0},
{ 383, 3218981444u, 4088124503u, 0u, 110u, 3334324804u, 4088124503u, 0, LDEXP_TOLERANCE, 0},
{ 384, 1071801993u, 814008375u, 0u, 336u, 1424123529u, 814008375u, 0, LDEXP_TOLERANCE, 0},
{ 385, 1066437805u, 3656359254u, 0u, 66u, 1135643821u, 3656359254u, 0, LDEXP_TOLERANCE, 0},
{ 386, 3203021744u, 2817965308u, 0u, 440u, 3664395184u, 2817965308u, 0, LDEXP_TOLERANCE, 0},
{ 387, 3230741411u, 1789555686u, 0u, 143u, 3380687779u, 1789555686u, 0, LDEXP_TOLERANCE, 0},
{ 388, 1080923606u, 1088945233u, 0u, 95u, 1180538326u, 1088945233u, 0, LDEXP_TOLERANCE, 0},
{ 389, 3207306559u, 1072535369u, 0u, 356u, 3580599615u, 1072535369u, 0, LDEXP_TOLERANCE, 0},
{ 390, 1070189724u, 891892107u, 0u, 31u, 1102695580u, 891892107u, 0, LDEXP_TOLERANCE, 0},
{ 391, 3190088451u, 2651702199u, 0u, 404u, 3613713155u, 2651702199u, 0, LDEXP_TOLERANCE, 0},
{ 392, 1060939155u, 4016460801u, 0u, 419u, 1500292499u, 4016460801u, 0, LDEXP_TOLERANCE, 0},
{ 393, 1045144591u, 3993557701u, 0u, 87u, 1136370703u, 3993557701u, 0, LDEXP_TOLERANCE, 0},
{ 394, 3239768936u, 2532362633u, 0u, 260u, 3512398696u, 2532362633u, 0, LDEXP_TOLERANCE, 0},
{ 395, 1073180085u, 3537487468u, 0u, 388u, 1480027573u, 3537487468u, 0, LDEXP_TOLERANCE, 0},
{ 396, 3198529584u, 564216088u, 0u, 421u, 3639980080u, 564216088u, 0, LDEXP_TOLERANCE, 0},
{ 397, 3231451722u, 144814872u, 0u, 377u, 3626764874u, 144814872u, 0, LDEXP_TOLERANCE, 0},
{ 398, 1072709093u, 596120394u, 0u, 25u, 1098923493u, 596120394u, 0, LDEXP_TOLERANCE, 0},
{ 399, 1067876025u, 3310262308u, 0u, 313u, 1396080313u, 3310262308u, 0, LDEXP_TOLERANCE, 0},
{ 400, 3213074059u, 4166287959u, 0u, 332u, 3561201291u, 4166287959u, 0, LDEXP_TOLERANCE, 0},
{ 401, 1041212112u, 3518868553u, 0u, 279u, 1333764816u, 3518868553u, 0, LDEXP_TOLERANCE, 0},
{ 402, 1066131946u, 3173459054u, 0u, 324u, 1405870570u, 3173459054u, 0, LDEXP_TOLERANCE, 0},
{ 403, 3202593969u, 1428731905u, 0u, 168u, 3378754737u, 1428731905u, 0, LDEXP_TOLERANCE, 0},
{ 404, 1054790485u, 453215326u, 0u, 371u, 1443812181u, 453215326u, 0, LDEXP_TOLERANCE, 0},
{ 405, 3200044385u, 467903731u, 0u, 183u, 3391933793u, 467903731u, 0, LDEXP_TOLERANCE, 0},
{ 406, 1072744324u, 1813392963u, 0u, 180u, 1261488004u, 1813392963u, 0, LDEXP_TOLERANCE, 0},
{ 407, 3227858678u, 3521174478u, 0u, 427u, 3675600630u, 3521174478u, 0, LDEXP_TOLERANCE, 0},
{ 408, 3220431019u, 1451134835u, 0u, 159u, 3387154603u, 1451134835u, 0, LDEXP_TOLERANCE, 0},
{ 409, 1072890925u, 478199813u, 0u, 188u, 1270023213u, 478199813u, 0, LDEXP_TOLERANCE, 0},
{ 410, 3247518236u, 2319141545u, 0u, 182u, 3438359068u, 2319141545u, 0, LDEXP_TOLERANCE, 0},
{ 411, 3205208241u, 468540316u, 0u, 236u, 3452672177u, 468540316u, 0, LDEXP_TOLERANCE, 0},
{ 412, 1088186210u, 2805548583u, 0u, 80u, 1172072290u, 2805548583u, 0, LDEXP_TOLERANCE, 0},
{ 413, 3208941801u, 3799277222u, 0u, 491u, 3723792617u, 3799277222u, 0, LDEXP_TOLERANCE, 0},
{ 414, 1098778634u, 4116114952u, 0u, 403u, 1521354762u, 4116114952u, 0, LDEXP_TOLERANCE, 0},
{ 415, 1089501101u, 3088319870u, 0u, 415u, 1524660141u, 3088319870u, 0, LDEXP_TOLERANCE, 0},
{ 416, 1092033606u, 4147340419u, 0u, 424u, 1536629830u, 4147340419u, 0, LDEXP_TOLERANCE, 0},
{ 417, 1097192134u, 2915618902u, 0u, 289u, 1400230598u, 2915618902u, 0, LDEXP_TOLERANCE, 0},
{ 418, 1083131407u, 949573155u, 0u, 213u, 1306478095u, 949573155u, 0, LDEXP_TOLERANCE, 0},
{ 419, 3217299226u, 953230084u, 0u, 56u, 3276019482u, 953230084u, 0, LDEXP_TOLERANCE, 0},
{ 420, 1042658166u, 1139656827u, 0u, 464u, 1529197430u, 1139656827u, 0, LDEXP_TOLERANCE, 0},
{ 421, 1074812004u, 1497640128u, 0u, 126u, 1206932580u, 1497640128u, 0, LDEXP_TOLERANCE, 0},
{ 422, 1049329601u, 1399097473u, 0u, 433u, 1503363009u, 1399097473u, 0, LDEXP_TOLERANCE, 0},
{ 423, 3206749408u, 547789874u, 0u, 431u, 3658685664u, 547789874u, 0, LDEXP_TOLERANCE, 0},
{ 424, 1074621795u, 671680995u, 0u, 3u, 1077767523u, 671680995u, 0, LDEXP_TOLERANCE, 0},
{ 425, 3213380440u, 2844394564u, 0u, 143u, 3363326808u, 2844394564u, 0, LDEXP_TOLERANCE, 0},
{ 426, 3237267124u, 1206228129u, 0u, 339u, 3592734388u, 1206228129u, 0, LDEXP_TOLERANCE, 0},
{ 427, 1048320712u, 1857527908u, 0u, 184u, 1241258696u, 1857527908u, 0, LDEXP_TOLERANCE, 0},
{ 428, 1073593099u, 3529728583u, 0u, 248u, 1333639947u, 3529728583u, 0, LDEXP_TOLERANCE, 0},
{ 429, 3208234855u, 1662197629u, 0u, 448u, 3677996903u, 1662197629u, 0, LDEXP_TOLERANCE, 0},
{ 430, 3227209251u, 830911610u, 0u, 206u, 3443215907u, 830911610u, 0, LDEXP_TOLERANCE, 0},
{ 431, 3191658671u, 3234651229u, 0u, 489u, 3704412335u, 3234651229u, 0, LDEXP_TOLERANCE, 0},
{ 432, 1060602604u, 1595574604u, 0u, 233u, 1304920812u, 1595574604u, 0, LDEXP_TOLERANCE, 0},
{ 433, 1060196346u, 2183973116u, 0u, 199u, 1268862970u, 2183973116u, 0, LDEXP_TOLERANCE, 0},
{ 434, 3237212525u, 2067967151u, 0u, 187u, 3433296237u, 2067967151u, 0, LDEXP_TOLERANCE, 0},
{ 435, 3249591914u, 4276685796u, 0u, 405u, 3674265194u, 4276685796u, 0, LDEXP_TOLERANCE, 0},
{ 436, 1097175658u, 915990537u, 0u, 414u, 1531286122u, 915990537u, 0, LDEXP_TOLERANCE, 0},
{ 437, 1096215811u, 3833628834u, 0u, 292u, 1402400003u, 3833628834u, 0, LDEXP_TOLERANCE, 0},
{ 438, 1081543609u, 2711665335u, 0u, 195u, 1286015929u, 2711665335u, 0, LDEXP_TOLERANCE, 0},
{ 439, 1103411165u, 2706155273u, 0u, 24u, 1128576989u, 2706155273u, 0, LDEXP_TOLERANCE, 0},
{ 440, 1103403130u, 3079968054u, 0u, 241u, 1356109946u, 3079968054u, 0, LDEXP_TOLERANCE, 0},
{ 441, 3198414665u, 2268506342u, 0u, 95u, 3298029385u, 2268506342u, 0, LDEXP_TOLERANCE, 0},
{ 442, 1047115221u, 1909994277u, 0u, 56u, 1105835477u, 1909994277u, 0, LDEXP_TOLERANCE, 0},
{ 443, 3220384775u, 2863812374u, 0u, 101u, 3326290951u, 2863812374u, 0, LDEXP_TOLERANCE, 0},
{ 444, 1100817899u, 1574724647u, 0u, 234u, 1346184683u, 1574724647u, 0, LDEXP_TOLERANCE, 0},
{ 445, 3224207486u, 2292911279u, 0u, 169u, 3401416830u, 2292911279u, 0, LDEXP_TOLERANCE, 0},
{ 446, 3210915147u, 1990631620u, 0u, 63u, 3276975435u, 1990631620u, 0, LDEXP_TOLERANCE, 0},
{ 447, 1102409950u, 2676261059u, 0u, 337u, 1455780062u, 2676261059u, 0, LDEXP_TOLERANCE, 0},
{ 448, 1097873191u, 1354342308u, 0u, 178u, 1284519719u, 1354342308u, 0, LDEXP_TOLERANCE, 0},
{ 449, 3244247065u, 1660724156u, 0u, 204u, 3458156569u, 1660724156u, 0, LDEXP_TOLERANCE, 0},
{ 450, 1104332602u, 1642699485u, 0u, 379u, 1501742906u, 1642699485u, 0, LDEXP_TOLERANCE, 0},
{ 451, 3250424296u, 1717672108u, 0u, 243u, 3505228264u, 1717672108u, 0, LDEXP_TOLERANCE, 0},
{ 452, 1104754957u, 287287829u, 0u, 96u, 1205418253u, 287287829u, 0, LDEXP_TOLERANCE, 0},
{ 453, 1041630773u, 1858851717u, 0u, 84u, 1129711157u, 1858851717u, 0, LDEXP_TOLERANCE, 0},
{ 454, 3214257433u, 751088586u, 0u, 320u, 3549801753u, 751088586u, 0, LDEXP_TOLERANCE, 0},
{ 455, 3220003982u, 1397652531u, 0u, 257u, 3489488014u, 1397652531u, 0, LDEXP_TOLERANCE, 0},
{ 456, 3227225453u, 3847749145u, 0u, 472u, 3722153325u, 3847749145u, 0, LDEXP_TOLERANCE, 0},
{ 457, 1070645131u, 2477088719u, 0u, 326u, 1412480907u, 2477088719u, 0, LDEXP_TOLERANCE, 0},
{ 458, 3227562493u, 857975269u, 0u, 17u, 3245388285u, 857975269u, 0, LDEXP_TOLERANCE, 0},
{ 459, 3194188951u, 1711780367u, 0u, 268u, 3475207319u, 1711780367u, 0, LDEXP_TOLERANCE, 0},
{ 460, 3235476602u, 451471221u, 0u, 156u, 3399054458u, 451471221u, 0, LDEXP_TOLERANCE, 0},
{ 461, 1074264014u, 2264504930u, 0u, 409u, 1503131598u, 2264504930u, 0, LDEXP_TOLERANCE, 0},
{ 462, 3228769528u, 1854181735u, 0u, 492u, 3744668920u, 1854181735u, 0, LDEXP_TOLERANCE, 0},
{ 463, 1046699567u, 1591940213u, 0u, 266u, 1325620783u, 1591940213u, 0, LDEXP_TOLERANCE, 0},
{ 464, 1061875970u, 1378057304u, 0u, 400u, 1481306370u, 1378057304u, 0, LDEXP_TOLERANCE, 0},
{ 465, 1058821926u, 2422126348u, 0u, 148u, 1214011174u, 2422126348u, 0, LDEXP_TOLERANCE, 0},
{ 466, 3228077848u, 3932207622u, 0u, 192u, 3429404440u, 3932207622u, 0, LDEXP_TOLERANCE, 0},
{ 467, 3195658563u, 2548035700u, 0u, 425u, 3641303363u, 2548035700u, 0, LDEXP_TOLERANCE, 0},
{ 468, 1090631865u, 3113298011u, 0u, 167u, 1265744057u, 3113298011u, 0, LDEXP_TOLERANCE, 0},
{ 469, 3192989874u, 286247089u, 0u, 112u, 3310430386u, 286247089u, 0, LDEXP_TOLERANCE, 0},
{ 470, 3253628449u, 1026197853u, 0u, 116u, 3375263265u, 1026197853u, 0, LDEXP_TOLERANCE, 0},
{ 471, 1074666768u, 375674756u, 0u, 282u, 1370365200u, 375674756u, 0, LDEXP_TOLERANCE, 0},
{ 472, 3188722502u, 2287547512u, 0u, 386u, 3593472838u, 2287547512u, 0, LDEXP_TOLERANCE, 0},
{ 473, 3195629985u, 1263494177u, 0u, 354u, 3566825889u, 1263494177u, 0, LDEXP_TOLERANCE, 0},
{ 474, 3204259255u, 1611440636u, 0u, 0u, 3204259255u, 1611440636u, 0, LDEXP_TOLERANCE, 0},
{ 475, 3213589312u, 1865725974u, 0u, 254u, 3479927616u, 1865725974u, 0, LDEXP_TOLERANCE, 0},
{ 476, 3207039183u, 115770551u, 0u, 289u, 3510077647u, 115770551u, 0, LDEXP_TOLERANCE, 0},
{ 477, 1070132645u, 1245005118u, 0u, 328u, 1414065573u, 1245005118u, 0, LDEXP_TOLERANCE, 0},
{ 478, 1078173946u, 1482721827u, 0u, 107u, 1190371578u, 1482721827u, 0, LDEXP_TOLERANCE, 0},
{ 479, 3192359503u, 3736750583u, 0u, 344u, 3553069647u, 3736750583u, 0, LDEXP_TOLERANCE, 0},
{ 480, 1090362269u, 2431996507u, 0u, 470u, 1583192989u, 2431996507u, 0, LDEXP_TOLERANCE, 0},
{ 481, 1102017594u, 242934189u, 0u, 127u, 1235186746u, 242934189u, 0, LDEXP_TOLERANCE, 0},
{ 482, 1082841536u, 4287291972u, 0u, 308u, 1405802944u, 4287291972u, 0, LDEXP_TOLERANCE, 0},
{ 483, 1078562189u, 3455122647u, 0u, 77u, 1159302541u, 3455122647u, 0, LDEXP_TOLERANCE, 0},
{ 484, 3209380687u, 1980318203u, 0u, 417u, 3646636879u, 1980318203u, 0, LDEXP_TOLERANCE, 0},
{ 485, 1081309333u, 3384251967u, 0u, 134u, 1221818517u, 3384251967u, 0, LDEXP_TOLERANCE, 0},
{ 486, 3245133381u, 2923526078u, 0u, 405u, 3669806661u, 2923526078u, 0, LDEXP_TOLERANCE, 0},
{ 487, 1064525899u, 3742487766u, 0u, 228u, 1303601227u, 3742487766u, 0, LDEXP_TOLERANCE, 0},
{ 488, 1091346793u, 3289095948u, 0u, 430u, 1542234473u, 3289095948u, 0, LDEXP_TOLERANCE, 0},
{ 489, 1058117934u, 2454945617u, 0u, 113u, 1176607022u, 2454945617u, 0, LDEXP_TOLERANCE, 0},
{ 490, 1078811133u, 1275993403u, 0u, 24u, 1103976957u, 1275993403u, 0, LDEXP_TOLERANCE, 0},
{ 491, 3196196192u, 2695666837u, 0u, 6u, 3202487648u, 2695666837u, 0, LDEXP_TOLERANCE, 0},
{ 492, 1047966215u, 3447944313u, 0u, 340u, 1404482055u, 3447944313u, 0, LDEXP_TOLERANCE, 0},
{ 493, 1101711780u, 2982959266u, 0u, 303u, 1419430308u, 2982959266u, 0, LDEXP_TOLERANCE, 0},
{ 494, 1054840864u, 171409502u, 0u, 129u, 1190107168u, 171409502u, 0, LDEXP_TOLERANCE, 0},
{ 495, 3197943165u, 3921063782u, 0u, 362u, 3577527677u, 3921063782u, 0, LDEXP_TOLERANCE, 0},
{ 496, 3189290617u, 1578223762u, 0u, 36u, 3227039353u, 1578223762u, 0, LDEXP_TOLERANCE, 0},
{ 497, 3192959856u, 1469212191u, 0u, 74u, 3270554480u, 1469212191u, 0, LDEXP_TOLERANCE, 0},
{ 498, 1054233191u, 2295692754u, 0u, 211u, 1275482727u, 2295692754u, 0, LDEXP_TOLERANCE, 0},
{ 499, 1053077031u, 3459566012u, 0u, 275u, 1341435431u, 3459566012u, 0, LDEXP_TOLERANCE, 0},
{ 500, 3251200938u, 4126298722u, 0u, 375u, 3644416938u, 4126298722u, 0, LDEXP_TOLERANCE, 0},
{ 501, 3232343117u, 2520630720u, 0u, 62u, 3297354829u, 2520630720u, 0, LDEXP_TOLERANCE, 0},
{ 502, 3213037619u, 887645440u, 0u, 43u, 3258126387u, 887645440u, 0, LDEXP_TOLERANCE, 0},
{ 503, 1086002105u, 946455365u, 0u, 277u, 1376457657u, 946455365u, 0, LDEXP_TOLERANCE, 0},
{ 504, 3201736709u, 1632857891u, 0u, 340u, 3558252549u, 1632857891u, 0, LDEXP_TOLERANCE, 0},
{ 505, 1040729961u, 4162008079u, 0u, 206u, 1256736617u, 4162008079u, 0, LDEXP_TOLERANCE, 0},
{ 506, 1059120765u, 3425518947u, 0u, 278u, 1350624893u, 3425518947u, 0, LDEXP_TOLERANCE, 0},
{ 507, 3251307470u, 4210912679u, 0u, 407u, 3678077902u, 4210912679u, 0, LDEXP_TOLERANCE, 0},
{ 508, 1090416633u, 2533687683u, 0u, 435u, 1546547193u, 2533687683u, 0, LDEXP_TOLERANCE, 0},
{ 509, 3235947244u, 2569281387u, 0u, 394u, 3649086188u, 2569281387u, 0, LDEXP_TOLERANCE, 0},
{ 510, 3245016670u, 1480024922u, 0u, 152u, 3404400222u, 1480024922u, 0, LDEXP_TOLERANCE, 0},
{ 511, 3208595959u, 3494862794u, 0u, 490u, 3722398199u, 3494862794u, 0, LDEXP_TOLERANCE, 0},
{ 512, 3242919505u, 3642407092u, 0u, 109u, 3357214289u, 3642407092u, 0, LDEXP_TOLERANCE, 0},
{ 513, 3252287877u, 3550162331u, 0u, 355u, 3624532357u, 3550162331u, 0, LDEXP_TOLERANCE, 0},
{ 514, 3246984334u, 2132131375u, 0u, 42u, 3291024526u, 2132131375u, 0, LDEXP_TOLERANCE, 0},
{ 515, 3251248752u, 3821901768u, 0u, 369u, 3638173296u, 3821901768u, 0, LDEXP_TOLERANCE, 0},
{ 516, 1061777502u, 3236596516u, 0u, 339u, 1417244766u, 3236596516u, 0, LDEXP_TOLERANCE, 0},
{ 517, 3240164097u, 57443054u, 0u, 474u, 3737189121u, 57443054u, 0, LDEXP_TOLERANCE, 0},
{ 518, 1101921141u, 2928317152u, 0u, 370u, 1489894261u, 2928317152u, 0, LDEXP_TOLERANCE, 0},
{ 519, 3246958541u, 122162205u, 0u, 395u, 3661146061u, 122162205u, 0, LDEXP_TOLERANCE, 0},
{ 520, 3194834642u, 2706165300u, 0u, 200u, 3404549842u, 2706165300u, 0, LDEXP_TOLERANCE, 0},
{ 521, 1094479529u, 1626929878u, 0u, 134u, 1234988713u, 1626929878u, 0, LDEXP_TOLERANCE, 0},
{ 522, 1083449076u, 2102520884u, 0u, 9u, 1092886260u, 2102520884u, 0, LDEXP_TOLERANCE, 0},
{ 523, 1076012412u, 2211699255u, 0u, 461u, 1559405948u, 2211699255u, 0, LDEXP_TOLERANCE, 0},
{ 524, 1041731776u, 2028363648u, 0u, 355u, 1413976256u, 2028363648u, 0, LDEXP_TOLERANCE, 0},
{ 525, 3187775160u, 2996976481u, 0u, 232u, 3431044792u, 2996976481u, 0, LDEXP_TOLERANCE, 0},
{ 526, 3248213693u, 3041999329u, 0u, 446u, 3715878589u, 3041999329u, 0, LDEXP_TOLERANCE, 0},
{ 527, 3196191712u, 1648584571u, 0u, 487u, 3706848224u, 1648584571u, 0, LDEXP_TOLERANCE, 0},
{ 528, 1093069876u, 540311934u, 0u, 362u, 1472654388u, 540311934u, 0, LDEXP_TOLERANCE, 0},
{ 529, 3205345633u, 3472075644u, 0u, 259u, 3476926817u, 3472075644u, 0, LDEXP_TOLERANCE, 0},
{ 530, 1079561503u, 3840720032u, 0u, 17u, 1097387295u, 3840720032u, 0, LDEXP_TOLERANCE, 0},
{ 531, 3240017460u, 1099567884u, 0u, 484u, 3747528244u, 1099567884u, 0, LDEXP_TOLERANCE, 0},
{ 532, 3238593552u, 2560836004u, 0u, 269u, 3520660496u, 2560836004u, 0, LDEXP_TOLERANCE, 0},
{ 533, 1072457286u, 524706354u, 0u, 254u, 1338795590u, 524706354u, 0, LDEXP_TOLERANCE, 0},
{ 534, 3234908869u, 3264644151u, 0u, 135u, 3376466629u, 3264644151u, 0, LDEXP_TOLERANCE, 0},
{ 535, 1058314227u, 2407947243u, 0u, 168u, 1234474995u, 2407947243u, 0, LDEXP_TOLERANCE, 0},
{ 536, 3199467414u, 230193094u, 0u, 462u, 3683909526u, 230193094u, 0, LDEXP_TOLERANCE, 0},
{ 537, 3198629672u, 2624677381u, 0u, 57u, 3258398504u, 2624677381u, 0, LDEXP_TOLERANCE, 0},
{ 538, 1085107111u, 1970804718u, 0u, 160u, 1252879271u, 1970804718u, 0, LDEXP_TOLERANCE, 0},
{ 539, 3247005564u, 1254715281u, 0u, 233u, 3491323772u, 1254715281u, 0, LDEXP_TOLERANCE, 0},
{ 540, 3233088901u, 1323165917u, 0u, 346u, 3595896197u, 1323165917u, 0, LDEXP_TOLERANCE, 0},
{ 541, 1085173524u, 2194185737u, 0u, 294u, 1393454868u, 2194185737u, 0, LDEXP_TOLERANCE, 0},
{ 542, 3217851015u, 1006976371u, 0u, 248u, 3477897863u, 1006976371u, 0, LDEXP_TOLERANCE, 0},
{ 543, 1097592222u, 627593287u, 0u, 427u, 1545334174u, 627593287u, 0, LDEXP_TOLERANCE, 0},
{ 544, 1086229861u, 2658788310u, 0u, 363u, 1466862949u, 2658788310u, 0, LDEXP_TOLERANCE, 0},
{ 545, 3207822943u, 4059505387u, 0u, 450u, 3679682143u, 4059505387u, 0, LDEXP_TOLERANCE, 0},
{ 546, 3252737468u, 3812071034u, 0u, 332u, 3600864700u, 3812071034u, 0, LDEXP_TOLERANCE, 0},
{ 547, 1059648367u, 999149762u, 0u, 233u, 1303966575u, 999149762u, 0, LDEXP_TOLERANCE, 0},
{ 548, 3252484132u, 781792055u, 0u, 491u, 3767334948u, 781792055u, 0, LDEXP_TOLERANCE, 0},
{ 549, 1054559826u, 3046272894u, 0u, 261u, 1328238162u, 3046272894u, 0, LDEXP_TOLERANCE, 0},
{ 550, 3205481779u, 1532426189u, 0u, 295u, 3514811699u, 1532426189u, 0, LDEXP_TOLERANCE, 0},
{ 551, 1075179177u, 214596211u, 0u, 488u, 1586884265u, 214596211u, 0, LDEXP_TOLERANCE, 0},
{ 552, 1098103739u, 3832087890u, 0u, 204u, 1312013243u, 3832087890u, 0, LDEXP_TOLERANCE, 0},
{ 553, 1077515271u, 593538252u, 0u, 86u, 1167692807u, 593538252u, 0, LDEXP_TOLERANCE, 0},
{ 554, 1083592720u, 3097953262u, 0u, 88u, 1175867408u, 3097953262u, 0, LDEXP_TOLERANCE, 0},
{ 555, 1054141917u, 2033383695u, 0u, 38u, 1093987805u, 2033383695u, 0, LDEXP_TOLERANCE, 0},
{ 556, 1048495909u, 3670016377u, 0u, 497u, 1569638181u, 3670016377u, 0, LDEXP_TOLERANCE, 0},
{ 557, 1050809029u, 3775007802u, 0u, 425u, 1496453829u, 3775007802u, 0, LDEXP_TOLERANCE, 0},
{ 558, 3238703280u, 3436328857u, 0u, 466u, 3727339696u, 3436328857u, 0, LDEXP_TOLERANCE, 0},
{ 559, 3197179414u, 3119528953u, 0u, 313u, 3525383702u, 3119528953u, 0, LDEXP_TOLERANCE, 0},
{ 560, 1098412609u, 2259509124u, 0u, 375u, 1491628609u, 2259509124u, 0, LDEXP_TOLERANCE, 0},
{ 561, 3224480068u, 553154637u, 0u, 286u, 3524372804u, 553154637u, 0, LDEXP_TOLERANCE, 0},
{ 562, 3215254594u, 3738077421u, 0u, 48u, 3265586242u, 3738077421u, 0, LDEXP_TOLERANCE, 0},
{ 563, 1052031347u, 293137764u, 0u, 193u, 1254406515u, 293137764u, 0, LDEXP_TOLERANCE, 0},
{ 564, 1048453019u, 3302718156u, 0u, 494u, 1566449563u, 3302718156u, 0, LDEXP_TOLERANCE, 0},
{ 565, 3223439338u, 3448048638u, 0u, 52u, 3277965290u, 3448048638u, 0, LDEXP_TOLERANCE, 0},
{ 566, 3223944194u, 1862856951u, 0u, 168u, 3400104962u, 1862856951u, 0, LDEXP_TOLERANCE, 0},
{ 567, 3244649498u, 3318830570u, 0u, 6u, 3250940954u, 3318830570u, 0, LDEXP_TOLERANCE, 0},
{ 568, 1095956900u, 168744837u, 0u, 184u, 1288894884u, 168744837u, 0, LDEXP_TOLERANCE, 0},
{ 569, 1096175678u, 2035208049u, 0u, 248u, 1356222526u, 2035208049u, 0, LDEXP_TOLERANCE, 0},
{ 570, 1071443591u, 2413085118u, 0u, 415u, 1506602631u, 2413085118u, 0, LDEXP_TOLERANCE, 0},
{ 571, 3231142151u, 2125266031u, 0u, 154u, 3392622855u, 2125266031u, 0, LDEXP_TOLERANCE, 0},
{ 572, 3239533970u, 2250119224u, 0u, 342u, 3598146962u, 2250119224u, 0, LDEXP_TOLERANCE, 0},
{ 573, 1067186195u, 3698426632u, 0u, 130u, 1203501075u, 3698426632u, 0, LDEXP_TOLERANCE, 0},
{ 574, 3196143186u, 2420102372u, 0u, 268u, 3477161554u, 2420102372u, 0, LDEXP_TOLERANCE, 0},
{ 575, 3237295327u, 950097945u, 0u, 177u, 3422893279u, 950097945u, 0, LDEXP_TOLERANCE, 0},
{ 576, 1041232546u, 3621700966u, 0u, 102u, 1148187298u, 3621700966u, 0, LDEXP_TOLERANCE, 0},
{ 577, 1050106742u, 4027115185u, 0u, 170u, 1228364662u, 4027115185u, 0, LDEXP_TOLERANCE, 0},
{ 578, 1058573943u, 2226077666u, 0u, 230u, 1299746423u, 2226077666u, 0, LDEXP_TOLERANCE, 0},
{ 579, 1060691586u, 1178315623u, 0u, 114u, 1180229250u, 1178315623u, 0, LDEXP_TOLERANCE, 0},
{ 580, 1103796205u, 2401303942u, 0u, 32u, 1137350637u, 2401303942u, 0, LDEXP_TOLERANCE, 0},
{ 581, 1096468311u, 726651516u, 0u, 499u, 1619707735u, 726651516u, 0, LDEXP_TOLERANCE, 0},
{ 582, 3222220162u, 3249224838u, 0u, 461u, 3705613698u, 3249224838u, 0, LDEXP_TOLERANCE, 0},
{ 583, 3254704022u, 384370422u, 0u, 310u, 3579762582u, 384370422u, 0, LDEXP_TOLERANCE, 0},
{ 584, 1097386147u, 3782310033u, 0u, 243u, 1352190115u, 3782310033u, 0, LDEXP_TOLERANCE, 0},
{ 585, 3252042528u, 146366045u, 0u, 356u, 3625335584u, 146366045u, 0, LDEXP_TOLERANCE, 0},
{ 586, 3244118788u, 2529029548u, 0u, 205u, 3459076868u, 2529029548u, 0, LDEXP_TOLERANCE, 0},
{ 587, 3247146310u, 3286328657u, 0u, 195u, 3451618630u, 3286328657u, 0, LDEXP_TOLERANCE, 0},
{ 588, 1082254153u, 633487468u, 0u, 173u, 1263657801u, 633487468u, 0, LDEXP_TOLERANCE, 0},
{ 589, 1106725606u, 4081471542u, 0u, 54u, 1163348710u, 4081471542u, 0, LDEXP_TOLERANCE, 0},
{ 590, 3235104785u, 2659274428u, 0u, 13u, 3248736273u, 2659274428u, 0, LDEXP_TOLERANCE, 0},
{ 591, 3192361033u, 3292996609u, 0u, 147u, 3346501705u, 3292996609u, 0, LDEXP_TOLERANCE, 0},
{ 592, 3243606330u, 1251690243u, 0u, 286u, 3543499066u, 1251690243u, 0, LDEXP_TOLERANCE, 0},
{ 593, 1078522672u, 534876830u, 0u, 312u, 1405678384u, 534876830u, 0, LDEXP_TOLERANCE, 0},
{ 594, 3236105559u, 2730725979u, 0u, 133u, 3375566167u, 2730725979u, 0, LDEXP_TOLERANCE, 0},
{ 595, 3207120390u, 3867917386u, 0u, 120u, 3332949510u, 3867917386u, 0, LDEXP_TOLERANCE, 0},
{ 596, 3209887750u, 282125870u, 0u, 290u, 3513974790u, 282125870u, 0, LDEXP_TOLERANCE, 0},
{ 597, 3221192531u, 1378332814u, 0u, 46u, 3269427027u, 1378332814u, 0, LDEXP_TOLERANCE, 0},
{ 598, 1071438511u, 1456720330u, 0u, 197u, 1278007983u, 1456720330u, 0, LDEXP_TOLERANCE, 0},
{ 599, 3204862644u, 625779797u, 0u, 242u, 3458618036u, 625779797u, 0, LDEXP_TOLERANCE, 0},
{ 600, 3188948769u, 1949093709u, 0u, 222u, 3421732641u, 1949093709u, 0, LDEXP_TOLERANCE, 0},
{ 601, 1040706087u, 1832636825u, 0u, 370u, 1428679207u, 1832636825u, 0, LDEXP_TOLERANCE, 0},
{ 602, 3241678717u, 4116863145u, 0u, 268u, 3522697085u, 4116863145u, 0, LDEXP_TOLERANCE, 0},
{ 603, 3254549137u, 1280908320u, 0u, 410u, 3684465297u, 1280908320u, 0, LDEXP_TOLERANCE, 0},
{ 604, 1044237059u, 849581558u, 0u, 61u, 1108200195u, 849581558u, 0, LDEXP_TOLERANCE, 0},
{ 605, 3227710894u, 1803008264u, 0u, 159u, 3394434478u, 1803008264u, 0, LDEXP_TOLERANCE, 0},
{ 606, 3222601478u, 3647912576u, 0u, 158u, 3388276486u, 3647912576u, 0, LDEXP_TOLERANCE, 0},
{ 607, 3201624749u, 1239907237u, 0u, 69u, 3273976493u, 1239907237u, 0, LDEXP_TOLERANCE, 0},
{ 608, 1074236329u, 1658600938u, 0u, 471u, 1568115625u, 1658600938u, 0, LDEXP_TOLERANCE, 0},
{ 609, 1075491548u, 3953853053u, 0u, 216u, 1301983964u, 3953853053u, 0, LDEXP_TOLERANCE, 0},
{ 610, 3213072244u, 1760177025u, 0u, 266u, 3491993460u, 1760177025u, 0, LDEXP_TOLERANCE, 0},
{ 611, 1080258478u, 2294697132u, 0u, 293u, 1387491246u, 2294697132u, 0, LDEXP_TOLERANCE, 0},
{ 612, 3231020290u, 2744719351u, 0u, 429u, 3680859394u, 2744719351u, 0, LDEXP_TOLERANCE, 0},
{ 613, 3189668753u, 1174874204u, 0u, 125u, 3320740753u, 1174874204u, 0, LDEXP_TOLERANCE, 0},
{ 614, 1057110584u, 848081004u, 0u, 119u, 1181891128u, 848081004u, 0, LDEXP_TOLERANCE, 0},
{ 615, 1058101211u, 2085894114u, 0u, 296u, 1368479707u, 2085894114u, 0, LDEXP_TOLERANCE, 0},
{ 616, 3202306280u, 348102924u, 0u, 288u, 3504296168u, 348102924u, 0, LDEXP_TOLERANCE, 0},
{ 617, 1093500372u, 2470748422u, 0u, 28u, 1122860500u, 2470748422u, 0, LDEXP_TOLERANCE, 0},
{ 618, 1061167400u, 138849460u, 0u, 322u, 1398808872u, 138849460u, 0, LDEXP_TOLERANCE, 0},
{ 619, 1104293747u, 1900437425u, 0u, 483u, 1610755955u, 1900437425u, 0, LDEXP_TOLERANCE, 0},
{ 620, 1100508815u, 3684301975u, 0u, 67u, 1170763407u, 3684301975u, 0, LDEXP_TOLERANCE, 0},
{ 621, 1044707490u, 2999949676u, 0u, 75u, 1123350690u, 2999949676u, 0, LDEXP_TOLERANCE, 0},
{ 622, 3254712629u, 4001809575u, 0u, 38u, 3294558517u, 4001809575u, 0, LDEXP_TOLERANCE, 0},
{ 623, 3254231152u, 2299565551u, 0u, 431u, 3706167408u, 2299565551u, 0, LDEXP_TOLERANCE, 0},
{ 624, 3194165277u, 3145100012u, 0u, 387u, 3599964189u, 3145100012u, 0, LDEXP_TOLERANCE, 0},
{ 625, 3236479153u, 2659893783u, 0u, 292u, 3542663345u, 2659893783u, 0, LDEXP_TOLERANCE, 0},
{ 626, 1066703665u, 4096436451u, 0u, 287u, 1367644977u, 4096436451u, 0, LDEXP_TOLERANCE, 0},
{ 627, 3191085836u, 2080198917u, 0u, 342u, 3549698828u, 2080198917u, 0, LDEXP_TOLERANCE, 0},
{ 628, 1103176642u, 292693126u, 0u, 269u, 1385243586u, 292693126u, 0, LDEXP_TOLERANCE, 0},
{ 629, 1076257739u, 439474159u, 0u, 53u, 1131832267u, 439474159u, 0, LDEXP_TOLERANCE, 0},
{ 630, 3203168524u, 4050424307u, 0u, 48u, 3253500172u, 4050424307u, 0, LDEXP_TOLERANCE, 0},
{ 631, 3211263954u, 3275604304u, 0u, 427u, 3659005906u, 3275604304u, 0, LDEXP_TOLERANCE, 0},
{ 632, 1098022244u, 1605519917u, 0u, 152u, 1257405796u, 1605519917u, 0, LDEXP_TOLERANCE, 0},
{ 633, 3225218243u, 2732577078u, 0u, 169u, 3402427587u, 2732577078u, 0, LDEXP_TOLERANCE, 0},
{ 634, 3224758945u, 639164136u, 0u, 250u, 3486902945u, 639164136u, 0, LDEXP_TOLERANCE, 0},
{ 635, 3206688283u, 365608035u, 0u, 220u, 3437375003u, 365608035u, 0, LDEXP_TOLERANCE, 0},
{ 636, 1096221986u, 188907563u, 0u, 258u, 1366754594u, 188907563u, 0, LDEXP_TOLERANCE, 0},
{ 637, 1077478629u, 2925706902u, 0u, 77u, 1158218981u, 2925706902u, 0, LDEXP_TOLERANCE, 0},
{ 638, 3245669892u, 1441001355u, 0u, 401u, 3666148868u, 1441001355u, 0, LDEXP_TOLERANCE, 0},
{ 639, 1086418963u, 1263339528u, 0u, 77u, 1167159315u, 1263339528u, 0, LDEXP_TOLERANCE, 0},
{ 640, 3243690997u, 4075177615u, 0u, 254u, 3510029301u, 4075177615u, 0, LDEXP_TOLERANCE, 0},
{ 641, 1043887798u, 2574410165u, 0u, 228u, 1282963126u, 2574410165u, 0, LDEXP_TOLERANCE, 0},
{ 642, 3228012899u, 1451038472u, 0u, 233u, 3472331107u, 1451038472u, 0, LDEXP_TOLERANCE, 0},
{ 643, 1057927965u, 3267242972u, 0u, 196u, 1263448861u, 3267242972u, 0, LDEXP_TOLERANCE, 0},
{ 644, 1088388240u, 147191702u, 0u, 277u, 1378843792u, 147191702u, 0, LDEXP_TOLERANCE, 0},
{ 645, 3237742613u, 463847325u, 0u, 141u, 3385591829u, 463847325u, 0, LDEXP_TOLERANCE, 0},
{ 646, 3231093084u, 309566036u, 0u, 15u, 3246821724u, 309566036u, 0, LDEXP_TOLERANCE, 0},
{ 647, 3236008002u, 369048143u, 0u, 142u, 3384905794u, 369048143u, 0, LDEXP_TOLERANCE, 0},
{ 648, 1106124402u, 4110964559u, 0u, 367u, 1490951794u, 4110964559u, 0, LDEXP_TOLERANCE, 0},
{ 649, 1081914210u, 3679866727u, 0u, 33u, 1116517218u, 3679866727u, 0, LDEXP_TOLERANCE, 0},
{ 650, 3208744451u, 810282289u, 0u, 240u, 3460402691u, 810282289u, 0, LDEXP_TOLERANCE, 0},
{ 651, 3214165397u, 3872563165u, 0u, 0u, 3214165397u, 3872563165u, 0, LDEXP_TOLERANCE, 0},
{ 652, 1098494887u, 2790313039u, 0u, 484u, 1606005671u, 2790313039u, 0, LDEXP_TOLERANCE, 0},
{ 653, 3221154109u, 1894124837u, 0u, 154u, 3382634813u, 1894124837u, 0, LDEXP_TOLERANCE, 0},
{ 654, 1046643778u, 1307532154u, 0u, 483u, 1553105986u, 1307532154u, 0, LDEXP_TOLERANCE, 0},
{ 655, 1074424846u, 2546231111u, 0u, 76u, 1154116622u, 2546231111u, 0, LDEXP_TOLERANCE, 0},
{ 656, 1070559510u, 1177789792u, 0u, 338u, 1424978198u, 1177789792u, 0, LDEXP_TOLERANCE, 0},
{ 657, 3225897784u, 1393159012u, 0u, 468u, 3716631352u, 1393159012u, 0, LDEXP_TOLERANCE, 0},
{ 658, 3241371250u, 2270747330u, 0u, 226u, 3478349426u, 2270747330u, 0, LDEXP_TOLERANCE, 0},
{ 659, 3206099061u, 387526371u, 0u, 489u, 3718852725u, 387526371u, 0, LDEXP_TOLERANCE, 0},
{ 660, 3248889342u, 1541778002u, 0u, 112u, 3366329854u, 1541778002u, 0, LDEXP_TOLERANCE, 0},
{ 661, 1057260850u, 487828421u, 0u, 161u, 1226081586u, 487828421u, 0, LDEXP_TOLERANCE, 0},
{ 662, 3227842110u, 3028362906u, 0u, 82u, 3313825342u, 3028362906u, 0, LDEXP_TOLERANCE, 0},
{ 663, 3232158280u, 2832526786u, 0u, 342u, 3590771272u, 2832526786u, 0, LDEXP_TOLERANCE, 0},
{ 664, 1086492044u, 1029336617u, 0u, 11u, 1098026380u, 1029336617u, 0, LDEXP_TOLERANCE, 0},
{ 665, 3201067521u, 3844885860u, 0u, 233u, 3445385729u, 3844885860u, 0, LDEXP_TOLERANCE, 0},
{ 666, 1081650590u, 3848664336u, 0u, 190u, 1280880030u, 3848664336u, 0, LDEXP_TOLERANCE, 0},
{ 667, 3216727300u, 1859175955u, 0u, 342u, 3575340292u, 1859175955u, 0, LDEXP_TOLERANCE, 0},
{ 668, 3247701688u, 4177384140u, 0u, 294u, 3555983032u, 4177384140u, 0, LDEXP_TOLERANCE, 0},
{ 669, 3225365211u, 1905063436u, 0u, 369u, 3612289755u, 1905063436u, 0, LDEXP_TOLERANCE, 0},
{ 670, 1060341776u, 3330581237u, 0u, 285u, 1359185936u, 3330581237u, 0, LDEXP_TOLERANCE, 0},
{ 671, 1086856468u, 3110345659u, 0u, 307u, 1408769300u, 3110345659u, 0, LDEXP_TOLERANCE, 0},
{ 672, 1040609072u, 2626928143u, 0u, 167u, 1215721264u, 2626928143u, 0, LDEXP_TOLERANCE, 0},
{ 673, 3193571775u, 2449013005u, 0u, 206u, 3409578431u, 2449013005u, 0, LDEXP_TOLERANCE, 0},
{ 674, 1044814475u, 3649425780u, 0u, 329u, 1389795979u, 3649425780u, 0, LDEXP_TOLERANCE, 0},
{ 675, 3247609790u, 1936138976u, 0u, 449u, 3718420414u, 1936138976u, 0, LDEXP_TOLERANCE, 0},
{ 676, 3222118023u, 3554670043u, 0u, 474u, 3719143047u, 3554670043u, 0, LDEXP_TOLERANCE, 0},
{ 677, 3226161360u, 2445669899u, 0u, 122u, 3354087632u, 2445669899u, 0, LDEXP_TOLERANCE, 0},
{ 678, 3231588583u, 3613487983u, 0u, 168u, 3407749351u, 3613487983u, 0, LDEXP_TOLERANCE, 0},
{ 679, 1070518869u, 2404090288u, 0u, 343u, 1430180437u, 2404090288u, 0, LDEXP_TOLERANCE, 0},
{ 680, 1056601872u, 3936780069u, 0u, 401u, 1477080848u, 3936780069u, 0, LDEXP_TOLERANCE, 0},
{ 681, 3251382149u, 3695226490u, 0u, 317u, 3583780741u, 3695226490u, 0, LDEXP_TOLERANCE, 0},
{ 682, 1084717105u, 2502140489u, 0u, 428u, 1533507633u, 2502140489u, 0, LDEXP_TOLERANCE, 0},
{ 683, 3231607738u, 3076182032u, 0u, 212u, 3453905850u, 3076182032u, 0, LDEXP_TOLERANCE, 0},
{ 684, 3226181630u, 52044482u, 0u, 56u, 3284901886u, 52044482u, 0, LDEXP_TOLERANCE, 0},
{ 685, 3209294194u, 3250576797u, 0u, 447u, 3678007666u, 3250576797u, 0, LDEXP_TOLERANCE, 0},
{ 686, 1067216664u, 280322485u, 0u, 68u, 1138519832u, 280322485u, 0, LDEXP_TOLERANCE, 0},
{ 687, 1056850730u, 3460638643u, 0u, 3u, 1059996458u, 3460638643u, 0, LDEXP_TOLERANCE, 0},
{ 688, 3198374301u, 836754546u, 0u, 227u, 3436401053u, 836754546u, 0, LDEXP_TOLERANCE, 0},
{ 689, 1053945586u, 1909842364u, 0u, 137u, 1197600498u, 1909842364u, 0, LDEXP_TOLERANCE, 0},
{ 690, 1102747575u, 3614304657u, 0u, 175u, 1286248375u, 3614304657u, 0, LDEXP_TOLERANCE, 0},
{ 691, 3232289682u, 104161319u, 0u, 258u, 3502822290u, 104161319u, 0, LDEXP_TOLERANCE, 0},
{ 692, 3239925976u, 4284835369u, 0u, 69u, 3312277720u, 4284835369u, 0, LDEXP_TOLERANCE, 0},
{ 693, 1101382703u, 1829525759u, 0u, 474u, 1598407727u, 1829525759u, 0, LDEXP_TOLERANCE, 0},
{ 694, 1080943896u, 3662877092u, 0u, 172u, 1261298968u, 3662877092u, 0, LDEXP_TOLERANCE, 0},
{ 695, 3208812483u, 1522451444u, 0u, 237u, 3457324995u, 1522451444u, 0, LDEXP_TOLERANCE, 0},
{ 696, 3207922109u, 3788656852u, 0u, 281u, 3502571965u, 3788656852u, 0, LDEXP_TOLERANCE, 0},
{ 697, 1051638218u, 161607862u, 0u, 267u, 1331608010u, 161607862u, 0, LDEXP_TOLERANCE, 0},
{ 698, 1090916217u, 2404130512u, 0u, 233u, 1335234425u, 2404130512u, 0, LDEXP_TOLERANCE, 0},
{ 699, 1059685751u, 2026411429u, 0u, 386u, 1464436087u, 2026411429u, 0, LDEXP_TOLERANCE, 0},
{ 700, 3253240072u, 1320615853u, 0u, 98u, 3356000520u, 1320615853u, 0, LDEXP_TOLERANCE, 0},
{ 701, 3252472409u, 3427912319u, 0u, 307u, 3574385241u, 3427912319u, 0, LDEXP_TOLERANCE, 0},
{ 702, 3239422485u, 3207831031u, 0u, 279u, 3531975189u, 3207831031u, 0, LDEXP_TOLERANCE, 0},
{ 703, 3225261763u, 193885269u, 0u, 263u, 3501037251u, 193885269u, 0, LDEXP_TOLERANCE, 0},
{ 704, 3198856153u, 1330711805u, 0u, 34u, 3234507737u, 1330711805u, 0, LDEXP_TOLERANCE, 0},
{ 705, 1061209059u, 2242782034u, 0u, 484u, 1568719843u, 2242782034u, 0, LDEXP_TOLERANCE, 0},
{ 706, 1105997747u, 1164748983u, 0u, 205u, 1320955827u, 1164748983u, 0, LDEXP_TOLERANCE, 0},
{ 707, 1041518408u, 427227336u, 0u, 468u, 1532251976u, 427227336u, 0, LDEXP_TOLERANCE, 0},
{ 708, 1047983837u, 571692916u, 0u, 112u, 1165424349u, 571692916u, 0, LDEXP_TOLERANCE, 0},
{ 709, 3243349276u, 1910625797u, 0u, 305u, 3563164956u, 1910625797u, 0, LDEXP_TOLERANCE, 0},
{ 710, 1056431544u, 3633684065u, 0u, 85u, 1145560504u, 3633684065u, 0, LDEXP_TOLERANCE, 0},
{ 711, 3216335063u, 2139337836u, 0u, 289u, 3519373527u, 2139337836u, 0, LDEXP_TOLERANCE, 0},
{ 712, 3221194724u, 3647632375u, 0u, 136u, 3363801060u, 3647632375u, 0, LDEXP_TOLERANCE, 0},
{ 713, 3194264761u, 3085230370u, 0u, 415u, 3629423801u, 3085230370u, 0, LDEXP_TOLERANCE, 0},
{ 714, 1047551748u, 2424866060u, 0u, 183u, 1239441156u, 2424866060u, 0, LDEXP_TOLERANCE, 0},
{ 715, 1056945903u, 2026968333u, 0u, 249u, 1318041327u, 2026968333u, 0, LDEXP_TOLERANCE, 0},
{ 716, 3254065942u, 2288082596u, 0u, 121u, 3380943638u, 2288082596u, 0, LDEXP_TOLERANCE, 0},
{ 717, 3204958105u, 146999679u, 0u, 260u, 3477587865u, 146999679u, 0, LDEXP_TOLERANCE, 0},
{ 718, 3249441223u, 3097120487u, 0u, 334u, 3599665607u, 3097120487u, 0, LDEXP_TOLERANCE, 0},
{ 719, 1092821012u, 2819263558u, 0u, 374u, 1484988436u, 2819263558u, 0, LDEXP_TOLERANCE, 0},
{ 720, 3248709970u, 1002982008u, 0u, 133u, 3388170578u, 1002982008u, 0, LDEXP_TOLERANCE, 0},
{ 721, 3196410507u, 3683897920u, 0u, 150u, 3353696907u, 3683897920u, 0, LDEXP_TOLERANCE, 0},
{ 722, 3198217745u, 2950261157u, 0u, 303u, 3515936273u, 2950261157u, 0, LDEXP_TOLERANCE, 0},
{ 723, 3251583196u, 1575329940u, 0u, 333u, 3600759004u, 1575329940u, 0, LDEXP_TOLERANCE, 0},
{ 724, 1041303822u, 3078435619u, 0u, 101u, 1147209998u, 3078435619u, 0, LDEXP_TOLERANCE, 0},
{ 725, 1074310746u, 2577246912u, 0u, 345u, 1436069466u, 2577246912u, 0, LDEXP_TOLERANCE, 0},
{ 726, 1043606901u, 2874218693u, 0u, 420u, 1484008821u, 2874218693u, 0, LDEXP_TOLERANCE, 0},
{ 727, 3224836328u, 1577726432u, 0u, 210u, 3445037288u, 1577726432u, 0, LDEXP_TOLERANCE, 0},
{ 728, 1080717542u, 3407236142u, 0u, 495u, 1599762662u, 3407236142u, 0, LDEXP_TOLERANCE, 0},
{ 729, 3239021323u, 1897226271u, 0u, 337u, 3592391435u, 1897226271u, 0, LDEXP_TOLERANCE, 0},
{ 730, 1091225343u, 3521028551u, 0u, 232u, 1334494975u, 3521028551u, 0, LDEXP_TOLERANCE, 0},
{ 731, 1047112378u, 3921932243u, 0u, 476u, 1546234554u, 3921932243u, 0, LDEXP_TOLERANCE, 0},
{ 732, 1061380266u, 1196702002u, 0u, 289u, 1364418730u, 1196702002u, 0, LDEXP_TOLERANCE, 0},
{ 733, 3228251369u, 3560249334u, 0u, 180u, 3416995049u, 3560249334u, 0, LDEXP_TOLERANCE, 0},
{ 734, 3202942296u, 256601931u, 0u, 412u, 3634955608u, 256601931u, 0, LDEXP_TOLERANCE, 0},
{ 735, 3188373428u, 4178341029u, 0u, 332u, 3536500660u, 4178341029u, 0, LDEXP_TOLERANCE, 0},
{ 736, 1074244557u, 1388509212u, 0u, 68u, 1145547725u, 1388509212u, 0, LDEXP_TOLERANCE, 0},
{ 737, 3227970267u, 278055877u, 0u, 158u, 3393645275u, 278055877u, 0, LDEXP_TOLERANCE, 0},
{ 738, 3253498427u, 1975402856u, 0u, 91u, 3348918843u, 1975402856u, 0, LDEXP_TOLERANCE, 0},
{ 739, 3212768361u, 36116288u, 0u, 91u, 3308188777u, 36116288u, 0, LDEXP_TOLERANCE, 0},
{ 740, 1067504948u, 2801410835u, 0u, 86u, 1157682484u, 2801410835u, 0, LDEXP_TOLERANCE, 0},
{ 741, 1056745800u, 1517147036u, 0u, 390u, 1465690440u, 1517147036u, 0, LDEXP_TOLERANCE, 0},
{ 742, 1055869313u, 3403644835u, 0u, 58u, 1116686721u, 3403644835u, 0, LDEXP_TOLERANCE, 0},
{ 743, 3239015924u, 1497452126u, 0u, 300u, 3553588724u, 1497452126u, 0, LDEXP_TOLERANCE, 0},
{ 744, 3198727606u, 527260849u, 0u, 15u, 3214456246u, 527260849u, 0, LDEXP_TOLERANCE, 0},
{ 745, 1055132057u, 730320459u, 0u, 341u, 1412696473u, 730320459u, 0, LDEXP_TOLERANCE, 0},
{ 746, 1071575537u, 3103627383u, 0u, 466u, 1560211953u, 3103627383u, 0, LDEXP_TOLERANCE, 0},
{ 747, 1075642950u, 676014010u, 0u, 15u, 1091371590u, 676014010u, 0, LDEXP_TOLERANCE, 0},
{ 748, 1093103612u, 2664812822u, 0u, 439u, 1553428476u, 2664812822u, 0, LDEXP_TOLERANCE, 0},
{ 749, 1076849399u, 511262496u, 0u, 262u, 1351576311u, 511262496u, 0, LDEXP_TOLERANCE, 0},
{ 750, 1040381038u, 1621968404u, 0u, 453u, 1515385966u, 1621968404u, 0, LDEXP_TOLERANCE, 0},
{ 751, 1051309752u, 716773972u, 0u, 190u, 1250539192u, 716773972u, 0, LDEXP_TOLERANCE, 0},
{ 752, 1089837159u, 3131066689u, 0u, 346u, 1452644455u, 3131066689u, 0, LDEXP_TOLERANCE, 0},
{ 753, 3234817844u, 2885211133u, 0u, 318u, 3568265012u, 2885211133u, 0, LDEXP_TOLERANCE, 0},
{ 754, 3244193329u, 935135102u, 0u, 44u, 3290330673u, 935135102u, 0, LDEXP_TOLERANCE, 0},
{ 755, 3203778258u, 3428784172u, 0u, 71u, 3278227154u, 3428784172u, 0, LDEXP_TOLERANCE, 0},
{ 756, 3238604006u, 2734177193u, 0u, 368u, 3624479974u, 2734177193u, 0, LDEXP_TOLERANCE, 0},
{ 757, 1091433848u, 3888398377u, 0u, 102u, 1198388600u, 3888398377u, 0, LDEXP_TOLERANCE, 0},
{ 758, 1046749113u, 3712806014u, 0u, 443u, 1511268281u, 3712806014u, 0, LDEXP_TOLERANCE, 0},
{ 759, 1076298852u, 991871299u, 0u, 82u, 1162282084u, 991871299u, 0, LDEXP_TOLERANCE, 0},
{ 760, 3206800539u, 4000035882u, 0u, 319u, 3541296283u, 4000035882u, 0, LDEXP_TOLERANCE, 0},
{ 761, 1067010471u, 2056309037u, 0u, 347u, 1430866343u, 2056309037u, 0, LDEXP_TOLERANCE, 0},
{ 762, 1058199525u, 1299425839u, 0u, 432u, 1511184357u, 1299425839u, 0, LDEXP_TOLERANCE, 0},
{ 763, 1050094941u, 3817959288u, 0u, 37u, 1088892253u, 3817959288u, 0, LDEXP_TOLERANCE, 0},
{ 764, 1095599309u, 1960661988u, 0u, 73u, 1172145357u, 1960661988u, 0, LDEXP_TOLERANCE, 0},
{ 765, 3187979854u, 2362441752u, 0u, 331u, 3535058510u, 2362441752u, 0, LDEXP_TOLERANCE, 0},
{ 766, 1088255327u, 270039934u, 0u, 194u, 1291679071u, 270039934u, 0, LDEXP_TOLERANCE, 0},
{ 767, 3249308688u, 397843258u, 0u, 214u, 3473703952u, 397843258u, 0, LDEXP_TOLERANCE, 0},
{ 768, 3212426640u, 3278767347u, 0u, 244u, 3468279184u, 3278767347u, 0, LDEXP_TOLERANCE, 0},
{ 769, 1073567981u, 3086540190u, 0u, 445u, 1540184301u, 3086540190u, 0, LDEXP_TOLERANCE, 0},
{ 770, 1064931281u, 1165998478u, 0u, 354u, 1436127185u, 1165998478u, 0, LDEXP_TOLERANCE, 0},
{ 771, 3204860436u, 1236881883u, 0u, 197u, 3411429908u, 1236881883u, 0, LDEXP_TOLERANCE, 0},
{ 772, 3211538326u, 71491083u, 0u, 429u, 3661377430u, 71491083u, 0, LDEXP_TOLERANCE, 0},
{ 773, 3242681902u, 664136103u, 0u, 40u, 3284624942u, 664136103u, 0, LDEXP_TOLERANCE, 0},
{ 774, 3189996280u, 1751559854u, 0u, 474u, 3687021304u, 1751559854u, 0, LDEXP_TOLERANCE, 0},
{ 775, 1051092760u, 2798720100u, 0u, 95u, 1150707480u, 2798720100u, 0, LDEXP_TOLERANCE, 0},
{ 776, 3205253626u, 3843740240u, 0u, 62u, 3270265338u, 3843740240u, 0, LDEXP_TOLERANCE, 0},
{ 777, 1092011864u, 751825094u, 0u, 342u, 1450624856u, 751825094u, 0, LDEXP_TOLERANCE, 0},
{ 778, 3209223122u, 3502451710u, 0u, 195u, 3413695442u, 3502451710u, 0, LDEXP_TOLERANCE, 0},
{ 779, 3247190406u, 4080443609u, 0u, 248u, 3507237254u, 4080443609u, 0, LDEXP_TOLERANCE, 0},
{ 780, 1096403156u, 3262097651u, 0u, 157u, 1261029588u, 3262097651u, 0, LDEXP_TOLERANCE, 0},
{ 781, 3252309668u, 4001157930u, 0u, 52u, 3306835620u, 4001157930u, 0, LDEXP_TOLERANCE, 0},
{ 782, 3193455299u, 2008796992u, 0u, 272u, 3478667971u, 2008796992u, 0, LDEXP_TOLERANCE, 0},
{ 783, 1074202826u, 3996321918u, 0u, 272u, 1359415498u, 3996321918u, 0, LDEXP_TOLERANCE, 0},
{ 784, 1097859997u, 559918757u, 0u, 200u, 1307575197u, 559918757u, 0, LDEXP_TOLERANCE, 0},
{ 785, 1105263000u, 1026957442u, 0u, 292u, 1411447192u, 1026957442u, 0, LDEXP_TOLERANCE, 0},
{ 786, 1090021734u, 10385612u, 0u, 274u, 1377331558u, 10385612u, 0, LDEXP_TOLERANCE, 0},
{ 787, 3204176005u, 138109865u, 0u, 460u, 3686520965u, 138109865u, 0, LDEXP_TOLERANCE, 0},
{ 788, 3248203007u, 2450309467u, 0u, 259u, 3519784191u, 2450309467u, 0, LDEXP_TOLERANCE, 0},
{ 789, 3222168498u, 3036525078u, 0u, 430u, 3673056178u, 3036525078u, 0, LDEXP_TOLERANCE, 0},
{ 790, 1089193268u, 2185243463u, 0u, 302u, 1405863220u, 2185243463u, 0, LDEXP_TOLERANCE, 0},
{ 791, 1098669225u, 945559339u, 0u, 379u, 1496079529u, 945559339u, 0, LDEXP_TOLERANCE, 0},
{ 792, 3247056551u, 3061117625u, 0u, 305u, 3566872231u, 3061117625u, 0, LDEXP_TOLERANCE, 0},
{ 793, 1056505004u, 3804703138u, 0u, 193u, 1258880172u, 3804703138u, 0, LDEXP_TOLERANCE, 0},
{ 794, 1064051616u, 4286212259u, 0u, 110u, 1179394976u, 4286212259u, 0, LDEXP_TOLERANCE, 0},
{ 795, 3228226248u, 3005944127u, 0u, 368u, 3614102216u, 3005944127u, 0, LDEXP_TOLERANCE, 0},
{ 796, 3227751196u, 1206270591u, 0u, 250u, 3489895196u, 1206270591u, 0, LDEXP_TOLERANCE, 0},
{ 797, 3189082429u, 2733129256u, 0u, 59u, 3250948413u, 2733129256u, 0, LDEXP_TOLERANCE, 0},
{ 798, 3245340921u, 4247799250u, 0u, 202u, 3457153273u, 4247799250u, 0, LDEXP_TOLERANCE, 0},
{ 799, 3221929633u, 1990351504u, 0u, 322u, 3559571105u, 1990351504u, 0, LDEXP_TOLERANCE, 0},
{ 800, 1088823630u, 1306766437u, 0u, 432u, 1541808462u, 1306766437u, 0, LDEXP_TOLERANCE, 0},
{ 801, 1103830155u, 1646497074u, 0u, 106u, 1214979211u, 1646497074u, 0, LDEXP_TOLERANCE, 0},
{ 802, 1045705464u, 1703969219u, 0u, 328u, 1389638392u, 1703969219u, 0, LDEXP_TOLERANCE, 0},
{ 803, 3235685067u, 2320792999u, 0u, 202u, 3447497419u, 2320792999u, 0, LDEXP_TOLERANCE, 0},
{ 804, 3245310028u, 2734025087u, 0u, 343u, 3604971596u, 2734025087u, 0, LDEXP_TOLERANCE, 0},
{ 805, 1050749188u, 1865522910u, 0u, 362u, 1430333700u, 1865522910u, 0, LDEXP_TOLERANCE, 0},
{ 806, 1082523997u, 607572944u, 0u, 246u, 1340473693u, 607572944u, 0, LDEXP_TOLERANCE, 0},
{ 807, 3212293317u, 1718035313u, 0u, 381u, 3611800773u, 1718035313u, 0, LDEXP_TOLERANCE, 0},
{ 808, 1077896873u, 1700936244u, 0u, 365u, 1460627113u, 1700936244u, 0, LDEXP_TOLERANCE, 0},
{ 809, 1105063042u, 999185924u, 0u, 440u, 1566436482u, 999185924u, 0, LDEXP_TOLERANCE, 0},
{ 810, 3207842510u, 788883399u, 0u, 125u, 3338914510u, 788883399u, 0, LDEXP_TOLERANCE, 0},
{ 811, 1068639210u, 3699016825u, 0u, 408u, 1496458218u, 3699016825u, 0, LDEXP_TOLERANCE, 0},
{ 812, 3254694575u, 3257889844u, 0u, 322u, 3592336047u, 3257889844u, 0, LDEXP_TOLERANCE, 0},
{ 813, 3226459123u, 3557606351u, 0u, 466u, 3715095539u, 3557606351u, 0, LDEXP_TOLERANCE, 0},
{ 814, 1096179175u, 2457013015u, 0u, 72u, 1171676647u, 2457013015u, 0, LDEXP_TOLERANCE, 0},
{ 815, 1054624206u, 714673146u, 0u, 423u, 1498171854u, 714673146u, 0, LDEXP_TOLERANCE, 0},
{ 816, 1068142810u, 798819874u, 0u, 305u, 1387958490u, 798819874u, 0, LDEXP_TOLERANCE, 0},
{ 817, 3236531985u, 3685187432u, 0u, 32u, 3270086417u, 3685187432u, 0, LDEXP_TOLERANCE, 0},
{ 818, 3215977438u, 2250028013u, 0u, 12u, 3228560350u, 2250028013u, 0, LDEXP_TOLERANCE, 0},
{ 819, 3212961466u, 822905748u, 0u, 81u, 3297896122u, 822905748u, 0, LDEXP_TOLERANCE, 0},
{ 820, 3221863333u, 162122081u, 0u, 161u, 3390684069u, 162122081u, 0, LDEXP_TOLERANCE, 0},
{ 821, 3229017334u, 184971503u, 0u, 186u, 3424052470u, 184971503u, 0, LDEXP_TOLERANCE, 0},
{ 822, 1068475748u, 3639227340u, 0u, 63u, 1134536036u, 3639227340u, 0, LDEXP_TOLERANCE, 0},
{ 823, 1068863190u, 4192848976u, 0u, 110u, 1184206550u, 4192848976u, 0, LDEXP_TOLERANCE, 0},
{ 824, 1067294567u, 3366476994u, 0u, 150u, 1224580967u, 3366476994u, 0, LDEXP_TOLERANCE, 0},
{ 825, 3190744330u, 2826973629u, 0u, 361u, 3569280266u, 2826973629u, 0, LDEXP_TOLERANCE, 0},
{ 826, 1093885013u, 3565509610u, 0u, 406u, 1519606869u, 3565509610u, 0, LDEXP_TOLERANCE, 0},
{ 827, 1103860823u, 3945565763u, 0u, 470u, 1596691543u, 3945565763u, 0, LDEXP_TOLERANCE, 0},
{ 828, 3253153113u, 3525488721u, 0u, 381u, 3652660569u, 3525488721u, 0, LDEXP_TOLERANCE, 0},
{ 829, 1072788663u, 3844072288u, 0u, 27u, 1101100215u, 3844072288u, 0, LDEXP_TOLERANCE, 0},
{ 830, 1105982382u, 396149483u, 0u, 309u, 1429992366u, 396149483u, 0, LDEXP_TOLERANCE, 0},
{ 831, 3208357660u, 1296976426u, 0u, 226u, 3445335836u, 1296976426u, 0, LDEXP_TOLERANCE, 0},
{ 832, 3198881428u, 3075911575u, 0u, 334u, 3549105812u, 3075911575u, 0, LDEXP_TOLERANCE, 0},
{ 833, 3210025772u, 2171409636u, 0u, 214u, 3434421036u, 2171409636u, 0, LDEXP_TOLERANCE, 0},
{ 834, 1085134286u, 3317203062u, 0u, 367u, 1469961678u, 3317203062u, 0, LDEXP_TOLERANCE, 0},
{ 835, 1096024056u, 342573501u, 0u, 150u, 1253310456u, 342573501u, 0, LDEXP_TOLERANCE, 0},
{ 836, 3214511676u, 1029815247u, 0u, 341u, 3572076092u, 1029815247u, 0, LDEXP_TOLERANCE, 0},
{ 837, 1058864545u, 3610237982u, 0u, 168u, 1235025313u, 3610237982u, 0, LDEXP_TOLERANCE, 0},
{ 838, 1087803418u, 915867083u, 0u, 25u, 1114017818u, 915867083u, 0, LDEXP_TOLERANCE, 0},
{ 839, 1088029890u, 3972498826u, 0u, 437u, 1546257602u, 3972498826u, 0, LDEXP_TOLERANCE, 0},
{ 840, 1069047467u, 4206678986u, 0u, 125u, 1200119467u, 4206678986u, 0, LDEXP_TOLERANCE, 0},
{ 841, 3228983407u, 1162164397u, 0u, 273u, 3515244655u, 1162164397u, 0, LDEXP_TOLERANCE, 0},
{ 842, 3250508564u, 2047944882u, 0u, 101u, 3356414740u, 2047944882u, 0, LDEXP_TOLERANCE, 0},
{ 843, 3190469300u, 721926766u, 0u, 484u, 3697980084u, 721926766u, 0, LDEXP_TOLERANCE, 0},
{ 844, 3205734397u, 858830829u, 0u, 96u, 3306397693u, 858830829u, 0, LDEXP_TOLERANCE, 0},
{ 845, 3254021490u, 1884944479u, 0u, 101u, 3359927666u, 1884944479u, 0, LDEXP_TOLERANCE, 0},
{ 846, 1061200790u, 770599461u, 0u, 457u, 1540400022u, 770599461u, 0, LDEXP_TOLERANCE, 0},
{ 847, 1070178161u, 1235369496u, 0u, 91u, 1165598577u, 1235369496u, 0, LDEXP_TOLERANCE, 0},
{ 848, 3224214082u, 2401751606u, 0u, 487u, 3734870594u, 2401751606u, 0, LDEXP_TOLERANCE, 0},
{ 849, 3195861982u, 2825171386u, 0u, 305u, 3515677662u, 2825171386u, 0, LDEXP_TOLERANCE, 0},
{ 850, 1061833598u, 1272591529u, 0u, 181u, 1251625854u, 1272591529u, 0, LDEXP_TOLERANCE, 0},
{ 851, 1105686806u, 3174008470u, 0u, 444u, 1571254550u, 3174008470u, 0, LDEXP_TOLERANCE, 0},
{ 852, 3201135451u, 1922413069u, 0u, 268u, 3482153819u, 1922413069u, 0, LDEXP_TOLERANCE, 0},
{ 853, 1082801190u, 515824452u, 0u, 365u, 1465531430u, 515824452u, 0, LDEXP_TOLERANCE, 0},
{ 854, 1069439223u, 2638362989u, 0u, 13u, 1083070711u, 2638362989u, 0, LDEXP_TOLERANCE, 0},
{ 855, 1090196972u, 3350821426u, 0u, 214u, 1314592236u, 3350821426u, 0, LDEXP_TOLERANCE, 0},
{ 856, 3222171679u, 2722693603u, 0u, 255u, 3489558559u, 2722693603u, 0, LDEXP_TOLERANCE, 0},
{ 857, 3187717259u, 2277305925u, 0u, 150u, 3345003659u, 2277305925u, 0, LDEXP_TOLERANCE, 0},
{ 858, 1043379197u, 1539782049u, 0u, 88u, 1135653885u, 1539782049u, 0, LDEXP_TOLERANCE, 0},
{ 859, 1096830612u, 4029608359u, 0u, 440u, 1558204052u, 4029608359u, 0, LDEXP_TOLERANCE, 0},
{ 860, 3252051109u, 2999983605u, 0u, 206u, 3468057765u, 2999983605u, 0, LDEXP_TOLERANCE, 0},
{ 861, 1096654323u, 2577373394u, 0u, 178u, 1283300851u, 2577373394u, 0, LDEXP_TOLERANCE, 0},
{ 862, 3210600814u, 3209526929u, 0u, 449u, 3681411438u, 3209526929u, 0, LDEXP_TOLERANCE, 0},
{ 863, 1052682749u, 2164476593u, 0u, 416u, 1488890365u, 2164476593u, 0, LDEXP_TOLERANCE, 0},
{ 864, 3239797146u, 1835860173u, 0u, 441u, 3702219162u, 1835860173u, 0, LDEXP_TOLERANCE, 0},
{ 865, 1081200406u, 2422232642u, 0u, 387u, 1486999318u, 2422232642u, 0, LDEXP_TOLERANCE, 0},
{ 866, 3217493714u, 236015626u, 0u, 448u, 3687255762u, 236015626u, 0, LDEXP_TOLERANCE, 0},
{ 867, 3215229102u, 4091953286u, 0u, 50u, 3267657902u, 4091953286u, 0, LDEXP_TOLERANCE, 0},
{ 868, 3232466491u, 4235242395u, 0u, 208u, 3450570299u, 4235242395u, 0, LDEXP_TOLERANCE, 0},
{ 869, 1056148932u, 2226894195u, 0u, 12u, 1068731844u, 2226894195u, 0, LDEXP_TOLERANCE, 0},
{ 870, 1085928888u, 1212597601u, 0u, 96u, 1186592184u, 1212597601u, 0, LDEXP_TOLERANCE, 0},
{ 871, 1092491334u, 2547796519u, 0u, 394u, 1505630278u, 2547796519u, 0, LDEXP_TOLERANCE, 0},
{ 872, 1089815741u, 931149948u, 0u, 9u, 1099252925u, 931149948u, 0, LDEXP_TOLERANCE, 0},
{ 873, 1078166121u, 2663981399u, 0u, 128u, 1212383849u, 2663981399u, 0, LDEXP_TOLERANCE, 0},
{ 874, 1099551055u, 1082898276u, 0u, 59u, 1161417039u, 1082898276u, 0, LDEXP_TOLERANCE, 0},
{ 875, 1067193495u, 3092668216u, 0u, 368u, 1453069463u, 3092668216u, 0, LDEXP_TOLERANCE, 0},
{ 876, 3220064091u, 735952225u, 0u, 121u, 3346941787u, 735952225u, 0, LDEXP_TOLERANCE, 0},
{ 877, 1088308510u, 3170295088u, 0u, 223u, 1322140958u, 3170295088u, 0, LDEXP_TOLERANCE, 0},
{ 878, 3239143845u, 3990023574u, 0u, 202u, 3450956197u, 3990023574u, 0, LDEXP_TOLERANCE, 0},
{ 879, 1068793940u, 1025779807u, 0u, 496u, 1588887636u, 1025779807u, 0, LDEXP_TOLERANCE, 0},
{ 880, 3217947229u, 937205825u, 0u, 96u, 3318610525u, 937205825u, 0, LDEXP_TOLERANCE, 0},
{ 881, 3214656757u, 824051806u, 0u, 191u, 3414934773u, 824051806u, 0, LDEXP_TOLERANCE, 0},
{ 882, 3246710531u, 2206975583u, 0u, 226u, 3483688707u, 2206975583u, 0, LDEXP_TOLERANCE, 0},
{ 883, 3212669530u, 1645486982u, 0u, 405u, 3637342810u, 1645486982u, 0, LDEXP_TOLERANCE, 0},
{ 884, 3239890670u, 668515593u, 0u, 162u, 3409759982u, 668515593u, 0, LDEXP_TOLERANCE, 0},
{ 885, 3231063208u, 1981359339u, 0u, 110u, 3346406568u, 1981359339u, 0, LDEXP_TOLERANCE, 0},
{ 886, 3224876941u, 895232801u, 0u, 11u, 3236411277u, 895232801u, 0, LDEXP_TOLERANCE, 0},
{ 887, 3202462144u, 2479069370u, 0u, 76u, 3282153920u, 2479069370u, 0, LDEXP_TOLERANCE, 0},
{ 888, 3230070172u, 424421119u, 0u, 428u, 3678860700u, 424421119u, 0, LDEXP_TOLERANCE, 0},
{ 889, 3221132536u, 2265367339u, 0u, 401u, 3641611512u, 2265367339u, 0, LDEXP_TOLERANCE, 0},
{ 890, 1095444173u, 1768241830u, 0u, 167u, 1270556365u, 1768241830u, 0, LDEXP_TOLERANCE, 0},
{ 891, 1042815211u, 2742800982u, 0u, 114u, 1162352875u, 2742800982u, 0, LDEXP_TOLERANCE, 0},
{ 892, 3227055805u, 66926332u, 0u, 47u, 3276338877u, 66926332u, 0, LDEXP_TOLERANCE, 0},
{ 893, 3208978599u, 793918921u, 0u, 79u, 3291816103u, 793918921u, 0, LDEXP_TOLERANCE, 0},
{ 894, 3190613834u, 2499520280u, 0u, 359u, 3567052618u, 2499520280u, 0, LDEXP_TOLERANCE, 0},
{ 895, 3231820809u, 468583709u, 0u, 330u, 3577850889u, 468583709u, 0, LDEXP_TOLERANCE, 0},
{ 896, 3209531041u, 216494777u, 0u, 244u, 3465383585u, 216494777u, 0, LDEXP_TOLERANCE, 0},
{ 897, 3208867582u, 455371296u, 0u, 23u, 3232984830u, 455371296u, 0, LDEXP_TOLERANCE, 0},
{ 898, 3237813129u, 1360096867u, 0u, 323u, 3576503177u, 1360096867u, 0, LDEXP_TOLERANCE, 0},
{ 899, 3234511235u, 722957892u, 0u, 23u, 3258628483u, 722957892u, 0, LDEXP_TOLERANCE, 0},
{ 900, 3196089837u, 1383518509u, 0u, 35u, 3232789997u, 1383518509u, 0, LDEXP_TOLERANCE, 0},
{ 901, 3231254997u, 243303420u, 0u, 450u, 3703114197u, 243303420u, 0, LDEXP_TOLERANCE, 0},
{ 902, 3226132757u, 2422073720u, 0u, 490u, 3739934997u, 2422073720u, 0, LDEXP_TOLERANCE, 0},
{ 903, 3232217617u, 1389215707u, 0u, 453u, 3707222545u, 1389215707u, 0, LDEXP_TOLERANCE, 0},
{ 904, 3192865206u, 1701554404u, 0u, 39u, 3233759670u, 1701554404u, 0, LDEXP_TOLERANCE, 0},
{ 905, 1099239964u, 620596423u, 0u, 296u, 1409618460u, 620596423u, 0, LDEXP_TOLERANCE, 0},
{ 906, 3204081936u, 794279522u, 0u, 292u, 3510266128u, 794279522u, 0, LDEXP_TOLERANCE, 0},
{ 907, 3244160134u, 742203584u, 0u, 252u, 3508401286u, 742203584u, 0, LDEXP_TOLERANCE, 0},
{ 908, 3226020545u, 101555209u, 0u, 493u, 3742968513u, 101555209u, 0, LDEXP_TOLERANCE, 0},
{ 909, 1084214050u, 3065770846u, 0u, 178u, 1270860578u, 3065770846u, 0, LDEXP_TOLERANCE, 0},
{ 910, 3251962512u, 3766248610u, 0u, 332u, 3600089744u, 3766248610u, 0, LDEXP_TOLERANCE, 0},
{ 911, 1094059783u, 2353397886u, 0u, 139u, 1239811847u, 2353397886u, 0, LDEXP_TOLERANCE, 0},
{ 912, 1067736547u, 3644468510u, 0u, 142u, 1216634339u, 3644468510u, 0, LDEXP_TOLERANCE, 0},
{ 913, 3203153389u, 3668774238u, 0u, 414u, 3637263853u, 3668774238u, 0, LDEXP_TOLERANCE, 0},
{ 914, 3254443077u, 3017062764u, 0u, 267u, 3534412869u, 3017062764u, 0, LDEXP_TOLERANCE, 0},
{ 915, 3229391605u, 2125864003u, 0u, 138u, 3374095093u, 2125864003u, 0, LDEXP_TOLERANCE, 0},
{ 916, 3189653973u, 2421488611u, 0u, 18u, 3208528341u, 2421488611u, 0, LDEXP_TOLERANCE, 0},
{ 917, 3189245988u, 1539535238u, 0u, 106u, 3300395044u, 1539535238u, 0, LDEXP_TOLERANCE, 0},
{ 918, 3246934215u, 508708967u, 0u, 166u, 3420997831u, 508708967u, 0, LDEXP_TOLERANCE, 0},
{ 919, 1096820310u, 1045480938u, 0u, 260u, 1369450070u, 1045480938u, 0, LDEXP_TOLERANCE, 0},
{ 920, 3253279675u, 4059455278u, 0u, 497u, 3774421947u, 4059455278u, 0, LDEXP_TOLERANCE, 0},
{ 921, 1086656128u, 2085052714u, 0u, 327u, 1429540480u, 2085052714u, 0, LDEXP_TOLERANCE, 0},
{ 922, 1101382876u, 3731725710u, 0u, 433u, 1555416284u, 3731725710u, 0, LDEXP_TOLERANCE, 0},
{ 923, 1102379272u, 3644659426u, 0u, 465u, 1589967112u, 3644659426u, 0, LDEXP_TOLERANCE, 0},
{ 924, 1042731156u, 1213208320u, 0u, 18u, 1061605524u, 1213208320u, 0, LDEXP_TOLERANCE, 0},
{ 925, 1098023542u, 1856411393u, 0u, 54u, 1154646646u, 1856411393u, 0, LDEXP_TOLERANCE, 0},
{ 926, 3203414683u, 2536686169u, 0u, 245u, 3460315803u, 2536686169u, 0, LDEXP_TOLERANCE, 0},
{ 927, 3221235845u, 3482598782u, 0u, 332u, 3569363077u, 3482598782u, 0, LDEXP_TOLERANCE, 0},
{ 928, 1054849265u, 2353103845u, 0u, 466u, 1543485681u, 2353103845u, 0, LDEXP_TOLERANCE, 0},
{ 929, 3246279974u, 1941016128u, 0u, 459u, 3727576358u, 1941016128u, 0, LDEXP_TOLERANCE, 0},
{ 930, 3223498027u, 3374865460u, 0u, 227u, 3461524779u, 3374865460u, 0, LDEXP_TOLERANCE, 0},
{ 931, 1043393020u, 3103223670u, 0u, 323u, 1382083068u, 3103223670u, 0, LDEXP_TOLERANCE, 0},
{ 932, 1044929218u, 2872266489u, 0u, 418u, 1483233986u, 2872266489u, 0, LDEXP_TOLERANCE, 0},
{ 933, 1050828303u, 2217887323u, 0u, 367u, 1435655695u, 2217887323u, 0, LDEXP_TOLERANCE, 0},
{ 934, 3200788569u, 1848418423u, 0u, 200u, 3410503769u, 1848418423u, 0, LDEXP_TOLERANCE, 0},
{ 935, 3249371352u, 2746559855u, 0u, 29u, 3279780056u, 2746559855u, 0, LDEXP_TOLERANCE, 0},
{ 936, 3214435784u, 3646244007u, 0u, 192u, 3415762376u, 3646244007u, 0, LDEXP_TOLERANCE, 0},
{ 937, 3197852749u, 3808681655u, 0u, 123u, 3326827597u, 3808681655u, 0, LDEXP_TOLERANCE, 0},
{ 938, 1046103353u, 3261896205u, 0u, 69u, 1118455097u, 3261896205u, 0, LDEXP_TOLERANCE, 0},
{ 939, 3198169239u, 2607332678u, 0u, 203u, 3411030167u, 2607332678u, 0, LDEXP_TOLERANCE, 0},
{ 940, 3202585798u, 910680626u, 0u, 363u, 3583218886u, 910680626u, 0, LDEXP_TOLERANCE, 0},
{ 941, 1090685451u, 2102413329u, 0u, 424u, 1535281675u, 2102413329u, 0, LDEXP_TOLERANCE, 0},
{ 942, 3253874340u, 3516336233u, 0u, 90u, 3348246180u, 3516336233u, 0, LDEXP_TOLERANCE, 0},
{ 943, 3232355944u, 1410347277u, 0u, 71u, 3306804840u, 1410347277u, 0, LDEXP_TOLERANCE, 0},
{ 944, 3237050423u, 107788725u, 0u, 162u, 3406919735u, 107788725u, 0, LDEXP_TOLERANCE, 0},
{ 945, 3231252730u, 1784424659u, 0u, 297u, 3542679802u, 1784424659u, 0, LDEXP_TOLERANCE, 0},
{ 946, 3199349254u, 1019916843u, 0u, 366u, 3583128070u, 1019916843u, 0, LDEXP_TOLERANCE, 0},
{ 947, 1083813098u, 2171986964u, 0u, 359u, 1460251882u, 2171986964u, 0, LDEXP_TOLERANCE, 0},
{ 948, 1096604388u, 736131791u, 0u, 408u, 1524423396u, 736131791u, 0, LDEXP_TOLERANCE, 0},
{ 949, 1071811135u, 3766682389u, 0u, 127u, 1204980287u, 3766682389u, 0, LDEXP_TOLERANCE, 0},
{ 950, 1076891662u, 2200276237u, 0u, 420u, 1517293582u, 2200276237u, 0, LDEXP_TOLERANCE, 0},
{ 951, 3234542983u, 2689686464u, 0u, 162u, 3404412295u, 2689686464u, 0, LDEXP_TOLERANCE, 0},
{ 952, 3247609257u, 139905412u, 0u, 24u, 3272775081u, 139905412u, 0, LDEXP_TOLERANCE, 0},
{ 953, 3234048376u, 580580861u, 0u, 373u, 3625167224u, 580580861u, 0, LDEXP_TOLERANCE, 0},
{ 954, 3210191121u, 3524948352u, 0u, 366u, 3593969937u, 3524948352u, 0, LDEXP_TOLERANCE, 0},
{ 955, 1101737698u, 914741728u, 0u, 349u, 1467690722u, 914741728u, 0, LDEXP_TOLERANCE, 0},
{ 956, 1092886795u, 464054401u, 0u, 229u, 1333010699u, 464054401u, 0, LDEXP_TOLERANCE, 0},
{ 957, 1075509277u, 417745917u, 0u, 31u, 1108015133u, 417745917u, 0, LDEXP_TOLERANCE, 0},
{ 958, 1057279131u, 1709794784u, 0u, 249u, 1318374555u, 1709794784u, 0, LDEXP_TOLERANCE, 0},
{ 959, 3234100445u, 3278422298u, 0u, 342u, 3592713437u, 3278422298u, 0, LDEXP_TOLERANCE, 0},
{ 960, 3203733705u, 4261064982u, 0u, 240u, 3455391945u, 4261064982u, 0, LDEXP_TOLERANCE, 0},
{ 961, 1100643460u, 2128617108u, 0u, 271u, 1384807556u, 2128617108u, 0, LDEXP_TOLERANCE, 0},
{ 962, 3240438466u, 21888920u, 0u, 78u, 3322227394u, 21888920u, 0, LDEXP_TOLERANCE, 0},
{ 963, 3197739999u, 1373233750u, 0u, 325u, 3538527199u, 1373233750u, 0, LDEXP_TOLERANCE, 0},
{ 964, 3213773114u, 834976849u, 0u, 287u, 3514714426u, 834976849u, 0, LDEXP_TOLERANCE, 0},
{ 965, 1106728187u, 1569913360u, 0u, 162u, 1276597499u, 1569913360u, 0, LDEXP_TOLERANCE, 0},
{ 966, 1101338019u, 1916097176u, 0u, 119u, 1226118563u, 1916097176u, 0, LDEXP_TOLERANCE, 0},
{ 967, 1088500589u, 2029599667u, 0u, 68u, 1159803757u, 2029599667u, 0, LDEXP_TOLERANCE, 0},
{ 968, 3223722021u, 1092470959u, 0u, 287u, 3524663333u, 1092470959u, 0, LDEXP_TOLERANCE, 0},
{ 969, 3227158932u, 904208640u, 0u, 104u, 3336210836u, 904208640u, 0, LDEXP_TOLERANCE, 0},
{ 970, 3252936386u, 3748743654u, 0u, 398u, 3670269634u, 3748743654u, 0, LDEXP_TOLERANCE, 0},
{ 971, 3214785260u, 3298077351u, 0u, 199u, 3423451884u, 3298077351u, 0, LDEXP_TOLERANCE, 0},
{ 972, 3239386269u, 4236797974u, 0u, 54u, 3296009373u, 4236797974u, 0, LDEXP_TOLERANCE, 0},
{ 973, 3233687691u, 2405805086u, 0u, 205u, 3448645771u, 2405805086u, 0, LDEXP_TOLERANCE, 0},
{ 974, 3222929431u, 4279456618u, 0u, 66u, 3292135447u, 4279456618u, 0, LDEXP_TOLERANCE, 0},
{ 975, 1045375126u, 3817511514u, 0u, 385u, 1449076886u, 3817511514u, 0, LDEXP_TOLERANCE, 0},
{ 976, 1081540030u, 2658217784u, 0u, 224u, 1316421054u, 2658217784u, 0, LDEXP_TOLERANCE, 0},
{ 977, 3242908935u, 2848327573u, 0u, 90u, 3337280775u, 2848327573u, 0, LDEXP_TOLERANCE, 0},
{ 978, 1073045264u, 1841901027u, 0u, 326u, 1414881040u, 1841901027u, 0, LDEXP_TOLERANCE, 0},
{ 979, 1090819154u, 1205187797u, 0u, 439u, 1551144018u, 1205187797u, 0, LDEXP_TOLERANCE, 0},
{ 980, 3233869823u, 1390957964u, 0u, 5u, 3239112703u, 1390957964u, 0, LDEXP_TOLERANCE, 0},
{ 981, 3208658945u, 2704249815u, 0u, 244u, 3464511489u, 2704249815u, 0, LDEXP_TOLERANCE, 0},
{ 982, 3229123692u, 338765118u, 0u, 205u, 3444081772u, 338765118u, 0, LDEXP_TOLERANCE, 0},
{ 983, 3215638141u, 2059348626u, 0u, 53u, 3271212669u, 2059348626u, 0, LDEXP_TOLERANCE, 0},
{ 984, 3206590689u, 3769581744u, 0u, 220u, 3437277409u, 3769581744u, 0, LDEXP_TOLERANCE, 0},
{ 985, 1087767451u, 2442561375u, 0u, 352u, 1456866203u, 2442561375u, 0, LDEXP_TOLERANCE, 0},
{ 986, 1043029185u, 1826571949u, 0u, 287u, 1343970497u, 1826571949u, 0, LDEXP_TOLERANCE, 0},
{ 987, 3227038874u, 4157848135u, 0u, 470u, 3719869594u, 4157848135u, 0, LDEXP_TOLERANCE, 0},
{ 988, 3210023815u, 3262641707u, 0u, 239u, 3460633479u, 3262641707u, 0, LDEXP_TOLERANCE, 0},
{ 989, 3233710961u, 851510610u, 0u, 299u, 3547235185u, 851510610u, 0, LDEXP_TOLERANCE, 0},
{ 990, 3232296686u, 55834416u, 0u, 155u, 3394825966u, 55834416u, 0, LDEXP_TOLERANCE, 0},
{ 991, 1067699608u, 4282766727u, 0u, 208u, 1285803416u, 4282766727u, 0, LDEXP_TOLERANCE, 0},
{ 992, 1073603056u, 2574237400u, 0u, 399u, 1491984880u, 2574237400u, 0, LDEXP_TOLERANCE, 0},
{ 993, 1059828657u, 1824828952u, 0u, 9u, 1069265841u, 1824828952u, 0, LDEXP_TOLERANCE, 0},
{ 994, 3243078353u, 4292530873u, 0u, 111u, 3359470289u, 4292530873u, 0, LDEXP_TOLERANCE, 0},
{ 995, 1066526787u, 3220678991u, 0u, 61u, 1130489923u, 3220678991u, 0, LDEXP_TOLERANCE, 0},
{ 996, 1101299693u, 4056776748u, 0u, 465u, 1588887533u, 4056776748u, 0, LDEXP_TOLERANCE, 0},
{ 997, 1071354531u, 683713613u, 0u, 210u, 1291555491u, 683713613u, 0, LDEXP_TOLERANCE, 0},
{ 998, 1089099910u, 2719336106u, 0u, 473u, 1585076358u, 2719336106u, 0, LDEXP_TOLERANCE, 0},
{ 999, 1084514518u, 343139655u, 0u, 247u, 1343512790u, 343139655u, 0, LDEXP_TOLERANCE, 0},


// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_LDEXP_H multiple inclusion protection

// EOF ldexp.h
