#ifndef __LM3S9XXX_ROM_H__
#define __LM3S9XXX_ROM_H__
//=============================================================================
//
//      rom_api.h
//
//      API interface to the functionality supplied in ROM.
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2011 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   stuartw
// Date:        2011-06-17
// Purpose:     Stellaris Cortex-M3 9000 Series API interface to the
//              functionality supplied in ROM.
// Description:
// Usage:       #include <cyg/hal/rom_api.h>
//
//####DESCRIPTIONEND####
//
//=============================================================================

//=============================================================================
//
// Pointers to the main API tables.
//
//=============================================================================
#define ROM_APITABLE            ((unsigned long *)0x01000010)
#define ROM_VERSION             (ROM_APITABLE[0])
#define ROM_UARTTABLE           ((unsigned long *)(ROM_APITABLE[1]))
#define ROM_SSITABLE            ((unsigned long *)(ROM_APITABLE[2]))
#define ROM_I2CTABLE            ((unsigned long *)(ROM_APITABLE[3]))
#define ROM_GPIOTABLE           ((unsigned long *)(ROM_APITABLE[4]))
#define ROM_ADCTABLE            ((unsigned long *)(ROM_APITABLE[5]))
#define ROM_COMPARATORTABLE     ((unsigned long *)(ROM_APITABLE[6]))
#define ROM_FLASHTABLE          ((unsigned long *)(ROM_APITABLE[7]))
#define ROM_PWMTABLE            ((unsigned long *)(ROM_APITABLE[8]))
#define ROM_QEITABLE            ((unsigned long *)(ROM_APITABLE[9]))
#define ROM_SYSTICKTABLE        ((unsigned long *)(ROM_APITABLE[10]))
#define ROM_TIMERTABLE          ((unsigned long *)(ROM_APITABLE[11]))
#define ROM_WATCHDOGTABLE       ((unsigned long *)(ROM_APITABLE[12]))
#define ROM_SYSCTLTABLE         ((unsigned long *)(ROM_APITABLE[13]))
#define ROM_INTERRUPTTABLE      ((unsigned long *)(ROM_APITABLE[14]))
#define ROM_ETHERNETTABLE       ((unsigned long *)(ROM_APITABLE[15]))
#define ROM_USBTABLE            ((unsigned long *)(ROM_APITABLE[16]))
#define ROM_UDMATABLE           ((unsigned long *)(ROM_APITABLE[17]))
#define ROM_CANTABLE            ((unsigned long *)(ROM_APITABLE[18]))
#define ROM_HIBERNATETABLE      ((unsigned long *)(ROM_APITABLE[19]))
#define ROM_MPUTABLE            ((unsigned long *)(ROM_APITABLE[20]))
#define ROM_SOFTWARETABLE       ((unsigned long *)(ROM_APITABLE[21]))
#define ROM_I2STABLE            ((unsigned long *)(ROM_APITABLE[22]))
#define ROM_EPITABLE            ((unsigned long *)(ROM_APITABLE[23]))

//=============================================================================
//
// Macros for calling ROM functions in the Ethernet API.
//
//=============================================================================
#define ROM_EthernetIntClear                                                  \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulIntFlags))ROM_ETHERNETTABLE[0])
#define ROM_EthernetInitExpClk                                                \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulEthClk))ROM_ETHERNETTABLE[1])
#define ROM_EthernetConfigSet                                                 \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulConfig))ROM_ETHERNETTABLE[2])
#define ROM_EthernetConfigGet                                                 \
        ((unsigned long (*)(unsigned long ulBase))ROM_ETHERNETTABLE[3])
#define ROM_EthernetMACAddrSet                                                \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned char *pucMACAddr))ROM_ETHERNETTABLE[4])
#define ROM_EthernetMACAddrGet                                                \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned char *pucMACAddr))ROM_ETHERNETTABLE[5])
#define ROM_EthernetEnable                                                    \
        ((void (*)(unsigned long ulBase))ROM_ETHERNETTABLE[6])
#define ROM_EthernetDisable                                                   \
        ((void (*)(unsigned long ulBase))ROM_ETHERNETTABLE[7])
#define ROM_EthernetPacketAvail                                               \
        ((bool (*)(unsigned long ulBase))ROM_ETHERNETTABLE[8])
#define ROM_EthernetSpaceAvail                                                \
        ((bool (*)(unsigned long ulBase))ROM_ETHERNETTABLE[9])
#define ROM_EthernetPacketGetNonBlocking                                      \
        ((long (*)(unsigned long ulBase,                                      \
                   unsigned char *pucBuf,                                     \
                   long lBufLen))ROM_ETHERNETTABLE[10])
#define ROM_EthernetPacketGet                                                 \
        ((long (*)(unsigned long ulBase,                                      \
                   unsigned char *pucBuf,                                     \
                   long lBufLen))ROM_ETHERNETTABLE[11])
#define ROM_EthernetPacketPutNonBlocking                                      \
        ((long (*)(unsigned long ulBase,                                      \
                   unsigned char *pucBuf,                                     \
                   long lBufLen))ROM_ETHERNETTABLE[12])
#define ROM_EthernetPacketPut                                                 \
        ((long (*)(unsigned long ulBase,                                      \
                   unsigned char *pucBuf,                                     \
                   long lBufLen))ROM_ETHERNETTABLE[13])
#define ROM_EthernetIntEnable                                                 \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulIntFlags))ROM_ETHERNETTABLE[14])
#define ROM_EthernetIntDisable                                                \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulIntFlags))ROM_ETHERNETTABLE[15])
#define ROM_EthernetIntStatus                                                 \
        ((unsigned long (*)(unsigned long ulBase,                             \
                            bool bMasked))ROM_ETHERNETTABLE[16])
#define ROM_EthernetPHYWrite                                                  \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned char ucRegAddr,                                   \
                   unsigned long ulData))ROM_ETHERNETTABLE[17])
#define ROM_EthernetPHYRead                                                   \
        ((unsigned long (*)(unsigned long ulBase,                             \
                            unsigned char ucRegAddr))ROM_ETHERNETTABLE[18])
#define ROM_UpdateEthernet                                                    \
        ((void (*)(unsigned long ulClock))ROM_ETHERNETTABLE[19])

//=============================================================================
//
// Macros for calling ROM functions in the Flash API.
//
//=============================================================================
#define ROM_FlashProgram                                                      \
        ((long (*)(unsigned long *pulData,                                    \
                   unsigned long ulAddress,                                   \
                   unsigned long ulCount))ROM_FLASHTABLE[0])
#define ROM_FlashUsecGet                                                      \
        ((unsigned long (*)(void))ROM_FLASHTABLE[1])
#define ROM_FlashUsecSet                                                      \
        ((void (*)(unsigned long ulClocks))ROM_FLASHTABLE[2])
#define ROM_FlashErase                                                        \
        ((long (*)(unsigned long ulAddress))ROM_FLASHTABLE[3])
#define ROM_FlashProtectGet                                                   \
        ((tFlashProtection (*)(unsigned long ulAddress))ROM_FLASHTABLE[4])
#define ROM_FlashProtectSet                                                   \
        ((long (*)(unsigned long ulAddress,                                   \
                   tFlashProtection eProtect))ROM_FLASHTABLE[5])
#define ROM_FlashProtectSave                                                  \
        ((long (*)(void))ROM_FLASHTABLE[6])
#define ROM_FlashUserGet                                                      \
        ((long (*)(unsigned long *pulUser0,                                   \
                   unsigned long *pulUser1))ROM_FLASHTABLE[7])
#define ROM_FlashUserSet                                                      \
        ((long (*)(unsigned long ulUser0,                                     \
                   unsigned long ulUser1))ROM_FLASHTABLE[8])
#define ROM_FlashUserSave                                                     \
        ((long (*)(void))ROM_FLASHTABLE[9])
#define ROM_FlashIntEnable                                                    \
        ((void (*)(unsigned long ulIntFlags))ROM_FLASHTABLE[10])
#define ROM_FlashIntDisable                                                   \
        ((void (*)(unsigned long ulIntFlags))ROM_FLASHTABLE[11])
#define ROM_FlashIntStatus                                                    \
        ((unsigned long (*)(bool bMasked))ROM_FLASHTABLE[12])
#define ROM_FlashIntClear                                                     \
        ((void (*)(unsigned long ulIntFlags))ROM_FLASHTABLE[13])

//=============================================================================
//
// Macros for calling ROM functions in the GPIO API.
//
//=============================================================================
#define ROM_GPIOPinWrite                                                      \
        ((void (*)(unsigned long ulPort,                                      \
                   unsigned char ucPins,                                      \
                   unsigned char ucVal))ROM_GPIOTABLE[0])
#define ROM_GPIODirModeSet                                                    \
        ((void (*)(unsigned long ulPort,                                      \
                   unsigned char ucPins,                                      \
                   unsigned long ulPinIO))ROM_GPIOTABLE[1])
#define ROM_GPIODirModeGet                                                    \
        ((unsigned long (*)(unsigned long ulPort,                             \
                            unsigned char ucPin))ROM_GPIOTABLE[2])
#define ROM_GPIOIntTypeSet                                                    \
        ((void (*)(unsigned long ulPort,                                      \
                   unsigned char ucPins,                                      \
                   unsigned long ulIntType))ROM_GPIOTABLE[3])
#define ROM_GPIOIntTypeGet                                                    \
        ((unsigned long (*)(unsigned long ulPort,                             \
                            unsigned char ucPin))ROM_GPIOTABLE[4])
#define ROM_GPIOPadConfigSet                                                  \
        ((void (*)(unsigned long ulPort,                                      \
                   unsigned char ucPins,                                      \
                   unsigned long ulStrength,                                  \
                   unsigned long ulPadType))ROM_GPIOTABLE[5])
#define ROM_GPIOPadConfigGet                                                  \
        ((void (*)(unsigned long ulPort,                                      \
                   unsigned char ucPin,                                       \
                   unsigned long *pulStrength,                                \
                   unsigned long *pulPadType))ROM_GPIOTABLE[6])
#define ROM_GPIOPinIntEnable                                                  \
        ((void (*)(unsigned long ulPort,                                      \
                   unsigned char ucPins))ROM_GPIOTABLE[7])
#define ROM_GPIOPinIntDisable                                                 \
        ((void (*)(unsigned long ulPort,                                      \
                   unsigned char ucPins))ROM_GPIOTABLE[8])
#define ROM_GPIOPinIntStatus                                                  \
        ((long (*)(unsigned long ulPort,                                      \
                   bool bMasked))ROM_GPIOTABLE[9])
#define ROM_GPIOPinIntClear                                                   \
        ((void (*)(unsigned long ulPort,                                      \
                   unsigned char ucPins))ROM_GPIOTABLE[10])
#define ROM_GPIOPinRead                                                       \
        ((long (*)(unsigned long ulPort,                                      \
                   unsigned char ucPins))ROM_GPIOTABLE[11])
#define ROM_GPIOPinTypeCAN                                                    \
        ((void (*)(unsigned long ulPort,                                      \
                   unsigned char ucPins))ROM_GPIOTABLE[12])
#define ROM_GPIOPinTypeComparator                                             \
        ((void (*)(unsigned long ulPort,                                      \
                   unsigned char ucPins))ROM_GPIOTABLE[13])
#define ROM_GPIOPinTypeGPIOInput                                              \
        ((void (*)(unsigned long ulPort,                                      \
                   unsigned char ucPins))ROM_GPIOTABLE[14])
#define ROM_GPIOPinTypeGPIOOutput                                             \
        ((void (*)(unsigned long ulPort,                                      \
                   unsigned char ucPins))ROM_GPIOTABLE[15])
#define ROM_GPIOPinTypeI2C                                                    \
        ((void (*)(unsigned long ulPort,                                      \
                   unsigned char ucPins))ROM_GPIOTABLE[16])
#define ROM_GPIOPinTypePWM                                                    \
        ((void (*)(unsigned long ulPort,                                      \
                   unsigned char ucPins))ROM_GPIOTABLE[17])
#define ROM_GPIOPinTypeQEI                                                    \
        ((void (*)(unsigned long ulPort,                                      \
                   unsigned char ucPins))ROM_GPIOTABLE[18])
#define ROM_GPIOPinTypeSSI                                                    \
        ((void (*)(unsigned long ulPort,                                      \
                   unsigned char ucPins))ROM_GPIOTABLE[19])
#define ROM_GPIOPinTypeTimer                                                  \
        ((void (*)(unsigned long ulPort,                                      \
                   unsigned char ucPins))ROM_GPIOTABLE[20])
#define ROM_GPIOPinTypeUART                                                   \
        ((void (*)(unsigned long ulPort,                                      \
                   unsigned char ucPins))ROM_GPIOTABLE[21])
#define ROM_GPIOPinTypeGPIOOutputOD                                           \
        ((void (*)(unsigned long ulPort,                                      \
                   unsigned char ucPins))ROM_GPIOTABLE[22])
#define ROM_GPIOPinTypeADC                                                    \
        ((void (*)(unsigned long ulPort,                                      \
                   unsigned char ucPins))ROM_GPIOTABLE[23])
#define ROM_GPIOPinTypeUSBDigital                                             \
        ((void (*)(unsigned long ulPort,                                      \
                   unsigned char ucPins))ROM_GPIOTABLE[24])
#define ROM_GPIOPinTypeI2S                                                    \
        ((void (*)(unsigned long ulPort,                                      \
                   unsigned char ucPins))ROM_GPIOTABLE[25])
#define ROM_GPIOPinConfigure                                                  \
        ((void (*)(unsigned long ulPinConfigure))ROM_GPIOTABLE[26])


//=============================================================================
//
// Macros for calling ROM functions in the Interrupt API.
//
//=============================================================================
#define ROM_IntEnable                                                         \
        ((void (*)(unsigned long ulInterrupt))ROM_INTERRUPTTABLE[0])
#define ROM_IntMasterEnable                                                   \
        ((bool (*)(void))ROM_INTERRUPTTABLE[1])
#define ROM_IntMasterDisable                                                  \
        ((bool (*)(void))ROM_INTERRUPTTABLE[2])
#define ROM_IntDisable                                                        \
        ((void (*)(unsigned long ulInterrupt))ROM_INTERRUPTTABLE[3])
#define ROM_IntPriorityGroupingSet                                            \
        ((void (*)(unsigned long ulBits))ROM_INTERRUPTTABLE[4])
#define ROM_IntPriorityGroupingGet                                            \
        ((unsigned long (*)(void))ROM_INTERRUPTTABLE[5])
#define ROM_IntPrioritySet                                                    \
        ((void (*)(unsigned long ulInterrupt,                                 \
                   unsigned char ucPriority))ROM_INTERRUPTTABLE[6])
#define ROM_IntPriorityGet                                                    \
        ((long (*)(unsigned long ulInterrupt))ROM_INTERRUPTTABLE[7])

//=============================================================================
//
// Macros for calling ROM functions in the SysCtl API.
//
//=============================================================================
#define ROM_SysCtlSleep                                                       \
        ((void (*)(void))ROM_SYSCTLTABLE[0])
#define ROM_SysCtlSRAMSizeGet                                                 \
        ((unsigned long (*)(void))ROM_SYSCTLTABLE[1])
#define ROM_SysCtlFlashSizeGet                                                \
        ((unsigned long (*)(void))ROM_SYSCTLTABLE[2])
#define ROM_SysCtlPinPresent                                                  \
        ((bool (*)(unsigned long ulPin))ROM_SYSCTLTABLE[3])
#define ROM_SysCtlPeripheralPresent                                           \
        ((bool (*)(unsigned long ulPeripheral))ROM_SYSCTLTABLE[4])
#define ROM_SysCtlPeripheralReset                                             \
        ((void (*)(unsigned long ulPeripheral))ROM_SYSCTLTABLE[5])
#define ROM_SysCtlPeripheralEnable                                            \
        ((void (*)(unsigned long ulPeripheral))ROM_SYSCTLTABLE[6])
#define ROM_SysCtlPeripheralDisable                                           \
        ((void (*)(unsigned long ulPeripheral))ROM_SYSCTLTABLE[7])
#define ROM_SysCtlPeripheralSleepEnable                                       \
        ((void (*)(unsigned long ulPeripheral))ROM_SYSCTLTABLE[8])
#define ROM_SysCtlPeripheralSleepDisable                                      \
        ((void (*)(unsigned long ulPeripheral))ROM_SYSCTLTABLE[9])
#define ROM_SysCtlPeripheralDeepSleepEnable                                   \
        ((void (*)(unsigned long ulPeripheral))ROM_SYSCTLTABLE[10])
#define ROM_SysCtlPeripheralDeepSleepDisable                                  \
        ((void (*)(unsigned long ulPeripheral))ROM_SYSCTLTABLE[11])
#define ROM_SysCtlPeripheralClockGating                                       \
        ((void (*)(bool bEnable))ROM_SYSCTLTABLE[12])
#define ROM_SysCtlIntEnable                                                   \
        ((void (*)(unsigned long ulInts))ROM_SYSCTLTABLE[13])
#define ROM_SysCtlIntDisable                                                  \
        ((void (*)(unsigned long ulInts))ROM_SYSCTLTABLE[14])
#define ROM_SysCtlIntClear                                                    \
        ((void (*)(unsigned long ulInts))ROM_SYSCTLTABLE[15])
#define ROM_SysCtlIntStatus                                                   \
        ((unsigned long (*)(bool bMasked))ROM_SYSCTLTABLE[16])
#define ROM_SysCtlLDOSet                                                      \
        ((void (*)(unsigned long ulVoltage))ROM_SYSCTLTABLE[17])
#define ROM_SysCtlLDOGet                                                      \
        ((unsigned long (*)(void))ROM_SYSCTLTABLE[18])
#define ROM_SysCtlReset                                                       \
        ((void (*)(void))ROM_SYSCTLTABLE[19])
#define ROM_SysCtlDeepSleep                                                   \
        ((void (*)(void))ROM_SYSCTLTABLE[20])
#define ROM_SysCtlResetCauseGet                                               \
        ((unsigned long (*)(void))ROM_SYSCTLTABLE[21])
#define ROM_SysCtlResetCauseClear                                             \
        ((void (*)(unsigned long ulCauses))ROM_SYSCTLTABLE[22])
#define ROM_SysCtlClockSet                                                    \
        ((void (*)(unsigned long ulConfig))ROM_SYSCTLTABLE[23])
#define ROM_SysCtlClockGet                                                    \
        ((unsigned long (*)(void))ROM_SYSCTLTABLE[24])
#define ROM_SysCtlPWMClockSet                                                 \
        ((void (*)(unsigned long ulConfig))ROM_SYSCTLTABLE[25])
#define ROM_SysCtlPWMClockGet                                                 \
        ((unsigned long (*)(void))ROM_SYSCTLTABLE[26])
#define ROM_SysCtlADCSpeedSet                                                 \
        ((void (*)(unsigned long ulSpeed))ROM_SYSCTLTABLE[27])
#define ROM_SysCtlADCSpeedGet                                                 \
        ((unsigned long (*)(void))ROM_SYSCTLTABLE[28])
#define ROM_SysCtlGPIOAHBEnable                                               \
        ((void (*)(unsigned long ulGPIOPeripheral))ROM_SYSCTLTABLE[29])
#define ROM_SysCtlGPIOAHBDisable                                              \
        ((void (*)(unsigned long ulGPIOPeripheral))ROM_SYSCTLTABLE[30])
#define ROM_SysCtlUSBPLLEnable                                                \
        ((void (*)(void))ROM_SYSCTLTABLE[31])
#define ROM_SysCtlUSBPLLDisable                                               \
        ((void (*)(void))ROM_SYSCTLTABLE[32])

//=============================================================================
//
// Macros for calling ROM functions in the SysTick API.
//
//=============================================================================
#define ROM_SysTickValueGet                                                   \
        ((unsigned long (*)(void))ROM_SYSTICKTABLE[0])
#define ROM_SysTickEnable                                                     \
        ((void (*)(void))ROM_SYSTICKTABLE[1])
#define ROM_SysTickDisable                                                    \
        ((void (*)(void))ROM_SYSTICKTABLE[2])
#define ROM_SysTickIntEnable                                                  \
        ((void (*)(void))ROM_SYSTICKTABLE[3])
#define ROM_SysTickIntDisable                                                 \
        ((void (*)(void))ROM_SYSTICKTABLE[4])
#define ROM_SysTickPeriodSet                                                  \
        ((void (*)(unsigned long ulPeriod))ROM_SYSTICKTABLE[5])
#define ROM_SysTickPeriodGet                                                  \
        ((unsigned long (*)(void))ROM_SYSTICKTABLE[6])

//=============================================================================
//
// Macros for calling ROM functions in the Timer API.
//
//=============================================================================
#define ROM_TimerIntClear                                                     \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulIntFlags))ROM_TIMERTABLE[0])
#define ROM_TimerEnable                                                       \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulTimer))ROM_TIMERTABLE[1])
#define ROM_TimerDisable                                                      \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulTimer))ROM_TIMERTABLE[2])
#define ROM_TimerConfigure                                                    \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulConfig))ROM_TIMERTABLE[3])
#define ROM_TimerControlLevel                                                 \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulTimer,                                     \
                   bool bInvert))ROM_TIMERTABLE[4])
#define ROM_TimerControlTrigger                                               \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulTimer,                                     \
                   bool bEnable))ROM_TIMERTABLE[5])
#define ROM_TimerControlEvent                                                 \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulTimer,                                     \
                   unsigned long ulEvent))ROM_TIMERTABLE[6])
#define ROM_TimerControlStall                                                 \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulTimer,                                     \
                   bool bStall))ROM_TIMERTABLE[7])
#define ROM_TimerRTCEnable                                                    \
        ((void (*)(unsigned long ulBase))ROM_TIMERTABLE[8])
#define ROM_TimerRTCDisable                                                   \
        ((void (*)(unsigned long ulBase))ROM_TIMERTABLE[9])
#define ROM_TimerPrescaleSet                                                  \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulTimer,                                     \
                   unsigned long ulValue))ROM_TIMERTABLE[10])
#define ROM_TimerPrescaleGet                                                  \
        ((unsigned long (*)(unsigned long ulBase,                             \
                            unsigned long ulTimer))ROM_TIMERTABLE[11])
#define ROM_TimerLoadSet                                                      \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulTimer,                                     \
                   unsigned long ulValue))ROM_TIMERTABLE[14])
#define ROM_TimerLoadGet                                                      \
        ((unsigned long (*)(unsigned long ulBase,                             \
                            unsigned long ulTimer))ROM_TIMERTABLE[15])
#define ROM_TimerValueGet                                                     \
        ((unsigned long (*)(unsigned long ulBase,                             \
                            unsigned long ulTimer))ROM_TIMERTABLE[16])
#define ROM_TimerMatchSet                                                     \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulTimer,                                     \
                   unsigned long ulValue))ROM_TIMERTABLE[17])
#define ROM_TimerMatchGet                                                     \
        ((unsigned long (*)(unsigned long ulBase,                             \
                            unsigned long ulTimer))ROM_TIMERTABLE[18])
#define ROM_TimerIntEnable                                                    \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulIntFlags))ROM_TIMERTABLE[19])
#define ROM_TimerIntDisable                                                   \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulIntFlags))ROM_TIMERTABLE[20])
#define ROM_TimerIntStatus                                                    \
        ((unsigned long (*)(unsigned long ulBase,                             \
                            bool bMasked))ROM_TIMERTABLE[21])

//=============================================================================
//
// Macros for calling ROM functions in the UART API.
//
//=============================================================================
#define ROM_UARTCharPut                                                       \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned char ucData))ROM_UARTTABLE[0])
#define ROM_UARTParityModeSet                                                 \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulParity))ROM_UARTTABLE[1])
#define ROM_UARTParityModeGet                                                 \
        ((unsigned long (*)(unsigned long ulBase))ROM_UARTTABLE[2])
#define ROM_UARTFIFOLevelSet                                                  \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulTxLevel,                                   \
                   unsigned long ulRxLevel))ROM_UARTTABLE[3])
#define ROM_UARTFIFOLevelGet                                                  \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long *pulTxLevel,                                 \
                   unsigned long *pulRxLevel))ROM_UARTTABLE[4])
#define ROM_UARTConfigSetExpClk                                               \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulUARTClk,                                   \
                   unsigned long ulBaud,                                      \
                   unsigned long ulConfig))ROM_UARTTABLE[5])
#define ROM_UARTConfigGetExpClk                                               \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulUARTClk,                                   \
                   unsigned long *pulBaud,                                    \
                   unsigned long *pulConfig))ROM_UARTTABLE[6])
#define ROM_UARTEnable                                                        \
        ((void (*)(unsigned long ulBase))ROM_UARTTABLE[7])
#define ROM_UARTDisable                                                       \
        ((void (*)(unsigned long ulBase))ROM_UARTTABLE[8])
#define ROM_UARTEnableSIR                                                     \
        ((void (*)(unsigned long ulBase,                                      \
                   bool bLowPower))ROM_UARTTABLE[9])
#define ROM_UARTDisableSIR                                                    \
        ((void (*)(unsigned long ulBase))ROM_UARTTABLE[10])
#define ROM_UARTCharsAvail                                                    \
        ((bool (*)(unsigned long ulBase))ROM_UARTTABLE[11])
#define ROM_UARTSpaceAvail                                                    \
        ((bool (*)(unsigned long ulBase))ROM_UARTTABLE[12])
#define ROM_UARTCharGetNonBlocking                                            \
        ((long (*)(unsigned long ulBase))ROM_UARTTABLE[13])
#define ROM_UARTCharGet                                                       \
        ((long (*)(unsigned long ulBase))ROM_UARTTABLE[14])
#define ROM_UARTCharPutNonBlocking                                            \
        ((bool (*)(unsigned long ulBase,                                  \
                       unsigned char ucData))ROM_UARTTABLE[15])
#define ROM_UARTBreakCtl                                                      \
        ((void (*)(unsigned long ulBase,                                      \
                   bool bBreakState))ROM_UARTTABLE[16])
#define ROM_UARTIntEnable                                                     \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulIntFlags))ROM_UARTTABLE[17])
#define ROM_UARTIntDisable                                                    \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulIntFlags))ROM_UARTTABLE[18])
#define ROM_UARTIntStatus                                                     \
        ((unsigned long (*)(unsigned long ulBase,                             \
                            bool bMasked))ROM_UARTTABLE[19])
#define ROM_UARTIntClear                                                      \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulIntFlags))ROM_UARTTABLE[20])
#define ROM_UpdateUART                                                        \
        ((void (*)(void))ROM_UARTTABLE[21])
#define ROM_UARTDMAEnable                                                     \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulDMAFlags))ROM_UARTTABLE[22])
#define ROM_UARTDMADisable                                                    \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulDMAFlags))ROM_UARTTABLE[23])
#define ROM_UARTFIFOEnable                                                    \
        ((void (*)(unsigned long ulBase))ROM_UARTTABLE[24])
#define ROM_UARTFIFODisable                                                   \
        ((void (*)(unsigned long ulBase))ROM_UARTTABLE[25])
#define ROM_UARTBusy                                                          \
        ((void (*)(unsigned long ulBase))ROM_UARTTABLE[26])
#define ROM_UARTTxIntModeSet                                                  \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulMode))ROM_UARTTABLE[27])
#define ROM_UARTTxIntModeGet                                                  \
        ((unsigned long (*)(unsigned long ulBase))ROM_UARTTABLE[28])
#define ROM_UARTRxErrorGet                                                    \
        ((unsigned long (*)(unsigned long ulBase))ROM_UARTTABLE[29])
#define ROM_UARTRxErrorClear                                                  \
        ((void (*)(unsigned long ulBase))ROM_UARTTABLE[30])

//=============================================================================
//
// Macros for calling ROM functions in the Watchdog API.
//
//=============================================================================
#define ROM_WatchdogIntClear                                                  \
        ((void (*)(unsigned long ulBase))ROM_WATCHDOGTABLE[0])
#define ROM_WatchdogRunning                                                   \
        ((bool (*)(unsigned long ulBase))ROM_WATCHDOGTABLE[1])
#define ROM_WatchdogEnable                                                    \
        ((void (*)(unsigned long ulBase))ROM_WATCHDOGTABLE[2])
#define ROM_WatchdogResetEnable                                               \
        ((void (*)(unsigned long ulBase))ROM_WATCHDOGTABLE[3])
#define ROM_WatchdogResetDisable                                              \
        ((void (*)(unsigned long ulBase))ROM_WATCHDOGTABLE[4])
#define ROM_WatchdogLock                                                      \
        ((void (*)(unsigned long ulBase))ROM_WATCHDOGTABLE[5])
#define ROM_WatchdogUnlock                                                    \
        ((void (*)(unsigned long ulBase))ROM_WATCHDOGTABLE[6])
#define ROM_WatchdogLockState                                                 \
        ((bool (*)(unsigned long ulBase))ROM_WATCHDOGTABLE[7])
#define ROM_WatchdogReloadSet                                                 \
        ((void (*)(unsigned long ulBase,                                      \
                   unsigned long ulLoadVal))ROM_WATCHDOGTABLE[8])
#define ROM_WatchdogReloadGet                                                 \
        ((unsigned long (*)(unsigned long ulBase))ROM_WATCHDOGTABLE[9])
#define ROM_WatchdogValueGet                                                  \
        ((unsigned long (*)(unsigned long ulBase))ROM_WATCHDOGTABLE[10])
#define ROM_WatchdogIntEnable                                                 \
        ((void (*)(unsigned long ulBase))ROM_WATCHDOGTABLE[11])
#define ROM_WatchdogIntStatus                                                 \
        ((unsigned long (*)(unsigned long ulBase,                             \
                            bool bMasked))ROM_WATCHDOGTABLE[12])
#define ROM_WatchdogStallEnable                                               \
        ((void (*)(unsigned long ulBase))ROM_WATCHDOGTABLE[13])
#define ROM_WatchdogStallDisable                                              \
        ((void (*)(unsigned long ulBase))ROM_WATCHDOGTABLE[14])

//=============================================================================
//
// Macros for calling ROM functions in the Software API.
//
//=============================================================================
#define ROM_Crc16Array                                                        \
        ((unsigned short (*)(unsigned long ulWordLen,                         \
                             unsigned long *pulData))ROM_SOFTWARETABLE[1])
#define ROM_Crc16Array3                                                       \
        ((void (*)(unsigned long ulWordLen,                                   \
                   unsigned long *pulData,                                    \
                   unsigned short *pusCrc3))ROM_SOFTWARETABLE[2])
#define ROM_pvAESTable                                                        \
        ((void *)&(ROM_SOFTWARETABLE[7]))


//=============================================================================
//
// Values for various Sysctl ROM functions
//
//=============================================================================
#define SYSCTL_PERIPH_WDOG0     0x00000008  // Watchdog 0
#define SYSCTL_PERIPH_TIMER0    0x10100001  // Timer 0
#define SYSCTL_PERIPH_TIMER1    0x10100002  // Timer 1
#define SYSCTL_PERIPH_TIMER2    0x10100004  // Timer 2
#define SYSCTL_PERIPH_TIMER3    0x10100008  // Timer 3
#define SYSCTL_PERIPH_GPIOA     0x20000001  // GPIO A
#define SYSCTL_PERIPH_GPIOB     0x20000002  // GPIO B
#define SYSCTL_PERIPH_GPIOC     0x20000004  // GPIO C
#define SYSCTL_PERIPH_GPIOD     0x20000008  // GPIO D
#define SYSCTL_PERIPH_GPIOE     0x20000010  // GPIO E
#define SYSCTL_PERIPH_GPIOF     0x20000020  // GPIO F
#define SYSCTL_PERIPH_GPIOG     0x20000040  // GPIO G
#define SYSCTL_PERIPH_GPIOH     0x20000080  // GPIO H
#define SYSCTL_PERIPH_GPIOJ     0x20000100  // GPIO J
#define SYSCTL_PERIPH_ETH       0x20105000  // ETH


//=============================================================================
//
// The following values define the bit field for the ucPins argument to several
// of the APIs.
//
//=============================================================================
#define GPIO_PIN_0              0x00000001  // GPIO pin 0
#define GPIO_PIN_1              0x00000002  // GPIO pin 1
#define GPIO_PIN_2              0x00000004  // GPIO pin 2
#define GPIO_PIN_3              0x00000008  // GPIO pin 3
#define GPIO_PIN_4              0x00000010  // GPIO pin 4
#define GPIO_PIN_5              0x00000020  // GPIO pin 5
#define GPIO_PIN_6              0x00000040  // GPIO pin 6
#define GPIO_PIN_7              0x00000080  // GPIO pin 7

#endif /* __LM3S9XXX_ROM_H__ */
