/*!
 * \file     gen_entropy.h
 * \brief    This file contains the prototypes that the program needs to use the
 * "GenEntropy()" API.
 */
#if !defined( _GEN_ENTROPY_H )
# define _GEN_ENTROPY_H

    /*!
     * \par Description
     * This file contains the prototypes for the "GenEntropy()" &
     * "TestGenEntropy" functions.
     * Under normal operation the "GenEntropy()" function encrypts the plaintext
     * and generates the entropy required by the RAND functions.
     * Under TEST operation the entropy generated by the "GenEntropy()" function
     * is displayed and passed to the "RAND_seed()" function to test it's
     * suitability in RSA key generation. The "TestGenEntropy()" function is
     * then called and sets up the nonce and plaintext to the validated NIST
     * values and then encrypts the plaintext and generates the entropy required
     * by the RAND functions. The ciphertext is then decrypted and the results
     * displayed to ensure that the code works properly. The entropy is then
     * displayed and passed to the "RAND_seed()" function to test it's
     * suitability in RSA key generation. As the NIST nonce and plaintext never
     * change, the NIST entropy should always be the same and should always pass
     * the RSA key generation test.
     *
     * \param *ckey
     * The pointer to the array that contains the key value.
     *
     * \param *entropy
     * The pointer to the array set up to hold the generated entropy.
     *
     * \param NUM_BYTES_ENTROPY
     * The size of the "entropy" array - required by the "RAND_add()" and
     * "RAND_seed()" functions.
     *
     * \returns
     * N/A.
     */
# include <crypt.h>
# include <ctype.h>
# include <stdio.h>
# include <stdlib.h>
# include <string.h>

/*!
 * The number of bytes used by nonce for ascii format arrays.
 */
# define NONCE_BLOCK_SIZE 10

/*!
 * The number of bytes used by nonce for hexadecimal format arrays.
 */
# define NONCE_BLOCK_SIZE_2 20

/*!
 * The number of bytes used by the plaintext and the ciphertext for hexadecimal
 * format arrays. AES_BLOCK_SIZE is defined as 16 bytes in "aes.h".
 */
# define AES_BLOCK_SIZE_2 32

/*!
 * The size of the encryption key in bits.
 */
# define AES_KEY_SIZE 128

/*!
 * Used to make conversions to and from hexadecimal format clearer.
 */
# define HEX_BASE 16

/*!
 * The upper limit of an 8 bit number and therefore and the upper limit of each
 * counter array element.
 */
# define ASCII_LIMIT 255

/*!
 * This block of #defines sets up constants for the various numbers used in the
 * program for math operations, initialising loops and array elements. The only
 * numbers that are directly coded are 0 and 1 used in loop initialisations,
 * file reads and writes and simple expressions.
 */
# define ZERO       0
# define ONE        1
# define TWO        2
# define THREE      3
# define FOUR       4
# define FIVE       5
# define SIX        6
# define SEVEN      7
# define EIGHT      8
# define NINE       9
# define TEN        10
# define ELEVEN     11
# define TWELVE     12
# define THIRTEEN   13
# define FOURTEEN   14
# define FIFTEEN    15

void GenEntropy( const unsigned char *_ckey, unsigned char *_entropy,
                 unsigned int NUM_BYTES_ENTROPY );
/******************************************************************************/
# if TEST
#  define NEG_ONE    -1
#  define NEG_TWO    -2
#  define NEG_THREE  -3
#  define NEG_FOUR   -4
#  define NEG_FIVE   -5
#  define NEG_SIX    -6
#  define NEG_SEVEN  -7

void DisplayEntropy( unsigned char *_entropy, unsigned int NUM_BYTES_ENTROPY );

void GenEntropyTest( const unsigned char *_ckey, unsigned char *_entropy,
                     unsigned int NUM_BYTES_ENTROPY );

int RsaEntropyTest( unsigned char *_entropy, unsigned int NUM_BYTES_ENTROPY );
# endif /* TEST */

#endif /* _GEN_ENTROPY_H */
/******************************************************************************/

