/*!
 * \file    rsa_compat.h
 * \brief   Provides a wrapper layer to RSA encryption/decryption to ensure
 *          compatibility with the previous RSA encryption/decryption used
 *          by Honeywell.
 *
 * \par File contents
 * The decrypting side should create an RSA structure containing the
 * private/public key details as normal. RSA_compat_private_decrypt() may
 * then be used to decrypt incoming data.
 *
 * RSA_compat_extract_public_key() may be used to extract the public key in
 * the form of a buffer which may be passed to the encryptor.
 *
 * RSA_compat_public_encrypt() may then be used with the provided public key
 * in buffer form to encrypt data.
 */

#ifndef _RSA_COMPAT_H_
# define _RSA_COMPAT_H_

# include "rsa.h"

int RSA_compat_extract_public_key (RSA              * rsa,
                                   unsigned char    * keyBuffer,
                                   unsigned int     bufferLen );

int RSA_compat_private_decrypt (int                 dataLen,
                                const unsigned char * from,
                                unsigned char       * to,
                                RSA                 * rsa );

int RSA_compat_public_encrypt (int                  dataLen,
                               const unsigned char  * from,
                               unsigned char        * to,
                               const unsigned char  * key,
                               unsigned int         keyLen );

#endif /* _RSA_COMPAT_H_ */
