#! /bin/sh

echo 'dude, assuming you are running this script from the packages/net/ipsec/libipsec/<version>/docs/ directory'

MANPAGE_LIST=`find manpages -type f -name '*.?'`

echo "MANPAGE_LIST is $MANPAGE_LIST"

echo 'removing the previous file libipsec-manpages.sgml'
/bin/rm -f libipsec-manpages.sgml
touch libipsec-manpages.sgml
echo '<!-- HEY YOU!!!!!!!!! -->' >> libipsec-manpages.sgml
echo '<!-- this file is automatically generated by the script -->' >> libipsec-manpages.sgml
echo '<!-- ' "     $0    " ' -->' >> libipsec-manpages.sgml
echo '<!-- so PLEASE do not modify it: your changes will be lost -->' >> libipsec-manpages.sgml
echo >> libipsec-manpages.sgml
echo >> libipsec-manpages.sgml

echo "<chapter id=\"libipsec-library-reference\">" >> libipsec-manpages.sgml
echo "  <title>libipsec Reference</title>" >> libipsec-manpages.sgml

echo >> libipsec-manpages.sgml
echo >> libipsec-manpages.sgml

for manpage in $MANPAGE_LIST
do
    echo "processing $manpage"
    # get the title for this section
    manpage_title=`egrep '^\.Dt' $manpage | awk '{print $2}' | tr 'A-Z' 'a-z'`
    # note that _ is illegal in an id, so we canonicalize it to -
    docbook_section_id=`echo $manpage_title | sed 's/_/-/g'`
    # now prepare out a section and title
    echo "  <sect1 id=\"net-ipsec-libipsec-man-$docbook_section_id\">" >> libipsec-manpages.sgml
    echo "    <title>$manpage_title</title>" >> libipsec-manpages.sgml
    # we make it <screen> so that it is a monospaced font
    echo "    <screen>" >> libipsec-manpages.sgml

    # now put the contents into this section
    cat $manpage | groff -Tascii -mandoc | sed 's/\_\(.\)/\1/g' \
      | sed 's/\(.\)\(.\)/\1/g' \
      | sed 's/\&/\&amp;/g' \
      | sed 's/</\&lt;/g' \
      | sed 's/+o/o/g' >> libipsec-manpages.sgml

    # now close out the section
    echo "    </screen>" >> libipsec-manpages.sgml
    echo "  </sect1>" >> libipsec-manpages.sgml
    echo >> libipsec-manpages.sgml
done

echo >> libipsec-manpages.sgml
echo "</chapter>" >> libipsec-manpages.sgml

cat <<EOF >> libipsec-manpages.sgml

<!-- Keep this comment at the end of the file
Local variables:
mode: sgml
sgml-omittag:nil
sgml-shorttag:t
sgml-namecase-general:t
sgml-general-insert-case:lower
sgml-minimize-attributes:nil
sgml-always-quote-attributes:t
sgml-indent-step:2
sgml-indent-data:t
sgml-parent-document:("ipsec.sgml" "book" "chapter")
sgml-exposed-tags:nil
sgml-local-catalogs:nil
sgml-local-ecat-files:nil
sgml-doctype:"book"
End:
-->

EOF
