//==========================================================================
//
//  coldfire.ld
//
//  Linker script
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2006 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):     Enrico Piria
// Contributors:  Wade Jensen
// Date:          2005-25-06
// Purpose:       Coldfire-specific linker script definitions.
//
//####DESCRIPTIONEND####
//========================================================================

STARTUP(vectors.o)
ENTRY(_start)
#ifdef EXTRAS
INPUT(extras.o)
#endif
#if (__GNUC__ >= 3)
GROUP(libtarget.a libgcc.a libsupc++.a)
#else
GROUP(libtarget.a libgcc.a)
#endif

#define ALIGN_LMA 4
#define FOLLOWING(_section_) AT ((LOADADDR (_section_) + SIZEOF (_section_) + ALIGN_LMA - 1) & ~ (ALIGN_LMA - 1))
#define LMA_EQ_VMA
#define FORCE_OUTPUT . = .

#define SECTIONS_BEGIN

#define SECTION_boot(_region_, _vma_, _lma_)                            \
    .boot _vma_ : _lma_                                                 \
    {                                                                   \
        FORCE_OUTPUT;                                                   \
        *(.boot*)                                                       \
        . = ALIGN(4);                                                   \
    }                                                                   \
    > _region_

#define SECTION_text(_region_, _vma_, _lma_)                            \
    .text _vma_ : _lma_                                                 \
    {                                                                   \
        _stext = .;                                                     \
        *(.text*) *(.gnu.warning) *(.gnu.linkonce*) *(.init)            \
        . = ALIGN(4);                                                   \
    }                                                                   \
    > _region_                                                          \
    _etext = .;  PROVIDE (etext = .);

#define SECTION_fini(_region_, _vma_, _lma_)                            \
    .fini _vma_ : _lma_                                                 \
    {                                                                   \
        FORCE_OUTPUT;                                                   \
        *(.fini)                                                        \
        . = ALIGN(4);                                                   \
    }                                                                   \
    > _region_

#define SECTION_rodata1(_region_, _vma_, _lma_)                         \
    .rodata1 _vma_ : _lma_                                              \
    {                                                                   \
        FORCE_OUTPUT;                                                   \
        *(.rodata1*)                                                    \
        . = ALIGN(4);                                                   \
    }                                                                   \
    > _region_

#define SECTION_rodata(_region_, _vma_, _lma_)                          \
    .rodata _vma_ : _lma_                                               \
    {                                                                   \
        FORCE_OUTPUT;                                                   \
        *(.rodata*)                                                     \
        . = ALIGN(4);                                                   \
    }                                                                   \
    > _region_

#define SECTION_fixup(_region_, _vma_, _lma_)                           \
    .fixup _vma_ : _lma_                                                \
    {                                                                   \
        __FIXUP_START__ = ABSOLUTE(.);                                  \
        *(.fixup)                                                       \
        . = ALIGN(4);                                                   \
        __FIXUP_END__ = ABSOLUTE(.);                                    \
    }                                                                   \
    > _region_

#define SECTION_gcc_except_table(_region_, _vma_, _lma_)                \
    .gcc_except_table _vma_ : _lma_                                     \
    {                                                                   \
        __EXCEPT_START__ = ABSOLUTE(.);                                 \
        *(.gcc_except_table)                                            \
        . = ALIGN(4);                                                   \
        __EXCEPT_END__ = ABSOLUTE(.);                                   \
    }                                                                   \
    > _region_

#define SECTION_data(_region_, _vma_, _lma_)                                        \
    .data _vma_ : _lma_                                                             \
    {                                                                               \
        __ram_data_start = ABSOLUTE(.);                                             \
        *(.data*)                                                                   \
        __GOT1_START__ = ABSOLUTE(.);                                               \
        *(.got1)                                                                    \
        __GOT1_END__ = ABSOLUTE(.);                                                 \
        . = ALIGN (4);                                                              \
          /* Put .ctors and .dtors next to the .got2 section, so that */            \
          /* the pointers get relocated with -mrelocatable.           */            \
        __CTOR_LIST__ = ABSOLUTE(.);                                                \
        KEEP(*(SORT(.ctors*)));                                                     \
        __CTOR_END__ = ABSOLUTE(.);                                                 \
        __DTOR_LIST__ = ABSOLUTE(.);                                                \
        KEEP(*(SORT(.dtors*)))                                                      \
        __DTOR_END__ = ABSOLUTE(.);                                                 \
        . = ALIGN(4);                                                               \
        KEEP(*( SORT (.ecos.table.*)));                                             \
        . = ALIGN (4);                                                              \
          *( .2ram.*) ;                                                             \
        __GOT2_START__ = ABSOLUTE(.);                                               \
        *(.got2)                                                                    \
        __GOT2_END__ = ABSOLUTE(.);                                                 \
        __GOT_START = ABSOLUTE(.);                                                  \
        _GLOBAL_OFFSET_TABLE_ = ABSOLUTE(. + 32768);                                \
        _SDA_BASE_ = ABSOLUTE(.);                                                   \
        *(.got.plt) *(.got)                                                         \
        __GOT_END__ = ABSOLUTE(.);                                                  \
        *(.dynamic)                                                                 \
        *(.eh_frame)                                                                \
          /* We want the small data sections together, so single-instruction */     \
          /* offsets can access them all, and initialized data all before    */     \
          /* uninitialized, so we can shorten the on-disk segment size.      */     \
        __SDATA_START__ = ABSOLUTE(.);                                              \
        *(.sdata) *(.sdata.*)                                                       \
        __SDATA2_START__ = ABSOLUTE(.);                                             \
        *(.sdata2*)                                                                 \
        . = ALIGN(4);                                                               \
        __ram_data_end = ABSOLUTE(.);                                               \
        __ram_data_size = ABSOLUTE (.) - ABSOLUTE(__ram_data_start);                \
    }                                                                               \
    > _region_                                                                      \
    __rom_data_start = LOADADDR(.data);                                             \
    __rom_data_size = SIZEOF(.data);                                                \
    __rom_data_end = __rom_data_start + __rom_data_size;

#define SECTION_bss(_region_, _vma_, _lma_)                                     \
    .bss _vma_ : _lma_                                                          \
    {                                                                           \
        __bss_start = ABSOLUTE (.);                                             \
        FORCE_OUTPUT;                                                           \
        *(.dynbss*) *(.bss*) *(COMMON) *(.sbss*) *(.scommon*)                   \
        . = ALIGN(4);                                                           \
        __bss_end = ABSOLUTE (.);                                               \
        __bss_size = ABSOLUTE (.) - ABSOLUTE(__bss_start);                      \
    }                                                                           \
    > _region_

#define SECTION_stab    \
    .stab 0 (NOLOAD) :  \
    {                   \
        *(.stab)        \
    }

#define SECTION_stabstr     \
    .stabstr 0 (NOLOAD) :   \
    {                       \
        *(.stabstr)         \
    }

#define SECTION_comment     \
    .comment 0 (NOLOAD) :   \
    {                       \
        *(.comment)         \
    }

#define SECTION_uninvar(_region_, _vma_, _lma_)                                 \
    .uninvar _vma_ : _lma_                                                      \
    {                                                                           \
        __uninvar_start = ABSOLUTE (.);                                         \
        FORCE_OUTPUT;                                                           \
        *(.uninvar);                                                            \
        . = ALIGN(4);                                                           \
        __uninvar_end = ABSOLUTE (.);                                           \
        __uninvar_size = ABSOLUTE (.) - ABSOLUTE(__uninvar_start);              \
    }                                                                           \
    > _region_

#define SECTION_romvec(_region_, _vma_, _lma_)                                  \
    .romvec _vma_ : _lma_                                                       \
    {                                                                           \
        __romvec_start = ABSOLUTE (.);                                          \
        FORCE_OUTPUT;                                                           \
        KEEP(*(.romvec));                                                       \
        . = ALIGN(4);                                                           \
        __romvec_end = ABSOLUTE (.);                                            \
        __romvec_size = ABSOLUTE (.) - ABSOLUTE(__romvec_start);                \
    }                                                                           \
    > _region_

#define SECTION_ramvec(_region_, _vma_, _lma_)                                  \
    .ramvec _vma_ : _lma_                                                       \
    {                                                                           \
        __ramvec_start = ABSOLUTE (.);                                          \
        FORCE_OUTPUT;                                                           \
        KEEP(*(.ramvec));                                                       \
        . = ALIGN(4);                                                           \
        __ramvec_end = ABSOLUTE (.);                                            \
        __ramvec_size = ABSOLUTE (.) - ABSOLUTE(__ramvec_start);                \
    }                                                                           \
    > _region_
    
#define SECTION_virtual_vec_table(_region_, _vma_, _lma_)                                   \
    .virtual_vec_table _vma_ : _lma_                                                        \
    {                                                                                       \
        __virtual_vec_table_start = ABSOLUTE (.);                                           \
        . += 0x100;                                                                         \
        __virtual_vec_table_end = ABSOLUTE (.);                                             \
        __virtual_vec_table_size = ABSOLUTE (.) - ABSOLUTE(__virtual_vec_table_start);      \
    }                                                                                       \
    > _region_

#define SECTIONS_END                                \
    SECTION_stab                                    \
    SECTION_stabstr                                 \
    SECTION_comment                                 \
    . = ALIGN(0x4); _end = .; PROVIDE (end = .);

#include <pkgconf/system.h>
#include CYGHWR_MEMORY_LAYOUT_LDI

hal_virtual_vector_table = __virtual_vec_table_start;
