#!/bin/bash

echo "Build Script for arm-elf-gcc-3.4.3 ToolChain Script **Version: 1.1**"

# Set to use gcc 3.4.4, will fail if 3.4.4 installed
echo "Setup Cygwin to use GCC 3.x.x"
set-gcc-default-3.sh

# Get the directory the script is running from
RUNNING_FROM_DIRECTORY=$(cd `dirname $0` && pwd) 
echo $RUNNING_FROM_DIRECTORY

# Create the directories for the achives. 
echo "Creating directory for downloaded archives"
mkdir archives
cd archives

# Check if the archives are present if not download them

# NewLib is not part of final libraries but needed for build process
echo "Downloading newlib 1.30.0 Soures..."
if test -f newlib-1.13.0.tar.gz; then echo exists; else wget "ftp://sources.redhat.com/pub/newlib/newlib-1.13.0.tar.gz"; fi

echo "Downloading gcc 3.4.3 Sources..."
if test -f gcc-3.4.3.tar.bz2; then echo exists; else wget wget "ftp.gnu.org/gnu/gcc/gcc-3.4.3/gcc-3.4.3.tar.bz2"; fi

echo "Downloading binutils 2.15 Soures..."
if test -f binutils-2.15.tar.bz2; then echo exists; else wget wget "ftp.gnu.org/gnu/binutils/binutils-2.15.tar.bz2"; fi

# Create directory for extracted files and start the extraction
echo "Extracting Source Files.."
cd $RUNNING_FROM_DIRECTORY
mkdir src
cd src

# NewLib is not part of final libraries but needed for build process
tar -zxvf ../archives/newlib-1.13.0.tar.gz    
tar -xjvf ../archives/binutils-2.15.tar.bz2
tar -xjvf ../archives/gcc-3.4.3.tar.bz2
tar -zxvf ../archives/eCos_Headers.tar.gz

# Create directory for extracted files and start the extraction
echo "Extracting Patch files.."
cd $RUNNING_FROM_DIRECTORY
mkdir gcc_build_patches
cd gcc_build_patches
tar -zxvf ../archives/gcc_build_patches.tar.gz

echo "Finished Download and Extraction of files"

# Create the directories for the build files
echo "Creating build directories"
cd $RUNNING_FROM_DIRECTORY
mkdir builds
cd builds
mkdir binutils-2.15
mkdir gcc-3.4.3

echo "Start building of binutils"

# START build of binutils
cd $RUNNING_FROM_DIRECTORY/builds/binutils-2.15
$RUNNING_FROM_DIRECTORY/src/binutils-2.15/configure --host=i686-pc-cygwin --target=arm-elf --prefix=$RUNNING_FROM_DIRECTORY/builds/binutils-2.15/INSTALL/bin
make
make install
echo "End building of binutils"

echo "Adding binutilts to front of path"
echo "  "
echo "Old Path"
echo $PATH
PATH=$RUNNING_FROM_DIRECTORY/builds/binutils-2.15/INSTALL/bin/bin:$PATH 
echo "  "
echo "New Path"
echo $PATH

echo "Copy newlib to GCC source folder"
cp -r $RUNNING_FROM_DIRECTORY/src/newlib-1.13.0/newlib $RUNNING_FROM_DIRECTORY/src/gcc-3.4.3/newlib
cp -r $RUNNING_FROM_DIRECTORY/src/newlib-1.13.0/libgloss $RUNNING_FROM_DIRECTORY/src/gcc-3.4.3/libgloss
# END build of binutils 
 
# START build of gcc-3.4.3 
echo "Configure and make GCC 3.4.3"
cd $RUNNING_FROM_DIRECTORY/builds/gcc-3.4.3
$RUNNING_FROM_DIRECTORY/src/gcc-3.4.3/configure --host=i686-pc-cygwin --target=arm-elf --prefix=$RUNNING_FROM_DIRECTORY/builds/gcc-3.4.3/INSTALL/bin --enable-languages=c,c++ --with-gnu-as --with-gnu-ld --with-newlib --enable-threads=posix --without-headers --enable-libstdcxx-allocator=malloc --enable-cstdio=stdio --disable-shared 
make 

echo "make will have failed"
echo "Adding arm-elf binutilts to front of path"
echo "  "
echo "Old Path"
echo $PATH
PATH=$RUNNING_FROM_DIRECTORY/builds/binutils-2.15/INSTALL/bin/arm-elf/bin:$PATH 
echo "  "
echo "New Path"
echo $PATH

# eCos headers are used instead of newlib as using posix.
echo "Copy eCos headers to GCC build directory"
cd $RUNNING_FROM_DIRECTORY/builds/gcc-3.4.3
cp -r $RUNNING_FROM_DIRECTORY/src/eCos_Headers/arm-elf $RUNNING_FROM_DIRECTORY/builds/gcc-3.4.3/
cd $RUNNING_FROM_DIRECTORY/builds/gcc-3.4.3/arm-elf/newlib
mkdir -p stmp-targ-include
cd $RUNNING_FROM_DIRECTORY/builds/gcc-3.4.3/arm-elf/thumb/newlib
mkdir -p stmp-targ-include

echo "Start the build again"
cd $RUNNING_FROM_DIRECTORY/builds/gcc-3.4.3
make

echo "make will have failed here so need to patch some files and run again"

echo "Patch config.h in libstdcc++-v3"
cd $RUNNING_FROM_DIRECTORY/builds/gcc-3.4.3/arm-elf/libstdc++-v3
cp -r $RUNNING_FROM_DIRECTORY/gcc_build_patches/libstdc_config.patch $RUNNING_FROM_DIRECTORY/builds/gcc-3.4.3/arm-elf/libstdc++-v3/libstdc_config.patch
patch < libstdc_config.patch 

echo "Patch config.h in libstdcc++-v3"
cd $RUNNING_FROM_DIRECTORY/builds/gcc-3.4.3/arm-elf/thumb/libstdc++-v3
cp -r $RUNNING_FROM_DIRECTORY/gcc_build_patches/libstdc_thumb_config.patch $RUNNING_FROM_DIRECTORY/builds/gcc-3.4.3/arm-elf/thumb/libstdc++-v3/libstdc_thumb_config.patch
patch < libstdc_thumb_config.patch

echo "Patch testsuite.cc"
cd $RUNNING_FROM_DIRECTORY/src/gcc-3.4.3/libstdc++-v3/testsuite
cp -r $RUNNING_FROM_DIRECTORY/gcc_build_patches/testsuite_hooks.patch $RUNNING_FROM_DIRECTORY/src/gcc-3.4.3/libstdc++-v3/testsuite/testsuite_hooks.patch
patch < testsuite_hooks.patch 

echo "Recopy eCos headers to GCC source"
cd $RUNNING_FROM_DIRECTORY/builds/gcc-3.4.3
cp -r $RUNNING_FROM_DIRECTORY/src/eCos_Headers/arm-elf $RUNNING_FROM_DIRECTORY/builds/gcc-3.4.3/

echo "Start the build again"
cd $RUNNING_FROM_DIRECTORY/builds/gcc-3.4.3
make
make install
# END build of gcc-3.4.3 

echo "Copy tools to install folder"
cd $RUNNING_FROM_DIRECTORY
mkdir install
cp -r $RUNNING_FROM_DIRECTORY/builds/binutils-2.15/INSTALL/bin $RUNNING_FROM_DIRECTORY/install
cp -r $RUNNING_FROM_DIRECTORY/builds/gcc-3.4.3/INSTALL/bin $RUNNING_FROM_DIRECTORY/install

echo "Script Finshed!!"


