#ifndef CYGONCE_DEVS_ETH_OMAP_PHY_H
#define CYGONCE_DEVS_ETH_OMAP_PHY_H
//==========================================================================
//
//      omap_phy.h
//
//      Access to PHY access for use by OMAP ethernet driver
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2008 Free Software Foundation, Inc.                        
// Copyright (C) 2008, 2010 eCosCentric Limited                                   
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    nickg
// Contributors: 
// Date:         2010-02-02
// Purpose:
// Description:  PHY access for use by OMAP ethernet driver
//
//####DESCRIPTIONEND####
//
//========================================================================*/

#include <pkgconf/system.h>
#include <pkgconf/hal.h> // clock speed definitions
#include <pkgconf/devs_eth_arm_omap.h>
#if defined(CYGPKG_REDBOOT)
# include <pkgconf/redboot.h>
#endif

#include <cyg/infra/cyg_type.h>
#include <cyg/infra/cyg_ass.h>
#include <cyg/infra/diag.h>
#include <cyg/hal/hal_io.h>
#include <cyg/hal/hal_diag.h> // HAL_DELAY_US
#include <cyg/io/eth_phy.h>

//======================================================================
// PHY access
// 

// ---------------------------------------------------------------------
// Write one of the PHY registers via the MDIO bus

static void
omap_write_phy(int reg_addr, int phy_addr, unsigned short data)
{
    cyg_uint32 mdio = CYGHWR_HAL_L1XX_EMAC_MDIO;
    cyg_uint32 ua0;

    phy_debug_printf("phy %d reg %d data %04x\n", phy_addr, reg_addr, data );

    ua0 = CYGHWR_HAL_L1XX_EMAC_MDIO_USERACCESS_PHY( phy_addr )
        | CYGHWR_HAL_L1XX_EMAC_MDIO_USERACCESS_REG( reg_addr )
        | CYGHWR_HAL_L1XX_EMAC_MDIO_USERACCESS_DATA( data )
        | CYGHWR_HAL_L1XX_EMAC_MDIO_USERACCESS_WRITE
        | CYGHWR_HAL_L1XX_EMAC_MDIO_USERACCESS_GO;

    HAL_WRITE_UINT32( mdio+CYGHWR_HAL_L1XX_EMAC_MDIO_USERACCESS0, ua0 );
    
    do {
        HAL_READ_UINT32( mdio+CYGHWR_HAL_L1XX_EMAC_MDIO_USERACCESS0, ua0 );
    } while( 0 != (ua0 & CYGHWR_HAL_L1XX_EMAC_MDIO_USERACCESS_GO) );
}

// ---------------------------------------------------------------------
// Read one of the PHY registers via the MDIO bus

static bool
omap_read_phy(int reg_addr, int phy_addr, unsigned short *data)
{
    cyg_uint32 mdio = CYGHWR_HAL_L1XX_EMAC_MDIO;
    cyg_uint32 ua0;

    phy_debug_printf("phy %d reg %d\n", phy_addr, reg_addr );
    
    ua0 = CYGHWR_HAL_L1XX_EMAC_MDIO_USERACCESS_PHY( phy_addr )
        | CYGHWR_HAL_L1XX_EMAC_MDIO_USERACCESS_REG( reg_addr )
        | CYGHWR_HAL_L1XX_EMAC_MDIO_USERACCESS_GO;

    HAL_WRITE_UINT32( mdio+CYGHWR_HAL_L1XX_EMAC_MDIO_USERACCESS0, ua0 );
    
    do {
        HAL_READ_UINT32( mdio+CYGHWR_HAL_L1XX_EMAC_MDIO_USERACCESS0, ua0 );
    } while( 0 != (ua0 & CYGHWR_HAL_L1XX_EMAC_MDIO_USERACCESS_GO) );

    phy_debug_printf("ua0 %08x\n", ua0 );
    
    *data = ua0 & 0xFFFF;
    
    return (true);
}

// ---------------------------------------------------------------------
// 

static void 
omap_init_phy(void)
{
    cyg_uint32 mdio = CYGHWR_HAL_L1XX_EMAC_MDIO;
    cyg_uint32 ctl, alive;
    int i;
    
    phy_debug_printf("mdio @%08x\n", mdio );
    
    // Init the MDIO module

    HAL_WRITE_UINT32( mdio+CYGHWR_HAL_L1XX_EMAC_MDIO_CONTROL,
                      CYGHWR_HAL_L1XX_EMAC_MDIO_CONTROL_ENABLE   |
                      CYGHWR_HAL_L1XX_EMAC_MDIO_CONTROL_FAULT    |
                      CYGHWR_HAL_L1XX_EMAC_MDIO_CONTROL_FAULTENB |
                      CYGHWR_HAL_L1XX_EMAC_MDIO_CONTROL_CLKDIV( (CYGHWR_HAL_ARM_ARM9_OMAP_L1XX_CLOCK_PLL_SYSCLK4/2000000) - 1 ) );

#if 0
    // This seems unnecessary, and can actually hang up.
    do {
        HAL_READ_UINT32( mdio+CYGHWR_HAL_L1XX_EMAC_MDIO_CONTROL, ctl );
    } while( (ctl & CYGHWR_HAL_L1XX_EMAC_MDIO_CONTROL_IDLE) == 0);
#endif

    // Wait for MDIO module to poll all the PHYs
    for( i = 0; i < 32; i++ )
    {
        HAL_READ_UINT32( mdio+CYGHWR_HAL_L1XX_EMAC_MDIO_ALIVE, alive );
        if( alive )
            break;
        OMAP_ETH_DELAY_US( 50 );
    }

    phy_debug_printf("alive: %08x\n", alive );
}

// ---------------------------------------------------------------------
// Instantiate the device

ETH_PHY_REG_LEVEL_ACCESS_FUNS(omap_phy, 
                              omap_init_phy,
                              NULL,
                              omap_write_phy,
                              omap_read_phy);

#endif // ifdef CYGONCE_DEVS_ETH_OMAP_PHY_H
//======================================================================
// EOF omap_phy.h
