#ifndef CYGONCE_DEVS_FLASH_SPANSION_S29GLN_V2_V2_H
# define CYGONCE_DEVS_FLASH_SPANSION_S29GLN_V2_V2_H
//==========================================================================
//
//      S29GL_N_dev.h
//
//      Flash driver for the Spansion family - driver details
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2004, 2005 Free Software Foundation, Inc.                  
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    DHogg
// Contributors:
// Date:         2010-06-15
//              
//####DESCRIPTIONEND####
//
//==========================================================================

#include <pkgconf/devs_flash_SPANSION_S29GLN_V2.h>
#include <cyg/infra/cyg_type.h>
#include <cyg/io/flash.h>
#include <cyg/io/flash_dev.h>

externC int cyg_s29gl_n_read_devid_8(     struct cyg_flash_dev*);
externC int cyg_s29gl_n_read_devid_16(    struct cyg_flash_dev*);
externC int cyg_s29gl_n_read_devid_32(    struct cyg_flash_dev*);
externC int cyg_s29gl_n_read_devid_88(    struct cyg_flash_dev*);
externC int cyg_s29gl_n_read_devid_8888(  struct cyg_flash_dev*);
externC int cyg_s29gl_n_read_devid_1616(  struct cyg_flash_dev*);
externC int cyg_s29gl_n_read_devid_16as8( struct cyg_flash_dev*);

externC int cyg_s29gl_n_init_check_devid_8(     struct cyg_flash_dev*);
externC int cyg_s29gl_n_init_check_devid_16(    struct cyg_flash_dev*);
externC int cyg_s29gl_n_init_check_devid_32(    struct cyg_flash_dev*);
externC int cyg_s29gl_n_init_check_devid_88(    struct cyg_flash_dev*);
externC int cyg_s29gl_n_init_check_devid_8888(  struct cyg_flash_dev*);
externC int cyg_s29gl_n_init_check_devid_1616(  struct cyg_flash_dev*);
externC int cyg_s29gl_n_init_check_devid_16as8( struct cyg_flash_dev*);

externC int cyg_s29gl_n_init_cfi_8(     struct cyg_flash_dev*);
externC int cyg_s29gl_n_init_cfi_16(    struct cyg_flash_dev*);
externC int cyg_s29gl_n_init_cfi_32(    struct cyg_flash_dev*);
externC int cyg_s29gl_n_init_cfi_88(    struct cyg_flash_dev*);
externC int cyg_s29gl_n_init_cfi_8888(  struct cyg_flash_dev*);
externC int cyg_s29gl_n_init_cfi_1616(  struct cyg_flash_dev*);
externC int cyg_s29gl_n_init_cfi_16as8( struct cyg_flash_dev*);

externC int cyg_s29gl_n_erase_8(     struct cyg_flash_dev*, cyg_flashaddr_t);
externC int cyg_s29gl_n_erase_16(    struct cyg_flash_dev*, cyg_flashaddr_t);
externC int cyg_s29gl_n_erase_32(    struct cyg_flash_dev*, cyg_flashaddr_t);
externC int cyg_s29gl_n_erase_88(    struct cyg_flash_dev*, cyg_flashaddr_t);
externC int cyg_s29gl_n_erase_8888(  struct cyg_flash_dev*, cyg_flashaddr_t);
externC int cyg_s29gl_n_erase_1616(  struct cyg_flash_dev*, cyg_flashaddr_t);
externC int cyg_s29gl_n_erase_16as8( struct cyg_flash_dev*, cyg_flashaddr_t);

externC int cyg_s29gl_n_program_8(     struct cyg_flash_dev*, cyg_flashaddr_t, const void*, size_t);
externC int cyg_s29gl_n_program_16(    struct cyg_flash_dev*, cyg_flashaddr_t, const void*, size_t);
externC int cyg_s29gl_n_program_32(    struct cyg_flash_dev*, cyg_flashaddr_t, const void*, size_t);
externC int cyg_s29gl_n_program_88(    struct cyg_flash_dev*, cyg_flashaddr_t, const void*, size_t);
externC int cyg_s29gl_n_program_8888(  struct cyg_flash_dev*, cyg_flashaddr_t, const void*, size_t);
externC int cyg_s29gl_n_program_1616(  struct cyg_flash_dev*, cyg_flashaddr_t, const void*, size_t);
externC int cyg_s29gl_n_program_16as8( struct cyg_flash_dev*, cyg_flashaddr_t, const void*, size_t);

// FIXME: add program_buffered() support as per e.g. the AM29LV128
// FIXME: add software lock/unlock support as per e.g. the AM29BDS640

// The driver-specific data, pointed at by the priv field in a
// a cyg_flash_dev structure.
typedef struct cyg_s29gl_n_dev {
    // The device id, mainly for use by the init_check_devid() routines
    cyg_uint32              devid;
    // Space for the block_info fields needed for the cyg_flash_dev.
    // These can be statically initialized, or dynamically via
    // init_cfi().
    cyg_flash_block_info_t  block_info[CYGNUM_DEVS_FLASH_SPANSION_S29GLN_V2_ERASE_REGIONS];
} cyg_s29gl_n_dev;

// TODO: An AM29 specific macro could optimise the common case of CYG_FLASH_FUNS.
// Bart and Jifl discussed this in mid July/start Aug 2005.

#endif  // CYGONCE_DEVS_FLASH_AM29xxxxx_dev_V2_H
