#ifndef CYGONCE_ARM_STR7XX_SERIAL_H
#define CYGONCE_ARM_STR7XX_SERIAL_H

// ====================================================================
//
//      str7xx_serial.h
//
//      Device I/O - Description of ST STR7XX serial hardware
//
// ====================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2004, 2005, 2006 Free Software Foundation, Inc.
// Copyright (C) 2004, 2005, 2006 eCosCentric Limited                       
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
// ====================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    nickg
// Contributors: gthomas
// Date:         2006-03-24
// Purpose:      Internal interfaces for serial I/O drivers
// Description:
//
//####DESCRIPTIONEND####
//
// ====================================================================

#include <cyg/hal/hal_io.h>  // Register definitions

// Translate system word length selector into local values. See code
// for how this is used.
static cyg_uint32 select_word_length[] = {
    5<<4,
    6<<4,
    7<<4,
    8<<4
};

// Translate system stop bit selector into control register bits.
static cyg_uint32 select_stop_bits[] = {
    0,
    CYGARC_HAL_STR7XX_UART_CR_STOP_1_0, // 1 stop bit
    CYGARC_HAL_STR7XX_UART_CR_STOP_1_5, // 1.5 stop bit
    CYGARC_HAL_STR7XX_UART_CR_STOP_2_0  // 2 stop bit
};

// Translate system parity selector into local values. See code for
// how this is used.
static cyg_uint32 select_parity[] = {
    0,  // No parity
    2,  // Even parity
    1,   // Odd parity
    4,  // Mark (1) parity -- not supported
    8  // Space (0) parity -- not supported
};

// Translate system baud selector into direct baud rate value. This is
// then used to calculate the clock divisor from the PCLK1 clock.
static cyg_int32 select_baud[] = {
    0,      // Unused
    50,     // 50
    75,     // 75
    110,    // 110
    0,      // 134.5
    150,    // 150
    200,    // 200
    300,    // 300
    600,    // 600
    1200,   // 1200
    1800,   // 1800
    2400,   // 2400
    3600,   // 3600
    4800,   // 4800
    7200,   // 7200
    9600,   // 9600
    14400,  // 14400
    19200,  // 19200
    38400,  // 38400
    57600,  // 57600
    115200, // 115200
    230400, // 230400
};


#endif // CYGONCE_ARM_STR7XX_SERIAL_H
