#ifndef CYGONCE_DEVS_SPI_ARM_AT91RM9200_EK_H
#define CYGONCE_DEVS_SPI_ARM_AT91RM9200_EK_H
//==========================================================================
//
//      spi_at91rm9200_ek.h
//
//      Atmel AT91RM9200-EK SPI devices defines
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2005, 2006 Free Software Foundation, Inc.
// Copyright (C) 2005, 2006 eCosCentric Limited                             
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):     nickg@ecoscentric.com
// Date:          2005-08-17
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <pkgconf/hal_arm_arm9_atmel_at91rm9200_kits.h>
#include <cyg/io/spi.h>
#include <cyg/io/spi_at91.h>
#include <cyg/hal/hal_io.h>

//-----------------------------------------------------------------------------
// AT91AT91RM9200_EK SPI exported devices 

#define HAL_SPI_EXPORTED_DEVICES \
    externC cyg_spi_device *cyg_spi_dataflash_dev0;

//-----------------------------------------------------------------------------

// Card detect GPIO pin for SD/MMC/DF socket for NPCS3 is PB27
// Card detect GPIO pin for DF socket for NPCS0 is PB10
#define CYGHWR_SPI_DETECT_DATAFLASH( __dataflash_dev, __detected )      \
    CYG_MACRO_START                                                     \
    cyg_spi_at91_device_t *__at91_spi_dev =                             \
        (cyg_spi_at91_device_t *) __dataflash_dev->spi_dev;             \
    cyg_uint32 __piob;                                                  \
                                                                        \
    HAL_READ_UINT32(AT91RM9200_PIOB+_PIO_PDSR, __piob);                 \
    if (__at91_spi_dev->dev_num == 3)                                   \
    {                                                                   \
        *__detected = !(__piob & (1<<27));                              \
    }                                                                   \
    else if (__at91_spi_dev->dev_num == 0)                              \
    {                                                                   \
        *__detected = !(__piob & (1<<10));                              \
    }                                                                   \
    CYG_MACRO_END

//-----------------------------------------------------------------------------

#if defined(CYGHWR_HAL_ARM_ARM9_ATMEL_AT91RM9200_KITS_BOARD_VARIANT_AT91RM9200_EK)
#define AT91_SPI_MMC_TYPE (1<<22)
#elif defined(CYGHWR_HAL_ARM_ARM9_ATMEL_AT91RM9200_KITS_BOARD_VARIANT_AT91RM9200_DK)
#define AT91_SPI_MMC_TYPE (1<<7)
#else
#error Unknown Atmel AT91RM9200 kit variant
#endif

//-----------------------------------------------------------------------------


// NOTE: here we let the SPI controller control
//       the data in, out and clock signals, but
//       we need to handle the chip selects manually
//       in order to achieve better chip select control
//       inbetween transactions.

#define CYGHWR_AT91_SPI_CONFIGURE_PINS( __base )                        \
{                                                                       \
    /* Put SPI MISO, MOIS and SPCK pins into peripheral mode */         \
    HAL_WRITE_UINT32(AT91_SPI_PIO+_PIO_PDR, AT91_PIO_PSR_SPCK |         \
                                            AT91_PIO_PSR_MISO |         \
                                            AT91_PIO_PSR_MOSI |         \
                                            AT91_SPI_PIO_NPCS(0x01));   \
    HAL_WRITE_UINT32(AT91_SPI_PIO+_PIO_ASR, AT91_PIO_PSR_SPCK |         \
                                            AT91_PIO_PSR_MISO |         \
                                            AT91_PIO_PSR_MOSI |         \
                                            AT91_SPI_PIO_NPCS(0x01));   \
                                                                        \
    /* Put SPI chip select pins in IO output mode */                    \
    HAL_WRITE_UINT32(AT91_SPI_PIO+_PIO_SODR, AT91_SPI_PIO_NPCS(0x0e));  \
    HAL_WRITE_UINT32(AT91_SPI_PIO+_PIO_PER,  AT91_SPI_PIO_NPCS(0x0e));  \
    HAL_WRITE_UINT32(AT91_SPI_PIO+_PIO_OER,  AT91_SPI_PIO_NPCS(0x0e));  \
                                                                        \
    HAL_WRITE_UINT32(AT91_SPI_PIO+_PIO_ODR,  AT91_SPI_PIO_NPCS(0x01));  \
    HAL_WRITE_UINT32(AT91_SPI_PIO+_PIO_CODR, AT91_SPI_PIO_NPCS(0x01));  \
                                                                        \
    /* Put MMC card socket into DataFlash mode */                       \
    HAL_WRITE_UINT32( AT91RM9200_PIOB+_PIO_PER, AT91_SPI_MMC_TYPE );    \
    HAL_WRITE_UINT32( AT91RM9200_PIOB+_PIO_OER, AT91_SPI_MMC_TYPE );    \
    HAL_WRITE_UINT32( AT91RM9200_PIOB+_PIO_CODR, AT91_SPI_MMC_TYPE );   \
}

#define CYGHWR_AT91_SPI_CLOCK_SPEED CYGARC_HAL_ARM_ARM9_AT91RM9200_MCK

#define CYGHWR_AT91_SPI_RAISE_CS( __num, __bus ) \
    if ( __num != 0 ) \
        HAL_WRITE_UINT32(AT91_SPI_PIO+_PIO_CODR, AT91_SPI_PIO_NPCS(1<<(__num)))

#define CYGHWR_AT91_SPI_DROP_CS( __num, __bus ) \
    if ( __num != 0 ) \
        HAL_WRITE_UINT32(AT91_SPI_PIO+_PIO_SODR, AT91_SPI_PIO_NPCS(1<<(__num)))
    
#define CYGHWR_AT91_SPI_ENABLE_SPI_CLOCK( __bus ) \
    HAL_WRITE_UINT32(AT91RM9200_PMC+_PMC_PCER, AT91_PMC_PCER_SPI)
    
#define CYGHWR_AT91_SPI_DISABLE_SPI_CLOCK( __bus ) \
    HAL_WRITE_UINT32(AT91RM9200_PMC+_PMC_PCDR, AT91_PMC_PCER_SPI)    

//-----------------------------------------------------------------------------

#endif // CYGONCE_DEVS_SPI_ARM_AT91RM9200_EK_H 

//-----------------------------------------------------------------------------
// End of spi_at91rm9200_ek.h
