#ifndef CYGONCE_DEVS_SPI_ARM_EB55_H
#define CYGONCE_DEVS_SPI_ARM_EB55_H
//==========================================================================
//
//      spi_eb55.h
//
//      Atmel AT91EB55 SPI devices defines
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):     Savin Zlobec <savin@elatec.si> 
// Date:          2004-08-27
//
//####DESCRIPTIONEND####
//
//==========================================================================

//-----------------------------------------------------------------------------
// AT91EB55 SPI exported devices 

#define HAL_SPI_EXPORTED_DEVICES \
    externC cyg_spi_device *cyg_spi_dataflash_dev0;

//-----------------------------------------------------------------------------

// NOTE: here we let the SPI controller control
//       the data in, out and clock signals, but
//       we need to handle the chip selects manually
//       in order to achieve better chip select control
//       inbetween transactions.

#define CYGHWR_AT91_SPI_CONFIGURE_PINS( __base )                                \
{                                                                               \
    /* Put SPI MISO, MOIS and SPCK pins into peripheral mode */                 \
    HAL_WRITE_UINT32(AT91_SPI_PIO+AT91_PIO_PDR, AT91_PIO_PSR_SPCK |             \
                                                AT91_PIO_PSR_MISO |             \
                                                AT91_PIO_PSR_MOSI);             \
                                                                                \
    /* Put SPI chip select pins in IO output mode */                            \
    HAL_WRITE_UINT32(AT91_SPI_PIO+AT91_PIO_SODR, AT91_SPI_PIO_NPCS(0x0F));      \
    HAL_WRITE_UINT32(AT91_SPI_PIO+AT91_PIO_PER,  AT91_SPI_PIO_NPCS(0x0F));      \
    HAL_WRITE_UINT32(AT91_SPI_PIO+AT91_PIO_OER,  AT91_SPI_PIO_NPCS(0x0F));      \
}

#define CYGHWR_AT91_SPI_CLOCK_SPEED CYGNUM_HAL_ARM_AT91_CLOCK_SPEED

#define CYGHWR_AT91_SPI_RAISE_CS( __num, __bus ) \
    HAL_WRITE_UINT32(AT91_SPI_PIO+AT91_PIO_CODR, AT91_SPI_PIO_NPCS(~(__num)))

#define CYGHWR_AT91_SPI_DROP_CS( __num, __bus ) \
    HAL_WRITE_UINT32(AT91_SPI_PIO+AT91_PIO_SODR, AT91_SPI_PIO_NPCS(0x0F))

#define CYGHWR_AT91_SPI_ENABLE_SPI_CLOCK( __bus ) \
    HAL_WRITE_UINT32(AT91_PMC+AT91_PMC_PCER, AT91_PMC_PCER_SPI)

#define CYGHWR_AT91_SPI_DISABLE_SPI_CLOCK( __bus ) \
    HAL_WRITE_UINT32(AT91_PMC+AT91_PMC_PCDR, AT91_PMC_PCER_SPI)

//-----------------------------------------------------------------------------

#endif // CYGONCE_DEVS_SPI_ARM_EB55_H 

//-----------------------------------------------------------------------------
// End of spi_eb55.h
