#ifndef CYGONCE_DEVS_SPI_ARM_PL022_H
#define CYGONCE_DEVS_SPI_ARM_PL022_H
//==========================================================================
//
//      spi_pl022.h
//
//      ARM PL022 primecell SPI driver defines
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2008 Free Software Foundation, Inc.                        
// Copyright (C) 2008, 2009 eCosCentric Limited                                   
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):     nickg
// Date:          2009-08-11
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <pkgconf/hal.h>
#include <pkgconf/io_spi.h>

#include <cyg/infra/cyg_type.h>
#include <cyg/hal/drv_api.h>
#include <cyg/io/spi.h>

//-----------------------------------------------------------------------------
// Redefine various macros if they are not already supplied by the HAL.

#ifndef CYGARC_PHYSICAL_ADDRESS
#define CYGARC_PHYSICAL_ADDRESS(x) ((CYG_ADDRESS)(x))
#endif

//-----------------------------------------------------------------------------
// SPI BUS

typedef struct cyg_spi_pl022_bus_s
{
    // ---- Upper layer data ----

    cyg_spi_bus   spi_bus;                  // Upper layer SPI bus data

    // ---- Lower layer data ----

    cyg_interrupt     spi_interrupt;        // SPI interrupt object
    cyg_handle_t      spi_interrupt_handle; // SPI interrupt handle
    cyg_drv_mutex_t   transfer_mx;          // Transfer mutex
    cyg_drv_cond_t    transfer_cond;        // Transfer condition
    cyg_bool          transfer_end;         // Transfer end flag
    cyg_bool          cs_up;                // Chip Select up flag
    cyg_vector_t      interrupt_number;     // SPI Interrupt Number
    cyg_uint32        interrupt_priority;   // SPI Interrupt Priority
    cyg_addrword_t    base;                 // Base Address of the SPI peripheral    
    cyg_count32       bus_num;              // Bus number

    // ---- Pin configuration assignments ----

    cyg_uint32        enable;               // Clock/power enable
    cyg_uint32        sclk_pin;             // SCLK pin
    cyg_uint32        miso_pin;             // MISO pin
    cyg_uint32        mosi_pin;             // MOSI pin
    cyg_uint32        *cs_pin;              // Chip select GPIO pins
    cyg_uint32        cs_count;             // Size of CS pin array

    // ---- Transfer data ----

    const cyg_uint8   *tx_data;             // Transmit buffer (may be NULL)
    cyg_uint8         *rx_data;             // Receive buffer (may be NULL)
    cyg_uint32        tx_count;             // Transmit count
    cyg_uint32        rx_count;             // Receive count
    
} cyg_spi_pl022_bus_t;

//-----------------------------------------------------------------------------
// SPI DEVICE

typedef struct cyg_spi_pl022_device_s
{
    // ---- Upper layer data ----

    cyg_spi_device spi_device;  // Upper layer SPI device data

    // ---- Lower layer data (configurable) ----

    cyg_uint8  dev_num;         // Device number
    cyg_uint8  cl_pol;          // Clock polarity (0 or 1)
    cyg_uint8  cl_pha;          // Clock phase    (0 or 1)
    cyg_uint32 cl_brate;        // Clock baud rate
    cyg_uint16 cs_up_udly;      // Delay in us between CS up and transfer start
    cyg_uint16 cs_dw_udly;      // Delay in us between transfer end and CS down
    cyg_uint16 tr_bt_udly;      // Delay in us between two transfers

    // ---- Lower layer data (internal) ----

    cyg_bool   init;            // Is device initialized
    cyg_uint8  cl_psr;          // Value of CPSR reg
    cyg_uint8  cl_scr;          // Value of SCR field of CR0
} cyg_spi_pl022_device_t;


//-----------------------------------------------------------------------------
// Driver interface functions

__externC void cyg_spi_pl022_transaction_begin(cyg_spi_device *dev);

__externC void cyg_spi_pl022_transaction_transfer(cyg_spi_device  *dev,
                                               cyg_bool         polled,
                                               cyg_uint32       count,
                                               const cyg_uint8 *tx_data,
                                               cyg_uint8       *rx_data,
                                               cyg_bool         drop_cs);

__externC void cyg_spi_pl022_transaction_tick(cyg_spi_device *dev,
                                           cyg_bool        polled,
                                           cyg_uint32      count);

__externC void cyg_spi_pl022_transaction_end(cyg_spi_device* dev);

__externC int cyg_spi_pl022_get_config(cyg_spi_device *dev, 
                                    cyg_uint32      key, 
                                    void           *buf,
                                    cyg_uint32     *len);

__externC int cyg_spi_pl022_set_config(cyg_spi_device *dev, 
                                    cyg_uint32      key, 
                                    const void     *buf, 
                                    cyg_uint32     *len);

//-----------------------------------------------------------------------------

#endif // CYGONCE_DEVS_SPI_ARM_PL022_H 

//-----------------------------------------------------------------------------
// End of spi_pl022.h
