//==========================================================================
//
//      devs/watchdog/arm/lpc2xxx/watchdog_lpc2xxx.cxx
//
//      Watchdog implementation for NXP LPC2xxx variant CPUs
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2004,2005, 2008, 2009 eCosCentric Limited
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2008 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    jlarmour
// Contributors: 
// Date:         2004-08-05
// Purpose:      Watchdog class implementation
// Description:  Contains an implementation of the Watchdog class for use
//               with the NXP LPC2xxx on-board watchdog timer.
//               Based on AT91 watchdog driver with contributors:
//               tkoeller, nickg
//####DESCRIPTIONEND####
//
//==========================================================================

#include <pkgconf/kernel.h>
#include <pkgconf/infra.h>
#include <pkgconf/kernel.h>
#include <pkgconf/watchdog.h>
#include <pkgconf/devs_watchdog_arm_lpc2xxx.h>

#include <cyg/infra/cyg_type.h>
#include <cyg/infra/cyg_ass.h>
#include <cyg/infra/cyg_trac.h>
#include <cyg/hal/hal_io.h>
#include <cyg/hal/hal_diag.h>

#include <cyg/io/watchdog.hxx>

#if !defined(CYGSEM_WATCHDOG_RESETS_ON_TIMEOUT)
#include <cyg/hal/hal_platform_ints.h>
#include <cyg/kernel/intr.hxx>
#endif

//==========================================================================

#define WD_TICK_FREQ            (CYGNUM_HAL_ARM_LPC2XXX_PCLK_SPEED/4)
#define WD_TIMER_CONSTANT_INIT  (((cyg_uint64)CYGNUM_DEVS_WATCHDOG_ARM_LPC2XXX_DESIRED_TIMEOUT_US * WD_TICK_FREQ)/1000000)

//==========================================================================

#if defined(CYGSEM_WATCHDOG_RESETS_ON_TIMEOUT)

void
Cyg_Watchdog::init_hw(void)
{
  CYG_REPORT_FUNCTION();
  CYG_REPORT_FUNCARGVOID();
  resolution = CYGNUM_DEVS_WATCHDOG_ARM_LPC2XXX_DESIRED_TIMEOUT_US*1000;
  CYG_REPORT_RETURN();
}

#else /* defined(CYGSEM_WATCHDOG_RESETS_ON_TIMEOUT) */

//==========================================================================

static Cyg_Watchdog *wd;

//==========================================================================

static cyg_uint32
isr(cyg_vector vector, CYG_ADDRWORD data)
{
  CYG_REPORT_FUNCTION();
  CYG_REPORT_FUNCARG2XV(vector, data);

  wd->trigger();
  Cyg_Interrupt::acknowledge_interrupt(CYGNUM_HAL_INTERRUPT_WATCHDOG);
  CYG_REPORT_RETVAL(Cyg_Interrupt::HANDLED);
  return Cyg_Interrupt::HANDLED;
}

//==========================================================================

static Cyg_Interrupt CYGBLD_ATTRIB_INIT_PRI(CYG_INIT_INTERRUPTS) wdint(
    CYGNUM_HAL_INTERRUPT_WATCHDOG,
    1,
    0,
    isr,
    NULL
  );

//==========================================================================

void
Cyg_Watchdog::init_hw(void)
{
  CYG_REPORT_FUNCTION();
  CYG_REPORT_FUNCARGVOID();

  wd = this;
  resolution = CYGNUM_DEVS_WATCHDOG_ARM_LPC2XXX_DESIRED_TIMEOUT_US*1000;
  wdint.attach();
  wdint.acknowledge_interrupt(CYGNUM_HAL_INTERRUPT_WATCHDOG);
  wdint.unmask_interrupt(CYGNUM_HAL_INTERRUPT_WATCHDOG);
  CYG_REPORT_RETURN();
}

#endif	/* defined(CYGSEM_WATCHDOG_RESETS_ON_TIMEOUT) */

//==========================================================================
/*
 * Reset watchdog timer. This needs to be called regularly to prevent
 * the watchdog from firing.
 */

void
Cyg_Watchdog::reset(void)
{
  CYG_REPORT_FUNCTION();
  CYG_REPORT_FUNCARGVOID();

  /* Write magic codes to reset the watchdog. */
  HAL_WRITE_UINT8( CYGARC_HAL_LPC2XXX_REG_WD_BASE + CYGARC_HAL_LPC2XXX_REG_WDFEED,
                   CYGARC_HAL_LPC2XXX_REG_WDFEED_MAGIC1 );
  HAL_WRITE_UINT8( CYGARC_HAL_LPC2XXX_REG_WD_BASE + CYGARC_HAL_LPC2XXX_REG_WDFEED,
                   CYGARC_HAL_LPC2XXX_REG_WDFEED_MAGIC2 );
  CYG_REPORT_RETURN();
}

//==========================================================================
/*
 * Start watchdog to generate a hardware reset
 * or interrupt when expiring.
 */

void
Cyg_Watchdog::start(void)
{
  CYG_REPORT_FUNCTION();
  CYG_REPORT_FUNCARGVOID();

#ifdef CYGARC_HAL_LPC2XXX_REG_WDCLKSEL
  // If the WDCLKSEL register is defined, then set it to source the
  // clock from PCLK.
  HAL_WRITE_UINT32( CYGARC_HAL_LPC2XXX_REG_WD_BASE + CYGARC_HAL_LPC2XXX_REG_WDCLKSEL,
                    CYGARC_HAL_LPC2XXX_REG_WDCLKSEL_PCLK );
#endif

  HAL_WRITE_UINT32( CYGARC_HAL_LPC2XXX_REG_WD_BASE + CYGARC_HAL_LPC2XXX_REG_WDTC,
                    ((cyg_uint32)WD_TIMER_CONSTANT_INIT) );
                    
#ifdef CYGSEM_WATCHDOG_RESETS_ON_TIMEOUT
  HAL_WRITE_UINT8( CYGARC_HAL_LPC2XXX_REG_WD_BASE + CYGARC_HAL_LPC2XXX_REG_WDMOD,
                   CYGARC_HAL_LPC2XXX_REG_WDMOD_WDEN|CYGARC_HAL_LPC2XXX_REG_WDMOD_WDRESET );
#else
  HAL_WRITE_UINT8( CYGARC_HAL_LPC2XXX_REG_WD_BASE + CYGARC_HAL_LPC2XXX_REG_WDMOD,
                   CYGARC_HAL_LPC2XXX_REG_WDMOD_WDEN );
#endif
  // Write magic values to reset and start watchdog
  HAL_WRITE_UINT8( CYGARC_HAL_LPC2XXX_REG_WD_BASE + CYGARC_HAL_LPC2XXX_REG_WDFEED,
                   CYGARC_HAL_LPC2XXX_REG_WDFEED_MAGIC1 );
  HAL_WRITE_UINT8( CYGARC_HAL_LPC2XXX_REG_WD_BASE + CYGARC_HAL_LPC2XXX_REG_WDFEED,
                   CYGARC_HAL_LPC2XXX_REG_WDFEED_MAGIC2 );
  CYG_REPORT_RETURN();
}

//==========================================================================
// End of watchdog_lpc2xxx.cxx
