//==========================================================================
//
//      devs/watchdog/arm/str7xx/watchdog_str7xx.cxx
//
//      Watchdog implementation for ST Str7xxPlus variant CPUs
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Free Software Foundation, Inc.
// Copyright (C) 2004, 2005, 2006 eCosCentric Limited                       
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    nickg
// Contributors: 
// Date:         2006-03-29
// Purpose:      Watchdog class implementation
// Description:  Contains an implementation of the Watchdog class for use
//               with the ST Str7xx on-board watchdog timer.
//               Based on LPC2xxx driver by jlarmour.
//####DESCRIPTIONEND####
//
//==========================================================================

#include <pkgconf/kernel.h>
#include <pkgconf/infra.h>
#include <pkgconf/kernel.h>
#include <pkgconf/watchdog.h>
#include <pkgconf/devs_watchdog_arm_str7xx.h>

#include <cyg/infra/cyg_type.h>
#include <cyg/infra/cyg_ass.h>
#include <cyg/infra/cyg_trac.h>
#include <cyg/hal/hal_io.h>
#include <cyg/hal/hal_diag.h>

#include <cyg/io/watchdog.hxx>

#if !defined(CYGSEM_WATCHDOG_RESETS_ON_TIMEOUT)
#include <cyg/hal/hal_platform_ints.h>
#include <cyg/kernel/intr.hxx>
#endif

#include <cyg/infra/diag.h>

//==========================================================================

//#define WD_PRESCALE             250
//#define WD_TICK_FREQ            ((CYGARC_HAL_STR7XX_AAPB_CLOCK+(WD_PRESCALE-1))/(WD_PRESCALE))
//#define WD_TIMER_CONSTANT_INIT  ((cyg_uint64)((cyg_uint64)CYGNUM_DEVS_WATCHDOG_ARM_STR7XX_DESIRED_TIMEOUT_US * (cyg_uint64)WD_TICK_FREQ +999999LL)/1000000LL)

//==========================================================================

#if defined(CYGSEM_WATCHDOG_RESETS_ON_TIMEOUT)

void
Cyg_Watchdog::init_hw(void)
{
  CYG_REPORT_FUNCTION();
  CYG_REPORT_FUNCARGVOID();
  resolution = CYGNUM_DEVS_WATCHDOG_ARM_STR7XX_DESIRED_TIMEOUT_US*1000;
  CYG_REPORT_RETURN();
}

#else /* defined(CYGSEM_WATCHDOG_RESETS_ON_TIMEOUT) */

//==========================================================================

static Cyg_Watchdog *wd;

//==========================================================================

static cyg_uint32
isr(cyg_vector vector, CYG_ADDRWORD data)
{
  CYG_REPORT_FUNCTION();
  CYG_REPORT_FUNCARG2XV(vector, data);

  wd->trigger();
  Cyg_Interrupt::acknowledge_interrupt(CYGNUM_HAL_INTERRUPT_WATCHDOG);
  CYG_REPORT_RETVAL(Cyg_Interrupt::HANDLED);
  return Cyg_Interrupt::HANDLED;
}

//==========================================================================

static Cyg_Interrupt wdint(
    CYGNUM_HAL_INTERRUPT_WATCHDOG,
    1,
    0,
    isr,
    NULL
  );

//==========================================================================

void
Cyg_Watchdog::init_hw(void)
{
  CYG_REPORT_FUNCTION();
  CYG_REPORT_FUNCARGVOID();

  wd = this;
  resolution = CYGNUM_DEVS_WATCHDOG_ARM_STR7XX_DESIRED_TIMEOUT_US*1000;
  wdint.attach();
  wdint.acknowledge_interrupt(CYGNUM_HAL_INTERRUPT_WATCHDOG);
  wdint.unmask_interrupt(CYGNUM_HAL_INTERRUPT_WATCHDOG);
  CYG_REPORT_RETURN();
}

#endif	/* defined(CYGSEM_WATCHDOG_RESETS_ON_TIMEOUT) */

//==========================================================================
/*
 * Reset watchdog timer. This needs to be called regularly to prevent
 * the watchdog from firing.
 */

void
Cyg_Watchdog::reset(void)
{
    CYG_ADDRESS base = CYGARC_HAL_STR7XX_WDG_BASE;
    
    CYG_REPORT_FUNCTION();
    CYG_REPORT_FUNCARGVOID();

    {
        cyg_uint32 count;
        HAL_READ_UINT16( base + CYGARC_HAL_STR7XX_WDG_CNT, count );
    }
    /* Write magic codes to reset the watchdog. */
    HAL_WRITE_UINT16( base + CYGARC_HAL_STR7XX_WDG_KR, CYGARC_HAL_STR7XX_WDG_KR_VAL1 );
    HAL_WRITE_UINT16( base + CYGARC_HAL_STR7XX_WDG_KR, CYGARC_HAL_STR7XX_WDG_KR_VAL2 );

    CYG_REPORT_RETURN();
}

//==========================================================================
/*
 * Start watchdog to generate a hardware reset
 * or interrupt when expiring.
 */

void
Cyg_Watchdog::start(void)
{
    CYG_ADDRESS base = CYGARC_HAL_STR7XX_WDG_BASE;
    
    CYG_REPORT_FUNCTION();
    CYG_REPORT_FUNCARGVOID();

    // Set watchdog via HAL to account for variations in the CPU clock speed

    hal_str7xx_watchdog_init( CYGNUM_DEVS_WATCHDOG_ARM_STR7XX_DESIRED_TIMEOUT_US );
    
    CYG_REPORT_RETURN();
}

//==========================================================================
// End of watchdog_str7xx.cxx
