//==========================================================================
//
//      devs/watchdog/cortexm/stm32/watchdog_stm32.cxx
//
//      Watchdog implementation for ST STM32 variant CPUs
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Free Software Foundation, Inc.
// Copyright (C) 2004, 2005, 2006, 2009 eCosCentric Limited                       
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    nickg
// Contributors: 
// Date:         2006-03-29
// Purpose:      Watchdog class implementation
// Description:  Contains an implementation of the Watchdog class for use
//               with the ST STM32 on-board watchdog timer.
//               Based on STR7XX driver by jlarmour.
//####DESCRIPTIONEND####
//
//==========================================================================

#include <pkgconf/kernel.h>
#include <pkgconf/infra.h>
#include <pkgconf/kernel.h>
#include <pkgconf/watchdog.h>
#include <pkgconf/devs_watchdog_cortexm_stm32.h>

#include <cyg/infra/cyg_type.h>
#include <cyg/infra/cyg_ass.h>
#include <cyg/infra/cyg_trac.h>
#include <cyg/hal/hal_io.h>
#include <cyg/hal/hal_diag.h>

#include <cyg/io/watchdog.hxx>

#include <cyg/infra/diag.h>

//==========================================================================
// Reload value. Calculated from desired us period, multiplied by
// clock Hz (60KHz divided by 256 prescaler), divided by 1000000. Add 1
// to round up to next whole number -- the period doesn't need to be
// perfectly accurate.
//
// The characteristics for the LSI ocillator say that it has a typical
// frequency of 40kHz but can vary between 30 and 60kHz. It would be
// possible to calibrate the timer using TIM5, but that is overkill
// for our purposes. So we use the maximum possible frequency of 60kHz
// for our calculations. This may result in watchdog timeouts 50%
// longer than requested, but that is better than timeouts that are
// too short. 

#define WD_RELOAD (((CYGNUM_DEVS_WATCHDOG_CORTEXM_STM32_DESIRED_TIMEOUT_US*(60000/256))/1000000)+1)

//==========================================================================

void
Cyg_Watchdog::init_hw(void)
{
  CYG_REPORT_FUNCTION();
  CYG_REPORT_FUNCARGVOID();
  resolution = ((cyg_uint64)CYGNUM_DEVS_WATCHDOG_CORTEXM_STM32_DESIRED_TIMEOUT_US)*1000LL;
  CYG_REPORT_RETURN();
}

//==========================================================================
/*
 * Reset watchdog timer. This needs to be called regularly to prevent
 * the watchdog from firing.
 */

void
Cyg_Watchdog::reset(void)
{
    CYG_ADDRESS base = CYGHWR_HAL_STM32_IWDG;
    
    CYG_REPORT_FUNCTION();
    CYG_REPORT_FUNCARGVOID();

    // Write magic code to reset the watchdog
    HAL_WRITE_UINT32( base + CYGHWR_HAL_STM32_IWDG_KR, CYGHWR_HAL_STM32_IWDG_KR_RESET );

    CYG_REPORT_RETURN();
}

//==========================================================================
/*
 * Start watchdog to generate a hardware reset
 * or interrupt when expiring.
 */

void
Cyg_Watchdog::start(void)
{
    CYG_ADDRESS base = CYGHWR_HAL_STM32_IWDG;
    CYG_ADDRESS rcc = CYGHWR_HAL_STM32_RCC;
    cyg_uint32 csr;
    
    CYG_REPORT_FUNCTION();
    CYG_REPORT_FUNCARGVOID();

    // Start up LSI clock
    HAL_READ_UINT32( rcc+CYGHWR_HAL_STM32_RCC_CSR, csr );
    csr |= CYGHWR_HAL_STM32_RCC_CSR_LSION;
    HAL_WRITE_UINT32( rcc+CYGHWR_HAL_STM32_RCC_CSR, csr );
    
    // Wait for LSI clock to startup
    do
    {
        HAL_READ_UINT32( rcc+CYGHWR_HAL_STM32_RCC_CSR, csr );
    } while( (csr & CYGHWR_HAL_STM32_RCC_CSR_LSIRDY) == 0 );

  
    // Write magic value to access PR and RLR registers
    HAL_WRITE_UINT32( base + CYGHWR_HAL_STM32_IWDG_KR, CYGHWR_HAL_STM32_IWDG_KR_ACCESS );

    // Set PR and RLR values.
    HAL_WRITE_UINT32( base + CYGHWR_HAL_STM32_IWDG_PR, CYGHWR_HAL_STM32_IWDG_PR_256 );    
    HAL_WRITE_UINT32( base + CYGHWR_HAL_STM32_IWDG_RLR, WD_RELOAD );    

    // Write magic value to store PR and RLR registers
    HAL_WRITE_UINT32( base + CYGHWR_HAL_STM32_IWDG_KR, CYGHWR_HAL_STM32_IWDG_KR_RESET );

    // Write magic value to start the watchdog    
    HAL_WRITE_UINT32( base + CYGHWR_HAL_STM32_IWDG_KR, CYGHWR_HAL_STM32_IWDG_KR_START );        
    
    CYG_REPORT_RETURN();
}

//==========================================================================
// End of watchdog_stm32.cxx
