#ifndef CYGONCE_AT91RM9200_H
#define CYGONCE_AT91RM9200_H
/*=============================================================================
//
//      at91rm9200.h
//
//      Register layout, etc, for Atmel AT91RM9200 CPU
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2003, 2004, 2005, 2007 Free Software Foundation, Inc.      
// Copyright (C) 2003, 2004, 2005, 2007 eCosCentric Limited                 
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    eCosCentric
// Contributors: 
// Date:         2003-09-15
// Purpose:      Atmel AT91RM9200 CPU variant definitions
// Description: 
// Usage:        #include <cyg/hal/at91rm9200.h>
//
//####DESCRIPTIONEND####
//
//===========================================================================*/

#include <pkgconf/hal_arm_arm9_at91rm9200.h>

// On-chip peripherals - Atmel AT91RM9200
#define AT91RM9200_AIC   0xFFFFF000  // Advanced Interrupt Controller
#define AT91RM9200_DEBUG 0xFFFFF200  // Debug uart 
#define AT91RM9200_PIOA  0xFFFFF400  // PIO controller A
#define AT91RM9200_PIOB  0xFFFFF600
#define AT91RM9200_PIOC  0xFFFFF800
#define AT91RM9200_PIOD  0xFFFFFA00
#define AT91RM9200_PMC   0xFFFFFC00  // Power Management Controller
#define AT91RM9200_ST    0xFFFFFD00  // System Timer
#define AT91RM9200_RTC   0xFFFFFE00  // Real Time Clock
#define AT91RM9200_MC    0xFFFFFF00  // Memory controller
#define AT91RM9200_TC0   0xFFFA0000  // Timer/Counter #0
#define AT91RM9200_TC1   0xFFFA0040  // Timer/Counter #1
#define AT91RM9200_TC2   0xFFFA0080  // Timer/Counter #2
#define AT91RM9200_TC3   0xFFFA4000  // Timer/Counter #3
#define AT91RM9200_TC4   0xFFFA4040  // Timer/Counter #4
#define AT91RM9200_TC5   0xFFFA4080  // Timer/Counter #5
#define AT91RM9200_USB   0xFFFB0000  // USB device
#define AT91RM9200_MCI   0xFFFB4000  // Multimedia controller
#define AT91RM9200_TWI   0xFFFB8000  // Two-wire interface
#define AT91RM9200_EMAC  0xFFFBC000  // Ethernet
#define AT91RM9200_UART0 0xFFFC0000
#define AT91RM9200_UART1 0xFFFC4000
#define AT91RM9200_UART2 0xFFFC8000
#define AT91RM9200_UART3 0xFFFCC000
#define AT91RM9200_SSC0  0xFFFD0000  // Synchronous serial controller
#define AT91RM9200_SSC1  0xFFFD4000
#define AT91RM9200_SSC2  0xFFFD8000
#define AT91RM9200_SPI   0xFFFE0000  // Serial Peripheral Interface

//=============================================================================
// Advanced Interrupt Controller (AIC)
#define _AIC_SMR   (AT91RM9200_AIC+0x0000) // Source Mode Register(s)
#define _AIC_SVR   (AT91RM9200_AIC+0x0080) // Source Vector Register(s)
#define _AIC_IVR   (AT91RM9200_AIC+0x0100) // IRQ Vector Register
#define _AIC_FVR   (AT91RM9200_AIC+0x0104) // FIQ Vector Register
#define _AIC_ISR   (AT91RM9200_AIC+0x0108) // Interrupt Status Register
#define _AIC_IPR   (AT91RM9200_AIC+0x010C) // Interrupt Pending Register
#define _AIC_IMR   (AT91RM9200_AIC+0x0110) // Interrupt Mask Register
#define _AIC_CISR  (AT91RM9200_AIC+0x0114) // Core Interrupt Status Register
#define _AIC_IECR  (AT91RM9200_AIC+0x0120) // Interrupt Enable Command Register
#define _AIC_IDCR  (AT91RM9200_AIC+0x0124) // Interrupt Disable Command Register
#define _AIC_ICCR  (AT91RM9200_AIC+0x0128) // Interrupt Clear Command Register
#define _AIC_ISCR  (AT91RM9200_AIC+0x012C) // Interrupt Set Command Register
#define _AIC_EOICR (AT91RM9200_AIC+0x0130) // End of Interrupt Command Register
#define _AIC_SPU   (AT91RM9200_AIC+0x0134) // Spurious Vector Register
#define _AIC_DCR   (AT91RM9200_AIC+0x0138) // Debug Control Register (Protect)
#define _AIC_FFER  (AT91RM9200_AIC+0x0140) // Fast Forcing Enable Register
#define _AIC_FFDR  (AT91RM9200_AIC+0x0144) // Fast Forcing Disable Register
#define _AIC_FFSR  (AT91RM9200_AIC+0x0148) // Fast Forcing Status Register

// This is the offset from the top of memory to the IVR register.
// It is used in the irq_vector and fiq_vector macros in the platform
// HAL's hal_platform_setup.h to access the interrupt vectors in a single
// instruction from the IRQ and FIQ exception vectors.

#define _AIC_IVR_OFFSET              (0xffffffff-_AIC_IVR+1)
#define _AIC_FVR_OFFSET              (0xffffffff-_AIC_FVR+1)


//=============================================================================
// Power Management Controller (PMC) & Clock Generator (CKGR)
#define _PMC_SCER        (AT91RM9200_PMC+0x00)   // System Clock Enable Register
#define   _PMC_SCER_PCK         (0x1<< 0)      //   Processor Clock
#define   _PMC_SCER_UDP         (0x1<< 1)      //   USB Device Port Clock
#define   _PMC_SCER_MCKUDP      (0x1<< 2)      //   USB Device Port Master Clock Automatic Disable on Suspend
#define   _PMC_SCER_UHP         (0x1<< 4)      //   USB Host Port Clock
#define   _PMC_SCER_PCK0        (0x1<< 8)      //   Programmable Clock Output
#define   _PMC_SCER_PCK1        (0x1<< 9)      //   Programmable Clock Output
#define   _PMC_SCER_PCK2        (0x1<<10)      //   Programmable Clock Output
#define   _PMC_SCER_PCK3        (0x1<<11)      //   Programmable Clock Output
#define   _PMC_SCER_PCK4        (0x1<<12)      //   Programmable Clock Output
#define   _PMC_SCER_PCK5        (0x1<<13)      //   Programmable Clock Output
#define   _PMC_SCER_PCK6        (0x1<<14)      //   Programmable Clock Output
#define   _PMC_SCER_PCK7        (0x1<<15)      //   Programmable Clock Output
#define _PMC_SCDR        (AT91RM9200_PMC+0x04)   // System Clock Disable Register
#define _PMC_SCSR        (AT91RM9200_PMC+0x08)   // System Clock Status Register
#define _PMC_PCER        (AT91RM9200_PMC+0x10)   // Peripheral Clock Enable Register
#define _PMC_PCDR        (AT91RM9200_PMC+0x14)   // Peripheral Clock Disable Register
#define _PMC_PCSR        (AT91RM9200_PMC+0x18)   // Peripheral Clock Status Register
#define _CKGR_MOR        (AT91RM9200_PMC+0x20)   // Main Oscillator Register
#define    _CKGR_MOR_MOSCEN     (0x1<< 0)      //   Main Oscillator Enable
#define    _CKGR_MOR_OSCTEST    (0x1<< 1)      //   Oscillator Test
#define    _CKGR_MOR_OSCOUNT    (0xFF<< 8)     //   Main Oscillator Start-up Time
#define _CKGR_MCFR       (AT91RM9200_PMC+0x24)   // Main Clock Frequency Register
#define    _CKGR_MCFR_MAINF      (0xFFFF<< 0)  //   Main Clock Frequency
#define    _CKGR_MCFR_MAINRDY    (0x1<<16)     //   Main Clock Ready
#define _CKGR_PLLAR      (AT91RM9200_PMC+0x28)   // PLL A Register
#define    _CKGR_PLLAR_DIVA       (0xFF<< 0)   //   Divider Selected
#define            _CKGR_PLLAR_DIVA_0      (0x0) //     Divider output is 0
#define            _CKGR_PLLAR_DIVA_BYPASS (0x1) //     Divider is bypassed
#define    _CKGR_PLLAR_PLLACOUNT  (0x3F<< 8)   //   PLL A Counter
#define    _CKGR_PLLAR_OUTA       (0x3<<14)    //   PLL A Output Frequency Range
#define            _CKGR_PLLAR_OUTA_0 (0x0<<14)
#define            _CKGR_PLLAR_OUTA_1 (0x1<<14)
#define            _CKGR_PLLAR_OUTA_2 (0x2<<14)
#define            _CKGR_PLLAR_OUTA_3 (0x3<<14)
#define    _CKGR_PLLAR_MULA       (0x7FF<<16)  //   PLL A Multiplier
#define    _CKGR_PLLAR_SRCA       (0x1<<29)    //   PLL A Source
#define _CKGR_PLLBR      (AT91RM9200_PMC+0x2C)   // PLL B Register
#define    _CKGR_PLLBR_DIVB       (0xFF<< 0)   //   Divider Selected
#define            _CKGR_PLLBR_DIVB_0      (0x0) //     Divider output is 0
#define            _CKGR_PLLBR_DIVB_BYPASS (0x1) //     Divider is bypassed
#define    _CKGR_PLLBR_PLLBCOUNT  (0x3F<< 8)   //   PLL B Counter
#define    _CKGR_PLLBR_OUTB       (0x3<<14)    //   PLL B Output Frequency Range
#define            _CKGR_PLLBR_OUTB_0 (0x0<<14)
#define            _CKGR_PLLBR_OUTB_1 (0x1<<14)
#define            _CKGR_PLLBR_OUTB_2 (0x2<<14)
#define            _CKGR_PLLBR_OUTB_3 (0x3<<14)
#define    _CKGR_PLLBR_MULB       (0x7FF<<16)  //   PLL B Multiplier
#define    _CKGR_PLLBR_USB_96M    (0x1<<28)    //   Divider for USB Ports
#define    _CKGR_PLLBR_USB_PLL    (0x1<<29)    //   PLL Use
#define _PMC_MCKR        (AT91RM9200_PMC+0x30)   // Master Clock Register
#define    _PMC_MCKR_CSS         (0x3<< 0)     //   Programmable Clock Selection
#define      _PMC_MCKR_CSS_SLOW_CLK        (0x0) //     Slow Clock is selected
#define      _PMC_MCKR_CSS_MAIN_CLK        (0x1) //     Main Clock is selected
#define      _PMC_MCKR_CSS_PLLA_CLK        (0x2) //     Clock from PLL A is selected
#define      _PMC_MCKR_CSS_PLLB_CLK        (0x3) //     Clock from PLL B is selected
#define    _PMC_MCKR_PRES        (0x7<< 2)     //   Programmable Clock Prescaler
#define      _PMC_MCKR_PRES_CLK      (0x0<< 2) //     Selected clock
#define      _PMC_MCKR_PRES_CLK_2    (0x1<< 2) //     Selected clock divided by 2
#define      _PMC_MCKR_PRES_CLK_4    (0x2<< 2) //     Selected clock divided by 4
#define      _PMC_MCKR_PRES_CLK_8    (0x3<< 2) //     Selected clock divided by 8
#define      _PMC_MCKR_PRES_CLK_16   (0x4<< 2) //     Selected clock divided by 16
#define      _PMC_MCKR_PRES_CLK_32   (0x5<< 2) //     Selected clock divided by 32
#define      _PMC_MCKR_PRES_CLK_64   (0x6<< 2) //     Selected clock divided by 64
#define    _PMC_MCKR_MDIV        (0x3<< 8)     //   Master Clock Division
#define      _PMC_MCKR_MDIV_1        (0x0<< 8) //     Processor clock == Master clock
#define      _PMC_MCKR_MDIV_2        (0x1<< 8) //     Processor clock == 2 * Master clock
#define      _PMC_MCKR_MDIV_3        (0x2<< 8) //     Processor clock == 3 * Master clock
#define      _PMC_MCKR_MDIV_4        (0x3<< 8) //     Processor clock == 4 *Master clock
#define _PMC_PCKR0       (AT91RM9200_PMC+0x40)   // Programmable Clock Register
#define _PMC_PCKR1       (AT91RM9200_PMC+0x44)   // Programmable Clock Register
#define _PMC_PCKR2       (AT91RM9200_PMC+0x48)   // Programmable Clock Register
#define _PMC_PCKR3       (AT91RM9200_PMC+0x4C)   // Programmable Clock Register
#define _PMC_PCKR4       (AT91RM9200_PMC+0x50)   // Programmable Clock Register
#define _PMC_PCKR5       (AT91RM9200_PMC+0x54)   // Programmable Clock Register
#define _PMC_PCKR6       (AT91RM9200_PMC+0x58)   // Programmable Clock Register
#define _PMC_PCKR7       (AT91RM9200_PMC+0x5C)   // Programmable Clock Register
#define _PMC_IER         (AT91RM9200_PMC+0x60)   // Interrupt Enable Register
#define    _PMC_IER_MOSCS       (0x1<< 0)      //   MOSC Status/Enable/Disable/Mask
#define    _PMC_IER_LOCKA       (0x1<< 1)      //   PLL A Status/Enable/Disable/Mask
#define    _PMC_IER_LOCKB       (0x1<< 2)      //   PLL B Status/Enable/Disable/Mask
#define    _PMC_IER_MCKRDY      (0x1<< 3)      //   MCK_RDY Status/Enable/Disable/Mask
#define    _PMC_IER_PCK0RDY     (0x1<< 8)      //   PCK0_RDY Status/Enable/Disable/Mask
#define    _PMC_IER_PCK1RDY     (0x1<< 9)      //   PCK1_RDY Status/Enable/Disable/Mask
#define    _PMC_IER_PCK2RDY     (0x1<<10)      //   PCK2_RDY Status/Enable/Disable/Mask
#define    _PMC_IER_PCK3RDY     (0x1<<11)      //   PCK3_RDY Status/Enable/Disable/Mask
#define    _PMC_IER_PCK4RDY     (0x1<<12)      //   PCK4_RDY Status/Enable/Disable/Mask
#define    _PMC_IER_PCK5RDY     (0x1<<13)      //   PCK5_RDY Status/Enable/Disable/Mask
#define    _PMC_IER_PCK6RDY     (0x1<<14)      //   PCK6_RDY Status/Enable/Disable/Mask
#define    _PMC_IER_PCK7RDY     (0x1<<15)      //   PCK7_RDY Status/Enable/Disable/Mask
#define _PMC_IDR         (AT91RM9200_PMC+0x64)   // Interrupt Disable Register
#define _PMC_SR          (AT91RM9200_PMC+0x68)   // Status Register
#define    _PMC_SR_MCKRDY       (0x1<<3)       // Master clock ready
#define _PMC_IMR         (AT91RM9200_PMC+0x6C)   // Interrupt Mask Register

// Memory controller (MC) and External Bus Interface (EBI)
#define _MC_RCR          (AT91RM9200_MC+0x00)    // Remap Control Register
#define    _MC_RCR_RCB          (0x1<< 0)      //   Remap Command Bit
#define _MC_ASR          (AT91RM9200_MC+0x04)    // Abort Status Register
#define    _MC_ASR_UNDADD       (0x1<< 0)      //    Undefined Addess Abort Status
#define    _MC_ASR_MISADD       (0x1<< 1)      //    Misaligned Addess Abort Status
#define    _MC_ASR_MPU          (0x1<< 2)      //    Memory protection Unit Abort Status
#define    _MC_ASR_ABTSZ        (0x3<< 8)      //    Abort Size Status
#define       _MC_ASR_ABTSZ_BYTE    (0x0<< 8)  //      Byte
#define       _MC_ASR_ABTSZ_HWORD   (0x1<< 8)  //      Half-word
#define       _MC_ASR_ABTSZ_WORD    (0x2<< 8)  //      Word
#define    _MC_ASR_ABTTYP       (0x3<<10)      //    Abort Type Status
#define       _MC_ASR_ABTTYP_DATAR  (0x0<<10)  //      Data Read
#define       _MC_ASR_ABTTYP_DATAW  (0x1<<10)  //      Data Write
#define       _MC_ASR_ABTTYP_FETCH  (0x2<<10)  //      Code Fetch
#define    _MC_ASR_MST0         (0x1<<16)      //    Master 0 Abort Source
#define    _MC_ASR_MST1         (0x1<<17)      //    Master 1 Abort Source
#define    _MC_ASR_SVMST0       (0x1<<24)      //    Saved Master 0 Abort Source
#define    _MC_ASR_SVMST1       (0x1<<25)      //    Saved Master 1 Abort Source
#define _MC_AASR         (AT91RM9200_MC+0x08)    // Abort Address Status Register
#define _MC_PUIA01       (AT91RM9200_MC+0x10)    // Protection Unit Area
#define    _MC_PUIA_PROT         (0x3<< 0)     //    Protection
#define       _MC_PUIA_PROT_PNAUNA     (0x0)     //      Privilege: No Access, User: No Access
#define       _MC_PUIA_PROT_PRWUNA     (0x1)     //      Privilege: Read/Write, User: No Access
#define       _MC_PUIA_PROT_PRWURO     (0x2)     //      Privilege: Read/Write, User: Read Only
#define       _MC_PUIA_PROT_PRWURW     (0x3)     //      Privilege: Read/Write, User: Read/Write
#define    _MC_PUIA_SIZE         (0xF<< 4)     //    Internal Area Size
#define       _MC_PUIA_SIZE_1KB    (0x0<< 4)   //      Area size 1KByte
#define       _MC_PUIA_SIZE_2KB    (0x1<< 4)   //      Area size 2KByte
#define       _MC_PUIA_SIZE_4KB    (0x2<< 4)   //      Area size 4KByte
#define       _MC_PUIA_SIZE_8KB    (0x3<< 4)   //      Area size 8KByte
#define       _MC_PUIA_SIZE_16KB   (0x4<< 4)   //      Area size 16KByte
#define       _MC_PUIA_SIZE_32KB   (0x5<< 4)   //      Area size 32KByte
#define       _MC_PUIA_SIZE_64KB   (0x6<< 4)   //      Area size 64KByte
#define       _MC_PUIA_SIZE_128KB  (0x7<< 4)   //      Area size 128KByte
#define       _MC_PUIA_SIZE_256KB  (0x8<< 4)   //      Area size 256KByte
#define       _MC_PUIA_SIZE_512KB  (0x9<< 4)   //      Area size 512KByte
#define       _MC_PUIA_SIZE_1MB    (0xA<< 4)   //      Area size 1MByte
#define       _MC_PUIA_SIZE_2MB    (0xB<< 4)   //      Area size 2MByte
#define       _MC_PUIA_SIZE_4MB    (0xC<< 4)   //      Area size 4MByte
#define       _MC_PUIA_SIZE_8MB    (0xD<< 4)   //      Area size 8MByte
#define       _MC_PUIA_SIZE_16MB   (0xE<< 4)   //      Area size 16MByte
#define       _MC_PUIA_SIZE_64MB   (0xF<< 4)   //      Area size 64MByte
#define    _MC_PUIA_BA       (0x3FFFF<<10)     //    Internal Area Base Address
#define _MC_PUIA02       (AT91RM9200_MC+0x14)    // Protection Unit Area
#define _MC_PUIA03       (AT91RM9200_MC+0x18)    // Protection Unit Area
#define _MC_PUIA04       (AT91RM9200_MC+0x1C)    // Protection Unit Area
#define _MC_PUIA05       (AT91RM9200_MC+0x20)    // Protection Unit Area
#define _MC_PUIA06       (AT91RM9200_MC+0x24)    // Protection Unit Area
#define _MC_PUIA07       (AT91RM9200_MC+0x28)    // Protection Unit Area
#define _MC_PUIA08       (AT91RM9200_MC+0x2C)    // Protection Unit Area
#define _MC_PUIA09       (AT91RM9200_MC+0x30)    // Protection Unit Area
#define _MC_PUIA10       (AT91RM9200_MC+0x34)    // Protection Unit Area
#define _MC_PUIA11       (AT91RM9200_MC+0x38)    // Protection Unit Area
#define _MC_PUIA12       (AT91RM9200_MC+0x3C)    // Protection Unit Area
#define _MC_PUIA13       (AT91RM9200_MC+0x40)    // Protection Unit Area
#define _MC_PUIA14       (AT91RM9200_MC+0x44)    // Protection Unit Area
#define _MC_PUIA15       (AT91RM9200_MC+0x48)    // Protection Unit Area
#define _MC_PUIA16       (AT91RM9200_MC+0x48)    // Protection Unit Area
#define _MC_PUP          (AT91RM9200_MC+0x50)    // Protection Unit Peripherals
#define _MC_PUER         (AT91RM9200_MC+0x54)    // Protection Unit Enable Register
#define    _MC_PUER_PUEB         (0x1<< 0)     //    Protection Unit enable Bit

#define _EBI_CSA         (AT91RM9200_MC+0x60)    // Chip Select Assignment Register
#define    _EBI_CSA_CS0A        (0x1<< 0)      //   Chip Select 0 Assignment
#define       _EBI_CSA_CS0A_SMC            (0x0) //   Chip Select 0 is assigned to the Static Memory Controller.
#define       _EBI_CSA_CS0A_BFC            (0x1) //   Chip Select 0 is assigned to the Burst Flash Controller.
#define    _EBI_CSA_CS1A        (0x1<< 1)      //   Chip Select 1 Assignment
#define       _EBI_CSA_CS1A_SMC      (0x0<< 1) //   Chip Select 1 is assigned to the Static Memory Controller.
#define       _EBI_CSA_CS1A_SDRAMC   (0x1<< 1) //   Chip Select 1 is assigned to the SDRAM Controller.
#define    _EBI_CSA_CS3A        (0x1<< 3)      //   Chip Select 3 Assignment
#define       _EBI_CSA_CS3A_SMC      (0x0<< 3) //   Chip Select 3 is only assigned to the Static Memory Controller and NCS3 behaves as defined by the SMC2.
#define       _EBI_CSA_CS3A_SMC_SmartMedia  (0x1<< 3) //   Chip Select 3 is assigned to the Static Memory Controller and the SmartMedia Logic is activated.
#define   _EBI_CSA_CS4A        (0x1<< 4)       //   Chip Select 4 Assignment
#define       _EBI_CSA_CS4A_SMC      (0x0<< 4) //   Chip Select 4 is assigned to the Static Memory Controller and NCS4,NCS5 and NCS6 behave as defined by the SMC2.
#define       _EBI_CSA_CS4A_SMC_CompactFlash (0x1<< 4) //   Chip Select 4 is assigned to the Static Memory Controller and the CompactFlash Logic is activated.
#define _EBI_CFGR        (AT91RM9200_MC+0x64)    // Configuration Register
#define    _EBI_CFGR_DBPUC       (0x1<< 0)     //   Data Bus Pull-Up Configuration
#define    _EBI_CFGR_EBSEN       (0x1<< 1)     //   Bus Sharing Enable
#define _EBI_SMC2_CSR0   (AT91RM9200_MC+0x70)    // SMC2 Chip Select Register
#define _EBI_SMC2_CSR1   (AT91RM9200_MC+0x74)    // SMC2 Chip Select Register
#define _EBI_SMC2_CSR2   (AT91RM9200_MC+0x78)    // SMC2 Chip Select Register
#define _EBI_SMC2_CSR3   (AT91RM9200_MC+0x7C)    // SMC2 Chip Select Register
#define _EBI_SMC2_CSR4   (AT91RM9200_MC+0x80)    // SMC2 Chip Select Register
#define _EBI_SMC2_CSR5   (AT91RM9200_MC+0x84)    // SMC2 Chip Select Register
#define _EBI_SMC2_CSR6   (AT91RM9200_MC+0x88)    // SMC2 Chip Select Register
#define _EBI_SMC2_CSR7   (AT91RM9200_MC+0x8C)    // SMC2 Chip Select Register
#define _EBI_SDRC_MR     (AT91RM9200_MC+0x90)    // SDRAM Controller Mode Register
#define    _EBI_SDRC_MR_MODE       (0xF<< 0)   //   Mode
#define       _EBI_SDRC_MR_MODE_NORMAL_CMD (0x0) //     Normal Mode
#define       _EBI_SDRC_MR_MODE_NOP_CMD    (0x1) //     NOP Command
#define       _EBI_SDRC_MR_MODE_PRCGALL_CMD (0x2)//     All Banks Precharge Command
#define       _EBI_SDRC_MR_MODE_LMR_CMD    (0x3) //     Load Mode Register Command
#define       _EBI_SDRC_MR_MODE_RFSH_CMD   (0x4) //     Refresh Command
#define    _EBI_SDRC_MR_DBW        (0x1<< 4)   //   Data Bus Width
#define       _EBI_SDRC_MR_DBW_32_BITS  (0x0<<4) //     32 Bits datas bus
#define       _EBI_SDRC_MR_DBW_16_BITS  (0x1<<4) //     16 Bits datas bus
#define _EBI_SDRC_TR     (AT91RM9200_MC+0x94)    // SDRAM Controller Refresh Timer Register
#define _EBI_SDRC_CR     (AT91RM9200_MC+0x98)    // SDRAM Controller Configuration Register 
#define    _EBI_SDRC_CR_NC         (0x3<< 0)   //   Number of Column Bits
#define       _EBI_SDRC_CR_NC_8            (0x0) //     8 Bits
#define       _EBI_SDRC_CR_NC_9            (0x1) //     9 Bits
#define       _EBI_SDRC_CR_NC_10           (0x2) //     10 Bits
#define       _EBI_SDRC_CR_NC_11           (0x3) //     11 Bits
#define    _EBI_SDRC_CR_NR         (0x3<< 2)   //   Number of Row Bits
#define       _EBI_SDRC_CR_NR_11     (0x0<< 2) //     11 Bits
#define       _EBI_SDRC_CR_NR_12     (0x1<< 2) //     12 Bits
#define       _EBI_SDRC_CR_NR_13     (0x2<< 2) //     13 Bits
#define    _EBI_SDRC_CR_NB         (0x1<< 4)   //   Number of Banks
#define       _EBI_SDRC_CR_NB_2_BANKS (0x0<<4) //     2 banks
#define       _EBI_SDRC_CR_NB_4_BANKS (0x1<<4) //     4 banks
#define    _EBI_SDRC_CR_CAS        (0x3<< 5)   //   CAS Latency
#define       _EBI_SDRC_CR_CAS_2     (0x2<< 5) //     2 cycles
#define    _EBI_SDRC_CR_TWR        (0xF<< 7)   //   Number of Write Recovery Time Cycles
#define    _EBI_SDRC_CR_TRC        (0xF<<11)   //   Number of RAS Cycle Time Cycles
#define    _EBI_SDRC_CR_TRP        (0xF<<15)   //   Number of RAS Precharge Time Cycles
#define    _EBI_SDRC_CR_TRCD       (0xF<<19)   //   Number of RAS to CAS Delay Cycles
#define    _EBI_SDRC_CR_TRAS       (0xF<<23)   //   Number of RAS Active Time Cycles
#define    _EBI_SDRC_CR_TXSR       (0xF<<27)   //   Number of Command Recovery Time Cycles
#define _EBI_SDRC_SRR    (AT91RM9200_MC+0x9C)    // SDRAM Controller Self Refresh Register
#define    _EBI_SDRC_SRR_SRCB       (0x1<< 0)  //   Self-refresh Command Bit
#define _EBI_SDRC_LPR    (AT91RM9200_MC+0xA0)    // SDRAM Controller Low Power Register
#define    _EBI_SDRC_LPR_LPCB       (0x1<< 0)  //   Low-power Command Bit
#define _EBI_SDRC_IER    (AT91RM9200_MC+0xA4)    // SDRAM Controller Interrupt Enable Register
#define    _EBI_SDRC_IER_RES        (0x1<< 0)  //   Refresh Error Status
#define _EBI_SDRC_IDR    (AT91RM9200_MC+0xA8)    // SDRAM Controller Interrupt Disable Register
#define _EBI_SDRC_IMR    (AT91RM9200_MC+0xAC)    // SDRAM Controller Interrupt Mask Register
#define _EBI_SDRC_ISR    (AT91RM9200_MC+0xB0)    // SDRAM Controller Interrupt Mask Register
#define _EBI_BFC_MR      (AT91RM9200_MC+0xC0)    // BFC Mode Register

//=============================================================================
// Parallel I/O (PIO) (offsets only because there are more than one)
#define _PIO_PER    0x00  // PIO Enable Register
#define _PIO_PDR    0x04  // PIO Disable Register
#define _PIO_PSR    0x08  // PIO Status Register
#define _PIO_OER    0x10  // Output Enable Register
#define _PIO_ODR    0x14  // Output Disable Registerr
#define _PIO_OSR    0x18  // Output Status Register
#define _PIO_IFER   0x20  // Input Filter Enable Register
#define _PIO_IFDR   0x24  // Input Filter Disable Register
#define _PIO_IFSR   0x28  // Input Filter Status Register
#define _PIO_SODR   0x30  // Set Output Data Register
#define _PIO_CODR   0x34  // Clear Output Data Register
#define _PIO_ODSR   0x38  // Output Data Status Register
#define _PIO_PDSR   0x3C  // Pin Data Status Register
#define _PIO_IER    0x40  // Interrupt Enable Register
#define _PIO_IDR    0x44  // Interrupt Disable Register
#define _PIO_IMR    0x48  // Interrupt Mask Register
#define _PIO_ISR    0x4C  // Interrupt Status Register
#define _PIO_MDER   0x50  // Multi-driver Enable Register
#define _PIO_MDDR   0x54  // Multi-driver Disable Register
#define _PIO_MDSR   0x58  // Multi-driver Status Register
#define _PIO_PUDR   0x60  // Pull-up Disable Register
#define _PIO_PUER   0x64  // Pull-up Enable Register
#define _PIO_PUSR   0x68  // Pad Pull-up Status Register
#define _PIO_ASR    0x70  // Select A Register
#define _PIO_BSR    0x74  // Select B Register
#define _PIO_ABSR   0x78  // AB Select Status Register
#define _PIO_OWER   0x80  // Output Write Enable Register
#define _PIO_OWDR   0x84  // Output Write Disable Register
#define _PIO_OWSR   0x88  // Output Write Status Register

// Incorrect register names, preserved for compatibility
#define _PIO_PPUDR  0x60  // Pull-up Disable Register
#define _PIO_PPUER  0x64  // Pull-up Enable Register
#define _PIO_PPUSR  0x68  // Pad Pull-up Status Register

//=============================================================================
// UART (offsets only because there are more than one)
#define _UART_CR            0x0000  // Control register
#define    _UART_CR_RSTRX    (0x1<< 2) // Reset Receiver
#define    _UART_CR_RSTTX    (0x1<< 3) // Reset Transmitter
#define    _UART_CR_RXEN     (0x1<< 4) // Receiver Enable
#define    _UART_CR_RXDIS    (0x1<< 5) // Receiver Disable
#define    _UART_CR_TXEN     (0x1<< 6) // Transmitter Enable
#define    _UART_CR_TXDIS    (0x1<< 7) // Transmitter Disable
#define    _UART_CR_RSTSTA   (0x1<< 8) // Reset Status Bits
#define    _UART_CR_STTBRK   (0x1<< 9) // Start Break
#define    _UART_CR_STPBRK   (0x1<<10) // Stop Break
#define    _UART_CR_STTTO    (0x1<<11) // Start Time-out
#define    _UART_CR_SENDA    (0x1<<12) // Send Address
#define    _UART_CR_RSTIT    (0x1<<13) // Reset Iterations
#define    _UART_CR_RSTNACK  (0x1<<14) // Reset Non Acknowledge
#define    _UART_CR_RETTO    (0x1<<15) // Rearm Time-out
#define    _UART_CR_DTREN    (0x1<<16) // Data Terminal ready Enable
#define    _UART_CR_DTRDIS   (0x1<<17) // Data Terminal ready Disable
#define    _UART_CR_RTSEN    (0x1<<18) // Request to Send enable
#define    _UART_CR_RTSDIS   (0x1<<19) // Request to Send Disable
#define _UART_MR            0x0004  // Mode register
#define    _UART_MR_USMODE       (0xF<< 0) // Usart mode
#define       _UART_MR_USMODE_NORMAL     (0x0) // Normal
#define       _UART_MR_USMODE_RS485      (0x1) // RS485
#define       _UART_MR_USMODE_HWHSH      (0x2) // Hardware Handshaking
#define       _UART_MR_USMODE_MODEM      (0x3) // Modem
#define       _UART_MR_USMODE_ISO7816_0  (0x4) // ISO7816 protocol: T = 0
#define       _UART_MR_USMODE_ISO7816_1  (0x6) // ISO7816 protocol: T = 1
#define       _UART_MR_USMODE_IRDA       (0x8) // IrDA
#define       _UART_MR_USMODE_SWHSH      (0xC) // Software Handshaking
#define    _UART_MR_CLKS         (0x3<< 4) // Clock Selection (Baud Rate generator Input Clock
#define       _UART_MR_CLKS_CLOCK        (0x0<< 4) // Clock
#define       _UART_MR_CLKS_FDIV1        (0x1<< 4) // fdiv1
#define       _UART_MR_CLKS_SLOW         (0x2<< 4) // slow_clock (ARM)
#define       _UART_MR_CLKS_EXT          (0x3<< 4) // External (SCK)
#define    _UART_MR_CHRL         (0x3<< 6) // Clock Selection (Baud Rate generator Input Clock
#define       _UART_MR_CHRL_5_BITS       (0x0<< 6) // Character Length: 5 bits
#define       _UART_MR_CHRL_6_BITS       (0x1<< 6) // Character Length: 6 bits
#define       _UART_MR_CHRL_7_BITS       (0x2<< 6) // Character Length: 7 bits
#define       _UART_MR_CHRL_8_BITS       (0x3<< 6) // Character Length: 8 bits
#define    _UART_MR_SYNC         (0x1<< 8) // Synchronous Mode Select
#define    _UART_MR_PAR          (0x7<< 9) // Parity type
#define       _UART_MR_PAR_EVEN          (0x0<< 9) // Even Parity
#define       _UART_MR_PAR_ODD           (0x1<< 9) // Odd Parity
#define       _UART_MR_PAR_SPACE         (0x2<< 9) // Parity forced to 0 (Space)
#define       _UART_MR_PAR_MARK          (0x3<< 9) // Parity forced to 1 (Mark)
#define       _UART_MR_PAR_NONE          (0x4<< 9) // No Parity
#define       _UART_MR_PAR_MULTI_DROP    (0x6<< 9) // Multi-drop mode
#define    _UART_MR_NBSTOP       (0x3<<12) // Number of Stop bits
#define       _UART_MR_NBSTOP_1_BIT      (0x0<<12) // 1 stop bit
#define       _UART_MR_NBSTOP_15_BIT     (0x1<<12) // Asynchronous (SYNC=0) 2 stop bits 
                                                   // Synchronous (SYNC=1) 2 stop bits
#define       _UART_MR_NBSTOP_2_BIT      (0x2<<12) // 2 stop bits
#define    _UART_MR_CHMODE       (0x3<<14) // Channel Mode
#define       _UART_MR_CHMODE_NORMAL     (0x0<<14) // Normal Mode: The USART channel operates as an RX/TX USART.
#define       _UART_MR_CHMODE_AUTO       (0x1<<14) // Automatic Echo: Rx Data Input is connected to the TXD pin.
#define       _UART_MR_CHMODE_LOCAL      (0x2<<14) // Local Loopback: Tx Output is connected to Rx Input
#define       _UART_MR_CHMODE_REMOTE     (0x3<<14) // Remote Loopback: RXD pin is internally connected to TXD pin.
#define    _UART_MR_MSBF         (0x1<<16) // Bit Order
#define    _UART_MR_MODE9        (0x1<<17) // 9-bit Character length
#define    _UART_MR_CKLO         (0x1<<18) // Clock Output Select
#define    _UART_MR_OVER         (0x1<<19) // Over Sampling Mode
#define    _UART_MR_INACK        (0x1<<20) // Inhibit Non Acknowledge
#define    _UART_MR_DSNACK       (0x1<<21) // Disable Successive NACK
#define    _UART_MR_MAX_ITER     (0x1<<24) // Number of Repetitions
#define    _UART_MR_FILTER       (0x1<<28) // Receive Line Filter
#define _UART_IER           0x0008  // Interrupt enable
#define _UART_IDR           0x000C  // Interrupt diable
#define _UART_IMR           0x0010  // Interrupt mask
#define    _UART_IER_RXRDY        (0x1<< 0) // RXRDY Interrupt
#define    _UART_IER_TXRDY        (0x1<< 1) // TXRDY Interrupt
#define    _UART_IER_RXBRK        (0x1<< 2) // Break Received/End of Break
#define    _UART_IER_ENDRX        (0x1<< 3) // End of Receive Transfer Interrupt
#define    _UART_IER_ENDTX        (0x1<< 4) // End of Transmit Interrupt
#define    _UART_IER_OVRE         (0x1<< 5) // Overrun Interrupt
#define    _UART_IER_FRAME        (0x1<< 6) // Framing Error Interrupt
#define    _UART_IER_PARE         (0x1<< 7) // Parity Error Interrupt
#define    _UART_IER_TIMEOUT      (0x1<< 8) // Receiver Time-out
#define    _UART_IER_TXEMPTY      (0x1<< 9) // TXEMPTY Interrupt
#define    _UART_IER_ITERATION    (0x1<<10) // Max number of Repetitions Reached
#define    _UART_IER_TXBUFE       (0x1<<11) // TXBUFE Interrupt
#define    _UART_IER_RXBUFF       (0x1<<12) // RXBUFF Interrupt
#define    _UART_IER_NACK         (0x1<<13) // Non Acknowledge
#define    _UART_IER_RIIC         (0x1<<16) // Ring INdicator Input Change Flag
#define    _UART_IER_DSRIC        (0x1<<17) // Data Set Ready Input Change Flag
#define    _UART_IER_DCDIC        (0x1<<18) // Data Carrier Flag
#define    _UART_IER_CTSIC        (0x1<<19) // Clear To Send Input Change Flag
#define    _UART_IER_COMM_TX      (0x1<<30) // COMM_TX Interrupt
#define    _UART_IER_COMM_RX      (0x1<<31) // COMM_RX Interrupt
#define _UART_CSR           0x0014  // Status
#define    _UART_CSR_CTS      (1<<23)
#define    _UART_CSR_DCD      (1<<22)
#define    _UART_CSR_DSR      (1<<21)
#define    _UART_CSR_RI       (1<<20)
#define    _UART_CSR_CTSIC    (1<<19)
#define    _UART_CSR_DCDIC    (1<<18)
#define    _UART_CSR_DSRIC    (1<<17)
#define    _UART_CSR_RIIC     (1<<16)
#define    _UART_CSR_NACK     (1<<13)
#define    _UART_CSR_RxBUFF   (1<<12)
#define    _UART_CSR_TxBUFE   (1<<11)
#define    _UART_CSR_ITER     (1<<10)
#define    _UART_CSR_TxEMPTY   (1<<9)
#define    _UART_CSR_TIMEOUT   (1<<8)
#define    _UART_CSR_PARE      (1<<7)
#define    _UART_CSR_FRAME     (1<<6)
#define    _UART_CSR_OVRE      (1<<5)
#define    _UART_CSR_ENDTx     (1<<4)
#define    _UART_CSR_ENDRx     (1<<3)
#define    _UART_CSR_RxBRK     (1<<2)
#define    _UART_CSR_TxRDY     (1<<1)
#define    _UART_CSR_RxRDY     (1<<0)
#define _UART_RHR           0x0018  // Receiver holding register
#define _UART_THR           0x001C  // Transmitter holding register
#define _UART_BRG           0x0020  // Baud rate generator
#define _UART_RTO           0x0024  // Receiver time-out
#define _UART_TTG           0x0028  // Transmit timeguard
#define _UART_FRR           0x0040  // FI/DI ratio
#define _UART_NER           0x0044  // Error counter
#define _UART_IF            0x004C  // IrDA filter

//=============================================================================
// The following are aliases of the UART definitions for the benefit
// of the AT91 serial device driver.

#define AT91_DEBUG      AT91RM9200_DEBUG
#define AT91_USART0     AT91RM9200_UART0
#define AT91_USART1     AT91RM9200_UART1
#define AT91_USART2     AT91RM9200_UART2
#define AT91_USART3     AT91RM9200_UART3

#define AT91_US_CR  _UART_CR
#define AT91_US_CR_RxRESET (1<<2)
#define AT91_US_CR_TxRESET (1<<3)
#define AT91_US_CR_RxENAB  (1<<4)
#define AT91_US_CR_RxDISAB (1<<5)
#define AT91_US_CR_TxENAB  (1<<6)
#define AT91_US_CR_TxDISAB (1<<7)
#define AT91_US_CR_RSTATUS (1<<8)
#define AT91_US_CR_STTTO   (1<<11)
#define AT91_US_CR_RTSEN   (1<<18)
#define AT91_US_CR_RTSDIS  (1<<19)
#define AT91_US_MR  _UART_MR  // Mode register
#define AT91_US_MR_USMODE 0      // USART mode
#define AT91_US_MR_USMODE_NORMAL      _UART_MR_USMODE_NORMAL     // Normal
#define AT91_US_MR_USMODE_RS485       _UART_MR_USMODE_RS485      // RS485
#define AT91_US_MR_USMODE_HWHSH       _UART_MR_USMODE_HWHSH      // Hardware Handshaking
#define AT91_US_MR_USMODE_MODEM       _UART_MR_USMODE_MODEM      // Modem
#define AT91_US_MR_USMODE_ISO7816_0   _UART_MR_USMODE_ISO7816_0  // ISO7816 protocol: T = 0
#define AT91_US_MR_USMODE_ISO7816_1   _UART_MR_USMODE_ISO7816_1  // ISO7816 protocol: T = 1
#define AT91_US_MR_USMODE_IRDA        _UART_MR_USMODE_IRDA       // IrDA
#define AT91_US_MR_CLOCK   4
#define AT91_US_MR_CLOCK_MCK  (0<<AT91_US_MR_CLOCK)
#define AT91_US_MR_CLOCK_MCK8 (1<<AT91_US_MR_CLOCK)
#define AT91_US_MR_CLOCK_SCK  (2<<AT91_US_MR_CLOCK)
#define AT91_US_MR_LENGTH  6
#define AT91_US_MR_LENGTH_5   (0<<AT91_US_MR_LENGTH)
#define AT91_US_MR_LENGTH_6   (1<<AT91_US_MR_LENGTH)
#define AT91_US_MR_LENGTH_7   (2<<AT91_US_MR_LENGTH)
#define AT91_US_MR_LENGTH_8   (3<<AT91_US_MR_LENGTH)
#define AT91_US_MR_SYNC    8
#define AT91_US_MR_SYNC_ASYNC (0<<AT91_US_MR_SYNC)
#define AT91_US_MR_SYNC_SYNC  (1<<AT91_US_MR_SYNC)
#define AT91_US_MR_PARITY  9
#define AT91_US_MR_PARITY_EVEN  (0<<AT91_US_MR_PARITY)
#define AT91_US_MR_PARITY_ODD   (1<<AT91_US_MR_PARITY)
#define AT91_US_MR_PARITY_SPACE (2<<AT91_US_MR_PARITY)
#define AT91_US_MR_PARITY_MARK  (3<<AT91_US_MR_PARITY)
#define AT91_US_MR_PARITY_NONE  (4<<AT91_US_MR_PARITY)
#define AT91_US_MR_PARITY_MULTI (6<<AT91_US_MR_PARITY)
#define AT91_US_MR_STOP   12
#define AT91_US_MR_STOP_1       (0<<AT91_US_MR_STOP)
#define AT91_US_MR_STOP_1_5     (1<<AT91_US_MR_STOP)
#define AT91_US_MR_STOP_2       (2<<AT91_US_MR_STOP)
#define AT91_US_MR_MODE   14
#define AT91_US_MR_MODE_NORMAL  (0<<AT91_US_MR_MODE)
#define AT91_US_MR_MODE_ECHO    (1<<AT91_US_MR_MODE)
#define AT91_US_MR_MODE_LOCAL   (2<<AT91_US_MR_MODE)
#define AT91_US_MR_MODE_REMOTE  (3<<AT91_US_MR_MODE)
#define AT91_US_MR_MODE9  17
#define AT91_US_MR_CLKO   18
#define AT91_US_IER _UART_IER  // Interrupt enable register
#define AT91_US_IER_RxRDY   (1<<0)  // Receive data ready
#define AT91_US_IER_TxRDY   (1<<1)  // Transmitter ready
#define AT91_US_IER_RxBRK   (1<<2)  // Break received
#define AT91_US_IER_ENDRX   (1<<3)  // Rx end
#define AT91_US_IER_ENDTX   (1<<4)  // Tx end
#define AT91_US_IER_OVRE    (1<<5)  // Rx overflow
#define AT91_US_IER_FRAME   (1<<6)  // Rx framing error
#define AT91_US_IER_PARITY  (1<<7)  // Rx parity
#define AT91_US_IER_TIMEOUT (1<<8)  // Rx timeout
#define AT91_US_IER_TxEMPTY (1<<9)  // Tx empty
#define AT91_US_IDR _UART_IDR  // Interrupt disable register
#define AT91_US_IMR _UART_IMR  // Interrupt mask register
#define AT91_US_CSR _UART_CSR  // Channel status register
#define AT91_US_CSR_RxRDY 0x01 // Receive data ready
#define AT91_US_CSR_TxRDY 0x02 // Transmit ready
#define AT91_US_CSR_OVRE  0x20 // Overrun error
#define AT91_US_CSR_FRAME 0x40 // Framing error
#define AT91_US_RHR _UART_RHR  // Receive holding register
#define AT91_US_THR _UART_THR  // Transmit holding register
#define AT91_US_BRG _UART_BRG  // Baud rate generator
#define AT91_US_RTO _UART_RTO  // Receive time out
#define AT91_US_TTG _UART_TTG  // Transmit timer guard
#define AT91_US_RPR 0x100      // Receive pointer register
#define AT91_US_RCR 0x104      // Receive counter register
#define AT91_US_TPR 0x108      // Transmit pointer register
#define AT91_US_TCR 0x10C      // Transmit counter register
#define AT91_US_RNPR 0x110      // Receive pointer register
#define AT91_US_RNCR 0x114      // Receive counter register
#define AT91_US_PTCR 0x120     // Transfer control register

#define AT91_US_BAUD(n) (((CYGARC_HAL_ARM_ARM9_AT91RM9200_MCK)/16)/n)

#define CYGNUM_HAL_INTERRUPT_USART0 CYGNUM_HAL_INTERRUPT_US0
#define CYGNUM_HAL_INTERRUPT_USART1 CYGNUM_HAL_INTERRUPT_US1
#define CYGNUM_HAL_INTERRUPT_USART2 CYGNUM_HAL_INTERRUPT_US2
#define CYGNUM_HAL_INTERRUPT_USART3 CYGNUM_HAL_INTERRUPT_US3

// The following macros are also used by the SPI and MMC drivers
#define AT91_PDC_RX_ENABLE( __base ) HAL_WRITE_UINT32( (__base)+AT91_US_PTCR, 0x0001 )
#define AT91_PDC_RX_DISABLE( __base ) HAL_WRITE_UINT32( (__base)+AT91_US_PTCR, 0x0002 )
#define AT91_PDC_TX_ENABLE( __base ) HAL_WRITE_UINT32( (__base)+AT91_US_PTCR, 0x0100 )
#define AT91_PDC_TX_DISABLE( __base ) HAL_WRITE_UINT32( (__base)+AT91_US_PTCR, 0x0200 )

//=============================================================================
// MultiMedia Card Interface (MCI)

#define _MCI_CR                        (AT91RM9200_MCI+0x00)
#define    _MCI_CR_MCIEN                  (1<<0)
#define    _MCI_CR_MCIDIS                 (1<<1)
#define    _MCI_CR_PWSEN                  (1<<2)
#define    _MCI_CR_PWSDIS                 (1<<3)
#define    _MCI_CR_SWRST                  (1<<7)
#define _MCI_MR                        (AT91RM9200_MCI+0x04)
#define    _MCI_MR_CLKDIV(__mr)           ((__mr) & 0xff)
#define    _MCI_MR_PWSDIV(__mr)           (((__mr)>>8) & 0x7)
#define    _MCI_MR_PWSDIV_SET(__pws)      (((__pws)& 0x7) << 8)
#define    _MCI_MR_PDCPADV                (1<<14)
#define    _MCI_MR_PDCMODE                (1<<15)
#define    _MCI_MR_BLKLEN(__mr)           (((__mr) >> 16) & 0x3fff)
#define    _MCI_MR_BLKLEN_SET(__blklen)   (((__blklen) & 0x3fff) << 16)
#define _MCI_DTOR                      (AT91RM9200_MCI+0x08)
#define    _MCI_DTOR_DTOCYC(__dtor)       ((__dtor) & 0xf)
#define    _MCI_DTOR_DTOMUL_1             (0 << 4)
#define    _MCI_DTOR_DTOMUL_16            (1 << 4)
#define    _MCI_DTOR_DTOMUL_128           (2 << 4)
#define    _MCI_DTOR_DTOMUL_256           (3 << 4)
#define    _MCI_DTOR_DTOMUL_1024          (4 << 4)
#define    _MCI_DTOR_DTOMUL_4096          (5 << 4)
#define    _MCI_DTOR_DTOMUL_65536         (6 << 4)
#define    _MCI_DTOR_DTOMUL_1048576       (7 << 4)
#define _MCI_SDCR                      (AT91RM9200_MCI+0x0C)
#define    _MCI_SDCR_SDCSEL_A             (0)
#define    _MCI_SDCR_SDCSEL_B             (1)
#define    _MCI_SDCBUS_1BIT               (0 << 7)
#define    _MCI_SDCBUS_4BIT               (1 << 7)
#define _MCI_ARGR                      (AT91RM9200_MCI+0x10)
#define _MCI_CMDR                      (AT91RM9200_MCI+0x14)
#define    _MCI_CMDR_CMDNB(__cmdr)        ((__cmdr) & 0x3f)
#define    _MCI_CMDR_RSPTYP_N             (0 << 6)
#define    _MCI_CMDR_RSPTYP_48            (1 << 6)
#define    _MCI_CMDR_RSPTYP_136           (2 << 6)
#define    _MCI_CMDR_SPCMD_N              (0 << 8)
#define    _MCI_CMDR_SPCMD_INIT           (1 << 8)
#define    _MCI_CMDR_SPCMD_SYNC           (2 << 8)
#define    _MCI_CMDR_SPCMD_INTC           (4 << 8)
#define    _MCI_CMDR_SPCMD_INTR           (5 << 8)
#define    _MCI_CMDR_OPDCMD               (1 << 11)
#define    _MCI_CMDR_MAXLAT_5             (0 << 12)
#define    _MCI_CMDR_MAXLAT_64            (1 << 12)
#define    _MCI_CMDR_TRCMD_N              (0 << 16)
#define    _MCI_CMDR_TRCMD_START          (1 << 16)
#define    _MCI_CMDR_TRCMD_STOP           (2 << 16)
#define    _MCI_CMDR_TRDIR_WRITE          (0 << 18)
#define    _MCI_CMDR_TRDIR_READ           (1 << 18)
#define    _MCI_CMDR_TRTYPE_BLOCK         (0 << 19)
#define    _MCI_CMDR_TRTYPE_MBLOCK        (1 << 19)
#define    _MCI_CMDR_TRTYPE_STREAM        (2 << 19)
#define _MCI_RSPR                      (AT91RM9200_MCI+0x20)
#define _MCI_RSPR1                     (AT91RM9200_MCI+0x24)
#define _MCI_RSPR2                     (AT91RM9200_MCI+0x28)
#define _MCI_RSPR3                     (AT91RM9200_MCI+0x2C)
#define _MCI_RDR                       (AT91RM9200_MCI+0x30)
#define _MCI_TDR                       (AT91RM9200_MCI+0x34)
#define _MCI_SR                        (AT91RM9200_MCI+0x40)
#define    _MCI_SR_CMDRDY                 (1 << 0)
#define    _MCI_SR_RXRDY                  (1 << 1)
#define    _MCI_SR_TXRDY                  (1 << 2)
#define    _MCI_SR_BLKE                   (1 << 3)
#define    _MCI_SR_DTIP                   (1 << 4)
#define    _MCI_SR_NOTBUSY                (1 << 5)
#define    _MCI_SR_ENDRX                  (1 << 6)
#define    _MCI_SR_ENDTX                  (1 << 7)
#define    _MCI_SR_RXBUFF                 (1 << 14)
#define    _MCI_SR_TXBUFE                 (1 << 15)
#define    _MCI_SR_RINDE                  (1 << 16)
#define    _MCI_SR_RDIRE                  (1 << 17)
#define    _MCI_SR_RCRCE                  (1 << 18)
#define    _MCI_SR_RENDE                  (1 << 19)
#define    _MCI_SR_RTOE                   (1 << 20)
#define    _MCI_SR_DCRCE                  (1 << 21)
#define    _MCI_SR_DTOE                   (1 << 22)
#define    _MCI_SR_OVRE                   (1 << 30)
#define    _MCI_SR_UNRE                   (1 << 31)
#define _MCI_IER                       (AT91RM9200_MCI+0x44)
#define _MCI_IDR                       (AT91RM9200_MCI+0x48)
#define _MCI_IMR                       (AT91RM9200_MCI+0x4C)

// PDC registers for MCI
#define _MCI_PDC_RPR           0x100             // Receive Pointer Register
#define _MCI_PDC_RCR           0x104             // Receive Counter Register
#define _MCI_PDC_TPR           0x108             // Transmit Pointer Register
#define _MCI_PDC_TCR           0x10C             // Transmit Counter Register
#define _MCI_PDC_PTCR          0x120             // Transfer control register

//=============================================================================
// Two Wire Interface

#define _TWI_CR                 (AT91RM9200_TWI+0x00)
#define    _TWI_CR_START        (1<<0)
#define    _TWI_CR_STOP         (1<<1)
#define    _TWI_CR_MSEN         (1<<2)
#define    _TWI_CR_MDIS         (1<<3)
#define    _TWI_CR_SWRST        (1<<7)
#define _TWI_MMR                (AT91RM9200_TWI+0x04)
#define    _TWI_MMR_IADRSZ_0    (0<<8)
#define    _TWI_MMR_IADRSZ_1    (1<<8)
#define    _TWI_MMR_IADRSZ_2    (2<<8)
#define    _TWI_MMR_IADRSZ_3    (3<<8)
#define    _TWI_MMR_MREAD       (1<<12)
#define    _TWI_MMR_DADR(__daddr)    (((__daddr)&0x7f)<<16)
#define _TWI_IADR               (AT91RM9200_TWI+0x0c)
#define _TWI_CWGR               (AT91RM9200_TWI+0x10)
#define    _TWI_CWGR_CLDIV(__cldiv)  (((__cldiv)&0xff)<<0)
#define    _TWI_CWGR_CHDIV(__chdiv)  (((__chdiv)&0xff)<<8)
#define    _TWI_CWGR_CKDIV(__ckdiv)  (((__ckdiv)&0x7)<<16)
#define _TWI_SR                 (AT91RM9200_TWI+0x20)
#define    _TWI_SR_TXCOMP       (1<<0)
#define    _TWI_SR_RXRDY        (1<<1)
#define    _TWI_SR_TXRDY        (1<<2)
#define    _TWI_SR_OVRE         (1<<6)
#define    _TWI_SR_UNRE         (1<<7)
#define    _TWI_SR_NACK         (1<<8)
#define _TWI_IER                (AT91RM9200_TWI+0x24)
#define _TWI_IDR                (AT91RM9200_TWI+0x28)
#define _TWI_IMR                (AT91RM9200_TWI+0x2c)
#define _TWI_RHR                (AT91RM9200_TWI+0x30)
#define _TWI_THR                (AT91RM9200_TWI+0x34)

//=============================================================================
// Ethernet

#define _ETH_CTL            *((volatile unsigned long *)(AT91RM9200_EMAC+0x0000))  // Control register
#define    _ETH_CTL_BP         (1<<8)
#define    _ETH_CTL_WES        (1<<7)
#define    _ETH_CTL_ISR        (1<<6)
#define    _ETH_CTL_CSR        (1<<5)
#define    _ETH_CTL_MPE        (1<<4)
#define    _ETH_CTL_TE         (1<<3)
#define    _ETH_CTL_RE         (1<<2)
#define    _ETH_CTL_LBL        (1<<1)
#define    _ETH_CTL_LB         (1<<0)
#define _ETH_CFG            *((volatile unsigned long *)(AT91RM9200_EMAC+0x0004))  // Configuration register
#define    _ETH_CFG_RMII       (1<<13)
#define    _ETH_CFG_RTY        (1<<12)
#define    _ETH_CFG_CLK        (3<<10)
#define      _ETH_CFG_CLK_8      (0<<10)
#define      _ETH_CFG_CLK_16     (1<<10)
#define      _ETH_CFG_CLK_32     (2<<10)
#define      _ETH_CFG_CLK_64     (3<<10)
#define    _ETH_CFG_EAE         (1<<9)
#define    _ETH_CFG_BIG         (1<<8)
#define    _ETH_CFG_UNI         (1<<7)
#define    _ETH_CFG_MTI         (1<<6)
#define    _ETH_CFG_NBC         (1<<5)
#define    _ETH_CFG_CAF         (1<<4)
#define    _ETH_CFG_BR          (1<<2)
#define    _ETH_CFG_FD          (1<<1)
#define    _ETH_CFG_SPD         (1<<0)
#define _ETH_SR             *((volatile unsigned long *)(AT91RM9200_EMAC+0x0008))  // Status 
#define    _ETH_SR_IDLE         (1<<2)
#define    _ETH_SR_MDIO         (1<<1)
#define    _ETH_SR_LINK         (1<<0)
#define _ETH_TAR            *((volatile unsigned long *)(AT91RM9200_EMAC+0x000C))  // Transmit [buffer] address
#define _ETH_TCR            *((volatile unsigned long *)(AT91RM9200_EMAC+0x0010))  // Transmit control
#define    _ETH_TCR_NCRC       (1<<15)
#define _ETH_TSR            *((volatile unsigned long *)(AT91RM9200_EMAC+0x0014))  // Transmit status
#define    _ETH_TSR_UND         (1<<6)
#define    _ETH_TSR_COMP        (1<<5)
#define    _ETH_TSR_BNQ         (1<<4)
#define    _ETH_TSR_IDLE        (1<<3)
#define    _ETH_TSR_RLE         (1<<2)
#define    _ETH_TSR_COL         (1<<1)
#define    _ETH_TSR_OVR         (1<<0)
#define _ETH_RBQ            *((volatile unsigned long *)(AT91RM9200_EMAC+0x0018))  // Receive buffer queue
#define _ETH_RSR            *((volatile unsigned long *)(AT91RM9200_EMAC+0x0020))  // Receive status
#define    _ETH_RSR_OVR         (1<<2)
#define    _ETH_RSR_REC         (1<<1)
#define    _ETH_RSR_BNA         (1<<0)
#define _ETH_ISR            *((volatile unsigned long *)(AT91RM9200_EMAC+0x0024))  // Interrupt status
#define    _ETH_ISR_ABT        (1<<11)
#define    _ETH_ISR_ROVR       (1<<10)
#define    _ETH_ISR_LINK        (1<<9)
#define    _ETH_ISR_TIDLE       (1<<8)
#define    _ETH_ISR_TCOM        (1<<7)
#define    _ETH_ISR_TBRE        (1<<6)
#define    _ETH_ISR_RTRY        (1<<5)
#define    _ETH_ISR_TUND        (1<<4)
#define    _ETH_ISR_TOVR        (1<<3)
#define    _ETH_ISR_RBNA        (1<<2)
#define    _ETH_ISR_RCOM        (1<<1)
#define    _ETH_ISR_DONE        (1<<0)
#define _ETH_IER            *((volatile unsigned long *)(AT91RM9200_EMAC+0x0028))  // Interrupt enable
#define _ETH_IDR            *((volatile unsigned long *)(AT91RM9200_EMAC+0x002C))  // Interrupt disable
#define _ETH_IMR            *((volatile unsigned long *)(AT91RM9200_EMAC+0x0030))  // Interrupt mask
#define _ETH_PHY            *((volatile unsigned long *)(AT91RM9200_EMAC+0x0034))  // PHY (MII) access
#define _ETH_HASH           *((volatile unsigned long *)(AT91RM9200_EMAC+0x0090))  // Address hash
#define _ETH_ESA1H          *((volatile unsigned long *)(AT91RM9200_EMAC+0x0098))  // Station address #1
#define _ETH_ESA1L          *((volatile unsigned long *)(AT91RM9200_EMAC+0x009C))  // Station address #1
#define _ETH_ESA2           *((volatile unsigned long *)(AT91RM9200_EMAC+0x00A0))  // Station address #2
#define _ETH_ESA3           *((volatile unsigned long *)(AT91RM9200_EMAC+0x00A8))  // Station address #3
#define _ETH_ESA4           *((volatile unsigned long *)(AT91RM9200_EMAC+0x00B0))  // Station address #4

//=============================================================================
// System timer
#define _ST_CR     (AT91RM9200_ST+0x00) // Control Register
#define    _ST_CR_WDRST     (0x1<< 0) // Watchdog Timer Restart
#define _ST_PIMR   (AT91RM9200_ST+0x04) // Period Interval Mode Register
#define _ST_WDMR   (AT91RM9200_ST+0x08) // Watchdog Mode Register
#define    _ST_WDMR_RSTEN   (0x1<<16) // Reset Enable
#define    _ST_WDMR_EXTEN   (0x1<<17) // External Signal Assertion Enable
#define _ST_RTMR   (AT91RM9200_ST+0x0C) // Real-time Mode Register
#define _ST_SR     (AT91RM9200_ST+0x10) // Status Register
#define    _ST_SR_PITS      (0x1<< 0) // Period Interval Timer Interrupt
#define    _ST_SR_WDOVF     (0x1<< 1) // Watchdog Overflow
#define    _ST_SR_RTTINC    (0x1<< 2) // Real-time Timer Increment
#define    _ST_SR_ALMS      (0x1<< 3) // Alarm Status
#define _ST_IER    (AT91RM9200_ST+0x14) // Interrupt Enable Register
#define _ST_IDR    (AT91RM9200_ST+0x18) // Interrupt Disable Register
#define _ST_IMR    (AT91RM9200_ST+0x1C) // Interrupt Mask Register
#define _ST_RTAR   (AT91RM9200_ST+0x20) // Real-time Alarm Register
#define _ST_CRTR   (AT91RM9200_ST+0x24) // Current Real-time Register

//=============================================================================
// Real Time Controller

#define _RTC_CR         (AT91RM9200_RTC+0x00)
#define    _RTC_CR_UPDTIM             (0x1<< 0)  // Update request time register
#define    _RTC_CR_UPDCAL             (0x1<< 1)  // Update request calendar register
#define    _RTC_CR_TIMEVSEL_MIN       (0x0<< 8)  // Minute is used for TIMEV
#define    _RTC_CR_TIMEVSEL_HOUR      (0x1<< 8)  // Hour is used for TIMEV
#define    _RTC_CR_TIMEVSEL_MIDNIGHT  (0x2<< 8)  // Midnight is used for TIMEV
#define    _RTC_CR_TIMEVSEL_NOON      (0x3<< 8)  // Noon is used for TIMEV
#define    _RTC_CR_CALVSEL_WEEK       (0x0<<16)  // Week is used for CALEV
#define    _RTC_CR_CALVSEL_MONTH      (0x1<<16)  // Month is used for CALEV
#define    _RTC_CR_CALVSEL_YEAR       (0x2<<16)  // Year is used for CALEV
#define _RTC_MR         (AT91RM9200_RTC+0x04)
#define    _RTC_MR_HRMOD              (0x1<< 0)  // 24-hour time=0, 12-hour time=1
#define _RTC_TIMR       (AT91RM9200_RTC+0x08)
#define    _RTC_TIMR_SEC_SHIFT        (0)        // Shift offset of seconds
#define    _RTC_TIMR_MIN_SHIFT        (8)        // Shift offset of minutes
#define    _RTC_TIMR_HOUR_SHIFT       (16)       // Shift offset of hours
#define    _RTC_TIMR_AMPM             (0x1<<22)  // AM=0, PM=1
#define _RTC_CALR       (AT91RM9200_RTC+0x0c)
#define    _RTC_CALR_CENT_SHIFT       (0)        // Shift offset of century
#define    _RTC_CALR_YEAR_SHIFT       (8)        // Shift offset of year
#define    _RTC_CALR_MONTH_SHIFT      (16)       // Shift offset of month
#define    _RTC_CALR_DAY_SHIFT        (21)       // Shift offset of day
#define    _RTC_CALR_DATE_SHIFT       (24)       // Shift offset of date
#define _RTC_TIMALR     (AT91RM9200_RTC+010)
#define    _RTC_TIMALR_SEC_SHIFT      (0)        // Shift offset of seconds
#define    _RTC_TIMALR_MIN_SHIFT      (8)        // Shift offset of minutes
#define    _RTC_TIMALR_HOUR_SHIFT     (16)       // Shift offset of hours
#define    _RTC_TIMALR_SECEN          (0x1<<7)   // Enable second alarm
#define    _RTC_TIMALR_MINEN          (0x1<<15)  // Enable minute alarm
#define    _RTC_TIMALR_AMPM           (0x1<<22)  // AM=0, PM=1
#define    _RTC_TIMALR_HOUREN         (0x1<<23)  // Enable hour alarm
#define _RTC_CALALR     (AT91RM9200_RTC+0x14)
#define    _RTC_CALALR_MONTH_SHIFT    (16)       // Shift offset of month
#define    _RTC_CALALR_DATE_SHIFT     (24)       // Shift offset of date
#define    _RTC_CALALR_MTHEN          (0x1<<23)  // Enable month alarm
#define    _RTC_CALALR_DATEEN         (0x1<<31)  // Enable date alarm
#define _RTC_SR         (AT91RM9200_RTC+0x18)
#define    _RTC_SR_ACKUPD             (0x1<< 0)  // Ack for update
#define    _RTC_SR_ALARM              (0x1<< 1)  // Alarm flag
#define    _RTC_SR_SEC                (0x1<< 2)  // Second event
#define    _RTC_SR_TIMEV              (0x1<< 3)  // Time event
#define    _RTC_SR_CALEV              (0x1<< 4)  // Calendar event
#define _RTC_SCCR       (AT91RM9200_RTC+0x1c)    // subfields same as _RTC_SR
#define _RTC_IER        (AT91RM9200_RTC+0x20)    // subfields same as _RTC_SR
#define _RTC_IDR        (AT91RM9200_RTC+0x24)    // subfields same as _RTC_SR
#define _RTC_IMR        (AT91RM9200_RTC+0x28)    // subfields same as _RTC_SR
#define _RTC_VER        (AT91RM9200_RTC+0x2c)
#define    _RTC_VER_NVTIM             (0x1<< 0)  // Last programmed _RTC_TIMR invalid
#define    _RTC_VER_NVCAL             (0x1<< 1)  // Last programmed _RTC_CALR invalid
#define    _RTC_VER_NVTIMALR          (0x1<< 2)  // Last programmed _RTC_TIMALR invalid
#define    _RTC_VER_NVCALALR          (0x1<< 3)  // Last programmed _RTC_CALALR invalid

//=============================================================================
// Timer Counters - offsets within a timer/counter block
#define _TC_CCR    0x0000   // Channel control register
#define    _TC_CCR_CLKEN        (0x1<< 0) // Counter Clock Enable Command
#define    _TC_CCR_CLKDIS       (0x1<< 1) // Counter Clock Disable Command
#define    _TC_CCR_SWTRG        (0x1<< 2) // Software Trigger Command
#define _TC_CMR    0x0004   // Channel mode register
#define    _TC_CMR_CPCSTOP      (0x1<< 6) // Counter Clock Stopped with RC Compare
#define    _TC_CMR_CPCDIS       (0x1<< 7) // Counter Clock Disable with RC Compare
#define    _TC_CMR_EEVTEDG      (0x3<< 8) // External Event Edge Selection
#define       _TC_CMR_EEVTEDG_NONE     (0x0<< 8) // Edge: None
#define       _TC_CMR_EEVTEDG_RISING   (0x1<< 8) // Edge: rising edge
#define       _TC_CMR_EEVTEDG_FALLING  (0x2<< 8) // Edge: falling edge
#define       _TC_CMR_EEVTEDG_BOTH     (0x3<< 8) // Edge: each edge
#define    _TC_CMR_EEVT         (0x3<<10) // External Event  Selection
#define       _TC_CMR_EEVT_NONE     (0x0<<10) // Signal selected as external event: TIOB TIOB direction: input
#define       _TC_CMR_EEVT_RISING   (0x1<<10) // Signal selected as external event: XC0 TIOB direction: output
#define       _TC_CMR_EEVT_FALLING  (0x2<<10) // Signal selected as external event: XC1 TIOB direction: output
#define       _TC_CMR_EEVT_BOTH     (0x3<<10) // Signal selected as external event: XC2 TIOB direction: output
#define    _TC_CMR_ENETRG       (0x1<<12) // External Event Trigger enable
#define    _TC_CMR_WAVESEL      (0x3<<13) // Waveform  Selection
#define       _TC_CMR_WAVESEL_UP       (0x0<<13) // UP mode without atomatic trigger on RC Compare
#define       _TC_CMR_WAVESEL_UP_AUTO  (0x2<<13) // UP mode with automatic trigger on RC Compare
#define       _TC_CMR_WAVESEL_UPDOWN   (0x1<<13) // UPDOWN mode without automatic trigger on RC Compare
#define       _TC_CMR_WAVESEL_UPDOWN_AUTO          (0x3<<13) // UPDOWN mode with automatic trigger on RC Compare
#define    _TC_CMR_CPCTRG       (0x1<<14) // RC Compare Trigger Enable
#define    _TC_CMR_WAVE         (0x1<<15) // 
#define    _TC_CMR_ACPA         (0x3<<16) // RA Compare Effect on TIOA
#define       _TC_CMR_ACPA_NONE     (0x0<<16) // Effect: none
#define       _TC_CMR_ACPA_SET      (0x1<<16) // Effect: set
#define       _TC_CMR_ACPA_CLEAR    (0x2<<16) // Effect: clear
#define       _TC_CMR_ACPA_TOGGLE   (0x3<<16) // Effect: toggle
#define    _TC_CMR_ACPC         (0x3<<18) // RC Compare Effect on TIOA
#define       _TC_CMR_ACPC_NONE     (0x0<<18) // Effect: none
#define       _TC_CMR_ACPC_SET      (0x1<<18) // Effect: set
#define       _TC_CMR_ACPC_CLEAR    (0x2<<18) // Effect: clear
#define       _TC_CMR_ACPC_TOGGLE   (0x3<<18) // Effect: toggle
#define    _TC_CMR_AEEVT        (0x3<<20) // External Event Effect on TIOA
#define       _TC_CMR_AEEVT_NONE     (0x0<<20) // Effect: none
#define       _TC_CMR_AEEVT_SET      (0x1<<20) // Effect: set
#define       _TC_CMR_AEEVT_CLEAR    (0x2<<20) // Effect: clear
#define       _TC_CMR_AEEVT_TOGGLE   (0x3<<20) // Effect: toggle
#define    _TC_CMR_ASWTRG       (0x3<<22) // Software Trigger Effect on TIOA
#define       _TC_CMR_ASWTRG_NONE     (0x0<<22) // Effect: none
#define       _TC_CMR_ASWTRG_SET      (0x1<<22) // Effect: set
#define       _TC_CMR_ASWTRG_CLEAR    (0x2<<22) // Effect: clear
#define       _TC_CMR_ASWTRG_TOGGLE   (0x3<<22) // Effect: toggle
#define    _TC_CMR_BCPB         (0x3<<24) // RB Compare Effect on TIOB
#define       _TC_CMR_BCPB_NONE     (0x0<<24) // Effect: none
#define       _TC_CMR_BCPB_SET      (0x1<<24) // Effect: set
#define       _TC_CMR_BCPB_CLEAR    (0x2<<24) // Effect: clear
#define       _TC_CMR_BCPB_TOGGLE   (0x3<<24) // Effect: toggle
#define    _TC_CMR_BCPC         (0x3<<26) // RC Compare Effect on TIOB
#define       _TC_CMR_BCPC_NONE     (0x0<<26) // Effect: none
#define       _TC_CMR_BCPC_SET      (0x1<<26) // Effect: set
#define       _TC_CMR_BCPC_CLEAR    (0x2<<26) // Effect: clear
#define       _TC_CMR_BCPC_TOGGLE   (0x3<<26) // Effect: toggle
#define    _TC_CMR_BEEVT        (0x3<<28) // External Event Effect on TIOB
#define       _TC_CMR_BEEVT_NONE     (0x0<<28) // Effect: none
#define       _TC_CMR_BEEVT_SET      (0x1<<28) // Effect: set
#define       _TC_CMR_BEEVT_CLEAR    (0x2<<28) // Effect: clear
#define       _TC_CMR_BEEVT_TOGGLE   (0x3<<28) // Effect: toggle
#define    _TC_CMR_BSWTRG       (0x3<<30) // Software Trigger Effect on TIOB
#define       _TC_CMR_BSWTRG_NONE     (0x0<<30) // Effect: none
#define       _TC_CMR_BSWTRG_SET      (0x1<<30) // Effect: set
#define       _TC_CMR_BSWTRG_CLEAR    (0x2<<30) // Effect: clear
#define       _TC_CMR_BSWTRG_TOGGLE   (0x3<<30) // Effect: toggle
#define _TC_CV     0x0010   // Channel counter value
#define _TC_RA     0x0014   // Channel register A
#define _TC_RB     0x0018   // Channel register B
#define _TC_RC     0x001C   // Channel register C
#define _TC_SR     0x0020   // Channel status register
#define    _TC_SR_COVFS        (0x1<< 0) // Counter Overflow
#define    _TC_SR_LOVRS        (0x1<< 1) // Load Overrun
#define    _TC_SR_CPAS         (0x1<< 2) // RA Compare
#define    _TC_SR_CPBS         (0x1<< 3) // RB Compare
#define    _TC_SR_CPCS         (0x1<< 4) // RC Compare
#define    _TC_SR_LDRAS        (0x1<< 5) // RA Loading
#define    _TC_SR_LDRBS        (0x1<< 6) // RB Loading
#define    _TC_SR_ETRCS        (0x1<< 7) // External Trigger
#define    _TC_SR_ETRGS        (0x1<<16) // Clock Enabling
#define    _TC_SR_MTIOA        (0x1<<17) // TIOA Mirror
#define    _TC_SR_MTIOB        (0x1<<18) // TIOA Mirror
#define _TC_IER    0x0024   // Channel interrupt enable
#define _TC_IDR    0x0028   // Channel interrupt disable
#define _TC_IMR    0x002C   // Channel interrupt mask
#define _TCB_BCR   0x00C0   // Block control register
#define    _TCB_BCR_SYNC        (0x1<< 0) // (TCB) Synchro Command
#define _TCB_BMR   0x00C4   // Block mode register
#define    _TCB_BMR_TC0XC0S     (0x1<< 0) // (TCB) External Clock Signal 0 Selection
#define       _TCB_BMR_TC0XC0S_TCLK0    (0x0) // (TCB) TCLK0 connected to XC0
#define       _TCB_BMR_TC0XC0S_NONE     (0x1) // (TCB) None signal connected to XC0
#define       _TCB_BMR_TC0XC0S_TIOA1    (0x2) // (TCB) TIOA1 connected to XC0
#define       _TCB_BMR_TC0XC0S_TIOA2    (0x3) // (TCB) TIOA2 connected to XC0
#define    _TCB_BMR_TC1XC1S     (0x1<< 2) // (TCB) External Clock Signal 1 Selection
#define       _TCB_BMR_TC1XC1S_TCLK1    (0x0<< 2) // (TCB) TCLK1 connected to XC1
#define       _TCB_BMR_TC1XC1S_NONE     (0x1<< 2) // (TCB) None signal connected to XC1
#define       _TCB_BMR_TC1XC1S_TIOA0    (0x2<< 2) // (TCB) TIOA0 connected to XC1
#define       _TCB_BMR_TC1XC1S_TIOA2    (0x3<< 2) // (TCB) TIOA2 connected to XC1
#define    _TCB_BMR_TC2XC2S     (0x1<< 4) // (TCB) External Clock Signal 2 Selection
#define       _TCB_BMR_TC2XC2S_TCLK2    (0x0<< 4) // (TCB) TCLK2 connected to XC2
#define       _TCB_BMR_TC2XC2S_NONE     (0x1<< 4) // (TCB) None signal connected to XC2
#define       _TCB_BMR_TC2XC2S_TIOA0    (0x2<< 4) // (TCB) TIOA0 connected to XC2
#define       _TCB_BMR_TC2XC2S_TIOA2    (0x3<< 4) // (TCB) TIOA2 connected to XC2

//=============================================================================
// SPI device
//
// These are named to correspond to the names used in the SPI driver.

#ifndef AT91_SPI
#define AT91_SPI               0xFFFE0000
#endif

#define AT91_SPI_CR            0x00              // Control Register 
#define AT91_SPI_CR_SPIEN      0x00000001        // SPI Enable
#define AT91_SPI_CR_SPIDIS     0x00000002        // SPI Disable
#define AT91_SPI_CR_SWRST      0x00000080        // SPI Software reset
#define AT91_SPI_MR            0x04              // Mode Register
#define AT91_SPI_MR_MSTR       0x00000001        // Master/Slave Mode 
#define AT91_SPI_MR_PS         0x00000002        // Peripheral Select
#define AT91_SPI_MR_PCSDEC     0x00000004        // Chip Select Decode
#define AT91_SPI_MR_DIV32      0x00000008        // Clock Selection 
#define AT91_SPI_MR_MODFDIS    0x00000010        // Mode fault disable
#define AT91_SPI_MR_LLB        0x00000080        // Local Loopback Enable
#define AT91_SPI_MR_PCS(x)     (((x)&0x0F)<<16)  // Peripheral Chip Select
#define AT91_SPI_MR_DLYBCS(x)  (((x)&0xFF)<<24)  // Delay Between Chip Selects
#define AT91_SPI_RDR           0x08              // Receive Data Register
#define AT91_SPI_TDR           0x0C              // Transmit Data Register
#define AT91_SPI_SR            0x10              // Status Register
#define AT91_SPI_SR_RDRF       0x00000001        // Receive Data Register Full
#define AT91_SPI_SR_TDRE       0x00000002        // Transmit Data Register Empty
#define AT91_SPI_SR_MODF       0x00000004        // Mode Fault Error
#define AT91_SPI_SR_OVRES      0x00000008        // Overrun Error Status
#define AT91_SPI_SR_ENDRX      0x00000010        // End of Receiver Transfer
#define AT91_SPI_SR_ENDTX      0x00000020        // End of Transmitter Transfer
#define AT91_SPI_SR_SPIENS     0x00010000        // SPI Enable Status
#define AT91_SPI_IER           0x14              // Interrupt Enable Register
#define AT91_SPI_IDR           0x18              // Interrupt Disable Register
#define AT91_SPI_IMR           0x1C              // Interrupt Mask Register
#define AT91_SPI_CSR0          0x30              // Chip Select Register 0
#define AT91_SPI_CSR1          0x34              // Chip Select Register 1
#define AT91_SPI_CSR2          0x38              // Chip Select Register 2
#define AT91_SPI_CSR3          0x3C              // Chip Select Register 3
#define AT91_SPI_CSR_CPOL      0x00000001        // Clock Polarity
#define AT91_SPI_CSR_NCPHA     0x00000002        // Clock Phase
#define AT91_SPI_CSR_BITS(x)   (((x)&0x0F)<<4)   // Bits Per Transfer
#define AT91_SPI_CSR_BITS8     AT91_SPI_CSR_BITS(0)
#define AT91_SPI_CSR_BITS9     AT91_SPI_CSR_BITS(1)
#define AT91_SPI_CSR_BITS10    AT91_SPI_CSR_BITS(2)
#define AT91_SPI_CSR_BITS11    AT91_SPI_CSR_BITS(3)
#define AT91_SPI_CSR_BITS12    AT91_SPI_CSR_BITS(4)
#define AT91_SPI_CSR_BITS13    AT91_SPI_CSR_BITS(5)
#define AT91_SPI_CSR_BITS14    AT91_SPI_CSR_BITS(6)
#define AT91_SPI_CSR_BITS15    AT91_SPI_CSR_BITS(7)
#define AT91_SPI_CSR_BITS16    AT91_SPI_CSR_BITS(8)
#define AT91_SPI_CSR_SCBR(x)   (((x)&0xFF)<<8)   // Serial Clock Baud Rate 
#define AT91_SPI_CSR_DLYBS(x)  (((x)&0xFF)<<16)  // Delay Before SPCK
#define AT91_SPI_CSR_DLYBCT(x) (((x)&0xFF)<<24)  // Delay Between two transfers


#define AT91_SPI_RPR           0x100             // Receive Pointer Register
#define AT91_SPI_RCR           0x104             // Receive Counter Register
#define AT91_SPI_TPR           0x108             // Transmit Pointer Register
#define AT91_SPI_TCR           0x10C             // Transmit Counter Register
#define AT91_SPI_PTCR          0x120             // Transfer control register


// SPI pins are controlled from PIOA
#define AT91_SPI_PIO            AT91RM9200_PIOA
#define AT91_PIO_PSR_MISO       (1<<0)
#define AT91_PIO_PSR_MOSI       (1<<1)
#define AT91_PIO_PSR_SPCK       (1<<2)
#define AT91_SPI_PIO_NPCS(x)    (((x)&0x0F)<<3)

// SPI device clock is controlled by bit 13 in PMC PCER.
#define AT91_PMC_PCER_SPI       (1<<13)

/*---------------------------------------------------------------------------*/

#ifndef __ASSEMBLER__

#include <cyg/infra/cyg_type.h>

__externC void _at91rm9200_hardware_init(void);
__externC int _csb337_i2c_write_reg(int addr, int reg, unsigned char val);
__externC int _csb337_i2c_read_reg(int addr, int reg);

#endif

/*---------------------------------------------------------------------------*/
/* end of at91rm9200.h                                                          */
#endif /* CYGONCE_AT91RM9200_H */
