#ifndef CYGONCE_DEVS_ATMEL_AT91RM9200_KITS_ETH_INL
#define CYGONCE_DEVS_ATMEL_AT91RM9200_KITS_ETH_INL
//==========================================================================
//
//      atmel-at91rm9200-kits-eth.inl
//
//      Hardware specifics for Atmel AT91RM9200-DK/EK board ethernet support
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005 Free Software Foundation, Inc.
// Copyright (C) 2003, 2004, 2005 eCosCentric Limited                       
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    eCosCentric
// Contributors: eCosCentric
// Date:         2004-12-10
// Purpose:      
// Description:  Based on KB9200 ethernet driver.
//              
//####DESCRIPTIONEND####
//
//==========================================================================

#include <cyg/hal/atmel-at91rm9200-kits.h>

#include CYGDAT_DEVS_AT91RM9200_ETH_CDL

#ifdef CYGPKG_HAL_ARM_ARM9_ATMEL_AT91RM9200_KITS_ETH0

#if 0
#include <cyg/io/eth_phy_dev.h>
// The default phy init in if_at91rm9200.c is empty, but we want to reset the phy
// in case of a JTAG reset.
// This doesn't work though. I can't seem to talk to the PHY at all after JTAG
// reset, even to reset it :-(.

static void
at91rm9200_kits_eth_phy_init(void)
{
    unsigned short bmcr;

    _ETH_CFG |= _ETH_CFG_RMII;
    at91rm9200_eth_phy_put_reg( PHY_BMCR, 0, PHY_BMCR_RESET );
    do {
        at91rm9200_eth_phy_get_reg( PHY_BMCR, 0, &bmcr );
    } while( (bmcr & PHY_BMCR_RESET) == 1 );

} // at91rm9200_kits_eth_phy_init()
#endif

ETH_PHY_REG_LEVEL_ACCESS_FUNS(eth0_phy, 
                              at91rm9200_eth_phy_init,
                              NULL,
                              at91rm9200_eth_phy_put_reg,
                              at91rm9200_eth_phy_get_reg);

// Align buffers on a cache boundary
#define RxBUFSIZE CYGNUM_DEVS_ETH_ARM_AT91RM9200_RxNUM*CYGNUM_DEVS_ETH_ARM_AT91RM9200_BUFSIZE
#define TxBUFSIZE CYGNUM_DEVS_ETH_ARM_AT91RM9200_TxNUM*CYGNUM_DEVS_ETH_ARM_AT91RM9200_BUFSIZE
#if 0
// These buffers are not actually used. Instead they are allocated explicitly in the on-chip
// SRAM at ATMEL_AT91RM9200_KITS_SRAM_VIRT_BASE. This is because the buffers themselves work
// best in SRAM, and the RX buffer descriptor table must be aligned on a 64byte boundary.
// The SRAM is 16k, which is enough for 2 Tx buffers, 8 Rx Buffers plus the RX descriptor table,
// but not much else.
static unsigned char at91rm9200_eth_rxbufs[RxBUFSIZE] __attribute__((aligned(HAL_DCACHE_LINE_SIZE)));
static unsigned char at91rm9200_eth_txbufs[TxBUFSIZE] __attribute__((aligned(HAL_DCACHE_LINE_SIZE)));
static bd_t at91rm9200_eth_rxbd[CYGNUM_DEVS_ETH_ARM_AT91RM9200_RxNUM] __attribute__((aligned(HAL_DCACHE_LINE_SIZE)));
#endif
static bd_t at91rm9200_eth_txbd[CYGNUM_DEVS_ETH_ARM_AT91RM9200_TxNUM] __attribute__((aligned(HAL_DCACHE_LINE_SIZE)));

static struct at91rm9200_eth_info at91rm9200_eth0_info = {
    0, // Interrupt vector
    "eth0_esa",
    { 0x00, 0x23, 0x31, 0x37, 0x00, 0x1C},                             // Default ESA
    CYGNUM_DEVS_ETH_ARM_AT91RM9200_RxNUM,                              // Number of Rx buffers
    (unsigned char *)(ATMEL_AT91RM9200_KITS_SRAM_VIRT_BASE+0x0D00),    // Rx buffer space in SRAM
    (bd_t *)(ATMEL_AT91RM9200_KITS_SRAM_VIRT_BASE+0x0000),             // Rx buffer headers in SRAM
    CYGNUM_DEVS_ETH_ARM_AT91RM9200_TxNUM,                              // Number of Tx buffers
    (unsigned char *)(ATMEL_AT91RM9200_KITS_SRAM_VIRT_BASE+0x0100),    // Tx buffer space in SRAM
    at91rm9200_eth_txbd,                                               // Tx buffer headers
    &eth0_phy,                                                         // PHY access routines
};

ETH_DRV_SC(at91rm9200_eth0_sc,
           &at91rm9200_eth0_info,  // Driver specific data
           "eth0",                 // Name for this interface
           at91rm9200_eth_start,
           at91rm9200_eth_stop,
           at91rm9200_eth_control,
           at91rm9200_eth_can_send,
           at91rm9200_eth_send,
           at91rm9200_eth_recv,
           at91rm9200_eth_deliver,
           at91rm9200_eth_int,
           at91rm9200_eth_int_vector);

NETDEVTAB_ENTRY(at91rm9200_netdev, 
                "at91rm9200_eth", 
                at91rm9200_eth_init, 
                &at91rm9200_eth0_sc);

// Not connected with full MII interface - instead RMII.
// So export this to main driver.
#define ETH_PHY_USES_RMII 1

#ifdef CYGPKG_REDBOOT
#include <pkgconf/redboot.h>
#ifdef CYGSEM_REDBOOT_FLASH_CONFIG
#include <redboot.h>
#include <flash_config.h>
RedBoot_config_option("Network hardware address [MAC]",
                      eth0_esa,
                      ALWAYS_ENABLED, true,
                      CONFIG_ESA, &at91rm9200_eth0_info.enaddr
    );
#endif // CYGSEM_REDBOOT_FLASH_CONFIG
#endif // CYGPKG_REDBOOT

#endif // CYGPKG_HAL_ARM_ARM9_ATMEL_AT91RM9200_KITS_ETH0

#endif  // CYGONCE_DEVS_ATMEL_AT91RM9200_KITS_ETH_INL
// ------------------------------------------------------------------------
