#ifndef CYGONCE_HAL_PLF_IO_H
#define CYGONCE_HAL_PLF_IO_H
//=============================================================================
//
//      plf_io.h
//
//      Platform specific registers
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2004 Free Software Foundation, Inc.
// Copyright (C) 2004 eCosCentric Limited                                   
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   nickg
// Contributors:nickg
// Date:        2004-07-05
// Purpose:     ARM/MX1ADS_A platform specific registers
// Description: 
// Usage:       #include <cyg/hal/plf_io.h>
//
//####DESCRIPTIONEND####
//
//=============================================================================

#include <cyg/hal/mx1ads_a.h>

//-----------------------------------------------------------------------------
// Address space translation macros


#ifndef CYG_HAL_STARTUP_SRAM

#define CYGARC_PHYSICAL_ADDRESS(_x_)                                    \
({ CYG_ADDRWORD _p = (CYG_ADDRWORD)(_x_);                               \
 if (_p >= MX1ADS_A_SDRAM_VIRT_BASE &&                                  \
     _p < (MX1ADS_A_SDRAM_VIRT_BASE+MX1ADS_A_SDRAM_SIZE))               \
     _p = (_p & MX1ADS_A_SDRAM_MASK) + MX1ADS_A_SDRAM_PHYS_BASE;        \
 else if (_p >= MX1ADS_A_DEVS_VIRT_BASE &&                              \
          _p < (MX1ADS_A_DEVS_VIRT_BASE+MX1ADS_A_DEVS_SIZE))            \
     _p = (_p & MX1ADS_A_DEVS_MASK) + MX1ADS_A_DEVS_PHYS_BASE;          \
 _p; })

#define CYGARC_VIRTUAL_ADDRESS(_x_)                                     \
({ CYG_ADDRWORD _p = (CYG_ADDRWORD)(_x_);                               \
 if (_p >= MX1ADS_A_SDRAM_PHYS_BASE &&                                  \
     _p < (MX1ADS_A_SDRAM_PHYS_BASE+MX1ADS_A_SDRAM_SIZE))               \
     _p = (_p & MX1ADS_A_SDRAM_MASK) + MX1ADS_A_SDRAM_VIRT_BASE;        \
 else if (_p >= MX1ADS_A_DEVS_PHYS_BASE &&                              \
          _p < (MX1ADS_A_DEVS_PHYS_BASE+MX1ADS_A_DEVS_SIZE))            \
     _p = (_p & MX1ADS_A_DEVS_MASK) + MX1ADS_A_DEVS_VIRT_BASE;          \
 _p; })

#define CYGARC_UNCACHED_ADDRESS(_x_)                                    \
({ CYG_ADDRWORD _p = (CYG_ADDRWORD)(_x_);                               \
 if (_p >= MX1ADS_A_SDRAM_VIRT_BASE &&                                  \
     _p < (MX1ADS_A_SDRAM_VIRT_BASE+MX1ADS_A_SDRAM_SIZE))               \
     _p = (_p & MX1ADS_A_SDRAM_MASK) + MX1ADS_A_SDRAM_UNCACHED_BASE;    \
 else if (_p >= MX1ADS_A_FLASH_VIRT_BASE &&                             \
          _p < (MX1ADS_A_FLASH_VIRT_BASE+MX1ADS_A_FLASH_SIZE))          \
     _p = (_p & MX1ADS_A_FLASH_MASK) + MX1ADS_A_FLASH_UNCACHED_BASE;    \
 _p; })

#else

#define CYGARC_PHYSICAL_ADDRESS(_x_) (_x_)

#define CYGARC_VIRTUAL_ADDRESS(_x_) (_x_)

#define CYGARC_UNCACHED_ADDRESS(_x_) (_x_)

#endif // CYG_HAL_STARTUP_SRAM

//-----------------------------------------------------------------------------
// end of plf_io.h
#endif // CYGONCE_HAL_PLF_IO_H
