// #========================================================================
// #
// #    arm9.S
// #
// #    ARM exception vectors
// #
// #========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2008 Free Software Foundation, Inc.
// Copyright (C) 2004, 2005, 2006, 2008 eCosCentric Limited                 
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
// #========================================================================
// ######DESCRIPTIONBEGIN####
// #
// # Author(s):     nickg
// # Contributors:  nickg
// # Date:          2004-04-21
// # Purpose:       ARM9 assembler functions
// # Description:   
// #
// #####DESCRIPTIONEND####
// #
// #========================================================================

#include <pkgconf/hal.h>
#include <pkgconf/hal_arm.h>
#include <pkgconf/hal_arm_arm9.h>

//==========================================================================

#include <cyg/hal/arch.inc>

#ifdef __thumb__
// Switch to thumb mode
#define THUMB_MODE(_r_, _l_)                     \
        ldr     _r_,=_l_ ## f+1                 ;\
        bx      _r_                             ;\
        .pool                                   ;\
        .code   16                              ;\
        .thumb_func                             ;\
 _l_:

// Call thumb function from ARM mode, return to ARM
// mode afterwards
#define THUMB_CALL(_r_, _l_, _f_)                \
        ldr     _r_,=_f_+1                      ;\
        mov     lr,pc                           ;\
        bx      _r_                             ;\
        .pool                                   ;\
        .code   16                              ;\
        .thumb_func                             ;\
        ldr     _r_,=_l_  ## f                  ;\
        bx      _r_                             ;\
        .pool                                   ;\
        .code   32                              ;\
 _l_:

// Switch to ARM mode
#define ARM_MODE(_r_, _l_)                       \
        ldr     _r_,=_l_ ## f                   ;\
        bx      _r_                             ;\
        .pool                                   ;\
        .code   32                              ;\
 _l_:

// Function definition, start executing body in ARM mode
#define FUNC_START_ARM(_name_, _r_)              \
        .section .text._name_                   ;\
        .type _name_, function                  ;\
        .code   16                              ;\
        .thumb_func                             ;\
        .globl _name_                           ;\
_name_:                                         ;\
        ldr     _r_,=_name_ ## _ARM             ;\
        bx      _r_                             ;\
        .code   32                              ;\
_name_ ## _ARM:

#else

// Switch to thumb mode
#define THUMB_MODE(_r_, _l_)

// Call ARM function
#define THUMB_CALL(_r_, _l_, _f_) \
        bl      _f_

// Switch to ARM mode
#define ARM_MODE(_r_, _l_)

// Function definition, start executing body in ARM mode
#define FUNC_START_ARM(_name_, _r_) \
        .section .text._name_                   ;\
        .type _name_, function                  ;\
        .globl _name_; \
_name_: 

#endif

#define PTR(name)               \
.##name: .word  name

//==========================================================================        

#if !(defined(CYGSEM_HAL_ARM_ARM9_MMH_MMU) || \
      defined(CYGSEM_HAL_ARM_ARM9_MMH_PU)  || \
      defined(CYGSEM_HAL_ARM_ARM9_MMH_NONE) )
#error No Memory Management Hardware defined
#endif                        
        
//==========================================================================        
// Set the TTB and DACR MMU registers

#if defined(CYGSEM_HAL_ARM_ARM9_MMH_MMU)        
FUNC_START_ARM(cyg_hal_arm9_set_mmuregs,r2)
        mcr     p15,0,r0,c2,c0,0        // set TT Base
        mcr     p15,0,r1,c3,c0,0        // Set DACR
        bx      lr
#endif
                
//==========================================================================

FUNC_START_ARM(cyg_hal_arm9_soft_reset,r1)

    /* It would probably make more sense to have the
       clear/drain/invalidate after disabling the cache and MMU, but
       then we'd have to know the (unmapped) address of this code. */
                  
        mrs     r1,cpsr
        bic     r1,r1,#0x1F       /* Put processor in SVC mode */
        orr     r1,r1,#0x13
        msr     cpsr,r1
                  
        mov     r1, #0
        mcr     p15,0,r1,c7,c7,0  /* clear I+DCache */
        mcr     p15,0,r1,c7,c10,4 /* Drain Write Buffer */
#if defined(CYGSEM_HAL_ARM_ARM9_MMH_MMU)        
        mcr     p15,0,r1,c8,c7,0  /* Invalidate TLBs */
        mrc     p15,0,r1,c1,c0,0
#endif        
        bic     r1,r1,#0x1000     /* disable ICache */
        bic     r1,r1,#0x0007     /* disable DCache, MMU and alignment faults */
        mcr     p15,0,r1,c1,c0,0
        nop                       /* delay 1 */
        mov     pc, r0            /* delay 2  - next instruction should be fetched flat */

1:      
        b       1b                /* Loop forever */

        bx      lr
        
        
//==========================================================================
// Instruction cache ops
        
// Enable the instruction cache
FUNC_START_ARM(hal_icache_enable,r1)
        mrc  p15,0,r1,c1,c0,0
        orr  r1,r1,#0x1000
        mcr  p15,0,r1,c1,c0,0                                    
        bx      lr

// Disable the instruction cache (and invalidate it, required semanitcs)
FUNC_START_ARM(hal_icache_disable,r1)
        mrc    p15,0,r1,c1,c0,0
        bic    r1,r1,#0x1000    /* disable ICache (but not MMU, etc) */
        mcr    p15,0,r1,c1,c0,0
        mov    r1,#0
        mcr    p15,0,r1,c7,c5,0 /* flush ICache */                  
        nop                     /* next few instructions may be via cache    */
        nop
        nop
        nop
        nop
        nop
        bx      lr

// Query the state of the instruction cache
FUNC_START_ARM(hal_icache_is_enabled,r0)
        mrc     p15,0,r0,c1,c0,0
        bx      lr

// Invalidate the entire cache
FUNC_START_ARM(hal_icache_invalidate_all,r1)
    /* this function can discard dirty cache lines (N/A for ICache) */
        mov    r1,#0
        mcr    p15,0,r1,c7,c5,0         /* flush ICache */
#if defined(CYGSEM_HAL_ARM_ARM9_MMH_MMU)        
        mcr    p15,0,r1,c8,c5,0         /* flush ITLB only */
#endif        
        nop                             /* next few instructions may be via cache    */
        nop
        nop
        nop
        nop
        nop
        bx      lr

//==========================================================================
// Data cache ops
                
// Enable the data cache
FUNC_START_ARM(hal_dcache_enable,r1)
        mrc  p15,0,r1,c1,c0,0
        orr  r1,r1,#0x000C      /* enable DCache and write buffer */
        mcr  p15,0,r1,c1,c0,0
        bx      lr

// Disable the data cache (and invalidate it, required semanitcs)
FUNC_START_ARM(hal_dcache_disable,r1)
        mrc  p15,0,r1,c1,c0,0
        bic  r1,r1,#0x000C      /* disable DCache AND write buffer  */
                                /* but not MMU and alignment faults */
        mcr  p15,0,r1,c1,c0,0
        mov  r1,#0
        mcr  p15,0,r1,c7,c6,0   /* clear data cache */
        bx      lr

// Query the state of the data cache
FUNC_START_ARM(hal_dcache_is_enabled,r0)
        mrc     p15,0,r0,c1,c0,0
        bx      lr

// Flush the entire dcache (and then both TLBs, just in case)
FUNC_START_ARM(hal_dcache_invalidate_all,r0)
        /* this function can discard dirty cache lines. */
/* The following used to be here but is unnecessary, right?
 *        mrc    p15,0,r0,c0,c0,1
 */
	mov    r0,#0
        mcr    p15,0,r0,c7,c6,0         /* flush d-cache */
#if defined(CYGSEM_HAL_ARM_ARM9_MMH_MMU)        
        mcr    p15,0,r0,c8,c7,0         /* flush i+d-TLBs */
#endif
        bx      lr

// Synchronize the contents of the cache with memory.
FUNC_START_ARM(hal_dcache_sync_clean,r0)
        mov    r0, #0
        mcr    p15,0,r0,c7,c10,0        /* clean DCache */                 
1:      mrc    p15,0,r0,c15,c4,0        /* wait for dirty flag to clear */
        ands   r0,r0,#0x80000000
        bne    1b
        mov    r0,#0
        mcr    p15,0,r0,c7,c6,0         /* flush DCache */                  
        mcr    p15,0,r0,c7,c10,4        /* and drain the write buffer */    
        bx      lr
        
FUNC_START_ARM(hal_dcache_sync_index,r2)
        stmfd   sp!,{r4}
        mov     r2, #0
1:
        mov     r3, #0
2:
        orr     r4,r2,r3
        mcr     p15,0,r4,c7,c10,2        /* clean index in DCache */        
        add     r3,r3,r0
        cmp     r3,r1
        bne     2b
        add     r2,r2,#0x04000000        /* get to next index */            
        cmp     r2,#0
        bne     1b
        mcr     p15,0,r2,c7,c10,4        /* drain the write buffer */
        ldmfd   sp!,{r4}
        bx      lr

FUNC_START_ARM(hal_dcache_sync_alt_clean,r0)
	mov	r0, #255 << 4            /* 256 entries/set */
2:
	mcr	p15, 0, r0, c7, c14, 2
	subs	r0, r0, #1 << 4
	bcs	2b			/* entries 255 to 0 */
	mcr	p15,0,r0,c7,c10,4	/* drain the write buffer */
	bx	lr
	
FUNC_START_ARM(hal_dcache_sync_arm926ej_clean,r0)
1:					/* clean & invalidate D index */
	mrc	p15, 0, r15, c7, c14, 3
	bne	1b
	mcr	p15,0,r0,c7,c10,4	/* drain the write buffer */
	bx	lr

	//==========================================================================
// Miscellaneous functions
        
// Wait for interrupt in low power mode
FUNC_START_ARM(cyg_hal_arm9_wait_for_interrupt,r0)
	mov	r0, #0
	mcr	p15, 0, r0, c7, c0, 4
	bx	lr

// Set FastBus mode
FUNC_START_ARM(cyg_hal_arm9_set_fastbus_mode,r0)
	mrc	p15, 0, r0, c1, c0, 0
	and	r0, r0, #0x3FFFFFFF
	mcr	p15, 0, r0, c1, c0, 0
	bx	lr

// Set Synchronous mode
FUNC_START_ARM(cyg_hal_arm9_set_sync_mode,r0)
	mrc	p15, 0, r0, c1, c0, 0
	and	r0, r0, #0x7FFFFFFF
	orr	r0, r0, #0x40000000
	mcr	p15, 0, r0, c1, c0, 0
	bx	lr

// Set Asynchronous mode
FUNC_START_ARM(cyg_hal_arm9_set_async_mode,r0)
	mrc	p15, 0, r0, c1, c0, 0
	orr	r0, r0, #0xC0000000
	mcr	p15, 0, r0, c1, c0, 0
	bx	lr	

FUNC_START_ARM(cyg_hal_arm9_get_clock_mode,r0)
        mrc     p15, 0, r0, c1, c0, 0
	mov	r0, r0, lsr #30	
	bx      lr	
                                       
// --------------------------------------------------------------------------
//  end of arm9.S
                        
