#ifndef CYGONCE_HAL_PLF_IO_H
#define CYGONCE_HAL_PLF_IO_H
//=============================================================================
//
//      plf_io.h
//
//      Platform specific registers
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2005, 2006, 2008 Free Software Foundation, Inc.
// Copyright (C) 2003, 2005, 2006, 2008, 2009, 2010 eCosCentric Limited                 
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    nickg
// Contributors: eCosCentric, jskov
// Date:         2009-12-09
// Purpose:      Platform specific registers
// Description: 
// Usage:        #include <cyg/hal/plf_io.h>
//
//####DESCRIPTIONEND####
//
//=============================================================================

#include <pkgconf/hal_arm_arm9_omap_l1xx.h>

#include <cyg/hal/omap_l1xx.h>

//-----------------------------------------------------------------------------
// Memory layout

#define CYGHWR_HAL_ZOOM_L138_RAM_PHYS_BASE              0xC0000000
#define CYGHWR_HAL_ZOOM_L138_RAM_VIRT_BASE              0xC0000000
#define CYGHWR_HAL_ZOOM_L138_RAM_UNCACHED_BASE          0xD0000000
#define CYGHWR_HAL_ZOOM_L138_RAM_SIZE                   0x04000000
#define CYGHWR_HAL_ZOOM_L138_RAM_MASK                   (CYGHWR_HAL_ZOOM_L138_RAM_SIZE-1)


//-----------------------------------------------------------------------------
// Address space translation macros

#define CYGARC_PHYSICAL_ADDRESS(__x)                                    \
({                                                                      \
    CYG_ADDRWORD __p = (CYG_ADDRWORD)(__x);                             \
    if (__p >= CYGHWR_HAL_ZOOM_L138_RAM_VIRT_BASE &&                    \
        __p < (CYGHWR_HAL_ZOOM_L138_RAM_VIRT_BASE+CYGHWR_HAL_ZOOM_L138_RAM_SIZE)) \
        __p = (__p & CYGHWR_HAL_ZOOM_L138_RAM_MASK) + CYGHWR_HAL_ZOOM_L138_RAM_PHYS_BASE; \
    __p;                                                                \
})

#define CYGARC_VIRTUAL_ADDRESS(__x)                                     \
({                                                                      \
    CYG_ADDRWORD __p = (CYG_ADDRWORD)(__x);                             \
    if (__p >= CYGHWR_HAL_ZOOM_L138_RAM_PHYS_BASE &&                    \
        __p < (CYGHWR_HAL_ZOOM_L138_RAM_PHYS_BASE+CYGHWR_HAL_ZOOM_L138_PHYS_SIZE)) \
        __p = (__p & CYGHWR_HAL_ZOOM_L138_RAM_MASK) + CYGHWR_HAL_ZOOM_L138_RAM_VIRT_BASE; \
    __p;                                                                \
})

#define CYGARC_UNCACHED_ADDRESS(__x)                                    \
({                                                                      \
    CYG_ADDRWORD __p = (CYG_ADDRWORD)(__x);                             \
    if (__p >= CYGHWR_HAL_ZOOM_L138_RAM_VIRT_BASE &&                    \
        __p < (CYGHWR_HAL_ZOOM_L138_RAM_VIRT_BASE+CYGHWR_HAL_ZOOM_L138_RAM_SIZE)) \
        __p = (__p & CYGHWR_HAL_ZOOM_L138_RAM_MASK) + CYGHWR_HAL_ZOOM_L138_RAM_UNCACHED_BASE; \
    __p;                                                                \
})

//-----------------------------------------------------------------------------

#define CYGHWR_HAL_OMAP_BUFF_OE            CYGHWR_HAL_L1XX_PINMUX(  6, 4, 8 )
#define CYGHWR_HAL_OMAP_BUFF_OE_GPIO       CYGHWR_HAL_L1XX_GPIO( 2, 6, OUTPUT )

#define CYGHWR_HAL_OMAP_BUFF_OE_SET()                                   \
{                                                                       \
    /* Configure BUFF_OE pin for GPIO output and set it low. */         \
    CYGHWR_HAL_L1XX_PINMUX_SET( CYGHWR_HAL_OMAP_BUFF_OE );              \
    CYGHWR_HAL_L1XX_GPIO_SET( CYGHWR_HAL_OMAP_BUFF_OE_GPIO );           \
    CYGHWR_HAL_L1XX_GPIO_OUT( CYGHWR_HAL_OMAP_BUFF_OE_GPIO, 0 );        \
}

//-----------------------------------------------------------------------------
// SPI device setup

#define CYGHWR_HAL_OMAP_SPI_INIT( __spi_bus )           \
{                                                       \
    if( (__spi_bus)->base == CYGHWR_HAL_L1XX_SPI1 )     \
    {                                                   \
        CYGHWR_HAL_OMAP_BUFF_OE_SET();                  \
    }                                                   \
}

//-----------------------------------------------------------------------------
// MMC/SD Interface (MCI) bus

// Only files that need the below defines will have set __MMCSD_DRIVER_PRIVATE before inclusion.
#if defined(__MMCSD_DRIVER_PRIVATE) && defined(CYGPKG_HAL_ARM_ARM9_OMAP_L1XX_MMC)
#include <cyg/infra/cyg_type.h>

#if defined(CYGIMP_HAL_ARM_ARM9_OMAP_L1XX_MMC_INTMODE)
#define HAL_MMCSD_PLF_SOCKET_INTERRUPT  1
#else
#define HAL_MMCSD_PLF_SOCKET_INTERRUPT  0
#endif

// Only one socket, so ignore card and bus throughout below.

// Platform hook for bus initialisation, independent of socket, e.g.
// socket-independent pin config.
// err only needs to be set if there's an error.
//#define HAL_MMCSD_PLF_INIT_BUS( _bus_, _err_ )

#define HAL_MMCSD_PLF_GET_SOCKET_CAPABILITY(_bus_, _socket_, _err_)     \
    CYG_MACRO_START                                                     \
    (_socket_)->sockethw_caps.valid = 1;                                \
    (_socket_)->sockethw_caps.sd = 1;                                   \
    (_socket_)->sockethw_caps.fourbit = 1;                              \
    (_socket_)->sockethw_caps.card_detect = 1;                          \
    (_socket_)->sockethw_caps.card_detect_int = HAL_MMCSD_PLF_SOCKET_INTERRUPT; \
    (_socket_)->sockethw_vdd = MMCSD_OCR_REGISTER_VDD_32_33;            \
    (_socket_)->sockethw_caps.multiblock_io = 0;                        \
    CYG_MACRO_END


// The board has CD connected to GPIO bank 4, pin 0 and WP connected
// to GPIO bank 4, pin 1.
#define CYGHWR_HAL_OMAP_MMCSD0_CD_PINMUX                CYGHWR_HAL_L1XX_PINMUX( 10, 28, 8 )
#define CYGHWR_HAL_OMAP_MMCSD0_CD_GPIO                  CYGHWR_HAL_L1XX_GPIO( 4, 0, INPUT )
#define CYGHWR_HAL_OMAP_MMCSD0_WP_PINMUX                CYGHWR_HAL_L1XX_PINMUX( 10, 24, 8 )
#define CYGHWR_HAL_OMAP_MMCSD0_WP_GPIO                  CYGHWR_HAL_L1XX_GPIO( 4, 1, INPUT )

// Platform hook for initialising card detection for polling. Usually some PIOs.
// Used in addition to HAL_MMCSD_PLF_INIT_CARD_DETECT_INTERRUPT if relevant.
#define HAL_MMCSD_PLF_INIT_CARD_DETECT( _bus_, _card_, _err_ )          \
    CYG_MACRO_START                                                     \
    CYGHWR_HAL_L1XX_PINMUX_SET( CYGHWR_HAL_OMAP_MMCSD0_CD_PINMUX );     \
    CYGHWR_HAL_L1XX_GPIO_SET( CYGHWR_HAL_OMAP_MMCSD0_CD_GPIO );         \
    CYGHWR_HAL_L1XX_PINMUX_SET( CYGHWR_HAL_OMAP_MMCSD0_WP_PINMUX );     \
    CYGHWR_HAL_L1XX_GPIO_SET( CYGHWR_HAL_OMAP_MMCSD0_WP_GPIO );         \
    CYG_MACRO_END

// Platform hook for initialisation of interrupt handler for card
// insertion/removal detection. Used in addition to HAL_MMCSD_PLF_INIT_CARD_DETECT.
// err only needs to be set if there's an error.
#if defined(CYGFUN_DEVS_DISK_MMCSD_BUS_REMOVABLE_MEDIA_SUPPORT) && \
    defined(CYGIMP_HAL_ARM_ARM9_OMAP_L1XX_MMC_INTMODE)
struct cyg_mmcsd_card; // forward declaration
__externC void cyg_hal_zoom_l1xx_init_card_detect_intr(struct cyg_mmcsd_card *socket);

# define HAL_MMCSD_PLF_INIT_CARD_DETECT_INTERRUPT(_bus_, _socket_, _err_) \
{                                                                       \
    omap_l1xx_mmc_bus *priv = (omap_l1xx_mmc_bus *)(_bus_)->hw_priv;    \
    if( priv->bus == 0 )                                                \
        cyg_hal_zoom_l1xx_init_card_detect_intr(_socket_);              \
}
#endif

// Update card's cardflags field with card presence
#define HAL_MMCSD_PLF_SAMPLE_CARD_DETECT( _card_, _err_ )               \
    CYG_MACRO_START                                                     \
    cyg_uint32 val;                                                     \
    CYGHWR_HAL_L1XX_GPIO_IN( CYGHWR_HAL_OMAP_MMCSD0_CD_GPIO, &val );    \
    (_card_)->cardflags.card_present = (val == 0);                      \
    CYG_MACRO_END


// Update card's cardflags field with physical write-protect switch state
#define HAL_MMCSD_PLF_SAMPLE_CARD_WP( _card_, _err_ )                   \
    CYG_MACRO_START                                                     \
    cyg_uint32 val;                                                     \
    CYGHWR_HAL_L1XX_GPIO_IN( CYGHWR_HAL_OMAP_MMCSD0_WP_GPIO, &val );    \
    (_card_)->cardflags.hw_writeprotect = (val != 0);                   \
    CYG_MACRO_END

#endif

//-----------------------------------------------------------------------------
// end of plf_io.h
#endif // CYGONCE_HAL_PLF_IO_H
