#!/usr/bin/env tclsh

#===============================================================================
#
#      flashimg.tcl
#
#      Script to generate an image file suitable for booting an application
#      from SPI flash using the TI user boot loader. 
#      
#
#===============================================================================
## ####ECOSGPLCOPYRIGHTBEGIN####                                            
## -------------------------------------------                              
## This file is part of eCos, the Embedded Configurable Operating System.   
## Copyright (C) 2003, 2004, 2005, 2006, 2008, 2009, 2010 eCosCentric Limited           
## Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2008 Free Software Foundation, Inc.
##
## eCos is free software; you can redistribute it and/or modify it under    
## the terms of the GNU General Public License as published by the Free     
## Software Foundation; either version 2 or (at your option) any later      
## version.                                                                 
##
## eCos is distributed in the hope that it will be useful, but WITHOUT      
## ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
## FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
## for more details.                                                        
##
## You should have received a copy of the GNU General Public License        
## along with eCos; if not, write to the Free Software Foundation, Inc.,    
## 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
##
## As a special exception, if other files instantiate templates or use      
## macros or inline functions from this file, or you compile this file      
## and link it with other works to produce a work based on this file,       
## this file does not by itself cause the resulting work to be covered by   
## the GNU General Public License. However the source code for this file    
## must still be made available in accordance with section (3) of the GNU   
## General Public License v2.                                               
##
## This exception does not invalidate any other reasons why a work based    
## on this file might be covered by the GNU General Public License.         
## -------------------------------------------                              
## ####ECOSGPLCOPYRIGHTEND####                                              
#===============================================================================
######DESCRIPTIONBEGIN####
#
# Author(s):      nickg
# Date:           2010-01-09
# Usage:          Run from the command line:
#
#                 $ flashimg <app binary> <image file>
#
#                 However, this script will mostly be run from a makefile.
#
#####DESCRIPTIONEND####
#
#===============================================================================

set debug 0

proc dputs { args } {
    global debug
    if { $debug > 0 } {
        puts -nonewline "DEBUG: "
        foreach i $args {
          puts -nonewline $i
        }
        puts ""
    }
}

#===============================================================================

proc tcl_path { posix_path } {
    # Use the HOST setting from the toplevel makefile in preference to
    # tcl_platform() since we have more control over the former than the
    # latter.
    if { [info exists ::env(HOST)] && [string equal $::env(HOST) "CYGWIN"] } {
        return [ exec cygpath -w $posix_path ]
    } else {
        return $posix_path
    }
}

#===============================================================================

# Fetch arguments
set binfile [ tcl_path [ lindex $argv 0 ] ]
set imgfile [ tcl_path [ lindex $argv 1 ] ]

dputs "binfile = " $binfile
dputs "imgfile = " $imgfile

# Open files and set them to binary mode
set bin [open $binfile r]
set img [open $imgfile w+]
fconfigure $bin -translation binary
fconfigure $img -translation binary

# Read executable binary image and get its size
set binary [read $bin]
set binsize [string length $binary]
dputs "binsize = " $binsize

# Create header
set header [binary format iiii 0xA1ACED00 0xC0008000 $binsize 0xC0008000]

# Write header+binary to output file
puts -nonewline $img $header
puts -nonewline $img $binary

# Tidy up and exit
close $bin
close $img

#===============================================================================
# EOF flashimg.tcl

