#ifndef CYGONCE_HAL_PLATFORM_INTS_H
#define CYGONCE_HAL_PLATFORM_INTS_H
//==========================================================================
//
//      hal_platform_ints.h
//
//      HAL Interrupt and clock assignments for AT91SAM7
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2006, 2007 Free Software Foundation, Inc.
// Copyright (C) 2006, 2007 eCosCentric Limited                             
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    gthomas
// Contributors: gthomas, Oliver Munz, Andrew Lunn, John Eigelaar, nickg
//               dhogg
// Date:         2001-07-12
// Purpose:      Define Interrupt support
// Description:  The interrupt specifics for the AT91SAM7 platform are
//               defined here.
//              
// Usage:        #include <cyg/hal/hal_platform_ints.h>
//               ...
//              
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <pkgconf/hal_arm_at91sam7.h>


#if defined(CYGHWR_HAL_ARM_AT91SAM7S) || defined(CYGHWR_HAL_ARM_AT91SAM7X) || defined(CYGHWR_HAL_ARM_AT91SAM7SE)

#define CYGNUM_HAL_INTERRUPT_FIQ		0       // Advanced Interrupt Controller (FIQ)

#define CYGNUM_HAL_INTERRUPT_SYS		1       // System Peripheral (debug unit, system timer)
#define CYGNUM_HAL_INTERRUPT_PIOA		2       // Parallel IO Controller A

#ifdef CYGHWR_HAL_ARM_AT91SAM7X
#define CYGNUM_HAL_INTERRUPT_PIOB		3       // Parallel IO Controller B
#define CYGNUM_HAL_INTERRUPT_SPI		4       // Serial Peripheral Interface
#define CYGNUM_HAL_INTERRUPT_SPI1		5       // Serial Peripheral Interface 1
#endif
#ifdef CYGHWR_HAL_ARM_AT91SAM7S
#define CYGNUM_HAL_INTERRUPT_ADC		4       // Analog-to-Digital Converter
#define CYGNUM_HAL_INTERRUPT_SPI		5       // Serial Peripheral Interface
#endif
#ifdef CYGHWR_HAL_ARM_AT91SAM7SE
#define CYGNUM_HAL_INTERRUPT_PIOB               3
#define CYGNUM_HAL_INTERRUPT_PIOC               4
#define CYGNUM_HAL_INTERRUPT_SPI                5
#endif

#define CYGNUM_HAL_INTERRUPT_USART0		6       // USART 0
#define CYGNUM_HAL_INTERRUPT_USART1		7       // USART 1
#define CYGNUM_HAL_INTERRUPT_SSC		8       // Serial Synchronous Controller
#define CYGNUM_HAL_INTERRUPT_TWI		9       // Two-Wire Interface (I2C)
#define CYGNUM_HAL_INTERRUPT_PWMC		10      // PWM Controller
#define CYGNUM_HAL_INTERRUPT_UDP		11      // USB Device Port
#define CYGNUM_HAL_INTERRUPT_TC0		12      // Timer Counter 0
#define CYGNUM_HAL_INTERRUPT_TC1		13      // Timer Counter 1
#define CYGNUM_HAL_INTERRUPT_TC2		14      // Timer Counter 2

#ifdef CYGHWR_HAL_ARM_AT91SAM7SE
#define CYGNUM_HAL_INTERRUPT_ADC                15
#endif
#ifdef CYGHWR_HAL_ARM_AT91SAM7X
#define CYGNUM_HAL_INTERRUPT_CAN0		15      // CAN Controller
#define CYGNUM_HAL_INTERRUPT_EMAC		16      // Ethernet MAC
#define CYGNUM_HAL_INTERRUPT_ADC		17      // Analog-to-Digital Converter
#endif

#define CYGNUM_HAL_INTERRUPT_IRQ0		30      // External IRQ0
#define CYGNUM_HAL_INTERRUPT_IRQ1		31      // External IRQ0

// Interrupts which are multiplexed on to the System Interrupt
#define CYGNUM_HAL_INTERRUPT_PITC               32      // Period Interval Timer
#define CYGNUM_HAL_INTERRUPT_RTTC               33      // Real-Time Timer
#define CYGNUM_HAL_INTERRUPT_PMC                34      // Power Management Controller
#define CYGNUM_HAL_INTERRUPT_MC                 35      // Memory Controller
#define CYGNUM_HAL_INTERRUPT_WDTC               36      // Watchdog
#define CYGNUM_HAL_INTERRUPT_RSTC               37      // Reset Controller
#define CYGNUM_HAL_INTERRUPT_DEBUG              38      // Debug Serial Port

#define CYGNUM_HAL_ISR_MIN			 0
#define CYGNUM_HAL_ISR_MAX			38

#define CYGNUM_HAL_ISR_COUNT			(CYGNUM_HAL_ISR_MAX + 1)

// The vector used by the Real time clock
#ifdef CYGBLD_HAL_ARM_AT91_TIMER_TC
#define CYGNUM_HAL_INTERRUPT_RTC		CYGNUM_HAL_INTERRUPT_TC0
#endif
#ifdef CYGBLD_HAL_ARM_AT91_TIMER_PIT
#define CYGNUM_HAL_INTERRUPT_RTC		CYGNUM_HAL_INTERRUPT_PITC
#endif

#elif defined(CYGHWR_HAL_ARM_AT91SAM7A)

#define CYGNUM_HAL_INTERRUPT_FIQ		 0      // Advanced Interrupt Controller (FIQ)
#define CYGNUM_HAL_INTERRUPT_SWIIRQ0             1      // Software Interrupt 0
#define CYGNUM_HAL_INTERRUPT_WD                  2      // Watchdog
#define CYGNUM_HAL_INTERRUPT_WT                  3      // Watch Timer
#define CYGNUM_HAL_INTERRUPT_USART0              4      // USART 0
#define CYGNUM_HAL_INTERRUPT_USART1              5      // USART 1
#define CYGNUM_HAL_INTERRUPT_CAN3                6      // CAN Controller 3
#define CYGNUM_HAL_INTERRUPT_SPI                 7      // Serial Peripheral Interface
#define CYGNUM_HAL_INTERRUPT_CAN1                8      // CAN Controller 1
#define CYGNUM_HAL_INTERRUPT_CAN2                9      // CAN Controller 2
#define CYGNUM_HAL_INTERRUPT_ADC0               10      // Analog-to-Digital Converter 0
#define CYGNUM_HAL_INTERRUPT_ADC1               11      // Analog-to-Digital Converter 1
#define CYGNUM_HAL_INTERRUPT_GPT0CH0            12      // General Purpose Timer 0 Channel 0
#define CYGNUM_HAL_INTERRUPT_GPT0CH1            13      // General Purpose Timer 0 Channel 1
#define CYGNUM_HAL_INTERRUPT_GPT0CH2            14      // General Purpose Timer 0 Channel 2
#define CYGNUM_HAL_INTERRUPT_SWIIRQ1            15      // Software Interrupt 1
#define CYGNUM_HAL_INTERRUPT_SWIIRQ2            16      // Software Interrupt 2
#define CYGNUM_HAL_INTERRUPT_SWIIRQ3            17      // Software Interrupt 3
#define CYGNUM_HAL_INTERRUPT_GPT1CH0            18      // General Purpose Timer 1 Channel 0
#define CYGNUM_HAL_INTERRUPT_PWM                19      // PWM Controller
#define CYGNUM_HAL_INTERRUPT_CAN0               20      // CAN Controller 0
#define CYGNUM_HAL_INTERRUPT_UPIO               21      // Unified Parallel IO Controller
#define CYGNUM_HAL_INTERRUPT_CAPT0              22      // Capture 0
#define CYGNUM_HAL_INTERRUPT_CAPT1              23      // Capture 1
#define CYGNUM_HAL_INTERRUPT_ST0                24      // Simple Timer 0
#define CYGNUM_HAL_INTERRUPT_ST1                25      // Simple Timer 1
#define CYGNUM_HAL_INTERRUPT_SWIIRQ4            26      // Software Interrupt 4
#define CYGNUM_HAL_INTERRUPT_SWIIRQ5            27      // Software Interrupt 5
#define CYGNUM_HAL_INTERRUPT_IRQ0               28      // External Interrupt 0
#define CYGNUM_HAL_INTERRUPT_IRQ1               29      // External Interrupt 1
#define CYGNUM_HAL_INTERRUPT_SWIIRQ6            30      // Software Interrupt 6
#define CYGNUM_HAL_INTERRUPT_SWIIRQ7            31      // Software Interrupt 7

#define CYGNUM_HAL_ISR_MIN			 0
#define CYGNUM_HAL_ISR_MAX			31

#define CYGNUM_HAL_ISR_COUNT			(CYGNUM_HAL_ISR_MAX + 1)

#define CYGNUM_HAL_INTERRUPT_RTC		CYGNUM_HAL_INTERRUPT_ST0

#elif defined(CYGHWR_HAL_ARM_AT91SAM7A3)

#define CYGNUM_HAL_INTERRUPT_FIQ		0       // Advanced Interrupt Controller (FIQ)
#define CYGNUM_HAL_INTERRUPT_SYS		1       // System Peripheral (debug unit, system timer)
#define CYGNUM_HAL_INTERRUPT_PIOA		2       // Parallel IO Controller A
#define CYGNUM_HAL_INTERRUPT_PIOB		3       // Parallel IO Controller B
#define CYGNUM_HAL_INTERRUPT_CAN0		4       // CAN Controller 0
#define CYGNUM_HAL_INTERRUPT_CAN1		5       // CAN Controller 1
#define CYGNUM_HAL_INTERRUPT_USART0		6       // USART 0
#define CYGNUM_HAL_INTERRUPT_USART1		7       // USART 1
#define CYGNUM_HAL_INTERRUPT_USART2		8       // USART 2
#define CYGNUM_HAL_INTERRUPT_MCI                9       // Multimedia Card Interface
#define CYGNUM_HAL_INTERRUPT_TWI		10      // Two-Wire Interface (I2C)
#define CYGNUM_HAL_INTERRUPT_SPI		11      // Serial Parallel Interface 0
#define CYGNUM_HAL_INTERRUPT_SPI1		12      // Serial Parallel Interface 1
#define CYGNUM_HAL_INTERRUPT_SSC0		13      // Serial Synchronous Controller 0
#define CYGNUM_HAL_INTERRUPT_SSC1		14      // Serial Synchronous Controller 1
#define CYGNUM_HAL_INTERRUPT_TC0		15      // Timer Counter 0
#define CYGNUM_HAL_INTERRUPT_TC1		16      // Timer Counter 1
#define CYGNUM_HAL_INTERRUPT_TC2		17      // Timer Counter 2
#define CYGNUM_HAL_INTERRUPT_TC3		18      // Timer Counter 3
#define CYGNUM_HAL_INTERRUPT_TC4		19      // Timer Counter 4
#define CYGNUM_HAL_INTERRUPT_TC5		20      // Timer Counter 5
#define CYGNUM_HAL_INTERRUPT_TC6		21      // Timer Counter 6
#define CYGNUM_HAL_INTERRUPT_TC7		22      // Timer Counter 7
#define CYGNUM_HAL_INTERRUPT_TC8		23      // Timer Counter 8
#define CYGNUM_HAL_INTERRUPT_ADC0		24      // Analog-to-Digital Converter 0
#define CYGNUM_HAL_INTERRUPT_ADC1		25      // Analog-to-Digital Converter 1
#define CYGNUM_HAL_INTERRUPT_PWMC		26      // PWM Controller
#define CYGNUM_HAL_INTERRUPT_UDP		27      // USB Device Port
#define CYGNUM_HAL_INTERRUPT_IRQ0		28      // External Interrupt 0
#define CYGNUM_HAL_INTERRUPT_IRQ1		29      // External Interrupt 1
#define CYGNUM_HAL_INTERRUPT_IRQ2		30      // External Interrupt 2
#define CYGNUM_HAL_INTERRUPT_IRQ3		31      // External Interrupt 3

// Interrupts which are multiplexed on to the System Interrupt
#define CYGNUM_HAL_INTERRUPT_PITC               32      // Period Interval Timer
#define CYGNUM_HAL_INTERRUPT_RTTC               33      // Real-Time Timer
#define CYGNUM_HAL_INTERRUPT_PMC                34      // Power Management Controller
#define CYGNUM_HAL_INTERRUPT_MC                 35      // Memory Controller
#define CYGNUM_HAL_INTERRUPT_WDTC               36      // Watchdog
#define CYGNUM_HAL_INTERRUPT_RSTC               37      // Reset Controller
#define CYGNUM_HAL_INTERRUPT_DEBUG              38      // Debug Serial Port

#define CYGNUM_HAL_ISR_MIN			 0
#define CYGNUM_HAL_ISR_MAX			38

#define CYGNUM_HAL_ISR_COUNT			(CYGNUM_HAL_ISR_MAX + 1)

// The vector used by the Real time clock
#ifdef CYGBLD_HAL_ARM_AT91_TIMER_TC
#define CYGNUM_HAL_INTERRUPT_RTC		CYGNUM_HAL_INTERRUPT_TC0
#endif
#ifdef CYGBLD_HAL_ARM_AT91_TIMER_PIT
#define CYGNUM_HAL_INTERRUPT_RTC		CYGNUM_HAL_INTERRUPT_PITC
#endif

#endif

//----------------------------------------------------------------------------
// Reset.
__externC void hal_at91_reset_cpu(void);
#define HAL_PLATFORM_RESET() hal_at91_reset_cpu()

#define HAL_PLATFORM_RESET_ENTRY 0x0000000

//----------------------------------------------------------------------------
#endif // CYGONCE_HAL_PLATFORM_INTS_H
