//==========================================================================
//
//      at91sam7a2ek_flash.c
//
//      Support for the various flash devices on the AT91SAM7A2EK board
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2006 Free Software Foundation, Inc.                        
// Copyright (C) 2006 eCosCentric Limited                                   
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   nickg
// Date:        2006-08-30
//
//####DESCRIPTIONEND####
//=============================================================================

#include <pkgconf/hal_arm_at91sam7a2ek.h>

// We use CFI to detect the exact device and set up the flash driver
// to match.

#include <cyg/io/flash.h>
#include <cyg/io/flash_dev.h>
#include <cyg/io/am29xxxxx_dev.h>

static const CYG_FLASH_FUNS(hal_at91sam7a2ek_flash_amd_funs,
                            &cyg_am29xxxxx_init_cfi_16,
                            &cyg_flash_devfn_query_nop,
                            &cyg_am29xxxxx_erase_16,
                            &cyg_am29xxxxx_program_16,
                            (int (*)(struct cyg_flash_dev*, const cyg_flashaddr_t, void*, size_t))0,
                            &cyg_flash_devfn_lock_nop,
                            &cyg_flash_devfn_unlock_nop);

static cyg_am29xxxxx_dev hal_at91sam7a2ek_flash_priv;

CYG_FLASH_DRIVER(hal_at91sam7a2ek_flash,
                 &hal_at91sam7a2ek_flash_amd_funs,
                 0,
                 0x40000000,
                 0,
                 2,
                 hal_at91sam7a2ek_flash_priv.block_info,
                 &hal_at91sam7a2ek_flash_priv
);

//=============================================================================
// end of at91sam7a2ek_flash.c
