#ifndef CYGONCE_HAL_PLATFORM_SETUP_H
#define CYGONCE_HAL_PLATFORM_SETUP_H

/*=============================================================================
//
//      hal_platform_setup.h
//
//      Platform specific support for HAL (assembly code)
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2006, 2008 Free Software Foundation, Inc.
// Copyright (C) 2004, 2006, 2008 eCosCentric Limited                       
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   jlarmour, nickg
// Contributors:nickg
// Date:        2008-02-02
// Purpose:     EA LPC2468 OEM board platform specific support routines
// Description:
// Usage:       #include <cyg/hal/hal_platform_setup.h>
//
//####DESCRIPTIONEND####
//
//===========================================================================*/

#include <cyg/hal/var_io.h>


        // ----------------------------------------------------------------
            
//#define LED_DELAY       (5*1000000)
#define LED_DELAY       (5*10000)        
        
        .macro  _led_init
#if 0
_led_init:              
        ldr     r0,=CYGARC_HAL_LPC2XXX_REG_PIN_BASE
        ldr     r1,=0x00200000
        str     r1,[r0,#CYGARC_HAL_LPC2XXX_REG_PINMODE4]
        
        ldr     r0,=CYGARC_HAL_LPC2XXX_REG_FIO_BASE
        ldr     r1,=(1<<10)
        ldr     r2,[r0,# CYGARC_HAL_LPC2XXX_REG_FIODIR(2)]
        orr     r2,r2,r1
        str     r2,[r0,# CYGARC_HAL_LPC2XXX_REG_FIODIR(2)]
        str     r1,[r0,# CYGARC_HAL_LPC2XXX_REG_FIOSET(2)]        
#endif
        _led    0x3
        .endm

        // ----------------------------------------------------------------

        .macro _led_flash
        str     r1,[r0,# CYGARC_HAL_LPC2XXX_REG_FIOCLR(2)]
        ldr     r2,=LED_DELAY
1:      subs    r2,r2,#1
        bne     1b
        str     r1,[r0,# CYGARC_HAL_LPC2XXX_REG_FIOSET(2)]
        ldr     r2,=LED_DELAY
1:      subs    r2,r2,#1
        bne     1b
        .endm

        .macro _led y
#if 0
        ldr     r0,=CYGARC_HAL_LPC2XXX_REG_FIO_BASE
        ldr     r1,=(1<<10)
        .rept   \y
        _led_flash
        .endr
        ldr     r2,=(LED_DELAY*5)
1:      subs    r2,r2,#1
        bne     1b
        b       2f
        .pool
2:              
#endif        
        .endm
        
        
        // ----------------------------------------------------------------
        
        .macro lpc2xxx_common_init

        // Enable Fast GPIO on ports 0 and 1

        ldr     r0,=CYGARC_HAL_LPC2XXX_REG_SCB_BASE
        mov     r2,#CYGARC_HAL_LPC2XXX_REG_SCS_GPIO_FAST        
        ldr     r1,[r0,#CYGARC_HAL_LPC2XXX_REG_SCS]
        orr     r1,r1,r2
        str     r1,[r0,#CYGARC_HAL_LPC2XXX_REG_SCS]
                        
        .endm

        // ----------------------------------------------------------------

        .macro lpc2xxx_pinsel_init
        
        // PINSEL0:     
        // P0.2 to P0.3         :       UART0
        // P0.12                :       AD0[6]
        // P0.13       :        :       AD0[7]
        // All others           :       Default to GPIO
        
        lpc2xxx_init_pinsel0 0x0f000050


        // PINSEL1:
        // P0.23                :       AD0[0]
        // P0.24                :       AD0[1]
        // P0.25                :       AD0[2]
        // P0.26                :       AOUT
        // All others           :       Default to GPIO
        
        lpc2xxx_init_pinsel1 0x00254000

        
        // PINSEL2:
        // All                  :       Default to GPIO
                
        lpc2xxx_init_pinsel2 0x00000000

        
        // PINSEL3:
        // P1.30                :       AD0[4]
        // P1.31                :       AD0[5]
        // All others           :       Default to GPIO
                
        lpc2xxx_init_pinsel3 0xf0000000

        
        // PINSEL4:
        // P2.14                :       CS2
        // P2.15                :       CS3
        // All others           :       Default to GPIO
                
        lpc2xxx_init_pinsel4 0x50000000

        
        // PINSEL5:
        // P2.16 to P2.31       :        all EMC pins, set up differently for
        //                               16 and 32 bit busses.
        
#ifdef CYGHWR_HAL_ARM_LPC2XXX_EA_LPC2468_MEMORY_WIDTH_16        
        lpc2xxx_init_pinsel5 0x05050555
#else
        lpc2xxx_init_pinsel5 0x55010115        
#endif                

        
        // PINSEL6:     
        // P3.0 to P3.15        :       EMC data bus low half

        lpc2xxx_init_pinsel6 0x55555555

        
        // PINSEL7:

#ifdef CYGHWR_HAL_ARM_LPC2XXX_EA_LPC2468_MEMORY_WIDTH_16
        // P3.16 to P3.22       :       UART1
        // P3.30                :       RTS1        
        lpc2xxx_init_pinsel7 0x30003fff
#else
        // P3.16 to P3.31       :       EMC data bus top half
        lpc2xxx_init_pinsel7 0x55555555
#endif                

        
        // PINSEL8:
        // P4.0 to P4.15        :       EMC address bus

        lpc2xxx_init_pinsel8 0x55555555

        
        // PINSEL9:
        // P4.16 to P4.23       :       EMC address bus
        // P4.24 to P4.27       :       EMC signals
        // P4.28 to P4.29       :       GPIO
        // P4.30                :       CS0
        // P4.31                :       CS1

        lpc2xxx_init_pinsel9 0x50555555

        
        // PINSEL10:     
        // All                  :       Default to GPIO

        lpc2xxx_init_pinsel10 0x00000000


        _led_init
                 
        .endm

        // ----------------------------------------------------------------
        
        .macro  lpc2xxx_rom_init

#if 0
        ldr     r0,=0
1:      
        cmp     r0,#0
        beq      1b
#endif
                        
        lpc2xxx_common_init
        _led    0
        lpc2xxx_pinsel_init        
        _led    1        
        lpc2xxx_init_pll
        _led    12

        // Turn on all peripheral clocks and set their dividers to 1, so PCLK == CCLK.

        ldr     r0,=CYGARC_HAL_LPC2XXX_REG_SCB_BASE
        ldr     r1,=0xFFFFFFFF
        str     r1,[r0,#CYGARC_HAL_LPC2XXX_REG_PCONP]
        ldr     r1,=0x55555555
        str     r1,[r0,#CYGARC_HAL_LPC2XXX_REG_PCLKSEL0]        
        str     r1,[r0,#CYGARC_HAL_LPC2XXX_REG_PCLKSEL1]        
                
#ifdef CYGHWR_HAL_ARM_LPC2XXX_EA_LPC2468_MEMORY_WIDTH_16
        lpc24xx_emc_dynamic_init 2,3,7,2,5,1,5,5,7,1,2,1
        lpc24xx_emc_dynamic      0,0x00000680,0x00000303,0x00033000
#elif defined(CYGHWR_HAL_ARM_LPC2XXX_EA_LPC2468_MEMORY_WIDTH_32)
        lpc24xx_emc_dynamic_init 1,3,5,1,5,1,5,5,5,1,1,1
        lpc24xx_emc_dynamic      0,0x00005480,0x00000202,0x00011000 
#endif
        lpc24xx_emc_static       0,0x00000081,0x2,0x2,0x1f,0x1f,0x1f,0xf
        lpc24xx_emc_static       1,0x00000080,0x2,0x2,0x8,0x1f,0x8,0xf
        
        lpc2xxx_copy_romram
        _led    13
        lpc2xxx_remap
        _led    14
        lpc2xxx_init_mam
        _led    15
        .endm

#if defined(CYG_HAL_STARTUP_ROM) || defined(CYG_HAL_STARTUP_ROMRAM) || defined(CYG_HAL_STARTUP_SRAM)        
#define CYGSEM_HAL_ROM_RESET_USES_JUMP
#define PLATFORM_SETUP1     lpc2xxx_rom_init

// The unused vector must contain the 2's complement of the sum 
// of the other vectors for the on-chip bootstrap to recognize 
// the executable image as valid.
                
#define CYGSEM_HAL_ARM_VECTOR_UNUSED
        .macro  unused_vector
        .long   0xb4405f62             // -((b reset_vector) + 6*(ldr pc,[pc,#24]))
        .endm

#else
#define PLATFORM_SETUP1     lpc2xxx_common_init
#endif
        
//-----------------------------------------------------------------------------
// end of hal_platform_setup.h
#endif // CYGONCE_HAL_PLATFORM_SETUP_H
