#ifndef CYGONCE_HAL_PLATFORM_SETUP_H
#define CYGONCE_HAL_PLATFORM_SETUP_H

/*=============================================================================
//
//      hal_platform_setup.h
//
//      Platform specific support for HAL (assembly code)
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.
// Copyright (C) 2004 eCosCentric Limited                                   
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   jlarmour, nickg
// Contributors:nickg
// Date:        2004-09-27
// Purpose:     Ashling EVBA7 Test Board platform specific support routines
// Description:
// Usage:       #include <cyg/hal/hal_platform_setup.h>
//
//####DESCRIPTIONEND####
//
//===========================================================================*/

#include <cyg/hal/var_io.h>


        // ----------------------------------------------------------------
        .macro  _led_init
        // Set GPIO direction for LED pins (P0.4-7). Don't touch others.
        ldr     r0,=CYGARC_HAL_LPC2XXX_REG_IO_BASE
        ldr     r1,[r0,#CYGARC_HAL_LPC2XXX_REG_IO0DIR]
        ldrc    r2,0x000000F0
        orr     r1,r1,r2
        str     r1,[r0,#CYGARC_HAL_LPC2XXX_REG_IO0DIR]
        
        // All LEDs on to start with
        _led    15
        .endm

        // ----------------------------------------------------------------
        .macro _led y
        ldr     r0,=CYGARC_HAL_LPC2XXX_REG_IO_BASE
        ldrc    r1,0x000000F0
        str     r1,[r0,#CYGARC_HAL_LPC2XXX_REG_IOCLR]
        ldrc    r2,(\y<<4)
        str     r2,[r0,#CYGARC_HAL_LPC2XXX_REG_IOSET]
        .endm


        // ----------------------------------------------------------------
        
        .macro lpc2xxx_common_init
#if defined(CYGHWR_HAL_ARM_LPC2XXX_EVBA7_LPC2104) || \
    defined(CYGHWR_HAL_ARM_LPC2XXX_EVBA7_LPC2105) || \
    defined(CYGHWR_HAL_ARM_LPC2XXX_EVBA7_LPC2106)

        // Set PINSEL0 to allow all relevant pins to allow UART0/1 signals
        // rather than default GPIO.
        // Enable I2C pins too.
        // Leave SPI pins as GPIO for the leds.
                
        lpc2xxx_init_pinsel0 0x55550055

#elif defined(CYGHWR_HAL_ARM_LPC2XXX_EVBA7_LPC2212) || \
      defined(CYGHWR_HAL_ARM_LPC2XXX_EVBA7_LPC2294)

        // Set PINSEL0 to allow all relevant pins to allow UART0/1 signals
        // rather than default GPIO.
        // Enable I2C pins too.
        // Leave SPI pins as GPIO for the leds.
        
        lpc2xxx_init_pinsel0 0x55550055

        // Set PINSEL1 to default value. This leaves all pins in GPIO
	// mode except P0.27 to P0.30, which are set to the A/D converter.
        
        lpc2xxx_init_pinsel1 0x15400000

        lpc2xxx_init_pinsel2 0x0C6009E4
#else
#error No EVBA7 variant defined        
#endif                
        _led_init
        .endm

        // ----------------------------------------------------------------
        
        .macro  lpc2xxx_rom_init
        lpc2xxx_common_init
        _led    0
        lpc2xxx_init_pll
        _led    12
        lpc2xxx_init_emc 0,0x20001c20,0,0                                              
        lpc2xxx_copy_romram
        _led    13
        lpc2xxx_remap
        _led    14
        lpc2xxx_init_mam        
        _led    15
        .endm

#if defined(CYG_HAL_STARTUP_ROM) || defined(CYG_HAL_STARTUP_ROMRAM) || defined(CYG_HAL_STARTUP_SRAM)        
#define CYGSEM_HAL_ROM_RESET_USES_JUMP
#define PLATFORM_SETUP1     lpc2xxx_rom_init
#else
#define PLATFORM_SETUP1     lpc2xxx_common_init
#endif
        
//-----------------------------------------------------------------------------
// end of hal_platform_setup.h
#endif // CYGONCE_HAL_PLATFORM_SETUP_H
