#ifndef CYGONCE_HAL_PLATFORM_SETUP_H
#define CYGONCE_HAL_PLATFORM_SETUP_H

/*=============================================================================
//
//      hal_platform_setup.h
//
//      Platform specific support for HAL (assembly code)
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2006, 2008 Free Software Foundation, Inc.
// Copyright (C) 2004, 2006, 2008 eCosCentric Limited                       
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   jlarmour, nickg
// Contributors:nickg
// Date:        2008-12-02
// Purpose:     Keil MCB2387 board platform specific support routines
// Description:
// Usage:       #include <cyg/hal/hal_platform_setup.h>
//
//####DESCRIPTIONEND####
//
//===========================================================================*/

#include <cyg/hal/var_io.h>


        // ----------------------------------------------------------------
            
//#define LED_DELAY       (5*1000000)
#define LED_DELAY       (15*10000)        
        
        .macro  _led_init
_led_init:              
        lpc2xxx_init_pinsel4 0x00000000
        ldr     r0,=CYGARC_HAL_LPC2XXX_REG_PIN_BASE
        ldr     r1,=0x0000AAAA
        str     r1,[r0,#CYGARC_HAL_LPC2XXX_REG_PINMODE4]
        
        ldr     r0,=CYGARC_HAL_LPC2XXX_REG_FIO_BASE
        ldr     r1,=0x000000FF
        ldr     r2,[r0,# CYGARC_HAL_LPC2XXX_REG_FIODIR(2)]
        orr     r2,r2,r1
        str     r2,[r0,# CYGARC_HAL_LPC2XXX_REG_FIODIR(2)]
        str     r1,[r0,# CYGARC_HAL_LPC2XXX_REG_FIOSET(2)]
        .endm

        // ----------------------------------------------------------------

        .macro _led y
        ldr     r0,=CYGARC_HAL_LPC2XXX_REG_FIO_BASE
        ldr     r1,=0xFF
        str     r1,[r0,# CYGARC_HAL_LPC2XXX_REG_FIOCLR(2)]
        ldr     r1,=\y
        str     r1,[r0,# CYGARC_HAL_LPC2XXX_REG_FIOSET(2)]
#if 0
        ldr     r0,=LED_DELAY
1:      add     r0,r0,#-1
        cmp     r0,#0
        bne     1b
#endif
        .endm
        
        
        // ----------------------------------------------------------------
        
        .macro lpc2xxx_common_init

        // Enable Fast GPIO on ports 0 and 1

        ldr     r0,=CYGARC_HAL_LPC2XXX_REG_SCB_BASE
        mov     r2,#CYGARC_HAL_LPC2XXX_REG_SCS_GPIO_FAST        
        ldr     r1,[r0,#CYGARC_HAL_LPC2XXX_REG_SCS]
        orr     r1,r1,r2
        str     r1,[r0,#CYGARC_HAL_LPC2XXX_REG_SCS]
                        
        .endm

        // ----------------------------------------------------------------

        .macro lpc2xxx_pinsel_init
        
        // PINSEL0:     
        // P0.2 to P0.3         :       UART0
        // P0.15                :       UART1
        // All others           :       Default to GPIO
        
        lpc2xxx_init_pinsel0 0x40000050


        // PINSEL1:
        // P0.16                :       UART1
        // P0.23                :       AD0[0]
        // P0.24                :       AD0[1]
        // P0.25                :       AD0[2]
        // P0.26                :       AOUT
        // All others           :       Default to GPIO
        
        lpc2xxx_init_pinsel1 0x00254001

        
        // PINSEL2:
        // All                  :       Default to GPIO
                
        lpc2xxx_init_pinsel2 0x00000000

        
        // PINSEL3:
        // P1.30                :       AD0[4]
        // P1.31                :       AD0[5]
        // All others           :       Default to GPIO
                
        lpc2xxx_init_pinsel3 0xf0000000

        
        // PINSEL4:
        // All                  :       Default to GPIO
                
        lpc2xxx_init_pinsel4 0x00000000

        
        // PINSEL5:
        // All                  :       Default to GPIO
             
        lpc2xxx_init_pinsel5 0x00000000
        
        // PINSEL6:     
        // Not used on LPC2387

        
        // PINSEL7:
        // All                  :       Default to GPIO             

        lpc2xxx_init_pinsel7 0x00000000

        
        // PINSEL8:
        // Not used on LPC2387
        
        // PINSEL9:
        // All                  :       Default to GPIO
             
        lpc2xxx_init_pinsel9 0x00000000

        
        // PINSEL10:     
        // All                  :       Default to GPIO

        lpc2xxx_init_pinsel10 0x00000000

        .endm

        // ----------------------------------------------------------------
        
        .macro  lpc2xxx_rom_init

        _led_init
        
        lpc2xxx_common_init
        _led    10
        lpc2xxx_pinsel_init        
        _led    11        
        lpc2xxx_init_pll
        _led    12

        // Turn on all peripheral clocks and set their dividers to 1, so PCLK == CCLK.
        // Except RTC, which must have a divided clock.

        ldr     r0,=CYGARC_HAL_LPC2XXX_REG_SCB_BASE
        ldr     r1,=0xFFFFFFFF
        str     r1,[r0,#CYGARC_HAL_LPC2XXX_REG_PCONP]
        ldr     r1,=0x55515555
        str     r1,[r0,#CYGARC_HAL_LPC2XXX_REG_PCLKSEL0]        
        str     r1,[r0,#CYGARC_HAL_LPC2XXX_REG_PCLKSEL1]        
                        
        lpc2xxx_copy_romram
        _led    13
        lpc2xxx_remap
        _led    14
        lpc2xxx_init_mam
        _led    15
        .endm

#if defined(CYG_HAL_STARTUP_ROM) || defined(CYG_HAL_STARTUP_JTAG)        

#define CYGSEM_HAL_ROM_RESET_USES_JUMP
#define PLATFORM_SETUP1     lpc2xxx_rom_init

// The unused vector must contain the 2's complement of the sum 
// of the other vectors for the on-chip bootstrap to recognize 
// the executable image as valid.
                
#define CYGSEM_HAL_ARM_VECTOR_UNUSED
        .macro  unused_vector
        .long   0xb4405f62             // -((b reset_vector) + 6*(ldr pc,[pc,#24]))
        .endm

#else
#define PLATFORM_SETUP1     lpc2xxx_common_init
#endif
        
//-----------------------------------------------------------------------------
// end of hal_platform_setup.h
#endif // CYGONCE_HAL_PLATFORM_SETUP_H
