//==========================================================================
//
//      ixp4xx_serial.inl
//
//      IXP4xx Serial I/O definitions
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2004, 2006 Free Software Foundation, Inc.
// Copyright (C) 2004,2006 eCosCentric Limited                              
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    jlarmour
// Contributors: 
// Date:         2006-03-21
// Purpose:      Intel XScale IXP4xx Serial I/O module
// Description: 
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <cyg/hal/hal_intr.h>
#include <cyg/hal/hal_io.h>            // For platform definitions

//-----------------------------------------------------------------------------
// Baud rate specification

// UART clock is fixed at 14.7456MHz so we can calculate static divisor values
// with the formula: divisor=14745600/(baud*16)
//
// Note that the IXP4xx supports even higher speeds which we do not support.

static unsigned int select_baud[] = {
    0,          // Unused -- marker
    18432,      // 50
    12288,      // 75
    8378,       // 110
    6852,       // 134.5
    6144,       // 150
    4608,       // 200
    3072,       // 300
    1536,       // 600
    768,        // 1200
    512,        // 1800
    384,        // 2400
    256,        // 3600
    192,        // 4800
    128,        // 7200
    96,         // 9600
    64,         // 14400
    48,         // 19200
    24,         // 38400
    16,         // 57600
    8,          // 115200
    4           // 230400
};

//-----------------------------------------------------------------------------
// Initialization hook

// The IXP4xx has a bit in the IER that controls whether the UART as a whole is
// enabled or disabled, where 0 means disabled. Not very 16x5x compatible :-|.
// Therefore we use an init hook to set it.

#define SIO_IER_UUE 0x40  // UART Unit Enable

#define CYGPRI_IO_SERIAL_GENERIC_16X5X_PLF_INIT_HOOK( ser_chan, new_config ) \
    CYG_MACRO_START                                                     \
    unsigned char _ier;                                                 \
    HAL_READ_UINT8( ser_chan->base+REG_ier, _ier );                     \
    _ier |= SIO_IER_UUE;                                                \
    HAL_WRITE_UINT8( ser_chan->base+REG_ier, _ier );                    \
    CYG_MACRO_END

//-----------------------------------------------------------------------------

#ifdef CYGPKG_IO_SERIAL_ARM_IXP4XX_SERIAL0
static pc_serial_info ixp4xx_serial_info0 = {0xC8000000,
                                             CYGNUM_HAL_INTERRUPT_UART1};
#if CYGNUM_IO_SERIAL_ARM_IXP4XX_SERIAL0_BUFSIZE > 0
static unsigned char ixp4xx_serial_out_buf0[CYGNUM_IO_SERIAL_ARM_IXP4XX_SERIAL0_BUFSIZE];
static unsigned char ixp4xx_serial_in_buf0[CYGNUM_IO_SERIAL_ARM_IXP4XX_SERIAL0_BUFSIZE];

static SERIAL_CHANNEL_USING_INTERRUPTS(ixp4xx_serial_channel0,
                                       pc_serial_funs, 
                                       ixp4xx_serial_info0,
                                       CYG_SERIAL_BAUD_RATE(CYGNUM_IO_SERIAL_ARM_IXP4XX_SERIAL0_BAUD),
                                       CYG_SERIAL_STOP_DEFAULT,
                                       CYG_SERIAL_PARITY_DEFAULT,
                                       CYG_SERIAL_WORD_LENGTH_DEFAULT,
                                       CYG_SERIAL_FLAGS_DEFAULT,
                                       &ixp4xx_serial_out_buf0[0], sizeof(ixp4xx_serial_out_buf0),
                                       &ixp4xx_serial_in_buf0[0], sizeof(ixp4xx_serial_in_buf0)
    );
#else
static SERIAL_CHANNEL(ixp4xx_serial_channel0,
                      pc_serial_funs, 
                      ixp4xx_serial_info0,
                      CYG_SERIAL_BAUD_RATE(CYGNUM_IO_SERIAL_ARM_IXP4XX_SERIAL0_BAUD),
                      CYG_SERIAL_STOP_DEFAULT,
                      CYG_SERIAL_PARITY_DEFAULT,
                      CYG_SERIAL_WORD_LENGTH_DEFAULT,
                      CYG_SERIAL_FLAGS_DEFAULT
    );
#endif

DEVTAB_ENTRY(ixp4xx_serial_io0, 
             CYGDAT_IO_SERIAL_ARM_IXP4XX_SERIAL0_NAME,
             0,                     // Does not depend on a lower level interface
             &cyg_io_serial_devio, 
             pc_serial_init, 
             pc_serial_lookup,     // Serial driver may need initializing
             &ixp4xx_serial_channel0
    );
#endif //  CYGPKG_IO_SERIAL_ARM_IXP4XX_SERIAL0

//-----------------------------------------------------------------------------

#ifdef CYGPKG_IO_SERIAL_ARM_IXP4XX_SERIAL1
static pc_serial_info ixp4xx_serial_info1 = {0xC8001000,
                                             CYGNUM_HAL_INTERRUPT_UART2};
#if CYGNUM_IO_SERIAL_ARM_IXP4XX_SERIAL1_BUFSIZE > 0
static unsigned char ixp4xx_serial_out_buf1[CYGNUM_IO_SERIAL_ARM_IXP4XX_SERIAL1_BUFSIZE];
static unsigned char ixp4xx_serial_in_buf1[CYGNUM_IO_SERIAL_ARM_IXP4XX_SERIAL1_BUFSIZE];

static SERIAL_CHANNEL_USING_INTERRUPTS(ixp4xx_serial_channel1,
                                       pc_serial_funs, 
                                       ixp4xx_serial_info1,
                                       CYG_SERIAL_BAUD_RATE(CYGNUM_IO_SERIAL_ARM_IXP4XX_SERIAL1_BAUD),
                                       CYG_SERIAL_STOP_DEFAULT,
                                       CYG_SERIAL_PARITY_DEFAULT,
                                       CYG_SERIAL_WORD_LENGTH_DEFAULT,
                                       CYG_SERIAL_FLAGS_DEFAULT,
                                       &ixp4xx_serial_out_buf1[0], sizeof(ixp4xx_serial_out_buf1),
                                       &ixp4xx_serial_in_buf1[0], sizeof(ixp4xx_serial_in_buf1)
    );
#else
static SERIAL_CHANNEL(ixp4xx_serial_channel1,
                      pc_serial_funs, 
                      ixp4xx_serial_info1,
                      CYG_SERIAL_BAUD_RATE(CYGNUM_IO_SERIAL_ARM_IXP4XX_SERIAL1_BAUD),
                      CYG_SERIAL_STOP_DEFAULT,
                      CYG_SERIAL_PARITY_DEFAULT,
                      CYG_SERIAL_WORD_LENGTH_DEFAULT,
                      CYG_SERIAL_FLAGS_DEFAULT
    );
#endif

DEVTAB_ENTRY(ixp4xx_serial_io1, 
             CYGDAT_IO_SERIAL_ARM_IXP4XX_SERIAL1_NAME,
             0,                     // Does not depend on a lower level interface
             &cyg_io_serial_devio, 
             pc_serial_init, 
             pc_serial_lookup,     // Serial driver may need initializing
             &ixp4xx_serial_channel1
    );
#endif //  CYGPKG_IO_SERIAL_ARM_IXP4XX_SERIAL1

//-----------------------------------------------------------------------------
// EOF ixp4xx_serial.inl
