#ifndef CYGONCE_HAL_VAR_INTR_H
#define CYGONCE_HAL_VAR_INTR_H
//==========================================================================
//
//      var_intr.h
//
//      HAL Interrupt and clock assignments for LM3S variants
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2008, 2009 Free Software Foundation, Inc.                        
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    nickg
// Date:         2009-07-30
// Purpose:      Define Interrupt support
// Description:  The interrupt specifics for LM3S variants are
//               defined here.
//              
// Usage:        #include <cyg/hal/var_intr.h>
//               However applications should include using <cyg/hal/hal_intr.h>
//               instead to allow for platform overrides.
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <cyg/hal/plf_intr.h>

//==========================================================================
// Interrupt vectors
//
// Only the main hardware vectors are currently supported. In theory
// each GPIO line is capable of generating an interrupt, which we
// could trampoline into further vectors. However, with 7 ports of 8
// pins each, that would be an extra 56 vectors, an extra 672 bytes of
// tables and associated code. This is too much for somthing that will
// get used infrequently. Instead the user will have to attach to the
// per-GPIO controller vectors and decode the sources pins themself.

#define CYGNUM_HAL_INTERRUPT_GPIOA              ( 0+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_GPIOB              ( 1+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_GPIOC              ( 2+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_GPIOD              ( 3+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_GPIOE              ( 4+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_UART0              ( 5+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_UART1              ( 6+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_SSI0               ( 7+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_I2C0               ( 8+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_PWM_FAULT          ( 9+CYGNUM_HAL_INTERRUPT_EXTERNAL)

#define CYGNUM_HAL_INTERRUPT_PWM_GEN0           (10+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_PWM_GEN1           (11+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_PWM_GEN2           (12+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_QEI0               (13+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_ADC0               (14+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_ADC1               (15+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_ADC2               (16+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_ADC3               (17+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_WATCHDOG           (18+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_TIMER0A            (19+CYGNUM_HAL_INTERRUPT_EXTERNAL)

#define CYGNUM_HAL_INTERRUPT_TIMER0B            (20+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_TIMER1A            (21+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_TIMER1B            (22+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_TIMER2A            (23+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_TIMER2B            (24+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_ANALOG0            (25+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_RESV_26            (26+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_RESV_27            (27+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_SYSTEM             (28+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_FLASH              (29+CYGNUM_HAL_INTERRUPT_EXTERNAL)

#define CYGNUM_HAL_INTERRUPT_GPIOF              (30+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_GPIOG              (31+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_RESV_32            (32+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_RESV_33            (33+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_RESV_34            (34+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_TIMER3A            (35+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_TIMER3B            (36+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_RESV_37            (37+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_QEI1               (38+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_CAN0               (39+CYGNUM_HAL_INTERRUPT_EXTERNAL)

#define CYGNUM_HAL_INTERRUPT_RESV_40            (40+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_RESV_41            (41+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_ETH                (42+CYGNUM_HAL_INTERRUPT_EXTERNAL)
#define CYGNUM_HAL_INTERRUPT_HIBERNATE          (43+CYGNUM_HAL_INTERRUPT_EXTERNAL)

#define CYGNUM_HAL_INTERRUPT_NVIC_MAX           (43+CYGNUM_HAL_INTERRUPT_EXTERNAL)

#define CYGNUM_HAL_ISR_MIN                     0
#define CYGNUM_HAL_ISR_MAX                     CYGNUM_HAL_INTERRUPT_HIBERNATE
#define CYGNUM_HAL_ISR_COUNT                   (CYGNUM_HAL_ISR_MAX + 1)

#define CYGNUM_HAL_VSR_MIN                     0
#ifndef CYGNUM_HAL_VSR_MAX
#define CYGNUM_HAL_VSR_MAX                     (CYGNUM_HAL_VECTOR_SYS_TICK+CYGNUM_HAL_INTERRUPT_NVIC_MAX)
#endif
#define CYGNUM_HAL_VSR_COUNT                   (CYGNUM_HAL_VSR_MAX+1)

//----------------------------------------------------------------------------
#endif // CYGONCE_HAL_VAR_INTR_H
// EOF var_intr.h
