//==========================================================================
//
//        kprio.c
//
//        Thread prioirity test
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2005, 2006 Free Software Foundation, Inc.                  
// Copyright (C) 2005, 2006 eCosCentric Limited                             
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):     nickg
// Contributors:  nickg
// Date:          2005-12-19
// Description:   Test range of thread priorities.
//
//####DESCRIPTIONEND####
//==========================================================================

#include <pkgconf/hal.h>
#include <pkgconf/kernel.h>

#include <cyg/infra/testcase.h>

#include <cyg/hal/hal_arch.h>           // CYGNUM_HAL_STACK_SIZE_TYPICAL

#include <cyg/infra/cyg_ass.h>
#include <cyg/infra/cyg_trac.h>
#include <cyg/infra/diag.h>             // diag_printf

#include <cyg/kernel/kapi.h>

// ------------------------------------------------------------------------

#define NTHREADS (CYGNUM_KERNEL_SCHED_PRIORITIES-1)

#define STACKSIZE CYGNUM_HAL_STACK_SIZE_TYPICAL

static cyg_handle_t thread[NTHREADS];
static cyg_thread thread_obj[NTHREADS];
static char stack[NTHREADS][STACKSIZE];

static int thread_run[NTHREADS];

// ------------------------------------------------------------------------

#ifdef CYGSEM_HAL_STOP_CONSTRUCTORS_ON_FLAG
externC void
cyg_hal_invoke_constructors();
#endif

// ------------------------------------------------------------------------

volatile int fails = 0;

// ------------------------------------------------------------------------

static void test_thread( cyg_addrword_t data )
{
//    diag_printf("<INFO>: test_thread %p id %d priority %d\n", cyg_thread_self(), data, cyg_thread_get_priority(self) );

    thread_run[data]++;

    cyg_thread_exit();
}

// ------------------------------------------------------------------------

static void control_thread( cyg_addrword_t data )
{
    int i;

   
    // One thread per priority level.

    for( i = 1; i < NTHREADS; i++ )
    {
        thread_run[i] = 0;
        cyg_thread_create( i,
                           test_thread,
                           (cyg_addrword_t)i,
                           "test thread",
                           (void *)stack[i],
                           STACKSIZE,
                           &thread[i],
                           &thread_obj[i]);
        cyg_thread_resume(thread[i]);
    }

    cyg_thread_delay( 100 );
    
    for( i = 1; i < NTHREADS; i++ )
    {
        if( thread_run[i] != 1 )
        {
            CYG_TEST_FAIL("Thread did not run");
            fails++;
        }
        cyg_thread_delete(thread[i]);
    }


    // Assign threads to buckets spread across the priority range.
    
    for( i = 1; i < NTHREADS; i++ )
    {
        thread_run[i] = 0;
        cyg_thread_create( i - (i % 5),
                           test_thread,
                           (cyg_addrword_t)i,
                           "test thread",
                           (void *)stack[i],
                           STACKSIZE,
                           &thread[i],
                           &thread_obj[i]);
        cyg_thread_resume(thread[i]);
    }

    cyg_thread_delay( 100 );
    
    for( i = 1; i < NTHREADS; i++ )
    {
        if( thread_run[i] != 1 )
        {
            CYG_TEST_FAIL("Thread did not run");
            fails++;
        }
        cyg_thread_delete(thread[i]);
    }


    if( fails > 0 )
        CYG_TEST_FAIL_FINISH("kprio");
    else
        CYG_TEST_PASS_FINISH("kprio");
    
}

// ------------------------------------------------------------------------

#if defined(CYGSEM_KERNEL_SCHED_MLQUEUE)

externC void
cyg_user_start( void )
{ 
#ifdef CYGSEM_HAL_STOP_CONSTRUCTORS_ON_FLAG
    cyg_hal_invoke_constructors();
#endif

    CYG_TEST_INIT();

    cyg_thread_create( 0,
                       control_thread ,
                       (cyg_addrword_t)0,
                       "control_thread",
                       (void *)stack[0],
                       STACKSIZE,
                       &thread[0],
                       &thread_obj[0]);
    cyg_thread_resume(thread[0]);

    cyg_scheduler_start();

    CYG_TEST_FAIL_FINISH("Not reached");
}

#else

externC void
cyg_user_start( void )
{ 
#ifdef CYGSEM_HAL_STOP_CONSTRUCTORS_ON_FLAG
    cyg_hal_invoke_constructors();
#endif
    CYG_TEST_INIT();    
    CYG_TEST_NA("Test will not work in this configuration");
    
}

#endif


// ------------------------------------------------------------------------
// EOF kprio.c
