#include <pkgconf/system.h>
#include <pkgconf/libstdcxx.h> // config header
#ifdef CYGPKG_ISOINFRA
# include <pkgconf/isoinfra.h>
#endif
#include <cyg/infra/testcase.h>

#if !defined(CYGPKG_ISOINFRA)
# define NA_MSG "Requires isoinfra package"
#elif !defined(CYGPKG_LIBSTDCXX_LIBRARY)
# define NA_MSG "Requires libstdc++ library support"
#elif !CYGINT_ISO_MAIN_STARTUP
# define NA_MSG "Requires main() startup"
#endif

#ifdef NA_MSG

externC void
cyg_start()
{
    CYG_TEST_INIT();
    CYG_TEST_NA( NA_MSG );
    CYG_TEST_FINISH("Done");
}
#else

// { dg-options "-O0" }
// 2000-11-20
// Benjamin Kosnik bkoz@redhat.com

// Copyright (C) 2000, 2003 Free Software Foundation, Inc.
// Copyright (C) 2006 eCosCentric Ltd.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

#include <complex>
#include "tscpp/testsuite_hooks.h"

/* For this test, we need to test equality of doubles, where it is
 * possible there are limitations for doubles that don't allow tests for
 * exact equality.  Hence: */
#define FABS( a )   ((0.0<=(a))?(a):(-(a)))
#define MAX( a, b ) (((a)>(b))?(a):(b))

/* Check for beeing equal, or one being zero and the other small, or the
 * difference being small relative to the magnitude of either. */
#define DEQ( a, b )  (((a)==(b))||\
                      ((0.0==(a))&&FABS(b)<(1e-6))||\
                      ((0==(b))&&FABS(a)<(1e-6))||\
                      ((1e-6)>(FABS(a-b)/MAX(FABS(a),FABS(b)))))

void test01()
{
 using namespace std;
 bool test = true;
 typedef complex<double> complex_type;
 const double cd1 = -11.451;
 const double cd2 = -442.1533;

 complex_type a(cd1, cd2);
 double d;
 d = a.real();
 VERIFY( d == cd1);

 d = a.imag();
 VERIFY(d == cd2);

 complex_type c(cd1, cd2);
 double d6 = abs(c);
 VERIFY( d6 >= 0);

 double d7 = arg(c);
 double d8 = atan2(c.imag(), c.real());
 VERIFY( DEQ(d7, d8) );

 double d9 = norm(c);
 double d10 = d6 * d6;
 VERIFY( DEQ(d9,d10) ) ;

 complex_type e = conj(c);
 
 complex_type f = polar(c.imag(), 0.0);
 VERIFY(f.real() != 0);
}


int main()
{
    CYG_TEST_INIT();
  test01();
  CYG_TEST_PASS_FINISH( "complex_value done" );
  return 0;
}

#endif // !NA_MSG

// EOF
