//========================================================================
//
//      sys_arch.h
//
//      Definitions for abstraction layer between lwIP and eCos
//
//========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2004, 2006 Free Software Foundation, Inc.                  
// Copyright (C) 2004, 2006 eCosCentric Limited                             
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):     Jani Monoses, jlarmour
// Contributors:  
// Date:          2004-05-04
// Purpose:       Provides definitions for abstraction
//                layer between lwIP and eCos
// Description:   Part of lwip - eCos abstraction layer
// Usage:
//
//####DESCRIPTIONEND####
//
//========================================================================

#ifndef __SYS_ECOS_H__
#define __SYS_ECOS_H__

/* Abstraction layer uses eCos native C++ API which is not usable from C code,
 * so in turn abstract that away.
 */
#include <stddef.h>  /* NULL */
#include <cyg/infra/cyg_type.h>

#define SYS_MBOX_NULL (sys_mbox_t)NULL 
#define SYS_SEM_NULL  (sys_sem_t)NULL

typedef void*        sys_sem_t;
typedef CYG_ADDRESS  sys_mbox_t;
typedef CYG_ADDRESS  sys_thread_t;

/* Used by sockets.c */
#define ERRNO

/* Defines used internally by eCos lwip port */
#define CYG_LWIP_TCPIP_THREAD_EVENT_MBOX_MSG      (1<<0)
#define CYG_LWIP_TCPIP_THREAD_EVENT_ETH_DELIVERY  (1<<1)
#define CYG_LWIP_TCPIP_THREAD_EVENT_ETH_RX        (1<<2)

/* Use special routine from tcpip thread to get messages if we also want
 * it to process incoming eth packets
 */
#ifdef CYGPKG_LWIP_ETH
__externC void cyg_lwip_tcpip_sys_mbox_fetch( sys_mbox_t, void ** );

#define TCPIP_SYS_MBOX_FETCH( _mbox_, _msg_ ) \
                                 cyg_lwip_tcpip_sys_mbox_fetch( _mbox_, _msg_ )
#endif

#endif /* __SYS_ECOS_H__ */

/* EOF sys_arch.h */
