#ifndef CYGONCE_DEVS_SER_PL011_H
#define CYGONCE_DEVS_SER_PL011_H
//==========================================================================
//
//      ser_pl011.h
//
//      Generic ARM PL011 macrocell serial header
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2006 Free Software Foundation, Inc.
// Copyright (C) 2003, 2004, 2006 eCosCentric Limited                       
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    chris, nickg
// Contributors: jlarmour
// Date:         2008-03-18
// Purpose:      PL011 generic serial driver
// Description:  The contents of this file are entirely derived from the
//               Versatile board HAL's vpb926ejs.h by nickg.
//
//####DESCRIPTIONEND####
//
//==========================================================================

#define _UART_DR		0x00     /*  Data read or written from the interface. */

#define _UART_RSR		0x04     /*  Receive status register (Read). */
#define _UART_ECR		0x04     /*  Error clear register (Write). */
#define  _UART_RSR_OE		0x08
#define  _UART_RSR_BE		0x04
#define  _UART_RSR_PE		0x02
#define  _UART_RSR_FE		0x01

#define _UART_FR		0x18     /*  Flag register (Read only). */
#define  _UART_FR_RI		0x100
#define  _UART_FR_TXFE		0x080
#define  _UART_FR_RXFF		0x040
#define  _UART_FR_TXFF		0x020
#define  _UART_FR_RXFE		0x010
#define  _UART_FR_BUSY		0x008
#define  _UART_FR_DCD		0x004
#define  _UART_FR_DSR		0x002
#define  _UART_FR_CTS		0x001

#define _UART_IBRD		0x24
#define _UART_FBRD		0x28

#define _UART_LCRH		0x2C
#define  _UART_LCRH_SPS		(1 << 7)
#define  _UART_LCRH_WLEN_8	(3 << 5)
#define  _UART_LCRH_WLEN_7	(2 << 5)
#define  _UART_LCRH_WLEN_6	(1 << 5)
#define  _UART_LCRH_WLEN_5	(0 << 5)
#define  _UART_LCRH_FEN		(1 << 4)
#define  _UART_LCRH_STP2	(1 << 3)
#define  _UART_LCRH_EPS		(1 << 2)
#define  _UART_LCRH_PEN		(1 << 1)
#define  _UART_LCRH_BRK		(1 << 0)

#define _UART_CR		0x30
#define  _UART_CR_CTSEN		(1 << 15)
#define  _UART_CR_RTSEN		(1 << 14)
#define  _UART_CR_OUT2		(1 << 13)
#define  _UART_CR_OUT1		(1 << 12)
#define  _UART_CR_RTS		(1 << 11)
#define  _UART_CR_DTR		(1 << 10)
#define  _UART_CR_RXE		(1 << 9)
#define  _UART_CR_TXE		(1 << 8)
#define  _UART_CR_LPE		(1 << 7)
#define  _UART_CR_IIRLP		(1 << 2)
#define  _UART_CR_SIREN		(1 << 1)
#define  _UART_CR_UARTEN	(1 << 0)

#ifdef CYGPKG_IO_SERIAL_PL011_FIFO

#define _UART_IFLS              0x34

#define  _UART_IFLS_TX(__x)     ((__x)&0x7)
#define  _UART_IFLS_RX(__x)     (((__x)&0x7)<<3)

#endif


#define _UART_IMSC		0x38
#define _UART_MIS		0x40
#define _UART_ICR		0x44
#define  _UART_IMSC_OEIM	(1 << 10)
#define  _UART_IMSC_BEIM	(1 << 9)
#define  _UART_IMSC_PEIM	(1 << 8)
#define  _UART_IMSC_FEIM	(1 << 7)
#define  _UART_IMSC_RTIM	(1 << 6)
#define  _UART_IMSC_TXIM	(1 << 5)
#define  _UART_IMSC_RXIM	(1 << 4)
#define  _UART_IMSC_DSRMIM	(1 << 3)
#define  _UART_IMSC_DCDMIM	(1 << 2)
#define  _UART_IMSC_CTSMIM	(1 << 1)
#define  _UART_IMSC_RIMIM	(1 << 0)

//==========================================================================

#endif	// ifndef CYGONCE_DEVS_SER_PL011_H

//==========================================================================
// EOF ser_pl011.h
