//==========================================================================
//
//      devs/wallclock/arm/at91/VERSION/src/wallclock_at91rttc.cxx
//
//      Wallclock implementation for Atmel AT91SAM7/9 CPUs
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2004, 2005, 2007 Free Software Foundation, Inc.
// Copyright (C) 2004, 2005, 2007 eCosCentric Limited                       
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):     nickg based on AT91 wallclock by jlarmour
// Contributors:  
// Date:          2007-09-26
// Purpose:       Wallclock driver for on-board RTC of Atmel AT91SAM7/9 CPUs.
// Description:   Based on eCosCentric LPC2xxx wallclock driver.
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <pkgconf/wallclock.h>          // Wallclock device config
#include <pkgconf/system.h>             // System package configuration

#include <cyg/hal/hal_io.h>             // IO macros
#include <cyg/hal/hal_intr.h>           // Interrupt macros
#include <cyg/infra/cyg_type.h>         // Common type definitions and support
#include <cyg/infra/cyg_ass.h>          // Assertions
#include <cyg/infra/cyg_trac.h>          // Assertions

#include <cyg/infra/diag.h>

#include <cyg/io/wallclock.hxx>         // The WallClock API

//-----------------------------------------------------------------------------

// The RTTC counter cannot be set to an arbitrary value, it can only
// be zeroed. This means that it can only be used to track the passage
// of time and not provide a date and time. So when the wallclock is
// set we record the value set and the RTTC time at which this
// happened and then calculate the new time from these when the
// wallclock is read.

static cyg_uint32 set_seconds, set_rttc;


//-----------------------------------------------------------------------------
// Functions required for the hardware-driver API.

// Returns the number of seconds elapsed since 1970-01-01 00:00:00.
cyg_uint32 
Cyg_WallClock::get_hw_seconds(void)
{
    cyg_uint32 rttc0, rttc1;

    // Ensure that we read a consistent timer value.
    do
    {
        HAL_READ_UINT32( AT91_RTTC+AT91_RTTC_RTVR, rttc0 );
        HAL_READ_UINT32( AT91_RTTC+AT91_RTTC_RTVR, rttc1 );
    } while( rttc0 != rttc1 );

    return set_seconds - set_rttc + rttc0;
}

#ifdef CYGSEM_WALLCLOCK_SET_GET_MODE
// Sets the clock. Argument is seconds elapsed since 1970-01-01 00:00:00.
void
Cyg_WallClock::set_hw_seconds( cyg_uint32 secs )
{
    cyg_uint32 rttc0, rttc1;

    // Ensure that the setting of set_seconds and set_rttc does not
    // occur across a change in the timer value.
    do
    {
        HAL_READ_UINT32( AT91_RTTC+AT91_RTTC_RTVR, rttc0 );
        set_seconds = secs;
        set_rttc = rttc0;
        HAL_READ_UINT32( AT91_RTTC+AT91_RTTC_RTVR, rttc1 );
    } while( rttc0 != rttc1 );
}
#endif

void
Cyg_WallClock::init_hw_seconds(void)
{
    // Force to known good state, just in case. Enable the timer and
    // set the prescaler to select 1s ticks.
    
    HAL_WRITE_UINT32( AT91_RTTC+AT91_RTTC_RTMR, 0x00008000 );

#ifndef CYGSEM_WALLCLOCK_SET_GET_MODE
    // This is our base: 1970-01-01 00:00:00
    // Set the HW clock - if for nothing else, just to be sure it's in a
    // legal range. Any arbitrary base could be used.
    // After this the hardware clock is only read.

    set_hw_seconds(0);
#endif    
}

//-----------------------------------------------------------------------------
// End of devs/wallclock/arm/at91/wallclock_at91.cxx
