//==========================================================================
//
//      wallclock_omap_l1xx.cxx
//
//      eCos TI OMAP L1XX wallclock
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Free Software Foundation, Inc.
// Copyright (C) 2009 eCosCentric Ltd.
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):     nickg
// Date:          2009-12-09
// Purpose:        
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <pkgconf/wallclock.h>           

#include <cyg/hal/hal_io.h>               
#include <cyg/hal/hal_arch.h>

#include <cyg/infra/cyg_type.h>          
#include <cyg/infra/diag.h>            

#include <cyg/io/wallclock.hxx>           // The WallClock API
#include <cyg/io/wallclock/wallclock.inl> // Helpers

//-----------------------------------------------------------------------------
// Functions for setting and getting the hardware clock counters

static void
set_omap_l1xx_hwclock(cyg_uint32 year, cyg_uint32 month, cyg_uint32 mday,
                     cyg_uint32 hour, cyg_uint32 minute, cyg_uint32 second)
{
    cyg_uint32 rtc = CYGHWR_HAL_L1XX_RTC;
    cyg_uint32 status;
    
    // Year must be last two digits within century.
    if (year > 100)
        year %= 100;

    // Unlock RTC registers
    HAL_WRITE_UINT32( rtc+CYGHWR_HAL_L1XX_RTC_KICK0, CYGHWR_HAL_L1XX_RTC_KICK0_UNLOCK );
    HAL_WRITE_UINT32( rtc+CYGHWR_HAL_L1XX_RTC_KICK1, CYGHWR_HAL_L1XX_RTC_KICK1_UNLOCK );

    // Wait for busy to clear
    do
    {
        HAL_READ_UINT32( rtc+CYGHWR_HAL_L1XX_RTC_STATUS, status );
    } while( (status & CYGHWR_HAL_L1XX_RTC_STATUS_BUSY) != 0 );
    
    // Program data and time to RTC
    HAL_WRITE_UINT8(rtc+CYGHWR_HAL_L1XX_RTC_YEAR,       TO_BCD(year));
    HAL_WRITE_UINT8(rtc+CYGHWR_HAL_L1XX_RTC_MONTH,      TO_BCD(month));
    HAL_WRITE_UINT8(rtc+CYGHWR_HAL_L1XX_RTC_DOTW,       TO_BCD(0)); // not used
    HAL_WRITE_UINT8(rtc+CYGHWR_HAL_L1XX_RTC_DAY,        TO_BCD(mday));
    HAL_WRITE_UINT8(rtc+CYGHWR_HAL_L1XX_RTC_HOUR,       TO_BCD(hour));
    HAL_WRITE_UINT8(rtc+CYGHWR_HAL_L1XX_RTC_MINUTE,     TO_BCD(minute));
    HAL_WRITE_UINT8(rtc+CYGHWR_HAL_L1XX_RTC_SECOND,     TO_BCD(second));

    // Lock RTC registers
    HAL_WRITE_UINT32( rtc+CYGHWR_HAL_L1XX_RTC_KICK0, 0 );
    HAL_WRITE_UINT32( rtc+CYGHWR_HAL_L1XX_RTC_KICK1, 0 );
}

static void
init_omap_l1xx_hwclock(void)
{
    cyg_uint32 rtc = CYGHWR_HAL_L1XX_RTC;
    
    // Unlock RTC registers
    HAL_WRITE_UINT32( rtc+CYGHWR_HAL_L1XX_RTC_KICK0, CYGHWR_HAL_L1XX_RTC_KICK0_UNLOCK );
    HAL_WRITE_UINT32( rtc+CYGHWR_HAL_L1XX_RTC_KICK1, CYGHWR_HAL_L1XX_RTC_KICK1_UNLOCK );

    // Set RUN bit. Also sets 24 hour mode
    HAL_WRITE_UINT32( rtc+CYGHWR_HAL_L1XX_RTC_CTRL, CYGHWR_HAL_L1XX_RTC_CTRL_RUN );

    // Block any interrupts.
    HAL_WRITE_UINT32( rtc+CYGHWR_HAL_L1XX_RTC_INTERRUPT, 0 );
    
    // Lock RTC registers
    HAL_WRITE_UINT32( rtc+CYGHWR_HAL_L1XX_RTC_KICK0, 0 );
    HAL_WRITE_UINT32( rtc+CYGHWR_HAL_L1XX_RTC_KICK1, 0 );    
}
        

static void
get_omap_l1xx_hwclock(cyg_uint32* year, cyg_uint32* month, cyg_uint32* mday,
                      cyg_uint32* hour, cyg_uint32* minute, cyg_uint32* second)
{
    cyg_uint32 rtc = CYGHWR_HAL_L1XX_RTC;    
    cyg_uint32 tmp;
         
    // Reading the SECOND register latches the others to give a
    // consistent result.

    HAL_READ_UINT8(rtc+CYGHWR_HAL_L1XX_RTC_SECOND,  tmp);
    *second = TO_DEC(tmp);
    HAL_READ_UINT8(rtc+CYGHWR_HAL_L1XX_RTC_MINUTE,  tmp);
    *minute = TO_DEC(tmp);
    HAL_READ_UINT8(rtc+CYGHWR_HAL_L1XX_RTC_HOUR, tmp);
    *hour = TO_DEC(tmp);
    HAL_READ_UINT8(rtc+CYGHWR_HAL_L1XX_RTC_DAY,  tmp);
    *mday = TO_DEC(tmp);
    HAL_READ_UINT8(rtc+CYGHWR_HAL_L1XX_RTC_MONTH,  tmp);
    *month = TO_DEC(tmp);
    HAL_READ_UINT8(rtc+CYGHWR_HAL_L1XX_RTC_YEAR, tmp);
    *year = TO_DEC(tmp);

    // The century is not stored, so translate the 2 digit year into
    // the most useful range.
    if (*year >= 70)
        *year += 1900;
    else
        *year += 2000;
}

//-----------------------------------------------------------------------------
// Functions required for the hardware-driver API.


// Returns the number of seconds elapsed since 1970-01-01 00:00:00.
cyg_uint32 
Cyg_WallClock::get_hw_seconds(void)
{
    cyg_uint32 year, month, mday, hour, minute, second;

    get_omap_l1xx_hwclock(&year, &month, &mday, &hour, &minute, &second);
    
    cyg_uint32 now = _simple_mktime(year, month, mday, hour, minute, second);
    return now;
}

#ifdef CYGSEM_WALLCLOCK_SET_GET_MODE

// Sets the clock. Argument is seconds elapsed since 1970-01-01 00:00:00.
void
Cyg_WallClock::set_hw_seconds( cyg_uint32 secs )
{
    cyg_uint32 year, month, mday, hour, minute, second;

    _simple_mkdate(secs, &year, &month, &mday, &hour, &minute, &second);
    
    set_omap_l1xx_hwclock(year, month, mday, hour, minute, second);
}

#endif

void
Cyg_WallClock::init_hw_seconds(void)
{
#ifdef CYGSEM_WALLCLOCK_SET_GET_MODE
    init_omap_l1xx_hwclock();
#else
    // This is our base: 1970-01-01 00:00:00
    // Set the HW clock - if for nothing else, just to be sure it's in a
    // legal range. Any arbitrary base could be used.
    // After this the hardware clock is only read.
    set_omap_l1xx_hwclock(1970,1,1,0,0,0);
#endif
}

//-----------------------------------------------------------------------------
// EOF wallclock_synth.cxx
