#ifndef CYGONCE_CSB337_H
#define CYGONCE_CSB337_H
/*=============================================================================
//
//      csb337.h
//
//      Platform specific support (register layout, etc)
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003 Free Software Foundation, Inc.
// Copyright (C) 2003 eCosCentric Limited                                   
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    eCosCentric
// Contributors: eCosCentric, jskov
// Date:         2001-10-30
// Purpose:      Cogent CSB337 platform specific support routines
// Description: 
// Usage:        #include <cyg/hal/csb337.h>
//
//####DESCRIPTIONEND####
//
//===========================================================================*/

#include <cyg/hal/at91rm9200.h>        // CPU details

//---------------------------------------------------------------------------
// Memory layout details needed by conversion macro
#define CSB337_SDRAM_PHYS_BASE         0x20000000
#define CSB337_SDRAM_VIRT_BASE         0x00000000
#define CSB337_SDRAM_SIZE              0x02000000
#define CSB337_SDRAM_MASK              (CSB337_SDRAM_SIZE-1)

#define CSB337_SRAM_PHYS_BASE          0x00200000
#define CSB337_SRAM_VIRT_BASE          0x70000000
#define CSB337_SRAM_SIZE               0x00004000
#define CSB337_SRAM_MASK               (CSB337_SRAM_SIZE-1)
#define CSB337_SRAM_UNCACHED_OFFSET    0x00100000

#define CSB337_FLASH_PHYS_BASE         0x10000000
#define CSB337_FLASH_VIRT_BASE         0x60000000
#define CSB337_FLASH_SIZE              0x00800000
#define CSB337_FLASH_MASK              (CSB337_FLASH_SIZE-1)

/*---------------------------------------------------------------------------*/
/* end of csb337.h                                                          */
#endif /* CYGONCE_CSB337_H */
