#ifndef CYGONCE_HAL_VAR_INTS_H
#define CYGONCE_HAL_VAR_INTS_H
//==========================================================================
//
//      var_ints.h
//
//      ARM9/MC9328MXL variant Interrupt and clock support
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.
// Copyright (C) 2003, 2004 eCosCentric Limited                             
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    nickg
// Contributors: 
// Date:         2004-07-05
// Purpose:      Define Interrupt support
// Description:  The interrupt details for the Motorola MC9328MXL are defined here.
// Usage:
//               #include <cyg/hal/hal_var_ints.h>
//               ...
//              
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <pkgconf/system.h>
#include <pkgconf/hal_arm_arm9_mc9328mxl.h>

//==========================================================================

// These are interrupts on the MC9328MXL core. The first 32 interrupts
// are controlled by the ...LO AITC registers and the second 32 by the
// ...HI registers.

#define CYGNUM_HAL_INTERRUPT_UNUSED_0           0
#define CYGNUM_HAL_INTERRUPT_UNUSED_1           1
#define CYGNUM_HAL_INTERRUPT_UNUSED_2           2
#define CYGNUM_HAL_INTERRUPT_UNUSED_3           3
#define CYGNUM_HAL_INTERRUPT_UNUSED_4           4
#define CYGNUM_HAL_INTERRUPT_UNUSED_5           5
#define CYGNUM_HAL_INTERRUPT_CSI                6
#define CYGNUM_HAL_INTERRUPT_MMA_MAC            7
#define CYGNUM_HAL_INTERRUPT_MMA                8
#define CYGNUM_HAL_INTERRUPT_UNUSED_9           9
#define CYGNUM_HAL_INTERRUPT_MSIRQ              10
#define CYGNUM_HAL_INTERRUPT_GPIO_PORTA         11
#define CYGNUM_HAL_INTERRUPT_GPIO_PORTB         12
#define CYGNUM_HAL_INTERRUPT_GPIO_PORTC         13
#define CYGNUM_HAL_INTERRUPT_LCDC               14
#define CYGNUM_HAL_INTERRUPT_UNUSED_15          15
#define CYGNUM_HAL_INTERRUPT_UNUSED_16          16
#define CYGNUM_HAL_INTERRUPT_RTC_INT            17
#define CYGNUM_HAL_INTERRUPT_RTC_SAM            18
#define CYGNUM_HAL_INTERRUPT_UART2_PFERR        19
#define CYGNUM_HAL_INTERRUPT_UART2_RTS          20
#define CYGNUM_HAL_INTERRUPT_UART2_DTR          21
#define CYGNUM_HAL_INTERRUPT_UART2_UARTC        22
#define CYGNUM_HAL_INTERRUPT_UART2_TX           23
#define CYGNUM_HAL_INTERRUPT_UART2_RX           24
#define CYGNUM_HAL_INTERRUPT_UART1_PFERR        25
#define CYGNUM_HAL_INTERRUPT_UART1_RTS          26
#define CYGNUM_HAL_INTERRUPT_UART1_DTR          27
#define CYGNUM_HAL_INTERRUPT_UART1_UARTC        28
#define CYGNUM_HAL_INTERRUPT_UART1_TX           29
#define CYGNUM_HAL_INTERRUPT_UART1_RX           30
#define CYGNUM_HAL_INTERRUPT_UNUSED_31          31

#define CYGNUM_HAL_INTERRUPT_UNUSED_32          32
#define CYGNUM_HAL_INTERRUPT_UNUSED_33          33
#define CYGNUM_HAL_INTERRUPT_PWM                34
#define CYGNUM_HAL_INTERRUPT_MMC                35
#define CYGNUM_HAL_INTERRUPT_UNUSED_36          36
#define CYGNUM_HAL_INTERRUPT_UNUSED_37          37
#define CYGNUM_HAL_INTERRUPT_UNUSED_38          38
#define CYGNUM_HAL_INTERRUPT_I2C                39
#define CYGNUM_HAL_INTERRUPT_SPI2               40
#define CYGNUM_HAL_INTERRUPT_SPI1               41
#define CYGNUM_HAL_INTERRUPT_SSI_TX             42
#define CYGNUM_HAL_INTERRUPT_SSI_TX_ERR         43
#define CYGNUM_HAL_INTERRUPT_SSI_RX             44
#define CYGNUM_HAL_INTERRUPT_SSI_RX_ERR         45
#define CYGNUM_HAL_INTERRUPT_UNUSED_46          46
#define CYGNUM_HAL_INTERRUPT_USBD_0             47
#define CYGNUM_HAL_INTERRUPT_USBD_1             48
#define CYGNUM_HAL_INTERRUPT_USBD_2             49
#define CYGNUM_HAL_INTERRUPT_USBD_3             50
#define CYGNUM_HAL_INTERRUPT_USBD_4             51
#define CYGNUM_HAL_INTERRUPT_USBD_5             52
#define CYGNUM_HAL_INTERRUPT_USBD_6             53
#define CYGNUM_HAL_INTERRUPT_UNUSED_54          54
#define CYGNUM_HAL_INTERRUPT_UNUSED_55          55
#define CYGNUM_HAL_INTERRUPT_UNUSED_56          56
#define CYGNUM_HAL_INTERRUPT_UNUSED_57          57
#define CYGNUM_HAL_INTERRUPT_TIMER2             58
#define CYGNUM_HAL_INTERRUPT_TIMER1             59
#define CYGNUM_HAL_INTERRUPT_DMA_ERR            60
#define CYGNUM_HAL_INTERRUPT_DMA                61
#define CYGNUM_HAL_INTERRUPT_GPIO_PORTD         62
#define CYGNUM_HAL_INTERRUPT_WATCHDOG           63

#ifdef CYGHWR_HAL_ARM_ARM9_MC9328MXL_DECODE_GPIO

#define CYGNUM_HAL_INTERRUPT_GPIOA_BASE         64
#define CYGNUM_HAL_INTERRUPT_GPIOA_0            (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+0)
#define CYGNUM_HAL_INTERRUPT_GPIOA_1            (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+1)
#define CYGNUM_HAL_INTERRUPT_GPIOA_2            (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+2)
#define CYGNUM_HAL_INTERRUPT_GPIOA_3            (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+3)
#define CYGNUM_HAL_INTERRUPT_GPIOA_4            (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+4)
#define CYGNUM_HAL_INTERRUPT_GPIOA_5            (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+5)
#define CYGNUM_HAL_INTERRUPT_GPIOA_6            (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+6)
#define CYGNUM_HAL_INTERRUPT_GPIOA_7            (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+7)
#define CYGNUM_HAL_INTERRUPT_GPIOA_8            (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+8)
#define CYGNUM_HAL_INTERRUPT_GPIOA_9            (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+9)
#define CYGNUM_HAL_INTERRUPT_GPIOA_10           (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+10)
#define CYGNUM_HAL_INTERRUPT_GPIOA_11           (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+11)
#define CYGNUM_HAL_INTERRUPT_GPIOA_12           (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+12)
#define CYGNUM_HAL_INTERRUPT_GPIOA_13           (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+13)
#define CYGNUM_HAL_INTERRUPT_GPIOA_14           (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+14)
#define CYGNUM_HAL_INTERRUPT_GPIOA_15           (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+15)
#define CYGNUM_HAL_INTERRUPT_GPIOA_16           (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+16)
#define CYGNUM_HAL_INTERRUPT_GPIOA_17           (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+17)
#define CYGNUM_HAL_INTERRUPT_GPIOA_18           (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+18)
#define CYGNUM_HAL_INTERRUPT_GPIOA_19           (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+19)
#define CYGNUM_HAL_INTERRUPT_GPIOA_20           (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+20)
#define CYGNUM_HAL_INTERRUPT_GPIOA_21           (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+21)
#define CYGNUM_HAL_INTERRUPT_GPIOA_22           (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+22)
#define CYGNUM_HAL_INTERRUPT_GPIOA_23           (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+23)
#define CYGNUM_HAL_INTERRUPT_GPIOA_24           (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+24)
#define CYGNUM_HAL_INTERRUPT_GPIOA_25           (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+25)
#define CYGNUM_HAL_INTERRUPT_GPIOA_26           (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+26)
#define CYGNUM_HAL_INTERRUPT_GPIOA_27           (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+27)
#define CYGNUM_HAL_INTERRUPT_GPIOA_28           (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+28)
#define CYGNUM_HAL_INTERRUPT_GPIOA_29           (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+29)
#define CYGNUM_HAL_INTERRUPT_GPIOA_30           (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+30)
#define CYGNUM_HAL_INTERRUPT_GPIOA_31           (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+31)

#define CYGNUM_HAL_INTERRUPT_GPIOB_BASE         (CYGNUM_HAL_INTERRUPT_GPIOA_BASE+32)
#define CYGNUM_HAL_INTERRUPT_GPIOB_0            (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+0)
#define CYGNUM_HAL_INTERRUPT_GPIOB_1            (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+1)
#define CYGNUM_HAL_INTERRUPT_GPIOB_2            (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+2)
#define CYGNUM_HAL_INTERRUPT_GPIOB_3            (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+3)
#define CYGNUM_HAL_INTERRUPT_GPIOB_4            (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+4)
#define CYGNUM_HAL_INTERRUPT_GPIOB_5            (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+5)
#define CYGNUM_HAL_INTERRUPT_GPIOB_6            (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+6)
#define CYGNUM_HAL_INTERRUPT_GPIOB_7            (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+7)
#define CYGNUM_HAL_INTERRUPT_GPIOB_8            (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+8)
#define CYGNUM_HAL_INTERRUPT_GPIOB_9            (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+9)
#define CYGNUM_HAL_INTERRUPT_GPIOB_10           (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+10)
#define CYGNUM_HAL_INTERRUPT_GPIOB_11           (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+11)
#define CYGNUM_HAL_INTERRUPT_GPIOB_12           (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+12)
#define CYGNUM_HAL_INTERRUPT_GPIOB_13           (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+13)
#define CYGNUM_HAL_INTERRUPT_GPIOB_14           (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+14)
#define CYGNUM_HAL_INTERRUPT_GPIOB_15           (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+15)
#define CYGNUM_HAL_INTERRUPT_GPIOB_16           (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+16)
#define CYGNUM_HAL_INTERRUPT_GPIOB_17           (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+17)
#define CYGNUM_HAL_INTERRUPT_GPIOB_18           (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+18)
#define CYGNUM_HAL_INTERRUPT_GPIOB_19           (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+19)
#define CYGNUM_HAL_INTERRUPT_GPIOB_20           (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+20)
#define CYGNUM_HAL_INTERRUPT_GPIOB_21           (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+21)
#define CYGNUM_HAL_INTERRUPT_GPIOB_22           (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+22)
#define CYGNUM_HAL_INTERRUPT_GPIOB_23           (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+23)
#define CYGNUM_HAL_INTERRUPT_GPIOB_24           (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+24)
#define CYGNUM_HAL_INTERRUPT_GPIOB_25           (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+25)
#define CYGNUM_HAL_INTERRUPT_GPIOB_26           (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+26)
#define CYGNUM_HAL_INTERRUPT_GPIOB_27           (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+27)
#define CYGNUM_HAL_INTERRUPT_GPIOB_28           (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+28)
#define CYGNUM_HAL_INTERRUPT_GPIOB_29           (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+29)
#define CYGNUM_HAL_INTERRUPT_GPIOB_30           (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+30)
#define CYGNUM_HAL_INTERRUPT_GPIOB_31           (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+31)

#define CYGNUM_HAL_INTERRUPT_GPIOC_BASE         (CYGNUM_HAL_INTERRUPT_GPIOB_BASE+32)
#define CYGNUM_HAL_INTERRUPT_GPIOC_0            (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+0)
#define CYGNUM_HAL_INTERRUPT_GPIOC_1            (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+1)
#define CYGNUM_HAL_INTERRUPT_GPIOC_2            (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+2)
#define CYGNUM_HAL_INTERRUPT_GPIOC_3            (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+3)
#define CYGNUM_HAL_INTERRUPT_GPIOC_4            (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+4)
#define CYGNUM_HAL_INTERRUPT_GPIOC_5            (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+5)
#define CYGNUM_HAL_INTERRUPT_GPIOC_6            (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+6)
#define CYGNUM_HAL_INTERRUPT_GPIOC_7            (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+7)
#define CYGNUM_HAL_INTERRUPT_GPIOC_8            (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+8)
#define CYGNUM_HAL_INTERRUPT_GPIOC_9            (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+9)
#define CYGNUM_HAL_INTERRUPT_GPIOC_10           (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+10)
#define CYGNUM_HAL_INTERRUPT_GPIOC_11           (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+11)
#define CYGNUM_HAL_INTERRUPT_GPIOC_12           (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+12)
#define CYGNUM_HAL_INTERRUPT_GPIOC_13           (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+13)
#define CYGNUM_HAL_INTERRUPT_GPIOC_14           (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+14)
#define CYGNUM_HAL_INTERRUPT_GPIOC_15           (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+15)
#define CYGNUM_HAL_INTERRUPT_GPIOC_16           (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+16)
#define CYGNUM_HAL_INTERRUPT_GPIOC_17           (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+17)
#define CYGNUM_HAL_INTERRUPT_GPIOC_18           (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+18)
#define CYGNUM_HAL_INTERRUPT_GPIOC_19           (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+19)
#define CYGNUM_HAL_INTERRUPT_GPIOC_20           (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+20)
#define CYGNUM_HAL_INTERRUPT_GPIOC_21           (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+21)
#define CYGNUM_HAL_INTERRUPT_GPIOC_22           (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+22)
#define CYGNUM_HAL_INTERRUPT_GPIOC_23           (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+23)
#define CYGNUM_HAL_INTERRUPT_GPIOC_24           (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+24)
#define CYGNUM_HAL_INTERRUPT_GPIOC_25           (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+25)
#define CYGNUM_HAL_INTERRUPT_GPIOC_26           (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+26)
#define CYGNUM_HAL_INTERRUPT_GPIOC_27           (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+27)
#define CYGNUM_HAL_INTERRUPT_GPIOC_28           (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+28)
#define CYGNUM_HAL_INTERRUPT_GPIOC_29           (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+29)
#define CYGNUM_HAL_INTERRUPT_GPIOC_30           (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+30)
#define CYGNUM_HAL_INTERRUPT_GPIOC_31           (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+31)

#define CYGNUM_HAL_INTERRUPT_GPIOD_BASE         (CYGNUM_HAL_INTERRUPT_GPIOC_BASE+32)
#define CYGNUM_HAL_INTERRUPT_GPIOD_0            (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+0)
#define CYGNUM_HAL_INTERRUPT_GPIOD_1            (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+1)
#define CYGNUM_HAL_INTERRUPT_GPIOD_2            (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+2)
#define CYGNUM_HAL_INTERRUPT_GPIOD_3            (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+3)
#define CYGNUM_HAL_INTERRUPT_GPIOD_4            (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+4)
#define CYGNUM_HAL_INTERRUPT_GPIOD_5            (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+5)
#define CYGNUM_HAL_INTERRUPT_GPIOD_6            (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+6)
#define CYGNUM_HAL_INTERRUPT_GPIOD_7            (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+7)
#define CYGNUM_HAL_INTERRUPT_GPIOD_8            (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+8)
#define CYGNUM_HAL_INTERRUPT_GPIOD_9            (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+9)
#define CYGNUM_HAL_INTERRUPT_GPIOD_10           (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+10)
#define CYGNUM_HAL_INTERRUPT_GPIOD_11           (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+11)
#define CYGNUM_HAL_INTERRUPT_GPIOD_12           (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+12)
#define CYGNUM_HAL_INTERRUPT_GPIOD_13           (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+13)
#define CYGNUM_HAL_INTERRUPT_GPIOD_14           (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+14)
#define CYGNUM_HAL_INTERRUPT_GPIOD_15           (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+15)
#define CYGNUM_HAL_INTERRUPT_GPIOD_16           (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+16)
#define CYGNUM_HAL_INTERRUPT_GPIOD_17           (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+17)
#define CYGNUM_HAL_INTERRUPT_GPIOD_18           (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+18)
#define CYGNUM_HAL_INTERRUPT_GPIOD_19           (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+19)
#define CYGNUM_HAL_INTERRUPT_GPIOD_20           (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+20)
#define CYGNUM_HAL_INTERRUPT_GPIOD_21           (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+21)
#define CYGNUM_HAL_INTERRUPT_GPIOD_22           (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+22)
#define CYGNUM_HAL_INTERRUPT_GPIOD_23           (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+23)
#define CYGNUM_HAL_INTERRUPT_GPIOD_24           (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+24)
#define CYGNUM_HAL_INTERRUPT_GPIOD_25           (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+25)
#define CYGNUM_HAL_INTERRUPT_GPIOD_26           (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+26)
#define CYGNUM_HAL_INTERRUPT_GPIOD_27           (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+27)
#define CYGNUM_HAL_INTERRUPT_GPIOD_28           (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+28)
#define CYGNUM_HAL_INTERRUPT_GPIOD_29           (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+29)
#define CYGNUM_HAL_INTERRUPT_GPIOD_30           (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+30)
#define CYGNUM_HAL_INTERRUPT_GPIOD_31           (CYGNUM_HAL_INTERRUPT_GPIOD_BASE+31)

#define CYGNUM_HAL_ISR_MAX                      CYGNUM_HAL_INTERRUPT_GPIOD_31

#else

#define CYGNUM_HAL_ISR_MAX                      CYGNUM_HAL_INTERRUPT_WATCHDOG

#endif


#define CYGNUM_HAL_INTERRUPT_NONE    -1

#define CYGNUM_HAL_ISR_MIN            0

#define CYGNUM_HAL_ISR_COUNT         (CYGNUM_HAL_ISR_MAX-CYGNUM_HAL_ISR_MIN+1)

// The vector used by the Real time clock
#define CYGNUM_HAL_INTERRUPT_RTC      CYGNUM_HAL_INTERRUPT_TIMER1

//----------------------------------------------------------------------------
// Reset.

externC void cyg_hal_mc9328mxl_reset(void);
#define HAL_PLATFORM_RESET() cyg_hal_mc9328mxl_reset()

#define HAL_PLATFORM_RESET_ENTRY 0x00000000

//----------------------------------------------------------------------------
#endif // CYGONCE_HAL_VAR_INTS_H
