#ifndef CYGONCE_OMAP_L1XX_H
#define CYGONCE_OMAP_L1XX_H
/*=============================================================================
//
//      omap_l1xx.h
//
//      Register layout, etc, for TI OMAP L1XX CPU
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2003, 2004, 2005, 2007 Free Software Foundation, Inc.      
// Copyright (C) 2003, 2004, 2005, 2007, 2009, 2010 eCosCentric Limited                 
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    nickg
// Contributors: 
// Date:         2009-12-09
// Purpose:      TI OMAP L1XX CPU variant definitions
// Description: 
// Usage:        #include <cyg/hal/omap_l1xx.h>
//
//####DESCRIPTIONEND####
//
//===========================================================================*/

#include <pkgconf/hal_arm_arm9_omap_l1xx.h>

/*---------------------------------------------------------------------------*/
/* Note:
 *
 * This device has a lot of registers. Only those that are directly
 * used by eCos and its device drivers are defined here.
 */


/*---------------------------------------------------------------------------*/
// Device base addresses

#define CYGHWR_HAL_L1XX_EDMA0_CC                        0x01C00000
#define CYGHWR_HAL_L1XX_EDMA0_TC0                       0x01C08000
#define CYGHWR_HAL_L1XX_EDMA0_TC1                       0x01C08400
#define CYGHWR_HAL_L1XX_PSC0                            0x01C10000
#define CYGHWR_HAL_L1XX_PLL0                            0x01C11000
#define CYGHWR_HAL_L1XX_SYSCFG0                         0x01C14000
#define CYGHWR_HAL_L1XX_TIMER0                          0x01C20000
#define CYGHWR_HAL_L1XX_TIMER1                          0x01C21000
#define CYGHWR_HAL_L1XX_I2C0                            0x01C22000
#define CYGHWR_HAL_L1XX_RTC                             0x01C23000
#define CYGHWR_HAL_L1XX_MMCSD0                          0x01C40000
#define CYGHWR_HAL_L1XX_SPI0                            0x01C41000
#define CYGHWR_HAL_L1XX_UART0                           0x01C42000

#define CYGHWR_HAL_L1XX_UART1                           0x01D0C000
#define CYGHWR_HAL_L1XX_UART2                           0x01D0D000

#define CYGHWR_HAL_L1XX_PLL1                            0x01E1A000
#define CYGHWR_HAL_L1XX_MMCSD1                          0x01E1B000
#define CYGHWR_HAL_L1XX_EMAC_CMRAM                      0x01E20000
#define CYGHWR_HAL_L1XX_EMAC_CMREG                      0x01E22000
#define CYGHWR_HAL_L1XX_EMAC_CR                         0x01E23000
#define CYGHWR_HAL_L1XX_EMAC_MDIO                       0x01E24000
#define CYGHWR_HAL_L1XX_USB1                            0x01E25000
#define CYGHWR_HAL_L1XX_GPIO_BASE                       0x01E26000
#define CYGHWR_HAL_L1XX_PSC1                            0x01E27000
#define CYGHWR_HAL_L1XX_I2C1                            0x01E28000
#define CYGHWR_HAL_L1XX_SYSCFG1                         0x01E2C000
#define CYGHWR_HAL_L1XX_EDMA1_CC                        0x01E30000
#define CYGHWR_HAL_L1XX_EDMA1_TC0                       0x01E38000


#define CYGHWR_HAL_L1XX_SPI1                            0x01F0E000

#define CYGHWR_HAL_L1XX_AINTC                           0xFFFEE000

/*---------------------------------------------------------------------------*/
// SYSCFG

#define CYGHWR_HAL_L1XX_SYSCFG0_REVID                   0x000
#define CYGHWR_HAL_L1XX_SYSCFG0_DIEDR0                  0x008
#define CYGHWR_HAL_L1XX_SYSCFG0_DIEDR1                  0x00C
#define CYGHWR_HAL_L1XX_SYSCFG0_DIEDR2                  0x010
#define CYGHWR_HAL_L1XX_SYSCFG0_DIEDR3                  0x014
#define CYGHWR_HAL_L1XX_SYSCFG0_BOOTCFG                 0x020
#define CYGHWR_HAL_L1XX_SYSCFG0_KICK0R                  0x038
#define CYGHWR_HAL_L1XX_SYSCFG0_KICK1R                  0x03C

#define CYGHWR_HAL_L1XX_SYSCFG0_CFGCHIP0                0x17C
#define CYGHWR_HAL_L1XX_SYSCFG0_CFGCHIP1                0x180
#define CYGHWR_HAL_L1XX_SYSCFG0_CFGCHIP2                0x184
#define CYGHWR_HAL_L1XX_SYSCFG0_CFGCHIP3                0x188
#define CYGHWR_HAL_L1XX_SYSCFG0_CFGCHIP4                0x18C

#define CYGHWR_HAL_L1XX_SYSCFG0_KICK0R_UNLOCK           0x83E70B13
#define CYGHWR_HAL_L1XX_SYSCFG0_KICK1R_UNLOCK           0x95A4F1E0

#define CYGHWR_HAL_L1XX_SYSCFG0_CFGCHIP3_RMII_SEL       (1<<8)

/*---------------------------------------------------------------------------*/
// Pin multipexing
//
// There is no correspondence between GPIO lines and the associated
// PINMUX registers, so this cannot be combined with GPIO
// configuration. The function codes across register fields are also
// not consistent, so we cannot even define any common function
// definitions. The user has to look up the register number, field
// offset and function code for each individual pin that is to be
// programmed.

#define CYGHWR_HAL_L1XX_SYSCFG0_PINMUX(__x)     (0x120+((__x)*4))

// Form a pinmux descriptor from register, field base and function. 
#define CYGHWR_HAL_L1XX_PINMUX(__reg, __field, __func ) \
    (((__reg)<<16) | ((__field)<<8) | (__func))

#define CYGHWR_HAL_L1XX_PINMUX_REG( __pin )     (((__pin)>>16)&0xFF)
#define CYGHWR_HAL_L1XX_PINMUX_FIELD( __pin )   (((__pin)>> 8)&0x1F)
#define CYGHWR_HAL_L1XX_PINMUX_FUNC( __pin )    (((__pin)>> 0)&0x0F)

#ifndef __ASSEMBLER__
__externC void hal_l1xx_pinmux_set( cyg_uint32 pin );

#define CYGHWR_HAL_L1XX_PINMUX_SET( __pin ) hal_l1xx_pinmux_set( __pin )
#endif

/*---------------------------------------------------------------------------*/
// GPIO

#define CYGHWR_HAL_L1XX_GPIO_BINTEN             0x008

#define CYGHWR_HAL_L1XX_GPIO01                  0x010
#define CYGHWR_HAL_L1XX_GPIO23                  0x038
#define CYGHWR_HAL_L1XX_GPIO45                  0x060
#define CYGHWR_HAL_L1XX_GPIO67                  0x088

#define CYGHWR_HAL_L1XX_GPIO_DIR                0x000
#define CYGHWR_HAL_L1XX_GPIO_OUT_DATA           0x004
#define CYGHWR_HAL_L1XX_GPIO_SET_DATA           0x008
#define CYGHWR_HAL_L1XX_GPIO_CLR_DATA           0x00C
#define CYGHWR_HAL_L1XX_GPIO_IN_DATA            0x010
#define CYGHWR_HAL_L1XX_GPIO_SET_RIS_TRIG       0x014
#define CYGHWR_HAL_L1XX_GPIO_CLR_RIS_TRIG       0x018
#define CYGHWR_HAL_L1XX_GPIO_SET_FAL_TRIG       0x01C
#define CYGHWR_HAL_L1XX_GPIO_CLR_FAL_TRIG       0x020
#define CYGHWR_HAL_L1XX_GPIO_IRQ_STAT           0x024

#define CYGHWR_HAL_L1XX_GPIO_MODE_INPUT         0x01
#define CYGHWR_HAL_L1XX_GPIO_MODE_OUTPUT        0x00


// This macro packs the bank number, bit number and mode of a GPIO pin
// into a single word. The packing puts the mode in the ls 8 bits, the bit
// number in 16:20 and the bank number in bits 8:15. The mode is only
// specified using the last component of the name to keep definitions
// short.

#define CYGHWR_HAL_L1XX_GPIO(__bank, __bit, __mode )    \
            (((__bank)<<8) |                                    \
             ((__bit)<<16) |                            \
             (CYGHWR_HAL_L1XX_GPIO_MODE_##__mode))

// Macros to extract encoded values
#define CYGHWR_HAL_L1XX_GPIO_BANK(__pin)       (((__pin)>>8)&0xF)
#define CYGHWR_HAL_L1XX_GPIO_BIT(__pin)        (((__pin)>>16)&0x1F)
#define CYGHWR_HAL_L1XX_GPIO_MODE(__pin)       ((__pin)&0xFF)


#define CYGHWR_HAL_L1XX_GPIO_NONE      (0xFFFFFFFF)

// Interrupt modes
#define CYGHWR_HAL_L1XX_GPIO_INTMODE_FALL       1
#define CYGHWR_HAL_L1XX_GPIO_INTMODE_RISE       2
#define CYGHWR_HAL_L1XX_GPIO_INTMODE_FALLRISE   3


// Functions and macros to configure GPIO ports.

#ifndef __ASSEMBLER__
__externC void hal_l1xx_gpio_set   ( cyg_uint32 pin );
__externC void hal_l1xx_gpio_out   ( cyg_uint32 pin, int val );
__externC void hal_l1xx_gpio_in    ( cyg_uint32 pin, int *val );
__externC void hal_l1xx_gpio_intcfg( cyg_uint32 pin, cyg_uint32 mode );
__externC void hal_l1xx_gpio_intstat( cyg_uint32 pin, int *stat );
    
#define CYGHWR_HAL_L1XX_GPIO_SET(__pin ) hal_l1xx_gpio_set( __pin )
#define CYGHWR_HAL_L1XX_GPIO_OUT(__pin, __val ) hal_l1xx_gpio_out( __pin, __val )
#define CYGHWR_HAL_L1XX_GPIO_IN(__pin,  __val ) hal_l1xx_gpio_in( __pin, __val )
#define CYGHWR_HAL_L1XX_GPIO_INTCFG(__pin, __mode ) hal_l1xx_gpio_intcfg( __pin, CYGHWR_HAL_L1XX_GPIO_INTMODE_##__mode )
#define CYGHWR_HAL_L1XX_GPIO_INTSTAT(__pin,  __stat ) hal_l1xx_gpio_intstat( __pin, __stat )    
#endif

#define CYGHWR_HAL_L1XX_GPIO_POWER              CYGHWR_HAL_L1XX_POWER( GPIO )

/*---------------------------------------------------------------------------*/
// PLLs

#define CYGHWR_HAL_L1XX_PLL_REVID               0x0000
#define CYGHWR_HAL_L1XX_PLL_RSTYPE              0x00E4
#define CYGHWR_HAL_L1XX_PLL_PLLCTL              0x0100
#define CYGHWR_HAL_L1XX_PLL_OCSEL               0x0104
#define CYGHWR_HAL_L1XX_PLL_PLLM                0x0110
#define CYGHWR_HAL_L1XX_PLL_PREDIV              0x0114
#define CYGHWR_HAL_L1XX_PLL_PLLDIV1             0x0118
#define CYGHWR_HAL_L1XX_PLL_PLLDIV2             0x011C
#define CYGHWR_HAL_L1XX_PLL_PLLDIV3             0x0120
#define CYGHWR_HAL_L1XX_PLL_OSCDIV              0x0124
#define CYGHWR_HAL_L1XX_PLL_POSTDIV             0x0128
#define CYGHWR_HAL_L1XX_PLL_PLLCMD              0x0138
#define CYGHWR_HAL_L1XX_PLL_PLLSTAT             0x013C
#define CYGHWR_HAL_L1XX_PLL_ALNCTL              0x0140
#define CYGHWR_HAL_L1XX_PLL_DCHANGE             0x0144
#define CYGHWR_HAL_L1XX_PLL_CKEN                0x0148
#define CYGHWR_HAL_L1XX_PLL_CKSTAT              0x014C
#define CYGHWR_HAL_L1XX_PLL_SYSTAT              0x0150
#define CYGHWR_HAL_L1XX_PLL_PLLDIV4             0x0160
#define CYGHWR_HAL_L1XX_PLL_PLLDIV5             0x0164
#define CYGHWR_HAL_L1XX_PLL_PLLDIV6             0x0168
#define CYGHWR_HAL_L1XX_PLL_PLLDIV7             0x016C


// PLLCTL
#define CYGHWR_HAL_L1XX_PLL_PLLCTL_EXTCLKSRC    0x00000200
#define CYGHWR_HAL_L1XX_PLL_PLLCTL_CLKMODE      0x00000100
#define CYGHWR_HAL_L1XX_PLL_PLLCTL_PLLENSRC     0x00000020
#define CYGHWR_HAL_L1XX_PLL_PLLCTL_PLLDIS       0x00000010
#define CYGHWR_HAL_L1XX_PLL_PLLCTL_PLLRST       0x00000008
#define CYGHWR_HAL_L1XX_PLL_PLLCTL_PLLPWRDN     0x00000002
#define CYGHWR_HAL_L1XX_PLL_PLLCTL_PLLEN        0x00000001

// PLLCMD and PLLSTAT
#define CYGHWR_HAL_L1XX_PLL_PLLCMD_GOSET        0x00000001

// PLLDIVx
#define CYGHWR_HAL_L1XX_PLL_PLLDIV_ENABLE       0x00008000

/*---------------------------------------------------------------------------*/
// Peripheral power control via PSCs


#define CYGHWR_HAL_L1XX_PSC_REVID               0x0000
#define CYGHWR_HAL_L1XX_PSC_INTEVAL             0x0018
#define CYGHWR_HAL_L1XX_PSC_MERRPR0             0x0040
#define CYGHWR_HAL_L1XX_PSC_MERRCR0             0x0050
#define CYGHWR_HAL_L1XX_PSC_PERRPR              0x0060
#define CYGHWR_HAL_L1XX_PSC_PERRCR              0x0068
#define CYGHWR_HAL_L1XX_PSC_PTCMD               0x0120
#define CYGHWR_HAL_L1XX_PSC_PTSTAT              0x0128
#define CYGHWR_HAL_L1XX_PSC_PDSTAT0             0x0200
#define CYGHWR_HAL_L1XX_PSC_PDSTAT1             0x0204
#define CYGHWR_HAL_L1XX_PSC_PDCTL0              0x0300
#define CYGHWR_HAL_L1XX_PSC_PDCTL1              0x0304
#define CYGHWR_HAL_L1XX_PSC_PDCFG0              0x0400
#define CYGHWR_HAL_L1XX_PSC_PDCFG1              0x0404
#define CYGHWR_HAL_L1XX_PSC_MDSTAT(__x)         (0x0800+(__x)*4)
#define CYGHWR_HAL_L1XX_PSC_MDCTL(__x)          (0x0A00+(__x)*4)

// PTCMD
#define CYGHWR_HAL_L1XX_PSC_PTCMD_GO0                   (1<<0)
#define CYGHWR_HAL_L1XX_PSC_PTCMD_GO1                   (1<<1)

// PTSTAT
#define CYGHWR_HAL_L1XX_PSC_PTSTAT_GO0                  (1<<0)
#define CYGHWR_HAL_L1XX_PSC_PTSTAT_GO1                  (1<<1)

// MDSTAT
#define CYGHWR_HAL_L1XX_PSC_MDSTAT_STATE_MASK           (0x3f<<0)
#define CYGHWR_HAL_L1XX_PSC_MDSTAT_STATE_DISABLE        (0x02<<0)
#define CYGHWR_HAL_L1XX_PSC_MDSTAT_STATE_ENABLE         (0x03<<0)

// MDCTL
#define CYGHWR_HAL_L1XX_PSC_MDCTL_NEXT_MASK             (0x7<<0)
#define CYGHWR_HAL_L1XX_PSC_MDCTL_NEXT_DISABLE          (0x2<<0)
#define CYGHWR_HAL_L1XX_PSC_MDCTL_NEXT_ENABLE           (0x3<<0)

// PSC0 LPSCs
#define CYGHWR_HAL_L1XX_PSC_LPSC_EDMA0_CC              (0)
#define CYGHWR_HAL_L1XX_PSC_LPSC_EDMA0_TC0             (1)
#define CYGHWR_HAL_L1XX_PSC_LPSC_EDMA0_TC1             (2)
#define CYGHWR_HAL_L1XX_PSC_LPSC_EMIFA                 (3)
#define CYGHWR_HAL_L1XX_PSC_LPSC_SPI0                  (4)
#define CYGHWR_HAL_L1XX_PSC_LPSC_MMCSD0                (5)
#define CYGHWR_HAL_L1XX_PSC_LPSC_AINTC                 (6)
#define CYGHWR_HAL_L1XX_PSC_LPSC_ARM_RAMROM            (7)
#define CYGHWR_HAL_L1XX_PSC_LPSC_UART0                 (9)
#define CYGHWR_HAL_L1XX_PSC_LPSC_SCR0                  (10)
#define CYGHWR_HAL_L1XX_PSC_LPSC_SCR1                  (11)
#define CYGHWR_HAL_L1XX_PSC_LPSC_SCR2                  (12)
#define CYGHWR_HAL_L1XX_PSC_LPSC_PRU                   (13)
#define CYGHWR_HAL_L1XX_PSC_LPSC_ARM                   (14)
#define CYGHWR_HAL_L1XX_PSC_LPSC_DSP                   ((15)|(1<<16))

// PSC1 LPSCs
#define CYGHWR_HAL_L1XX_PSC_LPSC_EDMA1_CC              (0)
#define CYGHWR_HAL_L1XX_PSC_LPSC_USB0                  (1|(1<<8))
#define CYGHWR_HAL_L1XX_PSC_LPSC_USB1                  (2|(1<<8))
#define CYGHWR_HAL_L1XX_PSC_LPSC_GPIO                  (3|(1<<8))
#define CYGHWR_HAL_L1XX_PSC_LPSC_HPI                   (4|(1<<8))
#define CYGHWR_HAL_L1XX_PSC_LPSC_EMAC                  (5|(1<<8))
#define CYGHWR_HAL_L1XX_PSC_LPSC_EMIF3A                (6|(1<<8))
#define CYGHWR_HAL_L1XX_PSC_LPSC_MCASP0                (7|(1<<8))
#define CYGHWR_HAL_L1XX_PSC_LPSC_SATA                  (8|(1<<8))
#define CYGHWR_HAL_L1XX_PSC_LPSC_VPIF                  (9|(1<<8))
#define CYGHWR_HAL_L1XX_PSC_LPSC_SPI1                  (10|(1<<8))
#define CYGHWR_HAL_L1XX_PSC_LPSC_I2C1                  (11|(1<<8))
#define CYGHWR_HAL_L1XX_PSC_LPSC_UART1                 (12|(1<<8))
#define CYGHWR_HAL_L1XX_PSC_LPSC_UART2                 (13|(1<<8))
#define CYGHWR_HAL_L1XX_PSC_LPSC_MCBSP0                (14|(1<<8))
#define CYGHWR_HAL_L1XX_PSC_LPSC_MCBSP1                (15|(1<<8))
#define CYGHWR_HAL_L1XX_PSC_LPSC_LCDC                  (16|(1<<8))
#define CYGHWR_HAL_L1XX_PSC_LPSC_PWM                   (17|(1<<8))
#define CYGHWR_HAL_L1XX_PSC_LPSC_MMCSD1                (18|(1<<8))
#define CYGHWR_HAL_L1XX_PSC_LPSC_RPI                   (19|(1<<8))
#define CYGHWR_HAL_L1XX_PSC_LPSC_ECAP                  (20|(1<<8))
#define CYGHWR_HAL_L1XX_PSC_LPSC_EDMA1_TC0             (21|(1<<8))
#define CYGHWR_HAL_L1XX_PSC_LPSC_SCR8                  (24|(1<<8))
#define CYGHWR_HAL_L1XX_PSC_LPSC_SCR7                  (25|(1<<8))
#define CYGHWR_HAL_L1XX_PSC_LPSC_SCR12                 (26|(1<<8))
#define CYGHWR_HAL_L1XX_PSC_LPSC_SHRAM                 (31|(1<<8)|(1<<16))


#define CYGHWR_HAL_L1XX_POWER( __device ) (CYGHWR_HAL_L1XX_PSC_LPSC_##__device)

#ifndef __ASSEMBLER__
__externC void hal_l1xx_power_enable( cyg_uint32 power );
__externC void hal_l1xx_power_disable( cyg_uint32 power );

#define CYGHWR_HAL_L1XX_POWER_ENABLE( __power ) hal_l1xx_power_enable( __power )
#define CYGHWR_HAL_L1XX_POWER_DISABLE( __power ) hal_l1xx_power_disable( __power )
#endif

/*---------------------------------------------------------------------------*/
// AINTC

#define CYGHWR_HAL_L1XX_AINTC_REVID             0x0000
#define CYGHWR_HAL_L1XX_AINTC_CR                0x0004
#define CYGHWR_HAL_L1XX_AINTC_GER               0x0010
#define CYGHWR_HAL_L1XX_AINTC_GNLR              0x001C
#define CYGHWR_HAL_L1XX_AINTC_SISR              0x0020
#define CYGHWR_HAL_L1XX_AINTC_SICR              0x0024
#define CYGHWR_HAL_L1XX_AINTC_EISR              0x0028
#define CYGHWR_HAL_L1XX_AINTC_EICR              0x002C
#define CYGHWR_HAL_L1XX_AINTC_HIEISR            0x0034
#define CYGHWR_HAL_L1XX_AINTC_HIEICR            0x0038
#define CYGHWR_HAL_L1XX_AINTC_VBR               0x0050
#define CYGHWR_HAL_L1XX_AINTC_VSR               0x0054
#define CYGHWR_HAL_L1XX_AINTC_VNR               0x0058
#define CYGHWR_HAL_L1XX_AINTC_GPIR              0x0080
#define CYGHWR_HAL_L1XX_AINTC_GPVR              0x0084
#define CYGHWR_HAL_L1XX_AINTC_SRSR1             0x0200
#define CYGHWR_HAL_L1XX_AINTC_SRSR2             0x0204
#define CYGHWR_HAL_L1XX_AINTC_SRSR3             0x0208
#define CYGHWR_HAL_L1XX_AINTC_SECR1             0x0280
#define CYGHWR_HAL_L1XX_AINTC_SECR2             0x0284
#define CYGHWR_HAL_L1XX_AINTC_SECR3             0x0288
#define CYGHWR_HAL_L1XX_AINTC_ESR1              0x0300
#define CYGHWR_HAL_L1XX_AINTC_ESR2              0x0304
#define CYGHWR_HAL_L1XX_AINTC_ESR3              0x0308
#define CYGHWR_HAL_L1XX_AINTC_ECR1              0x0380
#define CYGHWR_HAL_L1XX_AINTC_ECR2              0x0384
#define CYGHWR_HAL_L1XX_AINTC_ECR3              0x0388
#define CYGHWR_HAL_L1XX_AINTC_CMR(__x)          (0x400+((__x)*4))
#define CYGHWR_HAL_L1XX_AINTC_HIPIR1            0x0900
#define CYGHWR_HAL_L1XX_AINTC_HIPIR2            0x0904
#define CYGHWR_HAL_L1XX_AINTC_HINLR1            0x1100
#define CYGHWR_HAL_L1XX_AINTC_HINLR2            0x1104
#define CYGHWR_HAL_L1XX_AINTC_HIER              0x1500
#define CYGHWR_HAL_L1XX_AINTC_HIPVR1            0x1600
#define CYGHWR_HAL_L1XX_AINTC_HIPVR2            0x1604

// GER
#define CYGHWR_HAL_L1XX_AINTC_GER_ENABLE        1

// HIER
#define CYGHWR_HAL_L1XX_AINTC_HIER_FIQ          1
#define CYGHWR_HAL_L1XX_AINTC_HIER_IRQ          2

//=============================================================================
// UARTs

#define CYGHWR_HAL_L1XX_UART_RBR                     0x0000 // DLAB=0 read
#define CYGHWR_HAL_L1XX_UART_THR                     0x0000 // DLAB=0 write
#define CYGHWR_HAL_L1XX_UART_DLL                     0x0000 // DLAB=1 r/w
#define CYGHWR_HAL_L1XX_UART_IER                     0x0004 // DLAB=0
#define CYGHWR_HAL_L1XX_UART_DLM                     0x0004 // DLAB=1
#define CYGHWR_HAL_L1XX_UART_IIR                     0x0008 // read
#define CYGHWR_HAL_L1XX_UART_FCR                     0x0008 // write
#define CYGHWR_HAL_L1XX_UART_LCR                     0x000C
#define CYGHWR_HAL_L1XX_UART_MCR                     0x0010 // UART 1 only
#define CYGHWR_HAL_L1XX_UART_LSR                     0x0014
#define CYGHWR_HAL_L1XX_UART_MSR                     0x0018 // UART 1 only
#define CYGHWR_HAL_L1XX_UART_SCR                     0x001C

#define CYGHWR_HAL_L1XX_UART_PWREMU_MGMT             0x0030

#define CYGHWR_HAL_L1XX_UART_IER_RXDATA_INT          (1<<0)
#define CYGHWR_HAL_L1XX_UART_IER_THRE_INT            (1<<1)
#define CYGHWR_HAL_L1XX_UART_IER_RXLS_INT            (1<<2)
#define CYGHWR_HAL_L1XX_UART_IER_RXMS_INT            (1<<3) // UART 1 only

#define CYGHWR_HAL_L1XX_UART_IIR_IIR0                (1<<0)
#define CYGHWR_HAL_L1XX_UART_IIR_IIR1                (1<<1)
#define CYGHWR_HAL_L1XX_UART_IIR_IIR2                (1<<2)
#define CYGHWR_HAL_L1XX_UART_IIR_IIR3                (1<<3)
#define CYGHWR_HAL_L1XX_UART_IIR_FIFOS               (0xB0)

#define CYGHWR_HAL_L1XX_UART_FCR_FIFO_ENA            (1<<0)
#define CYGHWR_HAL_L1XX_UART_FCR_RX_FIFO_RESET       (1<<1)
#define CYGHWR_HAL_L1XX_UART_FCR_TX_FIFO_RESET       (1<<2)
#define CYGHWR_HAL_L1XX_UART_FCR_RX_TRIGGER_0        (0x00)
#define CYGHWR_HAL_L1XX_UART_FCR_RX_TRIGGER_1        (0x40)
#define CYGHWR_HAL_L1XX_UART_FCR_RX_TRIGGER_2        (0x80)
#define CYGHWR_HAL_L1XX_UART_FCR_RX_TRIGGER_3        (0xB0)

#define CYGHWR_HAL_L1XX_UART_LCR_WORD_LENGTH_5       (0x00)
#define CYGHWR_HAL_L1XX_UART_LCR_WORD_LENGTH_6       (0x01)
#define CYGHWR_HAL_L1XX_UART_LCR_WORD_LENGTH_7       (0x02)
#define CYGHWR_HAL_L1XX_UART_LCR_WORD_LENGTH_8       (0x03)
#define CYGHWR_HAL_L1XX_UART_LCR_STOP_1              (0x00)
#define CYGHWR_HAL_L1XX_UART_LCR_STOP_2              (0x04)
#define CYGHWR_HAL_L1XX_UART_LCR_PARITY_ENA          (0x08)
#define CYGHWR_HAL_L1XX_UART_LCR_PARITY_ODD          (0x00)
#define CYGHWR_HAL_L1XX_UART_LCR_PARITY_EVEN         (0x10)
#define CYGHWR_HAL_L1XX_UART_LCR_PARITY_ONE          (0x20)
#define CYGHWR_HAL_L1XX_UART_LCR_PARITY_ZERO         (0x30)
#define CYGHWR_HAL_L1XX_UART_LCR_BREAK_ENA           (0x40)
#define CYGHWR_HAL_L1XX_UART_LCR_DLAB                (0x80)


// Modem Control Register is UART1 only
#define CYGHWR_HAL_L1XX_UART_MCR_DTR                 (1<<0)
#define CYGHWR_HAL_L1XX_UART_MCR_RTS                 (1<<1)
#define CYGHWR_HAL_L1XX_UART_MCR_LOOPBACK            (1<<4)

#define CYGHWR_HAL_L1XX_UART_LSR_RDR                 (1<<0)
#define CYGHWR_HAL_L1XX_UART_LSR_OE                  (1<<1)
#define CYGHWR_HAL_L1XX_UART_LSR_PE                  (1<<2)
#define CYGHWR_HAL_L1XX_UART_LSR_FE                  (1<<3)
#define CYGHWR_HAL_L1XX_UART_LSR_BI                  (1<<4)
#define CYGHWR_HAL_L1XX_UART_LSR_THRE                (1<<5)
#define CYGHWR_HAL_L1XX_UART_LSR_TEMT                (1<<6)
#define CYGHWR_HAL_L1XX_UART_LSR_RX_FIFO_ERR         (1<<7)

// Modem Status Register is UART1 only
#define CYGHWR_HAL_L1XX_UART_MSR_DCTS                (1<<0)
#define CYGHWR_HAL_L1XX_UART_MSR_DDSR                (1<<1)
#define CYGHWR_HAL_L1XX_UART_MSR_RI_FALL             (1<<2)
#define CYGHWR_HAL_L1XX_UART_MSR_DDCD                (1<<3)
#define CYGHWR_HAL_L1XX_UART_MSR_CTS                 (1<<4)
#define CYGHWR_HAL_L1XX_UART_MSR_DSR                 (1<<5)
#define CYGHWR_HAL_L1XX_UART_MSR_RI                  (1<<6)
#define CYGHWR_HAL_L1XX_UART_MSR_DCD                 (1<<7)


// PWREMU_MGMT
#define CYGHWR_HAL_L1XX_UART_PWREMU_MGMT_FREE        (1<<0)
#define CYGHWR_HAL_L1XX_UART_PWREMU_MGMT_URRST       (1<<13)
#define CYGHWR_HAL_L1XX_UART_PWREMU_MGMT_UTRST       (1<<14)


#define CYGHWR_HAL_L1XX_UART0_RTS            CYGHWR_HAL_L1XX_PINMUX( 3, 28, 2 )
#define CYGHWR_HAL_L1XX_UART0_CTS            CYGHWR_HAL_L1XX_PINMUX( 3, 24, 2 )
#define CYGHWR_HAL_L1XX_UART0_TX             CYGHWR_HAL_L1XX_PINMUX( 3, 20, 2 )
#define CYGHWR_HAL_L1XX_UART0_RX             CYGHWR_HAL_L1XX_PINMUX( 3, 16, 2 )
#define CYGHWR_HAL_L1XX_UART0_POWER          CYGHWR_HAL_L1XX_POWER( UART0 )

#define CYGHWR_HAL_L1XX_UART1_RTS            CYGHWR_HAL_L1XX_PINMUX( 0, 16, 4 )
#define CYGHWR_HAL_L1XX_UART1_CTS            CYGHWR_HAL_L1XX_PINMUX( 0, 20, 4 )
#define CYGHWR_HAL_L1XX_UART1_TX             CYGHWR_HAL_L1XX_PINMUX( 4, 28, 2 )
#define CYGHWR_HAL_L1XX_UART1_RX             CYGHWR_HAL_L1XX_PINMUX( 4, 24, 2 )
#define CYGHWR_HAL_L1XX_UART1_POWER          CYGHWR_HAL_L1XX_POWER( UART1 )

#define CYGHWR_HAL_L1XX_UART2_RTS            CYGHWR_HAL_L1XX_PINMUX( 0, 24, 4 )
#define CYGHWR_HAL_L1XX_UART2_CTS            CYGHWR_HAL_L1XX_PINMUX( 0, 28, 4 )
#define CYGHWR_HAL_L1XX_UART2_TX             CYGHWR_HAL_L1XX_PINMUX( 4, 20, 2 )
#define CYGHWR_HAL_L1XX_UART2_RX             CYGHWR_HAL_L1XX_PINMUX( 4, 16, 2 )
#define CYGHWR_HAL_L1XX_UART2_POWER          CYGHWR_HAL_L1XX_POWER( UART2 )

//=============================================================================
// Timers

#define CYGHWR_HAL_L1XX_TIMER_REV                       0x0000
#define CYGHWR_HAL_L1XX_TIMER_EMUMGT                    0x0004
#define CYGHWR_HAL_L1XX_TIMER_GPINT_GPEN                0x0008
#define CYGHWR_HAL_L1XX_TIMER_GPDATA_GPDIR              0x000C
#define CYGHWR_HAL_L1XX_TIMER_TIM12                     0x0010
#define CYGHWR_HAL_L1XX_TIMER_TIM34                     0x0014
#define CYGHWR_HAL_L1XX_TIMER_PRD12                     0x0018
#define CYGHWR_HAL_L1XX_TIMER_PRD34                     0x001C
#define CYGHWR_HAL_L1XX_TIMER_TCR                       0x0020
#define CYGHWR_HAL_L1XX_TIMER_TGCR                      0x0024
#define CYGHWR_HAL_L1XX_TIMER_WDTCR                     0x0028
#define CYGHWR_HAL_L1XX_TIMER_REL12                     0x0034
#define CYGHWR_HAL_L1XX_TIMER_REL34                     0x0038
#define CYGHWR_HAL_L1XX_TIMER_CAP12                     0x003C
#define CYGHWR_HAL_L1XX_TIMER_CAP34                     0x0040
#define CYGHWR_HAL_L1XX_TIMER_INTCTLSTAT                0x0044
#define CYGHWR_HAL_L1XX_TIMER_CMP0                      0x0060
#define CYGHWR_HAL_L1XX_TIMER_CMP1                      0x0064
#define CYGHWR_HAL_L1XX_TIMER_CMP2                      0x0068
#define CYGHWR_HAL_L1XX_TIMER_CMP3                      0x006C
#define CYGHWR_HAL_L1XX_TIMER_CMP4                      0x0070
#define CYGHWR_HAL_L1XX_TIMER_CMP5                      0x0074
#define CYGHWR_HAL_L1XX_TIMER_CMP6                      0x0078
#define CYGHWR_HAL_L1XX_TIMER_CMP7                      0x007C

// EMUMGT
#define CYGHWR_HAL_L1XX_TIMER_EMUMGT_FREE               (1<<0)
#define CYGHWR_HAL_L1XX_TIMER_EMUMGT_SOFT               (1<<1)

// TCR
#define CYGHWR_HAL_L1XX_TIMER_TCR_MODE12_DIS            (0<< 6)
#define CYGHWR_HAL_L1XX_TIMER_TCR_MODE12_ONCE           (1<< 6)
#define CYGHWR_HAL_L1XX_TIMER_TCR_MODE12_CONT           (2<< 6)
#define CYGHWR_HAL_L1XX_TIMER_TCR_MODE12_CRL            (3<< 6)
#define CYGHWR_HAL_L1XX_TIMER_TCR_MODE34_DIS            (0<<22)
#define CYGHWR_HAL_L1XX_TIMER_TCR_MODE34_ONCE           (1<<22)
#define CYGHWR_HAL_L1XX_TIMER_TCR_MODE34_CONT           (2<<22)
#define CYGHWR_HAL_L1XX_TIMER_TCR_MODE34_CRL            (3<<22)


// TGCR
#define CYGHWR_HAL_L1XX_TIMER_TGCR_TIM12RS              (1<<0)
#define CYGHWR_HAL_L1XX_TIMER_TGCR_TIM34RS              (1<<1)
#define CYGHWR_HAL_L1XX_TIMER_TGCR_TIMMODE_64GP         (0<<2)
#define CYGHWR_HAL_L1XX_TIMER_TGCR_TIMMODE_32UC         (1<<2)
#define CYGHWR_HAL_L1XX_TIMER_TGCR_TIMMODE_64WD         (2<<2)
#define CYGHWR_HAL_L1XX_TIMER_TGCR_TIMMODE_23CC         (3<<2)
#define CYGHWR_HAL_L1XX_TIMER_TGCR_PLUSEN               (1<<4)
#define CYGHWR_HAL_L1XX_TIMER_TGCR_PSC34(__x)           ((__x)<<8)
#define CYGHWR_HAL_L1XX_TIMER_TGCR_TDDR34(__x)          ((__x)<<12)

// WDTCR
#define CYGHWR_HAL_L1XX_TIMER_WDTCR_WDEN                (1<<14)
#define CYGHWR_HAL_L1XX_TIMER_WDTCR_WDFLAG              (1<<15)
#define CYGHWR_HAL_L1XX_TIMER_WDTCR_WDKEY0              0xA5C60000
#define CYGHWR_HAL_L1XX_TIMER_WDTCR_WDKEY1              0xDA7E0000

// INTCTLSTAT
#define CYGHWR_HAL_L1XX_TIMER_INTCTLSTAT_PRD12EN        (1<< 0)
#define CYGHWR_HAL_L1XX_TIMER_INTCTLSTAT_PRD12ST        (1<< 1)
#define CYGHWR_HAL_L1XX_TIMER_INTCTLSTAT_PRD34EN        (1<<16)
#define CYGHWR_HAL_L1XX_TIMER_INTCTLSTAT_PRD34ST        (1<<17)

//=============================================================================
// EDMA

#define CYGHWR_HAL_L1XX_EDMA_REV	                0x0000
#define CYGHWR_HAL_L1XX_EDMA_CCCFG	                0x0004

#define CYGHWR_HAL_L1XX_EDMA_QCHMAP0	                0x0200
#define CYGHWR_HAL_L1XX_EDMA_DMAQNUM0	                0x0240
#define CYGHWR_HAL_L1XX_EDMA_QDMAQNUM	                0x0260
#define CYGHWR_HAL_L1XX_EDMA_QUETCMAP	                0x0280
#define CYGHWR_HAL_L1XX_EDMA_QUEPRI	                0x0284
#define CYGHWR_HAL_L1XX_EDMA_EMR	                0x0300
#define CYGHWR_HAL_L1XX_EDMA_EMCR	                0x0308
#define CYGHWR_HAL_L1XX_EDMA_QEMR	                0x0310
#define CYGHWR_HAL_L1XX_EDMA_QEMCR	                0x0314
#define CYGHWR_HAL_L1XX_EDMA_CCERR	                0x0318
#define CYGHWR_HAL_L1XX_EDMA_CCERRCLR	                0x031c
#define CYGHWR_HAL_L1XX_EDMA_EEVAL	                0x0320
#define CYGHWR_HAL_L1XX_EDMA_DRAE0	                0x0340
#define CYGHWR_HAL_L1XX_EDMA_QRAE0	                0x0380
#define CYGHWR_HAL_L1XX_EDMA_Q0E0       	        0x0400
#define CYGHWR_HAL_L1XX_EDMA_Q1E0       	        0x0440
#define CYGHWR_HAL_L1XX_EDMA_QSTAT	                0x0600
#define CYGHWR_HAL_L1XX_EDMA_QWMTHRA	                0x0620
#define CYGHWR_HAL_L1XX_EDMA_QWMTHRB	                0x0624
#define CYGHWR_HAL_L1XX_EDMA_CCSTAT	                0x0640

#define CYGHWR_HAL_L1XX_EDMA_GCR	                0x1000
#define CYGHWR_HAL_L1XX_EDMA_SHADOW(__x)                (0x2000+(__x)*0x200)

// Channel registers, both Global and Shadows
#define CYGHWR_HAL_L1XX_EDMA_ER		                0x0000
#define CYGHWR_HAL_L1XX_EDMA_ECR		        0x0008
#define CYGHWR_HAL_L1XX_EDMA_ESR		        0x0010
#define CYGHWR_HAL_L1XX_EDMA_CER        	        0x0018
#define CYGHWR_HAL_L1XX_EDMA_EER                        0x0020
#define CYGHWR_HAL_L1XX_EDMA_EECR      	                0x0028
#define CYGHWR_HAL_L1XX_EDMA_EESR      	                0x0030
#define CYGHWR_HAL_L1XX_EDMA_SER       	                0x0038
#define CYGHWR_HAL_L1XX_EDMA_SECR      	                0x0040
#define CYGHWR_HAL_L1XX_EDMA_IER       	                0x0050
#define CYGHWR_HAL_L1XX_EDMA_IECR     	                0x0058
#define CYGHWR_HAL_L1XX_EDMA_IESR      	                0x0060
#define CYGHWR_HAL_L1XX_EDMA_IPR       	                0x0068
#define CYGHWR_HAL_L1XX_EDMA_ICR       	                0x0070
#define CYGHWR_HAL_L1XX_EDMA_IEVAL                      0x0078
#define CYGHWR_HAL_L1XX_EDMA_QER       	                0x0080
#define CYGHWR_HAL_L1XX_EDMA_QEER      	                0x0084
#define CYGHWR_HAL_L1XX_EDMA_QEECR                      0x0088
#define CYGHWR_HAL_L1XX_EDMA_QEESR                      0x008c
#define CYGHWR_HAL_L1XX_EDMA_QSER      	                0x0090
#define CYGHWR_HAL_L1XX_EDMA_QSECR	                0x0094


#define CYGHWR_HAL_L1XX_EDMA_PARAM	                0x4000 

// PaRAM set offset
#define CYGHWR_HAL_L1XX_EDMA_PARAM_SET(__x)	        (0x4000+(__x)*0x20)

// PaRAM set structure
#define CYGHWR_HAL_L1XX_EDMA_SET_OPT                    0x00
#define CYGHWR_HAL_L1XX_EDMA_SET_SRC                    0x04
#define CYGHWR_HAL_L1XX_EDMA_SET_ABCNT                  0x08
#define CYGHWR_HAL_L1XX_EDMA_SET_DST                    0x0C
#define CYGHWR_HAL_L1XX_EDMA_SET_SDBIDX                 0x10
#define CYGHWR_HAL_L1XX_EDMA_SET_LNKBCNTRLD             0x14
#define CYGHWR_HAL_L1XX_EDMA_SET_SDCIDX                 0x18
#define CYGHWR_HAL_L1XX_EDMA_SET_CCNT                   0x1C

// Set options
#define CYGHWR_HAL_L1XX_EDMA_SET_OPT_ABSYNC             (1<<2)
#define CYGHWR_HAL_L1XX_EDMA_SET_OPT_TCINT              (1<<20)
#define CYGHWR_HAL_L1XX_EDMA_SET_OPT_TCC(__x)           ((__x)<<12)


// DMA controller + event descriptor encoding
#define CYGHWR_HAL_L1XX_EDMA_CHANNEL(__ctrl, __event )  (((__ctrl)<<16)|(__event))

#define CYGHWR_HAL_L1XX_EDMA_CHANNEL_CONTROLLER(__desc) (((__desc)>>16)&1)
#define CYGHWR_HAL_L1XX_EDMA_CHANNEL_EVENT(__desc)      ((__desc)&0xFF)

#define CYGHWR_HAL_L1XX_EDMA0_CC_POWER                  CYGHWR_HAL_L1XX_POWER( EDMA0_CC )
#define CYGHWR_HAL_L1XX_EDMA0_TC0_POWER                 CYGHWR_HAL_L1XX_POWER( EDMA0_TC0 )
#define CYGHWR_HAL_L1XX_EDMA0_TC1_POWER                 CYGHWR_HAL_L1XX_POWER( EDMA0_TC1 )
#define CYGHWR_HAL_L1XX_EDMA1_CC_POWER                  CYGHWR_HAL_L1XX_POWER( EDMA1_CC )
#define CYGHWR_HAL_L1XX_EDMA1_TC0_POWER                 CYGHWR_HAL_L1XX_POWER( EDMA1_TC0 )

#ifndef __ASSEMBLER__

struct hal_edma_channel;
typedef struct hal_edma_channel hal_edma_channel;

typedef void hal_edma_callback( hal_edma_channel *edma_chan, cyg_uint32 event, CYG_ADDRWORD data );

struct hal_edma_channel
{
    cyg_uint32          channel;        // channel descriptor
    cyg_uint32          edma_ctrl;      // EDMA channel control registers
    cyg_uint32          edma_shadow;    // EDMA shadow control registers
    cyg_uint32          param_set;      // PaRAM set
    hal_edma_callback   *callback;      // Callback function
    CYG_ADDRWORD        data;           // Client private data
    cyg_uint16          aburstsize;     // Size of each A burst
    cyg_uint16          bburstsize;     // Size of each B burst
    cyg_bool            active;         // Channel active?
};

#define CYGHWR_HAL_L1XX_EDMA_COMPLETE   1
#define CYGHWR_HAL_L1XX_EDMA_ERROR      2

__externC void hal_edma_channel_init    ( hal_edma_channel *edma_chan, cyg_uint32 channel,
                                          hal_edma_callback *callback, CYG_ADDRWORD data );
__externC void hal_edma_channel_delete  ( hal_edma_channel *edma_chan );

__externC void hal_edma_poll            ( void );

__externC void hal_edma_channel_source  ( hal_edma_channel *edma_chan, void *src , cyg_int16 bidx, cyg_int16 cidx );
__externC void hal_edma_channel_dest    ( hal_edma_channel *edma_chan, void *dest, cyg_int16 bidx, cyg_int16 cidx );
__externC void hal_edma_channel_burstsize( hal_edma_channel *edma_chan, cyg_uint16 aburstsize, cyg_uint16 bburstsize );
__externC void hal_edma_channel_size    ( hal_edma_channel *edma_chan, cyg_uint32 size );

__externC void hal_edma_channel_start   ( hal_edma_channel *edma_chan, cyg_uint32 opt );
__externC void hal_edma_channel_stop    ( hal_edma_channel *edma_chan );

#endif

//=============================================================================
// RTC

#define CYGHWR_HAL_L1XX_RTC_SECOND                      0x0000
#define CYGHWR_HAL_L1XX_RTC_MINUTE                      0x0004
#define CYGHWR_HAL_L1XX_RTC_HOUR                        0x0008
#define CYGHWR_HAL_L1XX_RTC_DAY                         0x000C
#define CYGHWR_HAL_L1XX_RTC_MONTH                       0x0010
#define CYGHWR_HAL_L1XX_RTC_YEAR                        0x0014
#define CYGHWR_HAL_L1XX_RTC_DOTW                        0x0018
#define CYGHWR_HAL_L1XX_RTC_ALARMSECOND                 0x0020
#define CYGHWR_HAL_L1XX_RTC_ALARMMINUTE                 0x0024
#define CYGHWR_HAL_L1XX_RTC_ALARMHOUR                   0x0028
#define CYGHWR_HAL_L1XX_RTC_ALARMDAY                    0x002C
#define CYGHWR_HAL_L1XX_RTC_ALARMMONTH                  0x0030
#define CYGHWR_HAL_L1XX_RTC_ALARMYEAR                   0x0034
#define CYGHWR_HAL_L1XX_RTC_CTRL                        0x0040
#define CYGHWR_HAL_L1XX_RTC_STATUS                      0x0044
#define CYGHWR_HAL_L1XX_RTC_INTERRUPT                   0x0048
#define CYGHWR_HAL_L1XX_RTC_COMPLSB                     0x004C
#define CYGHWR_HAL_L1XX_RTC_COMPMSB                     0x0050
#define CYGHWR_HAL_L1XX_RTC_OSC                         0x0054
#define CYGHWR_HAL_L1XX_RTC_SCRATCH0                    0x0060
#define CYGHWR_HAL_L1XX_RTC_SCRATCH1                    0x0064
#define CYGHWR_HAL_L1XX_RTC_SCRATCH2                    0x0068
#define CYGHWR_HAL_L1XX_RTC_KICK0                       0x006C
#define CYGHWR_HAL_L1XX_RTC_KICK1                       0x0070

// CTRL
#define CYGHWR_HAL_L1XX_RTC_CTRL_RUN                    (1<<0)

// STATUS
#define CYGHWR_HAL_L1XX_RTC_STATUS_BUSY                 (1<<0)

// KICKX
#define CYGHWR_HAL_L1XX_RTC_KICK0_UNLOCK                0x83E70B13
#define CYGHWR_HAL_L1XX_RTC_KICK1_UNLOCK                0x95A4F1E0

//=============================================================================
// SPI

#define CYGHWR_HAL_OMAP_SPI_GCR0                        0x0000
#define CYGHWR_HAL_OMAP_SPI_GCR1                        0x0004
#define CYGHWR_HAL_OMAP_SPI_INT                         0x0008
#define CYGHWR_HAL_OMAP_SPI_LVL                         0x000C
#define CYGHWR_HAL_OMAP_SPI_FLG                         0x0010
#define CYGHWR_HAL_OMAP_SPI_PC0                         0x0014
#define CYGHWR_HAL_OMAP_SPI_PC1                         0x0018
#define CYGHWR_HAL_OMAP_SPI_PC2                         0x001C
#define CYGHWR_HAL_OMAP_SPI_PC3                         0x0020
#define CYGHWR_HAL_OMAP_SPI_PC4                         0x0024
#define CYGHWR_HAL_OMAP_SPI_PC5                         0x0028

#define CYGHWR_HAL_OMAP_SPI_DAT0                        0x0038
#define CYGHWR_HAL_OMAP_SPI_DAT1                        0x003C
#define CYGHWR_HAL_OMAP_SPI_BUF                         0x0040
#define CYGHWR_HAL_OMAP_SPI_EMU                         0x0044
#define CYGHWR_HAL_OMAP_SPI_DELAY                       0x0048
#define CYGHWR_HAL_OMAP_SPI_DEF                         0x004C
#define CYGHWR_HAL_OMAP_SPI_FMT0                        0x0050
#define CYGHWR_HAL_OMAP_SPI_FMT1                        0x0054
#define CYGHWR_HAL_OMAP_SPI_FMT2                        0x0058
#define CYGHWR_HAL_OMAP_SPI_FMT3                        0x005C
#define CYGHWR_HAL_OMAP_SPI_INTVEC0                     0x0060
#define CYGHWR_HAL_OMAP_SPI_INTVEC1                     0x0064

// GCR0
#define CYGHWR_HAL_OMAP_SPI_GCR0_RESET                  (1<<0)

// GCR1
#define CYGHWR_HAL_OMAP_SPI_GCR1_MASTER                 (1<<0)
#define CYGHWR_HAL_OMAP_SPI_GCR1_CLKMOD                 (1<<1)
#define CYGHWR_HAL_OMAP_SPI_GCR1_POWERDOWN              (1<<8)
#define CYGHWR_HAL_OMAP_SPI_GCR1_LOOPBACK               (1<<16)
#define CYGHWR_HAL_OMAP_SPI_GCR1_ENABLE                 (1<<24)

// INT, LVL and FLG
#define CYGHWR_HAL_OMAP_SPI_INT_DLENERR                 (1<< 0)
#define CYGHWR_HAL_OMAP_SPI_INT_TIMEOUT                 (1<< 1)
#define CYGHWR_HAL_OMAP_SPI_INT_PARERR                  (1<< 2)
#define CYGHWR_HAL_OMAP_SPI_INT_DESYNC                  (1<< 3)
#define CYGHWR_HAL_OMAP_SPI_INT_BITERR                  (1<< 4)
#define CYGHWR_HAL_OMAP_SPI_INT_OVRN                    (1<< 6)
#define CYGHWR_HAL_OMAP_SPI_INT_RX                      (1<< 8)
#define CYGHWR_HAL_OMAP_SPI_INT_TX                      (1<< 9)
#define CYGHWR_HAL_OMAP_SPI_INT_DMAREQ                  (1<<16)
#define CYGHWR_HAL_OMAP_SPI_INT_ENAHIGHZ                (1<<24)

// PCx registers
#define CYGHWR_HAL_OMAP_SPI_PCX_ENA                     (1<< 8)
#define CYGHWR_HAL_OMAP_SPI_PCX_CLK                     (1<< 9)
#define CYGHWR_HAL_OMAP_SPI_PCX_MOSI                    (1<<10)
#define CYGHWR_HAL_OMAP_SPI_PCX_MISO                    (1<<11)

// BUF
#define CYGHWR_HAL_OMAP_SPI_BUF_RXDATA(__buf)           ((__buf)&0xFFFF)
#define CYGHWR_HAL_OMAP_SPI_BUF_DLENERR                 (1<<24)
#define CYGHWR_HAL_OMAP_SPI_BUF_TIMEOUT                 (1<<25)
#define CYGHWR_HAL_OMAP_SPI_BUF_PARERR                  (1<<26)
#define CYGHWR_HAL_OMAP_SPI_BUF_DESYNC                  (1<<27)
#define CYGHWR_HAL_OMAP_SPI_BUF_BITERR                  (1<<28)
#define CYGHWR_HAL_OMAP_SPI_BUF_TXFULL                  (1<<29)
#define CYGHWR_HAL_OMAP_SPI_BUF_RXOVR                   (1<<30)
#define CYGHWR_HAL_OMAP_SPI_BUF_RXEMPTY                 (1<<31)

// FMTx
#define CYGHWR_HAL_OMAP_SPI_FMT_CHARLEN(__x)            (__x)
#define CYGHWR_HAL_OMAP_SPI_FMT_PRESCALE(__x)           ((__x)<<8)
#define CYGHWR_HAL_OMAP_SPI_FMT_PHASE                   (1<<16)
#define CYGHWR_HAL_OMAP_SPI_FMT_POLARITY                (1<<17)
#define CYGHWR_HAL_OMAP_SPI_FMT_DISCSTIMERS             (1<<18)
#define CYGHWR_HAL_OMAP_SPI_FMT_SHIFTDIR                (1<<20)
#define CYGHWR_HAL_OMAP_SPI_FMT_WAITENA                 (1<<21)
#define CYGHWR_HAL_OMAP_SPI_FMT_PARENA                  (1<<22)
#define CYGHWR_HAL_OMAP_SPI_FMT_PARPOL                  (1<<23)
#define CYGHWR_HAL_OMAP_SPI_FMT_WDELAY(__x)             ((__x)<<24)


#define CYGHWR_HAL_OMAP_SPI0_MISO                       CYGHWR_HAL_L1XX_PINMUX(  3, 12, 1 )
#define CYGHWR_HAL_OMAP_SPI0_MOSI                       CYGHWR_HAL_L1XX_PINMUX(  3,  8, 1 )
#define CYGHWR_HAL_OMAP_SPI0_CLK                        CYGHWR_HAL_L1XX_PINMUX(  3,  0, 1 )
#define CYGHWR_HAL_OMAP_SPI0_CS0                        CYGHWR_HAL_L1XX_PINMUX(  4,  4, 1 )
#define CYGHWR_HAL_OMAP_SPI0_CS1                        CYGHWR_HAL_L1XX_PINMUX(  4,  0, 1 )
#define CYGHWR_HAL_OMAP_SPI0_CS2                        CYGHWR_HAL_L1XX_PINMUX(  3, 28, 1 )
#define CYGHWR_HAL_OMAP_SPI0_CS3                        CYGHWR_HAL_L1XX_PINMUX(  3, 24, 1 )
#define CYGHWR_HAL_OMAP_SPI0_CS4                        CYGHWR_HAL_L1XX_PINMUX(  3, 20, 1 )
#define CYGHWR_HAL_OMAP_SPI0_CS5                        CYGHWR_HAL_L1XX_PINMUX(  3, 16, 1 )

#define CYGHWR_HAL_OMAP_SPI0_POWER                      CYGHWR_HAL_L1XX_POWER( SPI0 )
#define CYGHWR_HAL_OMAP_SPI0_RXDMA                      CYGHWR_HAL_L1XX_EDMA_CHANNEL( 0, 14 )
#define CYGHWR_HAL_OMAP_SPI0_TXDMA                      CYGHWR_HAL_L1XX_EDMA_CHANNEL( 0, 15 )


#define CYGHWR_HAL_OMAP_SPI1_MISO                       CYGHWR_HAL_L1XX_PINMUX(  5, 20, 1 )
#define CYGHWR_HAL_OMAP_SPI1_MOSI                       CYGHWR_HAL_L1XX_PINMUX(  5, 16, 1 )
#define CYGHWR_HAL_OMAP_SPI1_CLK                        CYGHWR_HAL_L1XX_PINMUX(  5,  8, 1 )
#define CYGHWR_HAL_OMAP_SPI1_CS0                        CYGHWR_HAL_L1XX_PINMUX(  5,  4, 1 )
#define CYGHWR_HAL_OMAP_SPI1_CS1                        CYGHWR_HAL_L1XX_PINMUX(  5,  0, 1 )
#define CYGHWR_HAL_OMAP_SPI1_CS2                        CYGHWR_HAL_L1XX_PINMUX(  4, 28, 1 )
#define CYGHWR_HAL_OMAP_SPI1_CS3                        CYGHWR_HAL_L1XX_PINMUX(  4, 24, 1 )
#define CYGHWR_HAL_OMAP_SPI1_CS4                        CYGHWR_HAL_L1XX_PINMUX(  4, 20, 1 )
#define CYGHWR_HAL_OMAP_SPI1_CS5                        CYGHWR_HAL_L1XX_PINMUX(  4, 16, 1 )
#define CYGHWR_HAL_OMAP_SPI1_CS6                        CYGHWR_HAL_L1XX_PINMUX(  4, 12, 1 )
#define CYGHWR_HAL_OMAP_SPI1_CS7                        CYGHWR_HAL_L1XX_PINMUX(  4,  8, 1 )

#define CYGHWR_HAL_OMAP_SPI1_POWER                      CYGHWR_HAL_L1XX_POWER( SPI0 )
#define CYGHWR_HAL_OMAP_SPI1_RXDMA                      CYGHWR_HAL_L1XX_EDMA_CHANNEL( 0, 18 )
#define CYGHWR_HAL_OMAP_SPI1_TXDMA                      CYGHWR_HAL_L1XX_EDMA_CHANNEL( 0, 19 )

//=============================================================================
// MMC/SD

#define CYGHWR_HAL_L1XX_MMC_CTL                         0x0000
#define CYGHWR_HAL_L1XX_MMC_CLK                         0x0004
#define CYGHWR_HAL_L1XX_MMC_ST0                         0x0008
#define CYGHWR_HAL_L1XX_MMC_ST1                         0x000C
#define CYGHWR_HAL_L1XX_MMC_IM                          0x0010
#define CYGHWR_HAL_L1XX_MMC_TOR                         0x0014
#define CYGHWR_HAL_L1XX_MMC_TOD                         0x0018
#define CYGHWR_HAL_L1XX_MMC_BLEN                        0x001C
#define CYGHWR_HAL_L1XX_MMC_NBLK                        0x0020
#define CYGHWR_HAL_L1XX_MMC_NBLC                        0x0024
#define CYGHWR_HAL_L1XX_MMC_DRR                         0x0028
#define CYGHWR_HAL_L1XX_MMC_DXR                         0x002C
#define CYGHWR_HAL_L1XX_MMC_CMD                         0x0030
#define CYGHWR_HAL_L1XX_MMC_ARGHL                       0x0034
#define CYGHWR_HAL_L1XX_MMC_RSP01                       0x0038
#define CYGHWR_HAL_L1XX_MMC_RSP23                       0x003C
#define CYGHWR_HAL_L1XX_MMC_RSP45                       0x0040
#define CYGHWR_HAL_L1XX_MMC_RSP67                       0x0044
#define CYGHWR_HAL_L1XX_MMC_DRSP                        0x0048
#define CYGHWR_HAL_L1XX_MMC_CIDX                        0x0050
#define CYGHWR_HAL_L1XX_SDIO_CTL                        0x0064
#define CYGHWR_HAL_L1XX_SDIO_ST0                        0x0068
#define CYGHWR_HAL_L1XX_SDIO_IEN                        0x006C
#define CYGHWR_HAL_L1XX_SDIO_IST                        0x0070
#define CYGHWR_HAL_L1XX_MMC_FIFOCTL                     0x0074

// CTL
#define CYGHWR_HAL_L1XX_MMC_CTL_DATRST                  (1<<0)
#define CYGHWR_HAL_L1XX_MMC_CTL_CMDRST                  (1<<1)
#define CYGHWR_HAL_L1XX_MMC_CTL_WIDTH_1                 0
#define CYGHWR_HAL_L1XX_MMC_CTL_WIDTH_4                 (1<<2)
#define CYGHWR_HAL_L1XX_MMC_CTL_WIDTH_8                 (1<<8)
#define CYGHWR_HAL_L1XX_MMC_CTL_WIDTH_MASK              ((1<<8)|(1<<2))
#define CYGHWR_HAL_L1XX_MMC_CTL_DATEG_DIS               0
#define CYGHWR_HAL_L1XX_MMC_CTL_DATEG_RISING            (1<<6)
#define CYGHWR_HAL_L1XX_MMC_CTL_DATEG_FALLING           (2<<6)
#define CYGHWR_HAL_L1XX_MMC_CTL_DATEG_BOTH              (3<<6)
#define CYGHWR_HAL_L1XX_MMC_CTL_PERMDR                  (1<<9)
#define CYGHWR_HAL_L1XX_MMC_CTL_PERMDX                  (1<<10)

// CLK
#define CYGHWR_HAL_L1XX_MMC_CLK_CLKRT(__x)              (__x)
#define CYGHWR_HAL_L1XX_MMC_CLK_CLKEN                   (1<<8)
#define CYGHWR_HAL_L1XX_MMC_CLK_DIV4                    (1<<9)

// ST0
#define CYGHWR_HAL_L1XX_MMC_ST0_DATADNE                 (1<<0)
#define CYGHWR_HAL_L1XX_MMC_ST0_BSYDNE                  (1<<1)
#define CYGHWR_HAL_L1XX_MMC_ST0_RSPDNE                  (1<<2)
#define CYGHWR_HAL_L1XX_MMC_ST0_TOUTRD                  (1<<3)
#define CYGHWR_HAL_L1XX_MMC_ST0_TOUTRS                  (1<<4)
#define CYGHWR_HAL_L1XX_MMC_ST0_CRCWR                   (1<<5)
#define CYGHWR_HAL_L1XX_MMC_ST0_CRCRD                   (1<<6)
#define CYGHWR_HAL_L1XX_MMC_ST0_CRCRS                   (1<<7)
#define CYGHWR_HAL_L1XX_MMC_ST0_DXRDY                   (1<<9)
#define CYGHWR_HAL_L1XX_MMC_ST0_DRRDY                   (1<<10)
#define CYGHWR_HAL_L1XX_MMC_ST0_DATED                   (1<<11)
#define CYGHWR_HAL_L1XX_MMC_ST0_TRNDNE                  (1<<12)
#define CYGHWR_HAL_L1XX_MMC_ST0_CCS                     (1<<13)

// ST1
#define CYGHWR_HAL_L1XX_MMC_ST1_BUSY                    (1<<0)
#define CYGHWR_HAL_L1XX_MMC_ST1_CLKSTP                  (1<<1)
#define CYGHWR_HAL_L1XX_MMC_ST1_DXEMP                   (1<<2)
#define CYGHWR_HAL_L1XX_MMC_ST1_DRFUL                   (1<<3)
#define CYGHWR_HAL_L1XX_MMC_ST1_DAT3ST                  (1<<4)
#define CYGHWR_HAL_L1XX_MMC_ST1_FIFOEMP                 (1<<5)
#define CYGHWR_HAL_L1XX_MMC_ST1_FIFOFUL                 (1<<6)


// TOR
#define CYGHWR_HAL_L1XX_MMC_TOR_TOR(__x)                (__x)
#define CYGHWR_HAL_L1XX_MMC_TOR_TOD_25_16(__x)          (((__x)>>8)&0x0003FF00)

// TOD
#define CYGHWR_HAL_L1XX_MMC_TOD_TOD_15_0(__x)           ((__x)&0xFFFF)

// CMD
#define CYGHWR_HAL_L1XX_MMC_CMD_CMD(__x)                ((__x)&0x3F)
#define CYGHWR_HAL_L1XX_MMC_CMD_PPLEN                   (1<<7)
#define CYGHWR_HAL_L1XX_MMC_CMD_BSYEXP                  (1<<8)
#define CYGHWR_HAL_L1XX_MMC_CMD_RSP_NONE                (0<<9)
#define CYGHWR_HAL_L1XX_MMC_CMD_RSP_48                  (1<<9)
#define CYGHWR_HAL_L1XX_MMC_CMD_RSP_136                 (2<<9)
#define CYGHWR_HAL_L1XX_MMC_CMD_RSP_48_NOCRC            (3<<9)
#define CYGHWR_HAL_L1XX_MMC_CMD_DTRW                    (1<<11)
#define CYGHWR_HAL_L1XX_MMC_CMD_STRMTP                  (1<<12)
#define CYGHWR_HAL_L1XX_MMC_CMD_WDATX                   (1<<13)
#define CYGHWR_HAL_L1XX_MMC_CMD_INTCLK                  (1<<14)
#define CYGHWR_HAL_L1XX_MMC_CMD_DCLR                    (1<<15)
#define CYGHWR_HAL_L1XX_MMC_CMD_DMATRIG                 (1<<16)

// FIFOCTL
#define CYGHWR_HAL_L1XX_MMC_FIFOCTL_RST                 (1<<0)
#define CYGHWR_HAL_L1XX_MMC_FIFOCTL_DIR_READ            (0<<1)
#define CYGHWR_HAL_L1XX_MMC_FIFOCTL_DIR_WRITE           (1<<1)
#define CYGHWR_HAL_L1XX_MMC_FIFOCTL_LEVEL_32            (0<<2)
#define CYGHWR_HAL_L1XX_MMC_FIFOCTL_LEVEL_64            (1<<2)
#define CYGHWR_HAL_L1XX_MMC_FIFOCTL_ACCWD_4             (0<<3)
#define CYGHWR_HAL_L1XX_MMC_FIFOCTL_ACCWD_3             (1<<3)
#define CYGHWR_HAL_L1XX_MMC_FIFOCTL_ACCWD_2             (2<<3)
#define CYGHWR_HAL_L1XX_MMC_FIFOCTL_ACCWD_1             (3<<3)


#define CYGHWR_HAL_OMAP_MMCSD0_CLK                      CYGHWR_HAL_L1XX_PINMUX( 10,  0, 2 )
#define CYGHWR_HAL_OMAP_MMCSD0_CMD                      CYGHWR_HAL_L1XX_PINMUX( 10,  4, 2 )
#define CYGHWR_HAL_OMAP_MMCSD0_DAT0                     CYGHWR_HAL_L1XX_PINMUX( 10,  8, 2 )
#define CYGHWR_HAL_OMAP_MMCSD0_DAT1                     CYGHWR_HAL_L1XX_PINMUX( 10, 12, 2 )
#define CYGHWR_HAL_OMAP_MMCSD0_DAT2                     CYGHWR_HAL_L1XX_PINMUX( 10, 16, 2 )
#define CYGHWR_HAL_OMAP_MMCSD0_DAT3                     CYGHWR_HAL_L1XX_PINMUX( 10, 20, 2 )
#define CYGHWR_HAL_OMAP_MMCSD0_DAT4                     CYGHWR_HAL_L1XX_PINMUX( 10, 24, 2 )
#define CYGHWR_HAL_OMAP_MMCSD0_DAT5                     CYGHWR_HAL_L1XX_PINMUX( 10, 28, 2 )
#define CYGHWR_HAL_OMAP_MMCSD0_DAT6                     CYGHWR_HAL_L1XX_PINMUX( 11,  0, 2 )
#define CYGHWR_HAL_OMAP_MMCSD0_DAT7                     CYGHWR_HAL_L1XX_PINMUX( 11,  4, 2 )
#define CYGHWR_HAL_OMAP_MMCSD0_POWER                    CYGHWR_HAL_L1XX_POWER( MMCSD0 )
#define CYGHWR_HAL_OMAP_MMCSD0_RXDMA                    CYGHWR_HAL_L1XX_EDMA_CHANNEL( 0, 16 )
#define CYGHWR_HAL_OMAP_MMCSD0_TXDMA                    CYGHWR_HAL_L1XX_EDMA_CHANNEL( 0, 17 )


#define CYGHWR_HAL_OMAP_MMCSD1_CLK                      CYGHWR_HAL_L1XX_PINMUX( 18, 12, 2 )
#define CYGHWR_HAL_OMAP_MMCSD1_CMD                      CYGHWR_HAL_L1XX_PINMUX( 18, 16, 2 )
#define CYGHWR_HAL_OMAP_MMCSD1_DAT0                     CYGHWR_HAL_L1XX_PINMUX( 18,  8, 2 )
#define CYGHWR_HAL_OMAP_MMCSD1_DAT1                     CYGHWR_HAL_L1XX_PINMUX( 19, 16, 2 )
#define CYGHWR_HAL_OMAP_MMCSD1_DAT2                     CYGHWR_HAL_L1XX_PINMUX( 19, 12, 2 )
#define CYGHWR_HAL_OMAP_MMCSD1_DAT3                     CYGHWR_HAL_L1XX_PINMUX( 19,  8, 2 )
#define CYGHWR_HAL_OMAP_MMCSD1_DAT4                     CYGHWR_HAL_L1XX_PINMUX( 19,  4, 1 )
#define CYGHWR_HAL_OMAP_MMCSD1_DAT5                     CYGHWR_HAL_L1XX_PINMUX( 19,  0, 1 )
#define CYGHWR_HAL_OMAP_MMCSD1_DAT6                     CYGHWR_HAL_L1XX_PINMUX( 18, 28, 1 )
#define CYGHWR_HAL_OMAP_MMCSD1_DAT7                     CYGHWR_HAL_L1XX_PINMUX( 18, 24, 1 )
#define CYGHWR_HAL_OMAP_MMCSD1_POWER                    CYGHWR_HAL_L1XX_POWER( MMCSD1 )
#define CYGHWR_HAL_OMAP_MMCSD1_RXDMA                    CYGHWR_HAL_L1XX_EDMA_CHANNEL( 0, 28 )
#define CYGHWR_HAL_OMAP_MMCSD1_TXDMA                    CYGHWR_HAL_L1XX_EDMA_CHANNEL( 0, 29 )


//=============================================================================
// EMAC

// Control Module

#define CYGHWR_HAL_L1XX_EMAC_CM_REVID                   0x0000
#define CYGHWR_HAL_L1XX_EMAC_CM_SOFTRESET               0x0004
#define CYGHWR_HAL_L1XX_EMAC_CM_RSVD0                   0x0008
#define CYGHWR_HAL_L1XX_EMAC_CM_INTCTL                  0x000C
#define CYGHWR_HAL_L1XX_EMAC_CM_C0RXTHRESHEN            0x0010
#define CYGHWR_HAL_L1XX_EMAC_CM_C0RXEN                  0x0014
#define CYGHWR_HAL_L1XX_EMAC_CM_C0TXEN                  0x0018
#define CYGHWR_HAL_L1XX_EMAC_CM_C0MISCEN                0x001C
#define CYGHWR_HAL_L1XX_EMAC_CM_C1RXTHRESHEN            0x0020
#define CYGHWR_HAL_L1XX_EMAC_CM_C1RXEN                  0x0024
#define CYGHWR_HAL_L1XX_EMAC_CM_C1TXEN                  0x0028
#define CYGHWR_HAL_L1XX_EMAC_CM_C1MISCEN                0x002C
#define CYGHWR_HAL_L1XX_EMAC_CM_C2RXTHRESHEN            0x0030
#define CYGHWR_HAL_L1XX_EMAC_CM_C2RXEN                  0x0034
#define CYGHWR_HAL_L1XX_EMAC_CM_C2TXEN                  0x0038
#define CYGHWR_HAL_L1XX_EMAC_CM_C2MISCEN                0x003C
#define CYGHWR_HAL_L1XX_EMAC_CM_C0RXTHRESHSTAT          0x0040
#define CYGHWR_HAL_L1XX_EMAC_CM_C0RXSTAT                0x0044
#define CYGHWR_HAL_L1XX_EMAC_CM_C0TXSTAT                0x0048
#define CYGHWR_HAL_L1XX_EMAC_CM_C0MISCSTAT              0x004C
#define CYGHWR_HAL_L1XX_EMAC_CM_C1RXTHRESHSTAT          0x0050
#define CYGHWR_HAL_L1XX_EMAC_CM_C1RXSTAT                0x0054
#define CYGHWR_HAL_L1XX_EMAC_CM_C1TXSTAT                0x0058
#define CYGHWR_HAL_L1XX_EMAC_CM_C1MISCSTAT              0x005C
#define CYGHWR_HAL_L1XX_EMAC_CM_C2RXTHRESHSTAT          0x0060
#define CYGHWR_HAL_L1XX_EMAC_CM_C2RXSTAT                0x0064
#define CYGHWR_HAL_L1XX_EMAC_CM_C2TXSTAT                0x0068
#define CYGHWR_HAL_L1XX_EMAC_CM_C2MISCSTAT              0x006C
#define CYGHWR_HAL_L1XX_EMAC_CM_C0RXIMAX                0x0070
#define CYGHWR_HAL_L1XX_EMAC_CM_C0TXIMAX                0x0074
#define CYGHWR_HAL_L1XX_EMAC_CM_C1RXIMAX                0x0078
#define CYGHWR_HAL_L1XX_EMAC_CM_C1TXIMAX                0x007C
#define CYGHWR_HAL_L1XX_EMAC_CM_C2RXIMAX                0x0080
#define CYGHWR_HAL_L1XX_EMAC_CM_C2TXIMAX                0x0084



// MDIO

#define CYGHWR_HAL_L1XX_EMAC_MDIO_REVID                 0x0000
#define CYGHWR_HAL_L1XX_EMAC_MDIO_CONTROL               0x0004
#define CYGHWR_HAL_L1XX_EMAC_MDIO_ALIVE                 0x0008
#define CYGHWR_HAL_L1XX_EMAC_MDIO_LINK                  0x000C
#define CYGHWR_HAL_L1XX_EMAC_MDIO_LINKINTRAW            0x0010
#define CYGHWR_HAL_L1XX_EMAC_MDIO_LINKINTMASKED         0x0014
#define CYGHWR_HAL_L1XX_EMAC_MDIO_USERINTRAW            0x0020
#define CYGHWR_HAL_L1XX_EMAC_MDIO_USERINTMASKED         0x0024
#define CYGHWR_HAL_L1XX_EMAC_MDIO_USERINTMASKSET        0x0028
#define CYGHWR_HAL_L1XX_EMAC_MDIO_USERINTMASKCLR        0x002C
#define CYGHWR_HAL_L1XX_EMAC_MDIO_USERACCESS0           0x0080
#define CYGHWR_HAL_L1XX_EMAC_MDIO_USERPHYSEL0           0x0084
#define CYGHWR_HAL_L1XX_EMAC_MDIO_USERACCESS1           0x0088
#define CYGHWR_HAL_L1XX_EMAC_MDIO_USERPHYSEL1           0x008C

// CONTROL
#define CYGHWR_HAL_L1XX_EMAC_MDIO_CONTROL_CLKDIV(__x)   (__x)
#define CYGHWR_HAL_L1XX_EMAC_MDIO_CONTROL_FAULTENB      (1<<18)
#define CYGHWR_HAL_L1XX_EMAC_MDIO_CONTROL_FAULT         (1<<19)
#define CYGHWR_HAL_L1XX_EMAC_MDIO_CONTROL_PREAMBLE      (1<<20)
#define CYGHWR_HAL_L1XX_EMAC_MDIO_CONTROL_HUC(__x)      ((__x)<<21)
#define CYGHWR_HAL_L1XX_EMAC_MDIO_CONTROL_ENABLE        (1<<30)
#define CYGHWR_HAL_L1XX_EMAC_MDIO_CONTROL_IDLE          (1<<31)

// LINKINT*
#define CYGHWR_HAL_L1XX_EMAC_MDIO_LINKINT(__x)          (1<<(__x))

// USERINT*
#define CYGHWR_HAL_L1XX_EMAC_MDIO_USERINT(__x)          (1<<(__x))

// USERACCESS*
#define CYGHWR_HAL_L1XX_EMAC_MDIO_USERACCESS_DATA(__x)  (__x)
#define CYGHWR_HAL_L1XX_EMAC_MDIO_USERACCESS_PHY(__x)   ((__x)<<16)
#define CYGHWR_HAL_L1XX_EMAC_MDIO_USERACCESS_REG(__x)   ((__x)<<21)
#define CYGHWR_HAL_L1XX_EMAC_MDIO_USERACCESS_ACK        (1<<29)
#define CYGHWR_HAL_L1XX_EMAC_MDIO_USERACCESS_WRITE      (1<<30)
#define CYGHWR_HAL_L1XX_EMAC_MDIO_USERACCESS_GO         (1<<31)

// USERPHYSEL*
#define CYGHWR_HAL_L1XX_EMAC_MDIO_USERPHYSEL_PHY(__x)   (__x)
#define CYGHWR_HAL_L1XX_EMAC_MDIO_USERPHYSEL_LINKINT    (1<<6)
#define CYGHWR_HAL_L1XX_EMAC_MDIO_USERPHYSEL_LINKSEL    (1<<7)



// EMAC

#define CYGHWR_HAL_L1XX_EMAC_TXREVID                    0x0000
#define CYGHWR_HAL_L1XX_EMAC_TXCONTROL                  0x0004
#define CYGHWR_HAL_L1XX_EMAC_TXTEARDOWN                 0x0008
#define CYGHWR_HAL_L1XX_EMAC_RXREVID                    0x0010
#define CYGHWR_HAL_L1XX_EMAC_RXCONTROL                  0x0014
#define CYGHWR_HAL_L1XX_EMAC_RXTEARDOWN                 0x0018
#define CYGHWR_HAL_L1XX_EMAC_TXINTSTATRAW               0x0080
#define CYGHWR_HAL_L1XX_EMAC_TXINTSTATMASKED            0x0084
#define CYGHWR_HAL_L1XX_EMAC_TXINTMASKSET               0x0088
#define CYGHWR_HAL_L1XX_EMAC_TXINTMASKCLEAR             0x008C
#define CYGHWR_HAL_L1XX_EMAC_MACINVECTOR                0x0090
#define CYGHWR_HAL_L1XX_EMAC_MACEOIVECTOR               0x0094
#define CYGHWR_HAL_L1XX_EMAC_RXINTSTATRAW               0x00A0
#define CYGHWR_HAL_L1XX_EMAC_RXINTSTATMASKED            0x00A4
#define CYGHWR_HAL_L1XX_EMAC_RXINTMASKSET               0x00A8
#define CYGHWR_HAL_L1XX_EMAC_RXINTMASKCLEAR             0x00AC
#define CYGHWR_HAL_L1XX_EMAC_MACINTSTATRAW              0x00B0
#define CYGHWR_HAL_L1XX_EMAC_MACINTSTATMASKED           0x00B4
#define CYGHWR_HAL_L1XX_EMAC_MACINTMASKSET              0x00B8
#define CYGHWR_HAL_L1XX_EMAC_MACINTMASKCLR              0x00BC
#define CYGHWR_HAL_L1XX_EMAC_RXMBPENABLE                0x0100
#define CYGHWR_HAL_L1XX_EMAC_RXUNICASTSET               0x0104
#define CYGHWR_HAL_L1XX_EMAC_RXUNICASTCLR               0x0108
#define CYGHWR_HAL_L1XX_EMAC_RXMAXLEN                   0x010C
#define CYGHWR_HAL_L1XX_EMAC_RXBUFFEROFFSET             0x0110
#define CYGHWR_HAL_L1XX_EMAC_RXFILTERLOWTHRESH          0x0114
#define CYGHWR_HAL_L1XX_EMAC_RX0FLOWTHRESH              0x0120
#define CYGHWR_HAL_L1XX_EMAC_RX1FLOWTHRESH              0x0124
#define CYGHWR_HAL_L1XX_EMAC_RX2FLOWTHRESH              0x0128
#define CYGHWR_HAL_L1XX_EMAC_RX3FLOWTHRESH              0x012C
#define CYGHWR_HAL_L1XX_EMAC_RX4FLOWTHRESH              0x0130
#define CYGHWR_HAL_L1XX_EMAC_RX5FLOWTHRESH              0x0134
#define CYGHWR_HAL_L1XX_EMAC_RX6FLOWTHRESH              0x0138
#define CYGHWR_HAL_L1XX_EMAC_RX7FLOWTHRESH              0x013C
#define CYGHWR_HAL_L1XX_EMAC_RX0FREEBUFFER              0x0140
#define CYGHWR_HAL_L1XX_EMAC_RX1FREEBUFFER              0x0144
#define CYGHWR_HAL_L1XX_EMAC_RX2FREEBUFFER              0x0148
#define CYGHWR_HAL_L1XX_EMAC_RX3FREEBUFFER              0x014C
#define CYGHWR_HAL_L1XX_EMAC_RX4FREEBUFFER              0x0150
#define CYGHWR_HAL_L1XX_EMAC_RX5FREEBUFFER              0x0154
#define CYGHWR_HAL_L1XX_EMAC_RX6FREEBUFFER              0x0158
#define CYGHWR_HAL_L1XX_EMAC_RX7FREEBUFFER              0x015C
#define CYGHWR_HAL_L1XX_EMAC_MACCONTROL                 0x0160
#define CYGHWR_HAL_L1XX_EMAC_MACSTATUS                  0x0164
#define CYGHWR_HAL_L1XX_EMAC_EMCONTROL                  0x0168
#define CYGHWR_HAL_L1XX_EMAC_FIFOCONTROL                0x016C
#define CYGHWR_HAL_L1XX_EMAC_MACCONFIG                  0x0170
#define CYGHWR_HAL_L1XX_EMAC_SOFTRESET                  0x0174
#define CYGHWR_HAL_L1XX_EMAC_MACSRCADDRLO               0x01D0
#define CYGHWR_HAL_L1XX_EMAC_MACSRCADDRHI               0x01D4
#define CYGHWR_HAL_L1XX_EMAC_MACHASH1                   0x01D8
#define CYGHWR_HAL_L1XX_EMAC_MACHASH2                   0x01DC
#define CYGHWR_HAL_L1XX_EMAC_BOFFTEST                   0x01E0
#define CYGHWR_HAL_L1XX_EMAC_TPACETEST                  0x01E4
#define CYGHWR_HAL_L1XX_EMAC_RXPAUSE                    0x01E8
#define CYGHWR_HAL_L1XX_EMAC_TXPAUSE                    0x01EC
#define CYGHWR_HAL_L1XX_EMAC_RXGOODFRAMES               0x0200
#define CYGHWR_HAL_L1XX_EMAC_RXBCASTFRAMES              0x0204
#define CYGHWR_HAL_L1XX_EMAC_RXMCASTFRAMES              0x0208
#define CYGHWR_HAL_L1XX_EMAC_RXPAUSEFRAMES              0x020C
#define CYGHWR_HAL_L1XX_EMAC_RXCRCERRORS                0x0210
#define CYGHWR_HAL_L1XX_EMAC_RXALIGNCODEERRORS          0x0214
#define CYGHWR_HAL_L1XX_EMAC_RXOVERSIZED                0x0218
#define CYGHWR_HAL_L1XX_EMAC_RXJABBER                   0x021C
#define CYGHWR_HAL_L1XX_EMAC_RXUNDERSIZED               0x0220
#define CYGHWR_HAL_L1XX_EMAC_RXFRAGMENTS                0x0224
#define CYGHWR_HAL_L1XX_EMAC_RXFILTERED                 0x0228
#define CYGHWR_HAL_L1XX_EMAC_RXQOSFILTERED              0x022C
#define CYGHWR_HAL_L1XX_EMAC_RXOCTETS                   0x0230
#define CYGHWR_HAL_L1XX_EMAC_TXGOODFRAMES               0x0234
#define CYGHWR_HAL_L1XX_EMAC_TXBCASTFRAMES              0x0238
#define CYGHWR_HAL_L1XX_EMAC_TXMCASTFRAMES              0x023C
#define CYGHWR_HAL_L1XX_EMAC_TXPAUSEFRAMES              0x0240
#define CYGHWR_HAL_L1XX_EMAC_TXDEFFERRED                0x0244
#define CYGHWR_HAL_L1XX_EMAC_TXCOLLISION                0x0248
#define CYGHWR_HAL_L1XX_EMAC_TXSINGLECOLL               0x024C
#define CYGHWR_HAL_L1XX_EMAC_TXMULTICOLL                0x0250
#define CYGHWR_HAL_L1XX_EMAC_TXEXCESSIVECOLL            0x0254
#define CYGHWR_HAL_L1XX_EMAC_TXLATECOLL                 0x0258
#define CYGHWR_HAL_L1XX_EMAC_TXUNDERRUN                 0x025C
#define CYGHWR_HAL_L1XX_EMAC_TXCARRIERSENSE             0x0260
#define CYGHWR_HAL_L1XX_EMAC_TXOCTETS                   0x0264
#define CYGHWR_HAL_L1XX_EMAC_FRAME64                    0x0268
#define CYGHWR_HAL_L1XX_EMAC_FRAME65T127                0x026C
#define CYGHWR_HAL_L1XX_EMAC_FRAME128T255               0x0270
#define CYGHWR_HAL_L1XX_EMAC_FRAME256T511               0x0274
#define CYGHWR_HAL_L1XX_EMAC_FRAME512T1023              0x0278
#define CYGHWR_HAL_L1XX_EMAC_FRAME1024TUP               0x027C
#define CYGHWR_HAL_L1XX_EMAC_NETOCTETS                  0x0280
#define CYGHWR_HAL_L1XX_EMAC_RXSOFOVERRUNS              0x0284
#define CYGHWR_HAL_L1XX_EMAC_RXMOFOVERRUNS              0x0288
#define CYGHWR_HAL_L1XX_EMAC_RXDMAOVERRUNS              0x028C
#define CYGHWR_HAL_L1XX_EMAC_MACADDRLO                  0x0500
#define CYGHWR_HAL_L1XX_EMAC_MACADDRHI                  0x0504
#define CYGHWR_HAL_L1XX_EMAC_MACINDEX                   0x0508
#define CYGHWR_HAL_L1XX_EMAC_TXHDP(__x)                 (0x0600+(__x)*4)
#define CYGHWR_HAL_L1XX_EMAC_RXHDP(__x)                 (0x0620+(__x)*4)
#define CYGHWR_HAL_L1XX_EMAC_TXCP(__x)                  (0x0640+(__x)*4)
#define CYGHWR_HAL_L1XX_EMAC_RXCP(__x)                  (0x0660+(__x)*4)

// MACEOIVECTOR

#define CYGHWR_HAL_L1XX_EMAC_MACEOIVECTOR_RX            1
#define CYGHWR_HAL_L1XX_EMAC_MACEOIVECTOR_TX            2
#define CYGHWR_HAL_L1XX_EMAC_MACEOIVECTOR_MISC          3


// RXMBPENABLE

#define CYGHWR_HAL_L1XX_EMAC_RXMBPENABLE_RXMULTEN       (1<<5)
#define CYGHWR_HAL_L1XX_EMAC_RXMBPENABLE_RXBROADEN      (1<<13)
#define CYGHWR_HAL_L1XX_EMAC_RXMBPENABLE_RXCAFEN        (1<<21)

// MACADDRLO

#define CYGHWR_HAL_L1XX_EMAC_MACADDRLO_MATCHFILT        (1<<19)
#define CYGHWR_HAL_L1XX_EMAC_MACADDRLO_VALID            (1<<20)

// MACCONTROL

#define CYGHWR_HAL_L1XX_EMAC_MACCONTROL_FULLDUPLEX      (1<<0)
#define CYGHWR_HAL_L1XX_EMAC_MACCONTROL_GMIIEN          (1<<5)
#define CYGHWR_HAL_L1XX_EMAC_MACCONTROL_RMIISPEED       (1<<15)

//Statistics Registers

#define CYGHWR_HAL_L1XX_EMAC_RXGOODFRAMES	        0x0200
#define CYGHWR_HAL_L1XX_EMAC_RXBCASTFRAMES	        0x0204
#define CYGHWR_HAL_L1XX_EMAC_RXMCASTFRAMES	        0x0208
#define CYGHWR_HAL_L1XX_EMAC_RXPAUSEFRAMES	        0x020C
#define CYGHWR_HAL_L1XX_EMAC_RXCRCERRORS	        0x0210
#define CYGHWR_HAL_L1XX_EMAC_RXALIGNCODEERRORS	        0x0214
#define CYGHWR_HAL_L1XX_EMAC_RXOVERSIZED	        0x0218
#define CYGHWR_HAL_L1XX_EMAC_RXJABBER		        0x021C
#define CYGHWR_HAL_L1XX_EMAC_RXUNDERSIZED	        0x0220
#define CYGHWR_HAL_L1XX_EMAC_RXFRAGMENTS	        0x0224
#define CYGHWR_HAL_L1XX_EMAC_RXFILTERED		        0x0228
#define CYGHWR_HAL_L1XX_EMAC_RXQOSFILTERED	        0x022C
#define CYGHWR_HAL_L1XX_EMAC_RXOCTETS		        0x0230
#define CYGHWR_HAL_L1XX_EMAC_TXGOODFRAMES	        0x0234
#define CYGHWR_HAL_L1XX_EMAC_TXBCASTFRAMES	        0x0238
#define CYGHWR_HAL_L1XX_EMAC_TXMCASTFRAMES	        0x023C
#define CYGHWR_HAL_L1XX_EMAC_TXPAUSEFRAMES	        0x0240
#define CYGHWR_HAL_L1XX_EMAC_TXDEFERRED		        0x0244
#define CYGHWR_HAL_L1XX_EMAC_TXCOLLISION	        0x0248
#define CYGHWR_HAL_L1XX_EMAC_TXSINGLECOLL	        0x024C
#define CYGHWR_HAL_L1XX_EMAC_TXMULTICOLL	        0x0250
#define CYGHWR_HAL_L1XX_EMAC_TXEXCESSIVECOLL	        0x0254
#define CYGHWR_HAL_L1XX_EMAC_TXLATECOLL		        0x0258
#define CYGHWR_HAL_L1XX_EMAC_TXUNDERRUN		        0x025C
#define CYGHWR_HAL_L1XX_EMAC_TXCARRIERSENSE	        0x0260
#define CYGHWR_HAL_L1XX_EMAC_TXOCTETS		        0x0264
#define CYGHWR_HAL_L1XX_EMAC_NETOCTETS		        0x0280
#define CYGHWR_HAL_L1XX_EMAC_RXSOFOVERRUNS	        0x0284
#define CYGHWR_HAL_L1XX_EMAC_RXMOFOVERRUNS	        0x0288
#define CYGHWR_HAL_L1XX_EMAC_RXDMAOVERRUNS	        0x028C



// Buffer Descriptor flags, Rx only

#define CYGHWR_HAL_L1XX_EMAC_BD_NOMATCH                 (1<<0)
#define CYGHWR_HAL_L1XX_EMAC_BD_CRCERROR                (1<<1)
#define CYGHWR_HAL_L1XX_EMAC_BD_ALIGNERROR              (1<<2)
#define CYGHWR_HAL_L1XX_EMAC_BD_CODEERROR               (1<<3)
#define CYGHWR_HAL_L1XX_EMAC_BD_OVERRUN                 (1<<4)
#define CYGHWR_HAL_L1XX_EMAC_BD_CONTROL                 (1<<5)
#define CYGHWR_HAL_L1XX_EMAC_BD_UNDERSIZED              (1<<6)
#define CYGHWR_HAL_L1XX_EMAC_BD_FRAGMENT                (1<<7)
#define CYGHWR_HAL_L1XX_EMAC_BD_OVERSIZE                (1<<8)
#define CYGHWR_HAL_L1XX_EMAC_BD_JABBER                  (1<<9)

#define CYGHWR_HAL_L1XX_EMAC_BD_ERRORS                  0x03FE

// Buffer Descriptor flags, both Tx and Rx

#define CYGHWR_HAL_L1XX_EMAC_BD_PASSCRC                 (1<<10)
#define CYGHWR_HAL_L1XX_EMAC_BD_TDOWNCMPLT              (1<<11)
#define CYGHWR_HAL_L1XX_EMAC_BD_EOQ                     (1<<12)
#define CYGHWR_HAL_L1XX_EMAC_BD_OWNER                   (1<<13)
#define CYGHWR_HAL_L1XX_EMAC_BD_EOP                     (1<<14)
#define CYGHWR_HAL_L1XX_EMAC_BD_SOP                     (1<<15)


// Power control

#define CYGHWR_HAL_L1XX_EMAC_POWER                      CYGHWR_HAL_L1XX_POWER( EMAC )

// Pin multipexing -- MII only at present

#define CYGHWR_HAL_L1XX_EMAC_TXCLK                      CYGHWR_HAL_L1XX_PINMUX(  2,  8, 8 )
#define CYGHWR_HAL_L1XX_EMAC_TXD0                       CYGHWR_HAL_L1XX_PINMUX(  2, 28, 8 )
#define CYGHWR_HAL_L1XX_EMAC_TXD1                       CYGHWR_HAL_L1XX_PINMUX(  2, 24, 8 )
#define CYGHWR_HAL_L1XX_EMAC_TXD2                       CYGHWR_HAL_L1XX_PINMUX(  2, 20, 8 )
#define CYGHWR_HAL_L1XX_EMAC_TXD3                       CYGHWR_HAL_L1XX_PINMUX(  2, 16, 8 )
#define CYGHWR_HAL_L1XX_EMAC_TXEN                       CYGHWR_HAL_L1XX_PINMUX(  2,  4, 8 )
#define CYGHWR_HAL_L1XX_EMAC_TXCOL                      CYGHWR_HAL_L1XX_PINMUX(  2, 12, 8 )
#define CYGHWR_HAL_L1XX_EMAC_TXCRS                      CYGHWR_HAL_L1XX_PINMUX(  3, 12, 8 )
#define CYGHWR_HAL_L1XX_EMAC_RXCLK                      CYGHWR_HAL_L1XX_PINMUX(  3,  0, 8 )
#define CYGHWR_HAL_L1XX_EMAC_RXD0                       CYGHWR_HAL_L1XX_PINMUX(  3, 28, 8 )
#define CYGHWR_HAL_L1XX_EMAC_RXD1                       CYGHWR_HAL_L1XX_PINMUX(  3, 24, 8 )
#define CYGHWR_HAL_L1XX_EMAC_RXD2                       CYGHWR_HAL_L1XX_PINMUX(  3, 20, 8 )
#define CYGHWR_HAL_L1XX_EMAC_RXD3                       CYGHWR_HAL_L1XX_PINMUX(  3, 16, 8 )
#define CYGHWR_HAL_L1XX_EMAC_RXDV                       CYGHWR_HAL_L1XX_PINMUX(  3,  4, 8 )
#define CYGHWR_HAL_L1XX_EMAC_RXER                       CYGHWR_HAL_L1XX_PINMUX(  3,  8, 8 )
#define CYGHWR_HAL_L1XX_EMAC_MDIO_CLK                   CYGHWR_HAL_L1XX_PINMUX(  4,  0, 8 )
#define CYGHWR_HAL_L1XX_EMAC_MDIO_DATA                  CYGHWR_HAL_L1XX_PINMUX(  4,  4, 8 )

/*---------------------------------------------------------------------------*/
/* end of omap_l1xx.h                                                        */
#endif /* CYGONCE_OMAP_L1XX_H */
