#ifndef CYGONCE_HAL_OMAP_L1XX_INIT_INC
#define CYGONCE_HAL_OMAP_L1XX_INIT_INC
/*=============================================================================
//
//      omap_l1xx_init.inc
//
//      Common OMAP_L1XX HAL initialisation helper macros (assembly code)
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007 Free Software Foundation, Inc.
// Copyright (C) 2003, 2004, 2005, 2006, 2007, 2009 eCosCentric Limited           
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    nickg
// Contributors: eCosCentric 
// Date:         2009-12-09
// Purpose:      Common OMAP L1XX HAL initialisation helper macros
// Description:  The idea with this file is not to provide macros that must be
//               made to work for every OMAP L1XX platform, but just try to
//               increase the amount of shared code. Therefore this is just
//               an optional library of macros, and platforms are able to do
//               their own thing instead.
//
// Usage:        #include <cyg/hal/omap_l1xx_init.inc>
//               Only used by platform "hal_platform_setup.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================*/


#include <pkgconf/system.h>                  // System-wide configuration info
#include <pkgconf/hal_arm.h>
#include <pkgconf/hal_arm_arm9.h>
#include <pkgconf/hal_arm_arm9_omap_l1xx.h>

#include CYGBLD_HAL_VARIANT_H                // Variant specific configuration
#include <cyg/hal/hal_mmu.h>                 // MMU definitions
#include <cyg/hal/omap_l1xx.h>               // Register addressed
        
//===========================================================================*/

//--------------------------------------------------------------------------------
// Set up the CPU
        
        .macro omap_l1xx_init_cpu
#if !defined(CYG_HAL_STARTUP_RAM)
        // Disable MMU, caches, and thus write buffer. Also sets little endian.
        // We daren't do this for RAM startup even if USE_ROM_MONITOR unset,
        // in case the MMU _was_ set up. e.g. if loading RAM RedBoot from ROM
        // RedBoot. This should be ok with JTAG as generally the CPU is reset
        // anyway (and so the MMU/caches were disabled).
        
        ldr     r0, =0x00000078
        mcr     p15,0,r0,c1,c0,0

        ldr     r0, =0x00000000
        mcr     p15,0,r0,c8,c7,0      // invalidate both i and d TLB's 
        mcr     p15,0,r0,c7,c7,0      // invalidate both i and d Caches 
        mcr     p15,0,r0,c7,c10,4     // Drain Write Buffer
        
        mvn     r0, #0                // grant manager access to all domains
        mcr     p15,0,r0,c3,c0,0  
#endif
        .endm

//--------------------------------------------------------------------------------
// Get the clocks running
//
// We don't actually need to do this since either the JTAG init
// sequence has already done this, or the User Boot Loader has set up the
// PLLs.

        .macro omap_l1xx_init_clocks
#if !defined(CYG_HAL_STARTUP_RAM) || !defined(CYGSEM_HAL_USE_ROM_MONITOR)

        ldr     r7,=CYGHWR_HAL_L1XX_SYSCFG0

        // Unlock SYSCFG  registers
        ldr     r8,=CYGHWR_HAL_L1XX_SYSCFG0_KICK0R_UNLOCK
        str     r8,[r7,#CYGHWR_HAL_L1XX_SYSCFG0_KICK0R]
        ldr     r8,=CYGHWR_HAL_L1XX_SYSCFG0_KICK1R_UNLOCK
        str     r8,[r7,#CYGHWR_HAL_L1XX_SYSCFG0_KICK1R]
        
#endif // if !defined(CYG_HAL_STARTUP_RAM) || !defined(CYGSEM_HAL_USE_ROM_MONITOR)


        .endm

//-----------------------------------------------------------------------------
// SDRAM Initialization
//
// As with clock initialization, this has already been done via JTAG
// or the USer Bool Loader.

        .macro omap_l1xx_init_sdram 

sdram_running:
        .endm

//--------------------------------------------------------------------------------
// MMU setup, and handle ROM->RAM copy in ROMRAM startups
// the argument values are irrelevant if ROMRAM unsupported
//
// It is assumed that:
//  * __startup_stack is defined and corresponds to the startup stack's address
//    after relocation, which will be in ram starting at 0x0 (after mmu setup).
//  * hal_mmu_init is to be called to do the real init
//  * __exception_handlers is defined and sensible and corresponds to ram
//    starting at 0x0 (after MMU setup)
//  * __rom_data_end is defined and sensible

#define CYGHWR_HAL_ARM_HAS_MMU

        .macro omap_l1xx_init_mmu phys_base

        // Test whether MMU is already running. If it is then we skip
        // over the setup code.
        ldr     r1,=MMU_Control_M
        mrc     MMU_CP,0,r2,MMU_Control,c0
        and     r1,r1,r2
        cmp     r1,#0
        bne     omap_l1xx_mmu_ok

        // Set up a stack [for calling C code]
        ldr     r1,=__startup_stack
        ldr     r2,=\phys_base
        orr     sp,r1,r2

        // Create MMU tables
        bl      hal_mmu_init

        // Enable MMU
        ldr     r2,=10f
        ldr    r1,=MMU_Control_Init|MMU_Control_M
        mcr    MMU_CP,0,r1,MMU_Control,c0
        mov    pc,r2    /* Change address spaces */
        nop
        nop
        nop
        .pool
10:

omap_l1xx_mmu_ok:
        
        .endm


//-----------------------------------------------------------------------------
#endif // ifndef CYGONCE_HAL_OMAP_L1XX_INIT_INC
// EOF omap_l1xx_init.inc
