#ifndef CYGONCE_HAL_VAR_INTS_H
#define CYGONCE_HAL_VAR_INTS_H
//==========================================================================
//
//      var_ints.h
//
//      OMAP L1XX variant Interrupt and clock support
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2007 Free Software Foundation, Inc.
// Copyright (C) 2003, 2004, 2005, 2007 eCosCentric Limited                 
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    eCosCentric
// Contributors: 
// Date:         2009-12-09
// Purpose:      Define Interrupt support
// Description:  The interrupt details for the TIOMAP L1XX are defined here.
// Usage:
//               #include <cyg/hal/hal_var_ints.h>
//               ...
//              
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <cyg/hal/omap_l1xx.h>
#include <cyg/hal/hal_io.h>

//==========================================================================


#define CYGNUM_HAL_INTERRUPT_COMMTX                             0
#define CYGNUM_HAL_INTERRUPT_COMMRX                             1
#define CYGNUM_HAL_INTERRUPT_NINT                               2
#define CYGNUM_HAL_INTERRUPT_PRU_EVTOUT0                        3
#define CYGNUM_HAL_INTERRUPT_PRU_EVTOUT1                        4
#define CYGNUM_HAL_INTERRUPT_PRU_EVTOUT2                        5
#define CYGNUM_HAL_INTERRUPT_PRU_EVTOUT3                        6
#define CYGNUM_HAL_INTERRUPT_PRU_EVTOUT4                        7
#define CYGNUM_HAL_INTERRUPT_PRU_EVTOUT5                        8
#define CYGNUM_HAL_INTERRUPT_PRU_EVTOUT6                        9
#define CYGNUM_HAL_INTERRUPT_PRU_EVTOUT7                        10
#define CYGNUM_HAL_INTERRUPT_EDMA3_0_CC0_INT0                   11
#define CYGNUM_HAL_INTERRUPT_EDMA3_0_CC0_ERRINT                 12
#define CYGNUM_HAL_INTERRUPT_EDMA3_0_TC0_ERRINT                 13
#define CYGNUM_HAL_INTERRUPT_EMIFA                              14
#define CYGNUM_HAL_INTERRUPT_I2C0                               15
#define CYGNUM_HAL_INTERRUPT_MMCSD0_INT0                        16
#define CYGNUM_HAL_INTERRUPT_MMCSD0_INT1                        17
#define CYGNUM_HAL_INTERRUPT_PSC0                               18      
#define CYGNUM_HAL_INTERRUPT_RTC_IRQS                           19
#define CYGNUM_HAL_INTERRUPT_SPI0                               20
#define CYGNUM_HAL_INTERRUPT_T64P0_TINT12                       21
#define CYGNUM_HAL_INTERRUPT_T64P0_TINT34                       22
#define CYGNUM_HAL_INTERRUPT_T64P1_TINT12                       23
#define CYGNUM_HAL_INTERRUPT_T64P1_TINT34                       24
#define CYGNUM_HAL_INTERRUPT_UART0                              25
#define CYGNUM_HAL_INTERRUPT_26                                 26
#define CYGNUM_HAL_INTERRUPT_PROTERR                            27
#define CYGNUM_HAL_INTERRUPT_SYSCFG_CHIPINT0                    28
#define CYGNUM_HAL_INTERRUPT_SYSCFG_CHIPINT1                    29
#define CYGNUM_HAL_INTERRUPT_SYSCFG_CHIPINT2                    30
#define CYGNUM_HAL_INTERRUPT_SYSCFG_CHIPINT3                    31
#define CYGNUM_HAL_INTERRUPT_EDMA3_0_TC1_ERRINT                 32
#define CYGNUM_HAL_INTERRUPT_EMAC_C0RXTHRESH                    33
#define CYGNUM_HAL_INTERRUPT_EMAC_C0RX                          34
#define CYGNUM_HAL_INTERRUPT_EMAC_C0TX                          35
#define CYGNUM_HAL_INTERRUPT_EMAC_C0MISC                        36
#define CYGNUM_HAL_INTERRUPT_EMAC_C1RXTHRESH                    37
#define CYGNUM_HAL_INTERRUPT_EMAC_C1RX                          38
#define CYGNUM_HAL_INTERRUPT_EMAC_C1TX                          39
#define CYGNUM_HAL_INTERRUPT_EMAC_C1MISC                        40
#define CYGNUM_HAL_INTERRUPT_DDR2_MEMERR                        41
#define CYGNUM_HAL_INTERRUPT_GPIO_B0INT                         42
#define CYGNUM_HAL_INTERRUPT_GPIO_B1INT                         43
#define CYGNUM_HAL_INTERRUPT_GPIO_B2INT                         44
#define CYGNUM_HAL_INTERRUPT_GPIO_B3INT                         45
#define CYGNUM_HAL_INTERRUPT_GPIO_B4INT                         46
#define CYGNUM_HAL_INTERRUPT_GPIO_B5INT                         47
#define CYGNUM_HAL_INTERRUPT_GPIO_B6INT                         48
#define CYGNUM_HAL_INTERRUPT_GPIO_B7INT                         49
#define CYGNUM_HAL_INTERRUPT_GPIO_B8INT                         50
#define CYGNUM_HAL_INTERRUPT_I2C1                               51
#define CYGNUM_HAL_INTERRUPT_LCDC                               52
#define CYGNUM_HAL_INTERRUPT_UART1                              53
#define CYGNUM_HAL_INTERRUPT_MCASP                              54
#define CYGNUM_HAL_INTERRUPT_PSC1                               55
#define CYGNUM_HAL_INTERRUPT_SPI1                               56
#define CYGNUM_HAL_INTERRUPT_UHPI_ARM                           57
#define CYGNUM_HAL_INTERRUPT_USB0                               58
#define CYGNUM_HAL_INTERRUPT_USB1_HC                            59
#define CYGNUM_HAL_INTERRUPT_USB1_WAKEUP                        60
#define CYGNUM_HAL_INTERRUPT_UART2                              61
#define CYGNUM_HAL_INTERRUPT_62                                 62
#define CYGNUM_HAL_INTERRUPT_EHRPWM0                            63
#define CYGNUM_HAL_INTERRUPT_EHRPWM0TZ                          64
#define CYGNUM_HAL_INTERRUPT_EHRPWM1                            65
#define CYGNUM_HAL_INTERRUPT_EHRPWM1TZ                          66
#define CYGNUM_HAL_INTERRUPT_SATA                               67
#define CYGNUM_HAL_INTERRUPT_T64P2_ALL                          68
#define CYGNUM_HAL_INTERRUPT_ECAP0                              69
#define CYGNUM_HAL_INTERRUPT_ECAP1                              70
#define CYGNUM_HAL_INTERRUPT_ECAP2                              71
#define CYGNUM_HAL_INTERRUPT_MMCSD1_INT0                        72
#define CYGNUM_HAL_INTERRUPT_MMCSD1_INT1                        73
#define CYGNUM_HAL_INTERRUPT_T64P0_CMP0                         74
#define CYGNUM_HAL_INTERRUPT_T64P0_CMP1                         75
#define CYGNUM_HAL_INTERRUPT_T64P0_CMP2                         76
#define CYGNUM_HAL_INTERRUPT_T64P0_CMP3                         77
#define CYGNUM_HAL_INTERRUPT_T64P0_CMP4                         78
#define CYGNUM_HAL_INTERRUPT_T64P0_CMP5                         79
#define CYGNUM_HAL_INTERRUPT_T64P0_CMP6                         80
#define CYGNUM_HAL_INTERRUPT_T64P0_CMP7                         81
#define CYGNUM_HAL_INTERRUPT_T64P1_CMP0                         82
#define CYGNUM_HAL_INTERRUPT_T64P1_CMP1                         83
#define CYGNUM_HAL_INTERRUPT_T64P1_CMP2                         84
#define CYGNUM_HAL_INTERRUPT_T64P1_CMP3                         85
#define CYGNUM_HAL_INTERRUPT_T64P1_CMP4                         85
#define CYGNUM_HAL_INTERRUPT_T64P1_CMP5                         87
#define CYGNUM_HAL_INTERRUPT_T64P1_CMP6                         88
#define CYGNUM_HAL_INTERRUPT_T64P1_CMP7                         89
#define CYGNUM_HAL_INTERRUPT_ARMCLKSTOPREQ                      90
#define CYGNUM_HAL_INTERRUPT_UPP                                91
#define CYGNUM_HAL_INTERRUPT_VPIF                               92
#define CYGNUM_HAL_INTERRUPT_EDMA3_1_CC0_INT0                   93
#define CYGNUM_HAL_INTERRUPT_EDMA3_1_CC0_ERRINT                 94
#define CYGNUM_HAL_INTERRUPT_EDMA3_1_TC0_ERRINT                 95
#define CYGNUM_HAL_INTERRUPT_T64P3_ALL                          96
#define CYGNUM_HAL_INTERRUPT_MCBSP0_RX                          97
#define CYGNUM_HAL_INTERRUPT_MCBSP0_TX                          98
#define CYGNUM_HAL_INTERRUPT_MCBSP1_RX                          99
#define CYGNUM_HAL_INTERRUPT_MCBSP1_TX                          100

#define CYGNUM_HAL_INTERRUPT_NONE    -1

#define CYGNUM_HAL_ISR_MIN            0
#define CYGNUM_HAL_ISR_MAX            100

#define CYGNUM_HAL_ISR_COUNT         (CYGNUM_HAL_ISR_MAX-CYGNUM_HAL_ISR_MIN+1)

// The vector used by the Real time clock
#define CYGNUM_HAL_INTERRUPT_RTC      CYGNUM_HAL_INTERRUPT_T64P0_TINT34

//==========================================================================
// Reset.

externC void cyg_hal_omap_l1xx_reset(void);
#define HAL_PLATFORM_RESET() cyg_hal_omap_l1xx_reset()

#define HAL_PLATFORM_RESET_ENTRY 0x00000000

//==========================================================================
#endif // CYGONCE_HAL_VAR_INTS_H
